/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.desktop.AbstractAssociationAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.platform.unix.DesktopFile;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuHelper {
    public static final String DESKTOP_SUFFIX = ".desktop";
    public static final String XDG_DESKTOP_MENU = "xdg-desktop-menu";
    public static final String COMMAND_INSTALL = "install";
    public static final String COMMAND_UNINSTALL = "uninstall";
    public static final String MODE_PARAMETER = "--mode";
    public static final String MODE_SYSTEM = "system";
    public static final String MODE_USER = "user";
    public static final String VARNAME_TOP_LEVEL_DESKTOP_FILES = "topLevelDesktopFiles";
    public static final boolean DEFAULT_TOP_LEVEL_DESKTOP_FILES = true;

    public static void installWindowsMenu(ExecutionContext executionContext, File menuFile, File shortcutTo, File iconFile) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, menuFile, shortcutTo, iconFile, null, false, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, File menuFile, File shortcutTo, File iconFile, String arguments, boolean runAsAdministrator, String description) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, menuFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, final File menuFile, final File shortcutTo, final File iconFile, final String arguments, final boolean runAsAdministrator, final String description, final File startIn) throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                MenuHelper.createWindowsMenuInt(menuFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, startIn);
            }
        });
    }

    private static void createWindowsMenuInt(File menuFile, File shortcutTo, File iconFile, String arguments, boolean runAsAdministrator, String description, File startIn) throws IOException, UserCanceledException {
        if (!shortcutTo.exists()) {
            return;
        }
        if (arguments != null && arguments.trim().isEmpty()) {
            arguments = null;
        }
        if (shortcutTo.getName().endsWith(".url")) {
            File urlFile = new File(menuFile.getAbsolutePath() + ".url");
            if (iconFile != null) {
                File tempUrlFile = File.createTempFile("i4j", ".url");
                if (FileUtil.copyFile(shortcutTo, tempUrlFile)) {
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(tempUrlFile, true));){
                        out.newLine();
                        out.write("IconIndex=0");
                        out.newLine();
                        out.write("IconFile=" + iconFile);
                    }
                    FileInstaller.getInstance().install(tempUrlFile, urlFile, new FileOptions(shortcutTo.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                }
                tempUrlFile.delete();
            } else {
                FileInstaller.getInstance().install(shortcutTo, urlFile, new FileOptions(shortcutTo.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
            }
            ShellLink.changeNotify(urlFile);
        } else {
            File lnkFile = new File(menuFile.getAbsolutePath() + ".lnk");
            File pifFile = new File(menuFile.getAbsolutePath() + ".pif");
            File tempLnkFile = File.createTempFile("i4j", ".lnk");
            File tempPifFile = new File(tempLnkFile.getAbsolutePath().substring(0, tempLnkFile.getAbsolutePath().length() - 3) + "pif");
            ShellLink.create(tempLnkFile, shortcutTo, iconFile, arguments, runAsAdministrator, description, startIn, 1);
            if (tempLnkFile.exists()) {
                FileInstaller.getInstance().install(tempLnkFile, lnkFile, new FileOptions(tempLnkFile.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                pifFile.delete();
            } else if (tempPifFile.exists()) {
                FileInstaller.getInstance().install(tempPifFile, pifFile, new FileOptions(tempPifFile.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                lnkFile.delete();
            }
            tempLnkFile.delete();
            tempPifFile.delete();
            ShellLink.changeNotify(lnkFile);
        }
    }

    public static File installUnixDesktopFile(File installationDir, File destinationDirectory, String fileName, File execFile, String name, String categories, String arguments, File iconFile, String description, List<String> additionalEntries, boolean setTrusted) throws IOException, UserCanceledException {
        if (execFile == null || !execFile.exists()) {
            return null;
        }
        DesktopFile desktopFile = new DesktopFile(name, MenuHelper.getDesktopExecutable(execFile) + (arguments == null ? "" : " " + arguments) + " %U");
        if (description != null && !description.isEmpty()) {
            desktopFile.addToMain("Comment", description);
        }
        if (iconFile == null) {
            iconFile = new File(installationDir, ".install4j/" + execFile.getName() + ".png");
        }
        if (iconFile.exists()) {
            desktopFile.addToMain("Icon", iconFile.getAbsolutePath());
        }
        if (categories != null) {
            desktopFile.addToMain("Categories", categories + (!categories.trim().endsWith(";") ? ";" : ""));
        }
        desktopFile.addContent(additionalEntries);
        File file = new File(destinationDirectory, fileName + DESKTOP_SUFFIX);
        File tempFile = File.createTempFile("i4j", null);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8));){
            desktopFile.print(pw);
        }
        String initialMode = setTrusted ? "644" : "755";
        boolean fileSuccess = FileInstaller.getInstance().install(tempFile, file, new FileOptions(new Date().getTime(), initialMode, OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
        if (fileSuccess && setTrusted) {
            MenuHelper.setTrusted(file);
            UnixFileSystem.setMode("755", file);
        }
        tempFile.delete();
        return file;
    }

    private static void setTrusted(File file) {
        String gioPath = "/usr/bin/gio";
        if (new File(gioPath).isFile()) {
            try {
                Process process = new ProcessBuilder(gioPath, "set", file.getAbsolutePath(), "metadata::trusted", "true").start();
                if (!process.waitFor(20L, TimeUnit.SECONDS)) {
                    Logger.getInstance().error(null, "gio timed out");
                } else {
                    int exitValue = process.exitValue();
                    if (exitValue != 0) {
                        Logger.getInstance().error(null, "gio returned " + exitValue);
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        }
    }

    private static String getDesktopExecutable(File execFile) throws IOException {
        String posixFilePermissions = FileAttributesHelper.getPosixFilePermissions(execFile);
        StringBuilder buffer = new StringBuilder();
        if (posixFilePermissions.length() < 9 || posixFilePermissions.charAt(2) != 'x') {
            buffer.append("/bin/sh ");
        }
        buffer.append('\"').append(execFile.getAbsolutePath()).append('\"');
        return buffer.toString();
    }

    public static void installUnixMenu(File installationDirectory, File execFile, String name, String categories, String arguments, File iconFile, String description, List<String> additionalEntries, boolean excludeUninstallerFromMenu) throws IOException, UserCanceledException {
        File desktopFile = MenuHelper.installUnixDesktopFile(installationDirectory, new File(installationDirectory, ".install4j"), MenuHelper.getRelativeDesktopFileName(FileUtil.getCanonicalPath(installationDirectory), execFile.getName()), execFile, name, categories, arguments, iconFile, description, additionalEntries, false);
        if (desktopFile != null) {
            if (CompilerVariableHelper.getCompilerExtensionVariable((Context)ContextImpl.getSingleContextInt(), VARNAME_TOP_LEVEL_DESKTOP_FILES, true)) {
                File topLevelDesktopFile = new File(installationDirectory, name + DESKTOP_SUFFIX);
                topLevelDesktopFile.delete();
                UnixFileSystem.createLink(".install4j/" + desktopFile.getName(), topLevelDesktopFile);
                FileInstaller.getInstance().registerUninstallFile(topLevelDesktopFile);
            }
            if (!(excludeUninstallerFromMenu && Objects.equals(execFile.getCanonicalPath(), new File(installationDirectory, InstallerConfig.getCurrentInstance().getUninstallerPath()).getCanonicalPath()) || !MenuHelper.installDesktopFile(desktopFile))) {
                AbstractAssociationAction.registerDesktopFile(execFile, desktopFile);
            }
        }
    }

    @NotNull
    public static String getRelativeDesktopFileName(String canonicalInstallationPath, String execFileName) {
        return MenuHelper.getVendorPrefix(canonicalInstallationPath) + execFileName.replace(" ", "_");
    }

    public static boolean installDesktopFile(File desktopFile) {
        if (MenuHelper.execute(desktopFile.getParentFile(), XDG_DESKTOP_MENU, COMMAND_INSTALL, MODE_PARAMETER, MenuHelper.getMode(), desktopFile.getName())) {
            FileInstaller.getInstance().registerPreUninstallCommand(desktopFile, XDG_DESKTOP_MENU, COMMAND_UNINSTALL, MODE_PARAMETER, MenuHelper.getMode(), desktopFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    public static void createUrlLink(File tempFile, String urlSpec, File iconFile, boolean favicon) {
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(tempFile));){
            pw.println("[InternetShortcut]");
            pw.print("URL=");
            pw.println(urlSpec);
            if (favicon) {
                try {
                    URL url = new URL(urlSpec);
                    pw.print("IconFile=");
                    pw.print(url.getProtocol());
                    pw.print("://");
                    pw.print(url.getHost());
                    pw.println("/favicon.ico");
                    pw.println("IconIndex=1");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (iconFile != null) {
                pw.print("IconFile=");
                pw.println(iconFile.getPath());
                pw.println("IconIndex=0");
                pw.println("HotKey=0");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void installUrlLink(ExecutionContext executionContext, String url, File targetFile, File iconFile, boolean useFavicon) throws IOException, UserCanceledException {
        File tempFile = File.createTempFile("i4j", ".url");
        MenuHelper.createUrlLink(tempFile, url, iconFile, useFavicon);
        MenuHelper.installWindowsMenu(executionContext, targetFile, tempFile, null, null, false, null);
        tempFile.delete();
    }

    public static LauncherSetup getLauncherWithUnixPath(Context context, File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (IOException e) {
            path = path.getAbsoluteFile();
        }
        for (LauncherSetup launcherSetup : context.getLaunchers()) {
            try {
                File launcherPath = context.getDestinationFile(launcherSetup.getRelativeFileName()).getCanonicalFile();
                if (!launcherPath.equals(path)) continue;
                return launcherSetup;
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
        return null;
    }

    @NotNull
    public static List<String> getAdditionalEntries(@Nullable LauncherSetup launcherSetup) {
        if (launcherSetup == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(InstallerVariables.replaceVariables(((ContextImpl.LauncherSetupImpl)launcherSetup).getLauncherConfig().getAdditionalStartFileEntries().toArray(), VariableErrorHandlingDescriptor.DEFAULT));
    }

    public static void updateDesktopDatabase() {
        Integer result = LaunchHelper.launchApplication(new LaunchDescriptor(new File("update-desktop-database")).wait(true).timeout(20).terminate(false));
        if (!Objects.equals(result, 0)) {
            Logger.getInstance().error(null, "update-desktop-database returned " + result);
        }
    }

    @NotNull
    public static String getMode() {
        return Util.hasFullAdminRights() ? MODE_SYSTEM : MODE_USER;
    }

    public static boolean execute(String command, String ... arguments) {
        return MenuHelper.execute(null, command, arguments);
    }

    public static boolean execute(File workingDir, String command, String ... arguments) {
        Integer result;
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(command)).arguments(arguments).wait(true).timeout(60).terminate(false);
        if (workingDir != null) {
            launchDescriptor.workingDirectory(workingDir.getAbsoluteFile());
        }
        if (Boolean.getBoolean("install4j.debugMenuHelper")) {
            launchDescriptor.stdoutRedirection(new OutputRedirection(OutputRedirectionMode.LOG_FILE, "", false, null, false));
            launchDescriptor.redirectErrorStream(true);
        }
        if (!Objects.equals(result = LaunchHelper.launchApplication(launchDescriptor), 0)) {
            Logger.getInstance().error(null, command + " returned " + result);
            return false;
        }
        return true;
    }

    public static String getVendorPrefix(String installationDir) {
        CRC32 crc = new CRC32();
        crc.update(installationDir.getBytes(StandardCharsets.UTF_8));
        return "install4j_" + Long.toString(crc.getValue(), 36) + "-";
    }
}

