/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.install4j.api.beans.Bean;
import com.install4j.api.context.Context;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.styles.Style;
import com.install4j.runtime.beans.styles.StyleManagerInt;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.IdWrapperContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.StyleBeanConfig;
import com.install4j.runtime.installer.config.StyleProvider;
import com.install4j.runtime.installer.config.WrapperBeanConfig;
import com.install4j.runtime.installer.frontend.FormPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleManagerImpl
implements StyleManagerInt {
    private static StyleManagerImpl styleManagerImpl = new StyleManagerImpl();
    private Map<Style, FormPanel> styleToFormPanel = new HashMap<Style, FormPanel>();
    private Map<Style, StyleProvider> styleToConfig = new HashMap<Style, StyleProvider>();
    private Map<Style, String> styleToId = new HashMap<Style, String>();
    private Map<String, Bean> idToReplacedBean = new HashMap<String, Bean>();

    @NotNull
    public static StyleManagerImpl getInstance() {
        return styleManagerImpl;
    }

    protected StyleManagerImpl() {
    }

    public void clear() {
        this.styleToFormPanel.clear();
        this.styleToConfig.clear();
        this.styleToId.clear();
        this.idToReplacedBean.clear();
    }

    @Override
    @Nullable
    public Style getStyleById(String styleId) {
        StyleProvider styleConfig = this.getStyleConfigById(styleId);
        if (styleConfig != null) {
            return this.registerStyle(styleConfig, styleId);
        }
        return null;
    }

    @Override
    public Style cloneStyleById(String styleId) {
        StyleProvider styleConfig = this.getStyleConfigById(styleId);
        if (styleConfig != null) {
            return this.registerStyle(styleConfig.cloneStyleProvider(), styleId);
        }
        return null;
    }

    @Override
    public JComponent createStyleComponent(Style style) {
        this.initializeStyle(style);
        return style.createComponent();
    }

    @Override
    public void willActivate(Style style) {
        if (style == null) {
            return;
        }
        FormPanel formPanel = this.styleToFormPanel.get(style);
        if (formPanel != null) {
            formPanel.willActivate();
        }
        style.willActivate();
    }

    @Override
    public void activated(Style style) {
        if (style == null) {
            return;
        }
        FormPanel formPanel = this.styleToFormPanel.get(style);
        if (formPanel != null) {
            formPanel.activated();
        }
        style.activated();
    }

    @Override
    public void deactivated(Style style) {
        if (style == null) {
            return;
        }
        FormPanel formPanel = this.styleToFormPanel.get(style);
        if (formPanel != null) {
            formPanel.deactivated();
        }
        style.deactivated();
    }

    @NotNull
    protected FormPanel createStyleFormPanel(Style style, @NotNull String styleId) {
        StyleBeanConfig styleConfig = (StyleBeanConfig)this.styleToConfig.get(style);
        if (styleConfig == null) {
            throw new IllegalStateException("Style with ID " + styleId + " not found");
        }
        List<AbstractBeanConfig> formComponentConfigs = styleConfig.getFormComponentConfigs();
        return new FormPanel(formComponentConfigs, this.getContext(styleId), styleConfig.getOrInstantiateStyle(false), null, this.idToReplacedBean);
    }

    protected void collectReplacedBeans(StyleProvider styleConfig, Map<String, Bean> idToReplacedBean) {
        for (WrapperBeanConfig wrapperBeanConfig : ((StyleBeanConfig)styleConfig).getOverriddenBeanConfigs()) {
            idToReplacedBean.put(wrapperBeanConfig.getId(), wrapperBeanConfig.getOrInstantiateBean(false));
        }
    }

    public void setTopLevelStyle(Style style) {
        if (style != null) {
            StyleProvider styleConfig = this.styleToConfig.get(style);
            if (styleConfig == null) {
                throw new IllegalStateException();
            }
            this.collectReplacedBeans(styleConfig, this.idToReplacedBean);
            this.initializeStyle(style);
        } else {
            this.idToReplacedBean.clear();
        }
    }

    public void initializeStyle(Style style) {
        StyleProvider styleConfig = this.styleToConfig.get(style);
        if (styleConfig == null) {
            throw new IllegalStateException("Style config for " + style + " not found");
        }
        String styleId = this.styleToId.get(style);
        if (styleId == null) {
            throw new IllegalStateException("Style ID for " + style + " not found");
        }
        this.initializeStyle(style, styleId);
    }

    protected Context getContext(String styleId) {
        Context currentContext = this.getContext();
        if (styleId.contains(":")) {
            String[] parts = styleId.split(":");
            String mergedProjectId = parts[0];
            return new IdWrapperContext(currentContext, mergedProjectId);
        }
        return currentContext;
    }

    protected Context getContext() {
        return ContextImpl.getCurrentContext();
    }

    protected void initializeStyle(Style style, @NotNull String styleId) {
        if (style instanceof FormPanelContainer) {
            FormPanel formPanel = this.createStyleFormPanel(style, styleId);
            this.styleToFormPanel.put(style, formPanel);
            ((FormPanelContainer)((Object)style)).setFormPanel(formPanel, formPanel.getFormEnvironment());
        }
    }

    protected StyleProvider getStyleConfigById(String styleId) {
        return InstallerConfig.getCurrentInstance().getStyleConfigById(styleId);
    }

    private Style registerStyle(StyleProvider styleConfig, String styleId) {
        Style style = styleConfig.getStyle();
        style.setContext(this.getContext(styleId));
        this.styleToConfig.put(style, styleConfig);
        this.styleToId.put(style, styleId);
        return style;
    }
}

