/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import uk.me.g4dpz.satellite.AbstractSatelliteTestBase;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class IlluminationTest
extends AbstractSatelliteTestBase {
    @Test
    public void testCalculateSunVector() {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertFalse(tle.isDeepspace());
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        DateTime timeNow = new DateTime("2009-06-01T00:00:00Z");
        int day = 0;
        while (day < 30) {
            SatPos satPos = satellite.getPosition(GROUND_STATION, timeNow.toDate());
            switch (day) {
                case 4: 
                case 9: 
                case 14: 
                case 19: 
                case 24: 
                case 29: {
                    Assert.assertTrue("Satellite should have been eclipsed on day " + day, satPos.isEclipsed());
                    break;
                }
                default: {
                    Assert.assertFalse("Satellite should not have been eclipsed on day " + day, satPos.isEclipsed());
                }
            }
            timeNow = timeNow.plusDays(1);
            ++day;
        }
    }
}

