/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import org.junit.Assert;
import org.junit.Test;
import uk.me.g4dpz.satellite.GroundStationPosition;

public final class GroundStationPositionTest {
    private static final double HEIGHT_AMSL = 3.0;
    private static final double LONGITUDE = 2.0;
    private static final double LATITUDE = 1.0;
    private static final double THETA = 4.0;

    @Test
    public void testDefaultConstructorAndSetters() {
        GroundStationPosition groundStationPosition = new GroundStationPosition();
        int[] nArray = new int[36];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 4;
        nArray[15] = 5;
        nArray[16] = 6;
        nArray[17] = 7;
        nArray[18] = 8;
        nArray[19] = 9;
        nArray[21] = 1;
        nArray[22] = 2;
        nArray[23] = 3;
        nArray[24] = 4;
        nArray[25] = 5;
        nArray[26] = 6;
        nArray[27] = 7;
        nArray[28] = 8;
        nArray[29] = 9;
        nArray[31] = 1;
        nArray[32] = 2;
        nArray[33] = 3;
        nArray[34] = 4;
        nArray[35] = 5;
        int[] elevations = nArray;
        groundStationPosition.setHorizonElevations(elevations);
        groundStationPosition.setTheta(4.0);
        int[] oElevations = groundStationPosition.getHorizonElevations();
        Assert.assertEquals(elevations.length, oElevations.length);
        int i2 = 0;
        while (i2 < elevations.length) {
            Assert.assertEquals(elevations[i2], oElevations[i2]);
            ++i2;
        }
        Assert.assertTrue(Math.abs(4.0 - groundStationPosition.getTheta()) < 1.0E-6);
    }

    @Test
    public void testConstructionUsingAttributes() {
        GroundStationPosition groundStationPosition = new GroundStationPosition(1.0, 2.0, 3.0);
        Assert.assertTrue(Math.abs(1.0 - groundStationPosition.getLatitude()) < 1.0E-6);
        Assert.assertTrue(Math.abs(2.0 - groundStationPosition.getLongitude()) < 1.0E-6);
        Assert.assertTrue(Math.abs(3.0 - groundStationPosition.getHeightAMSL()) < 1.0E-6);
    }

    @Test
    public void testSettingWrongNumberOfElevationsCausesException() {
        GroundStationPosition groundStationPosition = new GroundStationPosition();
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] elevations = nArray;
        try {
            groundStationPosition.setHorizonElevations(elevations);
            Assert.fail("IllegalArgumentException expected");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals(String.format("Expected 36 Horizon Elevations, got: %d", elevations.length), iae.getMessage());
        }
    }
}

