/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.io.Serializable;
import uk.me.g4dpz.satellite.AbstractSatellite;
import uk.me.g4dpz.satellite.TLE;

public class DeepSpaceSatellite
extends AbstractSatellite
implements Serializable {
    private static final long serialVersionUID = -9151311937099118037L;
    private double c1;
    private double c4;
    private double x1mth2;
    private double x3thm1;
    private double xlcof;
    private double xnodcf;
    private double t2cof;
    private double aycof;
    private double x7thm1;
    private boolean sdp4Init;
    private final DeepSpaceValueObject dsv = new DeepSpaceValueObject();
    private final DeepSpaceCalculator deep = new DeepSpaceCalculator();

    public DeepSpaceSatellite(TLE tle) {
        super(tle);
        this.initSDP4();
    }

    @Override
    protected synchronized void calculateSDP4(double tsince) {
        double capu;
        double[] temp = new double[12];
        if (!this.sdp4Init) {
            this.initSDP4();
        }
        double xmdf = this.getTLE().getXmo() + this.dsv.xmdot * tsince;
        double tsq = tsince * tsince;
        double templ = this.t2cof * tsq;
        this.dsv.xll = xmdf + this.dsv.xnodp * templ;
        this.dsv.omgadf = this.getTLE().getOmegao() + this.dsv.omgdot * tsince;
        double xnoddf = this.getTLE().getXnodeo() + this.dsv.xnodot * tsince;
        this.dsv.xnode = xnoddf + this.xnodcf * tsq;
        double tempa = 1.0 - this.c1 * tsince;
        double tempe = this.getTLE().getBstar() * this.c4 * tsince;
        this.dsv.xn = this.dsv.xnodp;
        this.dsv.t = tsince;
        this.deep.dpsec(this.getTLE());
        double a = Math.pow(0.0743669161 / this.dsv.xn, 0.6666666666666666) * tempa * tempa;
        this.dsv.em = this.dsv.em - tempe;
        this.deep.dpper(this.getTLE());
        double xl = this.dsv.xll + this.dsv.omgadf + this.dsv.xnode;
        double beta = Math.sqrt(1.0 - this.dsv.em * this.dsv.em);
        this.dsv.xn = 0.0743669161 / Math.pow(a, 1.5);
        double axn = this.dsv.em * Math.cos(this.dsv.omgadf);
        temp[0] = AbstractSatellite.invert(a * beta * beta);
        double xll = temp[0] * this.xlcof * axn;
        double aynl = temp[0] * this.aycof;
        double xlt = xl + xll;
        double ayn = this.dsv.em * Math.sin(this.dsv.omgadf) + aynl;
        temp[2] = capu = AbstractSatellite.mod2PI(xlt - this.dsv.xnode);
        AbstractSatellite.converge(temp, axn, ayn, capu);
        this.calculatePositionAndVelocity(temp, a, axn, ayn);
        this.calculatePhase(xlt, this.dsv.xnode, this.dsv.omgadf);
    }

    private void calculatePositionAndVelocity(double[] temp, double a, double axn, double ayn) {
        double ecose = temp[5] + temp[6];
        double esine = temp[3] - temp[4];
        double elsq = axn * axn + ayn * ayn;
        temp[0] = 1.0 - elsq;
        double pl = a * temp[0];
        temp[9] = a * (1.0 - ecose);
        temp[1] = AbstractSatellite.invert(temp[9]);
        temp[10] = 0.0743669161 * Math.sqrt(a) * esine * temp[1];
        temp[11] = 0.0743669161 * Math.sqrt(pl) * temp[1];
        temp[2] = a * temp[1];
        double betal = Math.sqrt(temp[0]);
        temp[3] = AbstractSatellite.invert(1.0 + betal);
        double cosu = temp[2] * (temp[8] - axn + ayn * esine * temp[3]);
        double sinu = temp[2] * (temp[7] - ayn - axn * esine * temp[3]);
        double u = Math.atan2(sinu, cosu);
        double sin2u = 2.0 * sinu * cosu;
        double cos2u = 2.0 * cosu * cosu - 1.0;
        temp[0] = AbstractSatellite.invert(pl);
        temp[1] = 5.413079E-4 * temp[0];
        temp[2] = temp[1] * temp[0];
        double rk = temp[9] * (1.0 - 1.5 * temp[2] * betal * this.x3thm1) + 0.5 * temp[1] * this.x1mth2 * cos2u;
        double uk = u - 0.25 * temp[2] * this.x7thm1 * sin2u;
        double xnodek = this.dsv.xnode + 1.5 * temp[2] * this.dsv.cosio * sin2u;
        double xinck = this.dsv.xinc + 1.5 * temp[2] * this.dsv.cosio * this.dsv.sinio * cos2u;
        double rdotk = temp[10] - this.dsv.xn * temp[1] * this.x1mth2 * sin2u;
        double rfdotk = temp[11] + this.dsv.xn * temp[1] * (this.x1mth2 * cos2u + 1.5 * this.x3thm1);
        super.calculatePositionAndVelocity(rk, uk, xnodek, xinck, rdotk, rfdotk);
    }

    private void initSDP4() {
        this.sdp4Init = true;
        this.recoverMeanMotionAndSemiMajorAxis();
        this.setPerigee((this.dsv.aodp * (1.0 - this.getTLE().getEo()) - 1.0) * 6378.137);
        this.checkPerigee();
        double pinvsq = AbstractSatellite.invert(this.dsv.aodp * this.dsv.aodp * this.dsv.betao2 * this.dsv.betao2);
        this.dsv.sing = Math.sin(this.getTLE().getOmegao());
        this.dsv.cosg = Math.cos(this.getTLE().getOmegao());
        double tsi = AbstractSatellite.invert(this.dsv.aodp - this.getS4());
        double eta = this.dsv.aodp * this.getTLE().getEo() * tsi;
        double etasq = eta * eta;
        double eeta = this.getTLE().getEo() * eta;
        double psisq = Math.abs(1.0 - etasq);
        double coef = this.getQoms24() * Math.pow(tsi, 4.0);
        double coef1 = coef / Math.pow(psisq, 3.5);
        double c2 = coef1 * this.dsv.xnodp * (this.dsv.aodp * (1.0 + 1.5 * etasq + eeta * (4.0 + etasq)) + 4.05980925E-4 * tsi / psisq * this.x3thm1 * (8.0 + 3.0 * etasq * (8.0 + etasq)));
        this.c1 = this.getTLE().getBstar() * c2;
        this.dsv.sinio = Math.sin(this.getTLE().getXincl());
        double a3ovk2 = 0.004690140306468833;
        this.x1mth2 = 1.0 - this.dsv.theta2;
        this.c4 = 2.0 * this.dsv.xnodp * coef1 * this.dsv.aodp * this.dsv.betao2 * (eta * (2.0 + 0.5 * etasq) + this.getTLE().getEo() * (0.5 + 2.0 * etasq) - 0.0010826158 * tsi / (this.dsv.aodp * psisq) * (-3.0 * this.x3thm1 * (1.0 - 2.0 * eeta + etasq * (1.5 - 0.5 * eeta)) + 0.75 * this.x1mth2 * (2.0 * etasq - eeta * (1.0 + etasq)) * Math.cos(2.0 * this.getTLE().getOmegao())));
        double theta4 = this.dsv.theta2 * this.dsv.theta2;
        double temp1 = 0.0016239237 * pinvsq * this.dsv.xnodp;
        double temp2 = temp1 * 5.413079E-4 * pinvsq;
        double temp3 = 7.762358750000001E-7 * pinvsq * pinvsq * this.dsv.xnodp;
        this.dsv.xmdot = this.dsv.xnodp + 0.5 * temp1 * this.dsv.betao * this.x3thm1 + 0.0625 * temp2 * this.dsv.betao * (13.0 - 78.0 * this.dsv.theta2 + 137.0 * theta4);
        double x1m5th = 1.0 - 5.0 * this.dsv.theta2;
        this.dsv.omgdot = -0.5 * temp1 * x1m5th + 0.0625 * temp2 * (7.0 - 114.0 * this.dsv.theta2 + 395.0 * theta4) + temp3 * (3.0 - 36.0 * this.dsv.theta2 + 49.0 * theta4);
        double xhdot1 = -temp1 * this.dsv.cosio;
        this.dsv.xnodot = xhdot1 + (0.5 * temp2 * (4.0 - 19.0 * this.dsv.theta2) + 2.0 * temp3 * (3.0 - 7.0 * this.dsv.theta2)) * this.dsv.cosio;
        this.xnodcf = 3.5 * this.dsv.betao2 * xhdot1 * this.c1;
        this.t2cof = 1.5 * this.c1;
        this.xlcof = 5.862675383086041E-4 * this.dsv.sinio * (3.0 + 5.0 * this.dsv.cosio) / (1.0 + this.dsv.cosio);
        this.aycof = 0.0011725350766172082 * this.dsv.sinio;
        this.x7thm1 = 7.0 * this.dsv.theta2 - 1.0;
        this.deep.init(this.getTLE());
    }

    private void recoverMeanMotionAndSemiMajorAxis() {
        double a1 = Math.pow(0.0743669161 / this.getTLE().getXno(), 0.6666666666666666);
        this.dsv.cosio = Math.cos(this.getTLE().getXincl());
        this.dsv.theta2 = this.dsv.cosio * this.dsv.cosio;
        this.x3thm1 = 3.0 * this.dsv.theta2 - 1.0;
        this.dsv.eosq = this.getTLE().getEo() * this.getTLE().getEo();
        this.dsv.betao2 = 1.0 - this.dsv.eosq;
        this.dsv.betao = Math.sqrt(this.dsv.betao2);
        double del1 = 8.1196185E-4 * this.x3thm1 / (a1 * a1 * this.dsv.betao * this.dsv.betao2);
        double ao = a1 * (1.0 - del1 * (0.3333333333333333 + del1 * (1.0 + 1.0 * del1)));
        double delo = 8.1196185E-4 * this.x3thm1 / (ao * ao * this.dsv.betao * this.dsv.betao2);
        this.dsv.xnodp = this.getTLE().getXno() / (1.0 + delo);
        this.dsv.aodp = ao / (1.0 - delo);
    }

    final class DeepSpaceCalculator
    implements Serializable {
        private static final long serialVersionUID = -1154274461279090353L;
        static final double ZSINIS = 0.39785416;
        static final double ZSINGS = -0.98088458;
        static final double ZNS = 1.19459E-5;
        static final double C1SS = 2.9864797E-6;
        static final double ZES = 0.01675;
        static final double ZNL = 1.5835218E-4;
        static final double C1L = 4.7968065E-7;
        static final double ZEL = 0.0549;
        static final double ROOT22 = 1.7891679E-6;
        static final double ROOT32 = 3.7393792E-7;
        static final double ROOT44 = 7.3636953E-9;
        static final double ROOT52 = 1.1428639E-7;
        static final double ROOT54 = 2.1765803E-9;
        static final double THDT = 0.0043752691;
        static final double Q22 = 1.7891679E-6;
        static final double Q31 = 2.1460748E-6;
        static final double Q33 = 2.2123015E-7;
        static final double G22 = 5.7686396;
        static final double G32 = 0.95240898;
        static final double G44 = 1.8014998;
        static final double G52 = 1.050833;
        static final double G54 = 4.4108898;
        private double thgr;
        private double xnq;
        private double xqncl;
        private double omegaq;
        private double zmol;
        private double zmos;
        private double savtsn;
        private double ee2;
        private double e3;
        private double xi2;
        private double xl2;
        private double xl3;
        private double xl4;
        private double xgh2;
        private double xgh3;
        private double xgh4;
        private double xh2;
        private double xh3;
        private double sse;
        private double ssi;
        private double ssg;
        private double xi3;
        private double se2;
        private double si2;
        private double sl2;
        private double sgh2;
        private double sh2;
        private double se3;
        private double si3;
        private double sl3;
        private double sgh3;
        private double sh3;
        private double sl4;
        private double sgh4;
        private double ssl;
        private double ssh;
        private double d3210;
        private double d3222;
        private double d4410;
        private double d4422;
        private double d5220;
        private double d5232;
        private double d5421;
        private double d5433;
        private double del1;
        private double del2;
        private double del3;
        private double fasx2;
        private double fasx4;
        private double fasx6;
        private double xlamo;
        private double xfact;
        private double xni;
        private double atime;
        private double stepp;
        private double stepn;
        private double step2;
        private double preep;
        private double pl;
        private double sghs;
        private double xli;
        private double d2201;
        private double d2211;
        private double sghl;
        private double sh1;
        private double pinc;
        private double pe;
        private double shs;
        private double zsingl;
        private double zcosgl;
        private double zsinhl;
        private double zcoshl;
        private double zsinil;
        private double zcosil;
        private double a1;
        private double a2;
        private double a3;
        private double a4;
        private double a5;
        private double a6;
        private double a7;
        private double a8;
        private double a9;
        private double a10;
        private double ainv2;
        private double alfdp;
        private double aqnv;
        private double sgh;
        private double sini2;
        private double sinis;
        private double sinok;
        private double sh;
        private double si;
        private double sil;
        private double day;
        private double betdp;
        private double dalf;
        private double bfact;
        private double c;
        private double cc;
        private double cosis;
        private double cosok;
        private double cosq;
        private double ctem;
        private double f322;
        private double zx;
        private double zy;
        private double dbet;
        private double dls;
        private double eoc;
        private double eq;
        private double f2;
        private double f220;
        private double f221;
        private double f3;
        private double f311;
        private double f321;
        private double xnoh;
        private double f330;
        private double f441;
        private double f442;
        private double f522;
        private double f523;
        private double f542;
        private double f543;
        private double g200;
        private double g201;
        private double g211;
        private double pgh;
        private double ph;
        private double s1;
        private double s2;
        private double s3;
        private double s4;
        private double s5;
        private double s6;
        private double s7;
        private double se;
        private double sel;
        private double ses;
        private double xls;
        private double g300;
        private double g310;
        private double g322;
        private double g410;
        private double g422;
        private double g520;
        private double g521;
        private double g532;
        private double g533;
        private double gam;
        private double sinq;
        private double sinzf;
        private double sis;
        private double sl;
        private double sll;
        private double sls;
        private double stem;
        private double temp;
        private double temp1;
        private double x1;
        private double x2;
        private double x2li;
        private double x2omi;
        private double x3;
        private double x4;
        private double x5;
        private double x6;
        private double x7;
        private double x8;
        private double xl;
        private double xldot;
        private double xmao;
        private double xnddt;
        private double xndot;
        private double xno2;
        private double xnodce;
        private double xnoi;
        private double xomi;
        private double xpidot;
        private double z1;
        private double z11;
        private double z12;
        private double z13;
        private double z2;
        private double z21;
        private double z22;
        private double z23;
        private double z3;
        private double z31;
        private double z32;
        private double z33;
        private double ze;
        private double zf;
        private double zm;
        private double zn;
        private double zsing;
        private double zsinh;
        private double zsini;
        private double zcosg;
        private double zcosh;
        private double zcosi;
        private double delt;
        private double ft;
        private boolean lunarTermsDone;
        private boolean resonance;
        private boolean synchronous;
        private boolean doLoop;
        private boolean epochRestart;

        private DeepSpaceCalculator() {
        }

        private void init(TLE tle) {
            this.thgr = this.thetaG(tle.getRefepoch());
            this.eq = tle.getEo();
            this.xnq = DeepSpaceSatellite.this.dsv.xnodp;
            this.aqnv = AbstractSatellite.invert(DeepSpaceSatellite.this.dsv.aodp);
            this.xqncl = tle.getXincl();
            this.xmao = tle.getXmo();
            this.xpidot = DeepSpaceSatellite.this.dsv.omgdot + DeepSpaceSatellite.this.dsv.xnodot;
            this.sinq = Math.sin(tle.getXnodeo());
            this.cosq = Math.cos(tle.getXnodeo());
            this.omegaq = tle.getOmegao();
            this.initLunarSolarTerms();
            this.doSolarTerms();
            this.resonance = false;
            this.synchronous = false;
            if (!(this.xnq < 0.0052359877) || !(this.xnq > 0.0034906585)) {
                if (this.xnq < 0.00826 || this.xnq > 0.00924) {
                    return;
                }
                if (this.eq < 0.5) {
                    return;
                }
                this.calculateResonance(tle);
            } else {
                this.initSynchronousResonanceTerms(tle);
            }
            this.xfact = this.bfact - this.xnq;
            this.xli = this.xlamo;
            this.xni = this.xnq;
            this.atime = 0.0;
            this.stepp = 720.0;
            this.stepn = -720.0;
            this.step2 = 259200.0;
        }

        private void calculateResonance(TLE tle) {
            this.resonance = true;
            this.eoc = this.eq * DeepSpaceSatellite.this.dsv.eosq;
            this.g201 = -0.306 - (this.eq - 0.64) * 0.44;
            if (this.eq <= 0.65) {
                this.g211 = 3.616 - 13.247 * this.eq + 16.29 * DeepSpaceSatellite.this.dsv.eosq;
                this.g310 = -19.302 + 117.39 * this.eq - 228.419 * DeepSpaceSatellite.this.dsv.eosq + 156.591 * this.eoc;
                this.g322 = -18.9068 + 109.7927 * this.eq - 214.6334 * DeepSpaceSatellite.this.dsv.eosq + 146.5816 * this.eoc;
                this.g410 = -41.122 + 242.694 * this.eq - 471.094 * DeepSpaceSatellite.this.dsv.eosq + 313.953 * this.eoc;
                this.g422 = -146.407 + 841.88 * this.eq - 1629.014 * DeepSpaceSatellite.this.dsv.eosq + 1083.435 * this.eoc;
                this.g520 = -532.114 + 3017.977 * this.eq - 5740.0 * DeepSpaceSatellite.this.dsv.eosq + 3708.276 * this.eoc;
            } else {
                this.g211 = -72.099 + 331.819 * this.eq - 508.738 * DeepSpaceSatellite.this.dsv.eosq + 266.724 * this.eoc;
                this.g310 = -346.844 + 1582.851 * this.eq - 2415.925 * DeepSpaceSatellite.this.dsv.eosq + 1246.113 * this.eoc;
                this.g322 = -342.585 + 1554.908 * this.eq - 2366.899 * DeepSpaceSatellite.this.dsv.eosq + 1215.972 * this.eoc;
                this.g410 = -1052.797 + 4758.686 * this.eq - 7193.992 * DeepSpaceSatellite.this.dsv.eosq + 3651.957 * this.eoc;
                this.g422 = -3581.69 + 16178.11 * this.eq - 24462.77 * DeepSpaceSatellite.this.dsv.eosq + 12422.52 * this.eoc;
                this.g520 = this.eq <= 0.715 ? 1464.74 - 4664.75 * this.eq + 3763.64 * DeepSpaceSatellite.this.dsv.eosq : -5149.66 + 29936.92 * this.eq - 54087.36 * DeepSpaceSatellite.this.dsv.eosq + 31324.56 * this.eoc;
            }
            if (this.eq < 0.7) {
                this.g533 = -919.2277 + 4988.61 * this.eq - 9064.77 * DeepSpaceSatellite.this.dsv.eosq + 5542.21 * this.eoc;
                this.g521 = -822.71072 + 4568.6173 * this.eq - 8491.4146 * DeepSpaceSatellite.this.dsv.eosq + 5337.524 * this.eoc;
                this.g532 = -853.666 + 4690.25 * this.eq - 8624.77 * DeepSpaceSatellite.this.dsv.eosq + 5341.4 * this.eoc;
            } else {
                this.g533 = -37995.78 + 161616.52 * this.eq - 229838.2 * DeepSpaceSatellite.this.dsv.eosq + 109377.94 * this.eoc;
                this.g521 = -51752.104 + 218913.95 * this.eq - 309468.16 * DeepSpaceSatellite.this.dsv.eosq + 146349.42 * this.eoc;
                this.g532 = -40023.88 + 170470.89 * this.eq - 242699.48 * DeepSpaceSatellite.this.dsv.eosq + 115605.82 * this.eoc;
            }
            this.sini2 = DeepSpaceSatellite.this.dsv.sinio * DeepSpaceSatellite.this.dsv.sinio;
            this.f220 = 0.75 * (1.0 + 2.0 * DeepSpaceSatellite.this.dsv.cosio + DeepSpaceSatellite.this.dsv.theta2);
            this.f221 = 1.5 * this.sini2;
            this.f321 = 1.875 * DeepSpaceSatellite.this.dsv.sinio * (1.0 - 2.0 * DeepSpaceSatellite.this.dsv.cosio - 3.0 * DeepSpaceSatellite.this.dsv.theta2);
            this.f322 = -1.875 * DeepSpaceSatellite.this.dsv.sinio * (1.0 + 2.0 * DeepSpaceSatellite.this.dsv.cosio - 3.0 * DeepSpaceSatellite.this.dsv.theta2);
            this.f441 = 35.0 * this.sini2 * this.f220;
            this.f442 = 39.375 * this.sini2 * this.sini2;
            this.f522 = 9.84375 * DeepSpaceSatellite.this.dsv.sinio * (this.sini2 * (1.0 - 2.0 * DeepSpaceSatellite.this.dsv.cosio - 5.0 * DeepSpaceSatellite.this.dsv.theta2) + 0.33333333 * (-2.0 + 4.0 * DeepSpaceSatellite.this.dsv.cosio + 6.0 * DeepSpaceSatellite.this.dsv.theta2));
            this.f523 = DeepSpaceSatellite.this.dsv.sinio * (4.92187512 * this.sini2 * (-2.0 - 4.0 * DeepSpaceSatellite.this.dsv.cosio + 10.0 * DeepSpaceSatellite.this.dsv.theta2) + 6.56250012 * (1.0 + 2.0 * DeepSpaceSatellite.this.dsv.cosio - 3.0 * DeepSpaceSatellite.this.dsv.theta2));
            this.f542 = 29.53125 * DeepSpaceSatellite.this.dsv.sinio * (2.0 - 8.0 * DeepSpaceSatellite.this.dsv.cosio + DeepSpaceSatellite.this.dsv.theta2 * (-12.0 + 8.0 * DeepSpaceSatellite.this.dsv.cosio + 10.0 * DeepSpaceSatellite.this.dsv.theta2));
            this.f543 = 29.53125 * DeepSpaceSatellite.this.dsv.sinio * (-2.0 - 8.0 * DeepSpaceSatellite.this.dsv.cosio + DeepSpaceSatellite.this.dsv.theta2 * (12.0 + 8.0 * DeepSpaceSatellite.this.dsv.cosio - 10.0 * DeepSpaceSatellite.this.dsv.theta2));
            this.xno2 = this.xnq * this.xnq;
            this.ainv2 = this.aqnv * this.aqnv;
            this.temp1 = 3.0 * this.xno2 * this.ainv2;
            this.temp = this.temp1 * 1.7891679E-6;
            this.d2201 = this.temp * this.f220 * this.g201;
            this.d2211 = this.temp * this.f221 * this.g211;
            this.temp1 *= this.aqnv;
            this.temp = this.temp1 * 3.7393792E-7;
            this.d3210 = this.temp * this.f321 * this.g310;
            this.d3222 = this.temp * this.f322 * this.g322;
            this.temp1 *= this.aqnv;
            this.temp = 2.0 * this.temp1 * 7.3636953E-9;
            this.d4410 = this.temp * this.f441 * this.g410;
            this.d4422 = this.temp * this.f442 * this.g422;
            this.temp1 *= this.aqnv;
            this.temp = this.temp1 * 1.1428639E-7;
            this.d5220 = this.temp * this.f522 * this.g520;
            this.d5232 = this.temp * this.f523 * this.g532;
            this.temp = 2.0 * this.temp1 * 2.1765803E-9;
            this.d5421 = this.temp * this.f542 * this.g521;
            this.d5433 = this.temp * this.f543 * this.g533;
            this.xlamo = this.xmao + tle.getXnodeo() + tle.getXnodeo() - this.thgr - this.thgr;
            this.bfact = DeepSpaceSatellite.this.dsv.xmdot + DeepSpaceSatellite.this.dsv.xnodot + DeepSpaceSatellite.this.dsv.xnodot - 0.0043752691 - 0.0043752691;
            this.bfact = this.bfact + this.ssl + this.ssh + this.ssh;
        }

        private void doSolarTerms() {
            this.savtsn = 1.0E20;
            this.zcosg = 0.1945905;
            this.zsing = -0.98088458;
            this.zcosi = 0.91744867;
            this.zsini = 0.39785416;
            this.zcosh = this.cosq;
            this.zsinh = this.sinq;
            this.cc = 2.9864797E-6;
            this.zn = 1.19459E-5;
            this.ze = 0.01675;
            this.xnoi = AbstractSatellite.invert(this.xnq);
            while (true) {
                this.calculateSolarTerms();
                if (this.lunarTermsDone) break;
                this.calculateLunarTerms();
            }
            this.sse += this.se;
            this.ssi += this.si;
            this.ssl += this.sl;
            this.ssg = this.ssg + this.sgh - DeepSpaceSatellite.this.dsv.cosio / DeepSpaceSatellite.this.dsv.sinio * this.sh;
            this.ssh += this.sh / DeepSpaceSatellite.this.dsv.sinio;
        }

        private void calculateLunarTerms() {
            this.sse = this.se;
            this.ssi = this.si;
            this.ssl = this.sl;
            this.ssh = this.sh / DeepSpaceSatellite.this.dsv.sinio;
            this.ssg = this.sgh - DeepSpaceSatellite.this.dsv.cosio * this.ssh;
            this.se2 = this.ee2;
            this.si2 = this.xi2;
            this.sl2 = this.xl2;
            this.sgh2 = this.xgh2;
            this.sh2 = this.xh2;
            this.se3 = this.e3;
            this.si3 = this.xi3;
            this.sl3 = this.xl3;
            this.sgh3 = this.xgh3;
            this.sh3 = this.xh3;
            this.sl4 = this.xl4;
            this.sgh4 = this.xgh4;
            this.zcosg = this.zcosgl;
            this.zsing = this.zsingl;
            this.zcosi = this.zcosil;
            this.zsini = this.zsinil;
            this.zcosh = this.zcoshl * this.cosq + this.zsinhl * this.sinq;
            this.zsinh = this.sinq * this.zcoshl - this.cosq * this.zsinhl;
            this.zn = 1.5835218E-4;
            this.cc = 4.7968065E-7;
            this.ze = 0.0549;
            this.lunarTermsDone = true;
        }

        private void calculateSolarTerms() {
            this.a1 = this.zcosg * this.zcosh + this.zsing * this.zcosi * this.zsinh;
            this.a3 = -this.zsing * this.zcosh + this.zcosg * this.zcosi * this.zsinh;
            this.a7 = -this.zcosg * this.zsinh + this.zsing * this.zcosi * this.zcosh;
            this.a8 = this.zsing * this.zsini;
            this.a9 = this.zsing * this.zsinh + this.zcosg * this.zcosi * this.zcosh;
            this.a10 = this.zcosg * this.zsini;
            this.a2 = DeepSpaceSatellite.this.dsv.cosio * this.a7 + DeepSpaceSatellite.this.dsv.sinio * this.a8;
            this.a4 = DeepSpaceSatellite.this.dsv.cosio * this.a9 + DeepSpaceSatellite.this.dsv.sinio * this.a10;
            this.a5 = -DeepSpaceSatellite.this.dsv.sinio * this.a7 + DeepSpaceSatellite.this.dsv.cosio * this.a8;
            this.a6 = -DeepSpaceSatellite.this.dsv.sinio * this.a9 + DeepSpaceSatellite.this.dsv.cosio * this.a10;
            this.x1 = this.a1 * DeepSpaceSatellite.this.dsv.cosg + this.a2 * DeepSpaceSatellite.this.dsv.sing;
            this.x2 = this.a3 * DeepSpaceSatellite.this.dsv.cosg + this.a4 * DeepSpaceSatellite.this.dsv.sing;
            this.x3 = -this.a1 * DeepSpaceSatellite.this.dsv.sing + this.a2 * DeepSpaceSatellite.this.dsv.cosg;
            this.x4 = -this.a3 * DeepSpaceSatellite.this.dsv.sing + this.a4 * DeepSpaceSatellite.this.dsv.cosg;
            this.x5 = this.a5 * DeepSpaceSatellite.this.dsv.sing;
            this.x6 = this.a6 * DeepSpaceSatellite.this.dsv.sing;
            this.x7 = this.a5 * DeepSpaceSatellite.this.dsv.cosg;
            this.x8 = this.a6 * DeepSpaceSatellite.this.dsv.cosg;
            this.z31 = 12.0 * this.x1 * this.x1 - 3.0 * this.x3 * this.x3;
            this.z32 = 24.0 * this.x1 * this.x2 - 6.0 * this.x3 * this.x4;
            this.z33 = 12.0 * this.x2 * this.x2 - 3.0 * this.x4 * this.x4;
            this.z1 = 3.0 * (this.a1 * this.a1 + this.a2 * this.a2) + this.z31 * DeepSpaceSatellite.this.dsv.eosq;
            this.z2 = 6.0 * (this.a1 * this.a3 + this.a2 * this.a4) + this.z32 * DeepSpaceSatellite.this.dsv.eosq;
            this.z3 = 3.0 * (this.a3 * this.a3 + this.a4 * this.a4) + this.z33 * DeepSpaceSatellite.this.dsv.eosq;
            this.z11 = -6.0 * this.a1 * this.a5 + DeepSpaceSatellite.this.dsv.eosq * (-24.0 * this.x1 * this.x7 - 6.0 * this.x3 * this.x5);
            this.z12 = -6.0 * (this.a1 * this.a6 + this.a3 * this.a5) + DeepSpaceSatellite.this.dsv.eosq * (-24.0 * (this.x2 * this.x7 + this.x1 * this.x8) - 6.0 * (this.x3 * this.x6 + this.x4 * this.x5));
            this.z13 = -6.0 * this.a3 * this.a6 + DeepSpaceSatellite.this.dsv.eosq * (-24.0 * this.x2 * this.x8 - 6.0 * this.x4 * this.x6);
            this.z21 = 6.0 * this.a2 * this.a5 + DeepSpaceSatellite.this.dsv.eosq * (24.0 * this.x1 * this.x5 - 6.0 * this.x3 * this.x7);
            this.z22 = 6.0 * (this.a4 * this.a5 + this.a2 * this.a6) + DeepSpaceSatellite.this.dsv.eosq * (24.0 * (this.x2 * this.x5 + this.x1 * this.x6) - 6.0 * (this.x4 * this.x7 + this.x3 * this.x8));
            this.z23 = 6.0 * this.a4 * this.a6 + DeepSpaceSatellite.this.dsv.eosq * (24.0 * this.x2 * this.x6 - 6.0 * this.x4 * this.x8);
            this.z1 = this.z1 + this.z1 + DeepSpaceSatellite.this.dsv.betao2 * this.z31;
            this.z2 = this.z2 + this.z2 + DeepSpaceSatellite.this.dsv.betao2 * this.z32;
            this.z3 = this.z3 + this.z3 + DeepSpaceSatellite.this.dsv.betao2 * this.z33;
            this.s3 = this.cc * this.xnoi;
            this.s2 = -0.5 * this.s3 / DeepSpaceSatellite.this.dsv.betao;
            this.s4 = this.s3 * DeepSpaceSatellite.this.dsv.betao;
            this.s1 = -15.0 * this.eq * this.s4;
            this.s5 = this.x1 * this.x3 + this.x2 * this.x4;
            this.s6 = this.x2 * this.x3 + this.x1 * this.x4;
            this.s7 = this.x2 * this.x4 - this.x1 * this.x3;
            this.se = this.s1 * this.zn * this.s5;
            this.si = this.s2 * this.zn * (this.z11 + this.z13);
            this.sl = -this.zn * this.s3 * (this.z1 + this.z3 - 14.0 - 6.0 * DeepSpaceSatellite.this.dsv.eosq);
            this.sgh = this.s4 * this.zn * (this.z31 + this.z33 - 6.0);
            this.sh = -this.zn * this.s2 * (this.z21 + this.z23);
            if (this.xqncl < 0.052359877) {
                this.sh = 0.0;
            }
            this.ee2 = 2.0 * this.s1 * this.s6;
            this.e3 = 2.0 * this.s1 * this.s7;
            this.xi2 = 2.0 * this.s2 * this.z12;
            this.xi3 = 2.0 * this.s2 * (this.z13 - this.z11);
            this.xl2 = -2.0 * this.s3 * this.z2;
            this.xl3 = -2.0 * this.s3 * (this.z3 - this.z1);
            this.xl4 = -2.0 * this.s3 * (-21.0 - 9.0 * DeepSpaceSatellite.this.dsv.eosq) * this.ze;
            this.xgh2 = 2.0 * this.s4 * this.z32;
            this.xgh3 = 2.0 * this.s4 * (this.z33 - this.z31);
            this.xgh4 = -18.0 * this.s4 * this.ze;
            this.xh2 = -2.0 * this.s2 * this.z22;
            this.xh3 = -2.0 * this.s2 * (this.z23 - this.z21);
        }

        private void initLunarSolarTerms() {
            this.day = DeepSpaceSatellite.this.dsv.ds50 + 18261.5;
            if (Math.abs(this.day - this.preep) > 1.0E-6) {
                this.preep = this.day;
                this.xnodce = 4.523602 - 9.2422029E-4 * this.day;
                this.stem = Math.sin(this.xnodce);
                this.ctem = Math.cos(this.xnodce);
                this.zcosil = 0.91375164 - 0.03568096 * this.ctem;
                this.zsinil = Math.sqrt(1.0 - this.zcosil * this.zcosil);
                this.zsinhl = 0.089683511 * this.stem / this.zsinil;
                this.zcoshl = Math.sqrt(1.0 - this.zsinhl * this.zsinhl);
                this.c = 4.7199672 + 0.2299715 * this.day;
                this.gam = 5.8351514 + 0.001944368 * this.day;
                this.zmol = AbstractSatellite.mod2PI(this.c - this.gam);
                this.zx = 0.39785416 * this.stem / this.zsinil;
                this.zy = this.zcoshl * this.ctem + 0.91744867 * this.zsinhl * this.stem;
                this.zx = Math.atan2(this.zx, this.zy);
                this.zx = this.gam + this.zx - this.xnodce;
                this.zcosgl = Math.cos(this.zx);
                this.zsingl = Math.sin(this.zx);
                this.zmos = 6.2565837 + 0.017201977 * this.day;
                this.zmos = AbstractSatellite.mod2PI(this.zmos);
            }
        }

        private void initSynchronousResonanceTerms(TLE tle) {
            this.resonance = true;
            this.synchronous = true;
            this.g200 = 1.0 + DeepSpaceSatellite.this.dsv.eosq * (-2.5 + 0.8125 * DeepSpaceSatellite.this.dsv.eosq);
            this.g310 = 1.0 + 2.0 * DeepSpaceSatellite.this.dsv.eosq;
            this.g300 = 1.0 + DeepSpaceSatellite.this.dsv.eosq * (-6.0 + 6.60937 * DeepSpaceSatellite.this.dsv.eosq);
            this.f220 = 0.75 * (1.0 + DeepSpaceSatellite.this.dsv.cosio) * (1.0 + DeepSpaceSatellite.this.dsv.cosio);
            this.f311 = 0.9375 * DeepSpaceSatellite.this.dsv.sinio * DeepSpaceSatellite.this.dsv.sinio * (1.0 + 3.0 * DeepSpaceSatellite.this.dsv.cosio) - 0.75 * (1.0 + DeepSpaceSatellite.this.dsv.cosio);
            this.f330 = 1.0 + DeepSpaceSatellite.this.dsv.cosio;
            this.f330 = 1.875 * this.f330 * this.f330 * this.f330;
            this.del1 = 3.0 * this.xnq * this.xnq * this.aqnv * this.aqnv;
            this.del2 = 2.0 * this.del1 * this.f220 * this.g200 * 1.7891679E-6;
            this.del3 = 3.0 * this.del1 * this.f330 * this.g300 * 2.2123015E-7 * this.aqnv;
            this.del1 = this.del1 * this.f311 * this.g310 * 2.1460748E-6 * this.aqnv;
            this.fasx2 = 0.13130908;
            this.fasx4 = 2.8843198;
            this.fasx6 = 0.37448087;
            this.xlamo = this.xmao + tle.getXnodeo() + tle.getOmegao() - this.thgr;
            this.bfact = DeepSpaceSatellite.this.dsv.xmdot + this.xpidot - 0.0043752691;
            this.bfact = this.bfact + this.ssl + this.ssg + this.ssh;
        }

        private void dpsec(TLE tle) {
            DeepSpaceSatellite.this.dsv.xll = DeepSpaceSatellite.this.dsv.xll + this.ssl * DeepSpaceSatellite.this.dsv.t;
            DeepSpaceSatellite.this.dsv.omgadf = DeepSpaceSatellite.this.dsv.omgadf + this.ssg * DeepSpaceSatellite.this.dsv.t;
            DeepSpaceSatellite.this.dsv.xnode = DeepSpaceSatellite.this.dsv.xnode + this.ssh * DeepSpaceSatellite.this.dsv.t;
            DeepSpaceSatellite.this.dsv.em = tle.getEo() + this.sse * DeepSpaceSatellite.this.dsv.t;
            DeepSpaceSatellite.this.dsv.xinc = tle.getXincl() + this.ssi * DeepSpaceSatellite.this.dsv.t;
            if (DeepSpaceSatellite.this.dsv.xinc < 0.0) {
                DeepSpaceSatellite.this.dsv.xinc = -DeepSpaceSatellite.this.dsv.xinc;
                DeepSpaceSatellite.this.dsv.xnode = DeepSpaceSatellite.this.dsv.xnode + Math.PI;
                DeepSpaceSatellite.this.dsv.omgadf = DeepSpaceSatellite.this.dsv.omgadf - Math.PI;
            }
            if (!this.resonance) {
                return;
            }
            do {
                this.processEpochRestartLoop();
            } while (this.doLoop && this.epochRestart);
            DeepSpaceSatellite.this.dsv.xn = this.xni + this.xndot * this.ft + this.xnddt * this.ft * this.ft * 0.5;
            this.xl = this.xli + this.xldot * this.ft + this.xndot * this.ft * this.ft * 0.5;
            this.temp = -DeepSpaceSatellite.this.dsv.xnode + this.thgr + DeepSpaceSatellite.this.dsv.t * 0.0043752691;
            if (this.synchronous) {
                DeepSpaceSatellite.this.dsv.xll = this.xl - DeepSpaceSatellite.this.dsv.omgadf + this.temp;
            } else {
                DeepSpaceSatellite.this.dsv.xll = this.xl + this.temp + this.temp;
            }
        }

        private void processEpochRestartLoop() {
            if (this.atime == 0.0 || DeepSpaceSatellite.this.dsv.t >= 0.0 && this.atime < 0.0 || DeepSpaceSatellite.this.dsv.t < 0.0 && this.atime >= 0.0) {
                this.calclateDelt();
                this.atime = 0.0;
                this.xni = this.xnq;
                this.xli = this.xlamo;
            } else if (Math.abs(DeepSpaceSatellite.this.dsv.t) >= Math.abs(this.atime)) {
                this.calclateDelt();
            }
            this.processNotEpochRestartLoop();
        }

        private void calclateDelt() {
            this.delt = DeepSpaceSatellite.this.dsv.t < 0.0 ? this.stepn : this.stepp;
        }

        private void processNotEpochRestartLoop() {
            do {
                if (Math.abs(DeepSpaceSatellite.this.dsv.t - this.atime) >= this.stepp) {
                    this.doLoop = true;
                    this.epochRestart = false;
                } else {
                    this.ft = DeepSpaceSatellite.this.dsv.t - this.atime;
                    this.doLoop = false;
                }
                if (Math.abs(DeepSpaceSatellite.this.dsv.t) < Math.abs(this.atime)) {
                    this.delt = DeepSpaceSatellite.this.dsv.t >= 0.0 ? this.stepn : this.stepp;
                    this.doLoop |= this.epochRestart;
                }
                if (this.synchronous) {
                    this.xndot = this.del1 * Math.sin(this.xli - this.fasx2) + this.del2 * Math.sin(2.0 * (this.xli - this.fasx4)) + this.del3 * Math.sin(3.0 * (this.xli - this.fasx6));
                    this.xnddt = this.del1 * Math.cos(this.xli - this.fasx2) + 2.0 * this.del2 * Math.cos(2.0 * (this.xli - this.fasx4)) + 3.0 * this.del3 * Math.cos(3.0 * (this.xli - this.fasx6));
                } else {
                    this.xomi = this.omegaq + DeepSpaceSatellite.this.dsv.omgdot * this.atime;
                    this.x2omi = this.xomi + this.xomi;
                    this.x2li = this.xli + this.xli;
                    this.xndot = this.d2201 * Math.sin(this.x2omi + this.xli - 5.7686396) + this.d2211 * Math.sin(this.xli - 5.7686396) + this.d3210 * Math.sin(this.xomi + this.xli - 0.95240898) + this.d3222 * Math.sin(-this.xomi + this.xli - 0.95240898) + this.d4410 * Math.sin(this.x2omi + this.x2li - 1.8014998) + this.d4422 * Math.sin(this.x2li - 1.8014998) + this.d5220 * Math.sin(this.xomi + this.xli - 1.050833) + this.d5232 * Math.sin(-this.xomi + this.xli - 1.050833) + this.d5421 * Math.sin(this.xomi + this.x2li - 4.4108898) + this.d5433 * Math.sin(-this.xomi + this.x2li - 4.4108898);
                    this.xnddt = this.d2201 * Math.cos(this.x2omi + this.xli - 5.7686396) + this.d2211 * Math.cos(this.xli - 5.7686396) + this.d3210 * Math.cos(this.xomi + this.xli - 0.95240898) + this.d3222 * Math.cos(-this.xomi + this.xli - 0.95240898) + this.d5220 * Math.cos(this.xomi + this.xli - 1.050833) + this.d5232 * Math.cos(-this.xomi + this.xli - 1.050833) + 2.0 * (this.d4410 * Math.cos(this.x2omi + this.x2li - 1.8014998) + this.d4422 * Math.cos(this.x2li - 1.8014998) + this.d5421 * Math.cos(this.xomi + this.x2li - 4.4108898) + this.d5433 * Math.cos(-this.xomi + this.x2li - 4.4108898));
                }
                this.xldot = this.xni + this.xfact;
                this.xnddt *= this.xldot;
                if (!this.doLoop) continue;
                this.xli = this.xli + this.xldot * this.delt + this.xndot * this.step2;
                this.xni = this.xni + this.xndot * this.delt + this.xnddt * this.step2;
                this.atime += this.delt;
            } while (this.doLoop && !this.epochRestart);
        }

        private void dpper(TLE tle) {
            this.sinis = Math.sin(DeepSpaceSatellite.this.dsv.xinc);
            this.cosis = Math.cos(DeepSpaceSatellite.this.dsv.xinc);
            if (Math.abs(this.savtsn - DeepSpaceSatellite.this.dsv.t) >= 30.0) {
                this.savtsn = DeepSpaceSatellite.this.dsv.t;
                this.zm = this.zmos + 1.19459E-5 * DeepSpaceSatellite.this.dsv.t;
                this.zf = this.zm + 0.0335 * Math.sin(this.zm);
                this.sinzf = Math.sin(this.zf);
                this.f2 = 0.5 * this.sinzf * this.sinzf - 0.25;
                this.f3 = -0.5 * this.sinzf * Math.cos(this.zf);
                this.ses = this.se2 * this.f2 + this.se3 * this.f3;
                this.sis = this.si2 * this.f2 + this.si3 * this.f3;
                this.sls = this.sl2 * this.f2 + this.sl3 * this.f3 + this.sl4 * this.sinzf;
                this.sghs = this.sgh2 * this.f2 + this.sgh3 * this.f3 + this.sgh4 * this.sinzf;
                this.shs = this.sh2 * this.f2 + this.sh3 * this.f3;
                this.zm = this.zmol + 1.5835218E-4 * DeepSpaceSatellite.this.dsv.t;
                this.zf = this.zm + 0.1098 * Math.sin(this.zm);
                this.sinzf = Math.sin(this.zf);
                this.f2 = 0.5 * this.sinzf * this.sinzf - 0.25;
                this.f3 = -0.5 * this.sinzf * Math.cos(this.zf);
                this.sel = this.ee2 * this.f2 + this.e3 * this.f3;
                this.sil = this.xi2 * this.f2 + this.xi3 * this.f3;
                this.sll = this.xl2 * this.f2 + this.xl3 * this.f3 + this.xl4 * this.sinzf;
                this.sghl = this.xgh2 * this.f2 + this.xgh3 * this.f3 + this.xgh4 * this.sinzf;
                this.sh1 = this.xh2 * this.f2 + this.xh3 * this.f3;
                this.pe = this.ses + this.sel;
                this.pinc = this.sis + this.sil;
                this.pl = this.sls + this.sll;
            }
            this.pgh = this.sghs + this.sghl;
            this.ph = this.shs + this.sh1;
            DeepSpaceSatellite.this.dsv.xinc = DeepSpaceSatellite.this.dsv.xinc + this.pinc;
            DeepSpaceSatellite.this.dsv.em = DeepSpaceSatellite.this.dsv.em + this.pe;
            if (this.xqncl >= 0.2) {
                this.ph /= DeepSpaceSatellite.this.dsv.sinio;
                this.pgh -= DeepSpaceSatellite.this.dsv.cosio * this.ph;
                DeepSpaceSatellite.this.dsv.omgadf = DeepSpaceSatellite.this.dsv.omgadf + this.pgh;
                DeepSpaceSatellite.this.dsv.xnode = DeepSpaceSatellite.this.dsv.xnode + this.ph;
                DeepSpaceSatellite.this.dsv.xll = DeepSpaceSatellite.this.dsv.xll + this.pl;
            } else {
                this.applyPeriodics();
                if (Math.abs(this.xnoh - DeepSpaceSatellite.this.dsv.xnode) > Math.PI) {
                    if (DeepSpaceSatellite.this.dsv.xnode < this.xnoh) {
                        DeepSpaceValueObject deepSpaceValueObject = DeepSpaceSatellite.this.dsv;
                        deepSpaceValueObject.xnode = deepSpaceValueObject.xnode + Math.PI * 2;
                    } else {
                        DeepSpaceValueObject deepSpaceValueObject = DeepSpaceSatellite.this.dsv;
                        deepSpaceValueObject.xnode = deepSpaceValueObject.xnode - Math.PI * 2;
                    }
                }
                DeepSpaceSatellite.this.dsv.xll = DeepSpaceSatellite.this.dsv.xll + this.pl;
                DeepSpaceSatellite.this.dsv.omgadf = this.xls - DeepSpaceSatellite.this.dsv.xll - Math.cos(DeepSpaceSatellite.this.dsv.xinc) * DeepSpaceSatellite.this.dsv.xnode;
            }
        }

        private void applyPeriodics() {
            this.sinok = Math.sin(DeepSpaceSatellite.this.dsv.xnode);
            this.cosok = Math.cos(DeepSpaceSatellite.this.dsv.xnode);
            this.alfdp = this.sinis * this.sinok;
            this.betdp = this.sinis * this.cosok;
            this.dalf = this.ph * this.cosok + this.pinc * this.cosis * this.sinok;
            this.dbet = -this.ph * this.sinok + this.pinc * this.cosis * this.cosok;
            this.alfdp += this.dalf;
            this.betdp += this.dbet;
            DeepSpaceSatellite.this.dsv.xnode = AbstractSatellite.mod2PI(DeepSpaceSatellite.this.dsv.xnode);
            this.xls = DeepSpaceSatellite.this.dsv.xll + DeepSpaceSatellite.this.dsv.omgadf + this.cosis * DeepSpaceSatellite.this.dsv.xnode;
            this.dls = this.pl + this.pgh - this.pinc * DeepSpaceSatellite.this.dsv.xnode * this.sinis;
            this.xls += this.dls;
            this.xnoh = DeepSpaceSatellite.this.dsv.xnode;
            DeepSpaceSatellite.this.dsv.xnode = Math.atan2(this.alfdp, this.betdp);
        }

        private double thetaG(double epoch) {
            double year = Math.floor(epoch * 0.001);
            double dayOfYear = (epoch * 0.001 - year) * 1000.0;
            year = year < 57.0 ? (year += 2000.0) : (year += 1900.0);
            double dayFloor = Math.floor(dayOfYear);
            double dayFraction = dayOfYear - dayFloor;
            dayOfYear = dayFloor;
            double jd = AbstractSatellite.julianDateOfYear(year) + dayOfYear;
            DeepSpaceSatellite.this.dsv.ds50 = jd - 2433281.5 + dayFraction;
            return AbstractSatellite.mod2PI(6.3003880987 * DeepSpaceSatellite.this.dsv.ds50 + 1.72944494);
        }
    }

    private static final class DeepSpaceValueObject
    implements Serializable {
        private static final long serialVersionUID = 5230929750062183569L;
        private double eosq;
        private double sinio;
        private double cosio;
        private double betao;
        private double aodp;
        private double theta2;
        private double sing;
        private double cosg;
        private double betao2;
        private double xmdot;
        private double omgdot;
        private double xnodot;
        private double xnodp;
        private double xll;
        private double omgadf;
        private double xnode;
        private double em;
        private double xinc;
        private double xn;
        private double t;
        private double ds50;

        private DeepSpaceValueObject() {
        }
    }
}

