/*
 * Decompiled with CFR 0.152.
 */
package passControl;

import ax25.Ax25Frame;
import ax25.Ax25Request;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import gui.MainWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import pacSat.frames.FTL0Frame;
import pacSat.frames.PacSatEvent;
import pacSat.frames.PacSatFrame;
import pacSat.frames.PacSatPrimative;
import pacSat.frames.StatusFrame;
import pacSat.frames.ULCmdFrame;
import passControl.PacsatStateMachine;

public class UplinkStateMachine
extends PacsatStateMachine
implements Runnable {
    public static final int UL_UNINIT = 0;
    public static final int UL_OPEN = 1;
    public static final int UL_CMD_OK = 2;
    public static final int UL_WAIT = 3;
    public static final int UL_DATA = 4;
    public static final int UL_END = 5;
    public static final int LOOP_TIME = 10;
    int state = 0;
    public File fileUploading = null;
    public long fileIdUploading = 0L;
    public long fileContinuationOffset = 0L;
    public long fileUploadingLength = 0L;
    public short fileHeaderCheck = 0;
    public short fileBodyCheck = 0;
    public static final int PACKET_SIZE = 190;
    public static final int TIMER_T3 = 6000;
    int t3_timer;
    public static final DateFormat fileDateFormat = new SimpleDateFormat("yyyyMMdd.HHmm");
    public static final String ERR = "err";
    public static final String UL = "ul";
    public static final String[] states = new String[]{"Idle", "Open", "Cmd Ok", "Waiting", "Data", "Data End", "Full", "Shut"};
    String pgList = "";
    boolean authorizedLoginOnly = false;

    public UplinkStateMachine(SpacecraftSettings sat) {
        super(sat);
    }

    public void setSpacecraft(SpacecraftSettings spacecraftSettings) {
        this.spacecraft = spacecraftSettings;
    }

    @Override
    public void processEvent(PacSatPrimative frame) {
        if (Config.getBoolean("DEBUG_EVENTS")) {
            this.DEBUG("Adding UP LINK Event: " + frame.toString());
        }
        this.frameEventQueue.add(frame);
    }

    @Override
    protected void nextState(PacSatPrimative pacSatPrimative) {
        if (!Config.getBoolean("uplink_enabled")) {
            this.state = 0;
            return;
        }
        switch (this.state) {
            case 0: {
                this.stateInit(pacSatPrimative);
                break;
            }
            case 1: {
                this.stateOpen(pacSatPrimative);
                break;
            }
            case 3: {
                this.stateWait(pacSatPrimative);
                break;
            }
            case 2: {
                this.state_UL_CMD_OK(pacSatPrimative);
                break;
            }
            case 4: {
                this.state_DATA(pacSatPrimative);
                break;
            }
            case 5: {
                this.state_DATA_END(pacSatPrimative);
                break;
            }
        }
    }

    private void stateInit(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 2: 
                case 11: {
                    this.PRINT("REFUSED: Can't upload a file until the Spacecraft is Open");
                    break;
                }
                case 10: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 102: {
                    if (((FTL0Frame)frame).sentToCallsign(Config.get("callsign"))) {
                        this.pgList = frame.toString();
                        this.fileUploading = null;
                        this.state = 2;
                        this.startT3();
                    }
                    if (MainWindow.frame == null) break;
                    MainWindow.setLoggedin(this.spacecraft.name, this.pgList);
                    break;
                }
                case 3: {
                    this.setPgStatus(frame);
                    this.startT3();
                    break;
                }
            }
        }
    }

    private void stateOpen(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 2: 
                case 11: {
                    this.PRINT("REFUSED: Can't upload a file until Logged in");
                    break;
                }
                case 1: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
                case 10: {
                    this.PRINT("Nothing heard from spacecraft ... ");
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    this.terminateDataLink();
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 102: {
                    if (((FTL0Frame)frame).sentToCallsign(Config.get("callsign"))) {
                        this.pgList = frame.toString();
                        this.state = 2;
                        this.startT3();
                    }
                    if (MainWindow.frame == null) break;
                    MainWindow.setLoggedin(this.spacecraft.name, this.pgList);
                    break;
                }
                case 3: {
                    this.setPgStatus(frame);
                    this.startT3();
                    break;
                }
            }
        }
    }

    private void state_UL_CMD_OK(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 11: {
                    try {
                        ULCmdFrame auth_cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), req, this.spacecraft.key);
                        this.DEBUG("UL AUTH_CMD: " + auth_cmd);
                        Ax25Request lay2req = new Ax25Request(auth_cmd.iFrame);
                        this.spacecraft.layer2data.processEvent(lay2req);
                        this.state = 3;
                    }
                    catch (IllegalArgumentException e) {
                        Log.errorDialog("ERROR", "Invalid secret command key\n");
                        this.DEBUG("ERROR with key for UL_CMD: ");
                        this.terminateDataLink();
                        this.state = 0;
                    }
                    break;
                }
                case 2: {
                    ULCmdFrame cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), req);
                    this.DEBUG("UL_CMD: " + cmd);
                    Ax25Request lay2req = new Ax25Request(cmd.iFrame);
                    this.spacecraft.layer2data.processEvent(lay2req);
                    this.state = 3;
                    break;
                }
                case 1: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                    break;
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 3: {
                    this.pgList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, this.pgList);
                    }
                    this.startT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                }
            }
        }
    }

    private void stateWait(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 1: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                    break;
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 104: {
                    this.DEBUG("UL_GO_RESP: " + frame);
                    FTL0Frame ftl = (FTL0Frame)frame;
                    this.DEBUG("GO FILE>" + ftl);
                    try {
                        PacSatFile psf = new PacSatFile(this.spacecraft, this.fileUploading.getPath());
                        psf.setFileId(ftl.getFileId());
                        psf.save();
                        PacSatFileHeader pfh = psf.loadPfh();
                        this.fileHeaderCheck = (short)pfh.getFieldById(10).getLongValue();
                        this.fileBodyCheck = (short)pfh.getFieldById(9).getLongValue();
                        if (Config.mainWindow != null) {
                            MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                        }
                    }
                    catch (MalformedPfhException e) {
                        this.PRINT("ERROR: The Pacsat File Header is corrupt for Upload file" + this.fileUploading.getPath() + "\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (IOException e) {
                        this.PRINT("ERROR: Could not write the new file Id to the Upload file\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    this.fileIdUploading = ftl.getFileId();
                    this.fileContinuationOffset = ftl.getContinuationOffset();
                    this.state = 4;
                    this.startT3();
                    break;
                }
                case 105: {
                    this.DEBUG("UL_ERROR_RESP: " + frame);
                    FTL0Frame err = (FTL0Frame)frame;
                    if (err.getErrorCode() == 4 || err.getErrorCode() == 2) {
                        try {
                            this.PRINT("Bad File Number, will ask Pacsat for a new number for file: " + this.fileUploading.getPath());
                            PacSatFile psf = new PacSatFile(this.spacecraft, this.fileUploading.getPath());
                            psf.setFileId(0L);
                            psf.save();
                            this.state = 2;
                            this.fileContinuationOffset = 0L;
                            this.processEvent(new PacSatEvent(psf));
                        }
                        catch (MalformedPfhException e) {
                            this.PRINT("ERROR: The Pacsat File Header is corrupt for Upload file" + this.fileUploading.getPath() + "\n" + e.getMessage());
                            this.terminateDataLink();
                            this.renameExtension(this.fileUploading, ERR);
                            this.fileUploading = null;
                            this.fileContinuationOffset = 0L;
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (IOException e) {
                            this.PRINT("ERROR: Could not write the new file Id to the Upload file\n" + e.getMessage());
                            this.terminateDataLink();
                            this.renameExtension(this.fileUploading, ERR);
                            this.fileUploading = null;
                            this.fileContinuationOffset = 0L;
                            e.printStackTrace(Log.getWriter());
                        }
                        if (Config.mainWindow != null) {
                            MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                        }
                        this.state = 2;
                    } else if (err.getErrorCode() == 12) {
                        this.PRINT("Already Uploaded: " + this.fileUploading.getPath());
                        this.renameExtension(this.fileUploading, UL);
                        if (Config.mainWindow != null) {
                            MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                        }
                        this.fileUploading = null;
                        this.fileContinuationOffset = 0L;
                        this.state = 2;
                    } else if (err.getErrorCode() == 13) {
                        this.PRINT("ERROR: Not enough room on Pacsat to Upload: " + this.fileUploading.getPath() + "\n");
                        this.renameExtension(this.fileUploading, ERR);
                        this.fileUploading = null;
                        this.fileContinuationOffset = 0L;
                        this.state = 2;
                    } else {
                        this.PRINT("ERROR: Can't Upload: " + this.fileUploading.getPath() + "\n");
                        this.renameExtension(this.fileUploading, ERR);
                        this.terminateDataLink();
                    }
                    this.startT3();
                    break;
                }
                case 3: {
                    this.pgList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, this.pgList);
                    }
                    this.startT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                }
            }
        }
    }

    private void state_DATA(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 1: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
                case 3: {
                    this.PRINT("Uploading file: " + Long.toHexString(this.fileIdUploading) + ": " + req);
                    if (MainWindow.frame != null) {
                        MainWindow.setFileUploading(this.spacecraft.name, this.fileIdUploading, this.fileContinuationOffset, this.fileUploadingLength);
                    }
                    ULCmdFrame cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), req);
                    Ax25Request lay2req = new Ax25Request(cmd.iFrame);
                    this.spacecraft.layer2data.processEvent(lay2req);
                    this.state = 4;
                    this.startT3();
                    break;
                }
                case 12: {
                    try {
                        ULCmdFrame auth_cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), req, this.spacecraft.key);
                        this.PRINT("Sending AUTH DATA END for file: " + this.fileIdUploading);
                        Ax25Request lay2req = new Ax25Request(auth_cmd.iFrame);
                        this.spacecraft.layer2data.processEvent(lay2req);
                        this.state = 5;
                    }
                    catch (IllegalArgumentException e) {
                        Log.errorDialog("ERROR", "Invalid secret command key\n");
                        this.DEBUG("ERROR with key for UL_CMD: ");
                        this.terminateDataLink();
                        this.state = 0;
                    }
                    break;
                }
                case 4: {
                    this.PRINT("Sending DATA END for file: " + this.fileIdUploading);
                    ULCmdFrame cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), req);
                    Ax25Request lay2req = new Ax25Request(cmd.iFrame);
                    this.spacecraft.layer2data.processEvent(lay2req);
                    this.state = 5;
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                    break;
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 107: {
                    if (Config.getBoolean("DEBUG_LAYER3")) {
                        this.DEBUG("UL_NAK_RESP: " + frame);
                    }
                    FTL0Frame err = (FTL0Frame)frame;
                    this.PRINT("ERROR: " + err.getErrorString() + " NAK received while uploading: " + this.fileUploading.getPath() + "\n");
                    this.renameExtension(this.fileUploading, ERR);
                    if (Config.mainWindow != null) {
                        MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                    }
                    ULCmdFrame cmd = new ULCmdFrame(this.spacecraft, Config.get("callsign"), this.spacecraft.get("bbsCallsign"), new PacSatEvent(4));
                    Ax25Request lay2req = new Ax25Request(cmd.iFrame);
                    this.spacecraft.layer2data.processEvent(lay2req);
                    this.fileUploading = null;
                    this.state = 2;
                    this.startT3();
                    break;
                }
                case 105: {
                    this.DEBUG("UL_ERROR_RESP: " + frame);
                    FTL0Frame err = (FTL0Frame)frame;
                    this.PRINT("ERROR: " + err.getErrorString() + " while uploading: " + this.fileUploading.getPath() + "\n");
                    if (!((FTL0Frame)frame).sentToCallsign(Config.get("callsign"))) break;
                    this.renameExtension(this.fileUploading, ERR);
                    if (Config.mainWindow != null) {
                        MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                    }
                    this.fileUploading = null;
                    this.state = 2;
                    this.startT3();
                    break;
                }
                case 3: {
                    this.pgList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, this.pgList);
                    }
                    this.startT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                }
            }
        }
    }

    private void state_DATA_END(PacSatPrimative prim) {
        if (prim instanceof PacSatEvent) {
            PacSatEvent req = (PacSatEvent)prim;
            switch (req.type) {
                case 1: {
                    this.state = 0;
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                    break;
                }
                default: {
                    this.terminateDataLink();
                    this.DEBUG("DATA LINK TERMINATED");
                    this.state = 0;
                    break;
                }
            }
        } else {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 107: {
                    this.DEBUG("UL_NAK_RESP: " + frame);
                    FTL0Frame err = (FTL0Frame)frame;
                    this.PRINT("NAK: " + err.getErrorString() + " received at DATA END: " + this.fileUploading.getPath() + "\n");
                    try {
                        PacSatFile psf = new PacSatFile(this.spacecraft, this.fileUploading.getPath());
                        psf.setFileId(0L);
                        psf.save();
                    }
                    catch (MalformedPfhException e) {
                        this.PRINT("ERROR: The Pacsat File Header is corrupt for Upload file" + this.fileUploading.getPath() + "\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (IOException e) {
                        this.PRINT("ERROR: Could not write the new file Id to the Upload file\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    if (Config.mainWindow != null) {
                        MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                    }
                    this.fileUploading = null;
                    this.fileContinuationOffset = 0L;
                    this.state = 2;
                    this.startT3();
                    break;
                }
                case 106: {
                    this.DEBUG("UL_ACK_RESP: " + frame);
                    this.PRINT("SUCCESSFULLY UPLOADED: " + this.fileUploading.getPath());
                    try {
                        PacSatFile psf = new PacSatFile(this.spacecraft, this.fileUploading.getPath());
                        psf.getPfh(this.spacecraft).setFileUploadDate();
                        psf.save();
                        if (Config.mainWindow != null) {
                            MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                            MainWindow.setFileUploading(this.spacecraft.name, this.fileIdUploading, this.fileUploadingLength, this.fileUploadingLength);
                        }
                    }
                    catch (MalformedPfhException e) {
                        this.PRINT("ERROR: The Pacsat File Header is corrupt for Upload file" + this.fileUploading.getPath() + "\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (IOException e) {
                        this.PRINT("ERROR: Could not write the new file Id to the Upload file\n" + e.getMessage());
                        this.terminateDataLink();
                        this.renameExtension(this.fileUploading, ERR);
                        e.printStackTrace(Log.getWriter());
                    }
                    this.renameExtension(this.fileUploading, UL);
                    if (Config.mainWindow != null) {
                        MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                    }
                    this.fileUploading = null;
                    this.state = 2;
                    this.startT3();
                    break;
                }
                case 105: {
                    this.DEBUG("UL_ERROR_RESP: " + frame);
                    FTL0Frame err = (FTL0Frame)frame;
                    this.PRINT("ERROR: " + err.getErrorString() + " received while uploading: " + this.fileUploading.getPath() + "\n");
                    this.renameExtension(this.fileUploading, ERR);
                    if (Config.mainWindow != null) {
                        MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
                    }
                    this.fileUploading = null;
                    this.state = 2;
                    this.startT3();
                    break;
                }
                case 3: {
                    this.pgList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, this.pgList);
                    }
                    this.startT3();
                    break;
                }
            }
        }
    }

    private void setPgStatus(PacSatFrame frame) {
        if (((StatusFrame)frame).uiFrame.toCallsign.startsWith("BBCOM")) {
            if (!this.spacecraft.getBoolean("is_command_station")) {
                this.state = 0;
                return;
            }
            this.authorizedLoginOnly = true;
        } else {
            this.authorizedLoginOnly = false;
        }
        this.pgList = Ax25Frame.makeString(frame.getBytes());
        String call = ((StatusFrame)frame).getCall();
        if (call == null) {
            this.state = 1;
        } else if (call.equalsIgnoreCase(Config.get("callsign"))) {
            Log.println("PG has us: " + call);
            this.state = 1;
        } else {
            Log.println("PG FULL: " + call);
            this.state = 0;
        }
        if (MainWindow.frame != null) {
            MainWindow.setPGStatus(this.spacecraft.name, this.pgList);
        }
    }

    public void attemptLogin() {
        if (this.state == 0) {
            this.state = 1;
        }
    }

    private void terminateDataLink() {
        Ax25Request req = new Ax25Request(Config.get("callsign"), this.spacecraft.get("bbsCallsign"), 3);
        this.spacecraft.layer2data.processEvent(req);
        this.state = 0;
        this.fileUploading = null;
        if (MainWindow.frame != null) {
            MainWindow.setPGStatus(this.spacecraft.name, "");
            MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
        }
        if (Config.mainWindow != null) {
            MainWindow.setOutboxData(this.spacecraft.name, this.spacecraft.outbox.getTableData());
        }
        this.stopT3();
    }

    private void renameExtension(File fromFile, String ext) {
        Date today = Calendar.getInstance().getTime();
        fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = fileDateFormat.format(today);
        String to = fromFile.getPath().replace("out", "." + reportDate + "." + ext);
        File newFile = new File(to);
        if (fromFile.renameTo(newFile)) {
            return;
        }
        Log.errorDialog("ERROR", "Could not rename the outbox file from: " + fromFile.getPath() + "\n" + "to: " + newFile.getPath() + "\n" + "You must rename this file manually or it may accidently block future uploads.");
    }

    private void DEBUG(String s) {
        s = "DEBUG 3: " + states[this.state] + ": " + s;
        if (Config.getBoolean("DEBUG_LAYER3")) {
            if (this.ta != null) {
                this.ta.append(String.valueOf(s) + "\n");
            }
            Log.println(s);
        }
    }

    private void PRINT(String s) {
        if (this.ta != null) {
            this.ta.append(String.valueOf(s) + "\n");
        } else {
            Log.println(s);
        }
    }

    public void stopRunning() {
        this.running = false;
    }

    private void loginIfFile() {
        if (this.authorizedLoginOnly && !this.spacecraft.getBoolean("is_command_station")) {
            return;
        }
        File nextFile = this.spacecraft.outbox.getNextFile();
        if (nextFile != null && this.fileUploading == null) {
            this.PRINT("Ready to upload file: " + nextFile.getName());
            this.fileUploading = nextFile;
            Ax25Request req = new Ax25Request(Config.get("callsign"), this.spacecraft.get("bbsCallsign"));
            this.spacecraft.layer2data.processEvent(req);
            this.state = 1;
        }
    }

    private void requestIfFile() {
        if (this.authorizedLoginOnly && !this.spacecraft.getBoolean("is_command_station")) {
            return;
        }
        if (this.fileUploading.exists()) {
            try {
                PacSatFile psf = new PacSatFile(this.spacecraft, this.fileUploading.getPath());
                if (this.authorizedLoginOnly && this.spacecraft.getBoolean("is_command_station")) {
                    this.processEvent(new PacSatEvent(psf, true));
                } else {
                    this.processEvent(new PacSatEvent(psf, false));
                }
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Can't open file in OUTBOX: " + this.fileUploading.getPath() + "\n" + e.getMessage());
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Can't open file in OUTBOX: " + this.fileUploading.getPath() + "\n" + e.getMessage());
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    private void startT3() {
        this.t3_timer = 1;
    }

    private void stopT3() {
        this.t3_timer = 0;
    }

    @Override
    public void run() {
        Log.println("STARTING UPLINK Thread");
        Thread.currentThread().setName("UplinkStateMachine");
        while (this.running) {
            block39: {
                if (this.t3_timer > 0) {
                    ++this.t3_timer;
                    if (this.t3_timer > 6000) {
                        this.t3_timer = 0;
                        this.DEBUG(">>>>>>>>>>T3 expired");
                        this.nextState(new PacSatEvent(10));
                    }
                }
                if (this.spacecraft.layer2data != null && this.spacecraft.layer2data.isDisconnected() && this.fileUploading != null) {
                    this.fileUploading = null;
                    if (MainWindow.frame != null) {
                        MainWindow.setPGStatus(this.spacecraft.name, "");
                        MainWindow.setLoggedin(this.spacecraft.name, "Disconnected");
                    }
                    this.stopT3();
                }
                if (this.frameEventQueue.size() > 0) {
                    this.nextState((PacSatPrimative)this.frameEventQueue.poll());
                } else if (this.state == 1) {
                    if (this.spacecraft != null && this.spacecraft.getBoolean("upload_files")) {
                        this.loginIfFile();
                    }
                } else if (this.state == 2) {
                    File nextFile = this.spacecraft.outbox.getNextFile();
                    if (nextFile != null && this.fileUploading == null) {
                        this.PRINT("Ready to upload next file: " + nextFile.getName());
                        this.fileUploading = nextFile;
                    }
                    if (this.fileUploading != null) {
                        this.requestIfFile();
                    } else {
                        this.terminateDataLink();
                    }
                } else if (this.state == 4 && this.fileUploading != null && this.spacecraft.layer2data.isReadyForData()) {
                    RandomAccessFile fileOnDisk = null;
                    try {
                        fileOnDisk = new RandomAccessFile(this.fileUploading.getPath(), "r");
                        if (this.fileContinuationOffset < fileOnDisk.length()) {
                            long length = fileOnDisk.length() - this.fileContinuationOffset;
                            if (length > 190L) {
                                length = 190L;
                            }
                            this.fileUploadingLength = fileOnDisk.length();
                            fileOnDisk.seek(this.fileContinuationOffset);
                            int[] bytes = new int[(int)length];
                            int i2 = 0;
                            while ((long)i2 < length) {
                                bytes[i2++] = fileOnDisk.readUnsignedByte();
                            }
                            fileOnDisk.close();
                            this.processEvent(new PacSatEvent(bytes, this.fileContinuationOffset, this.fileUploadingLength));
                            this.fileContinuationOffset += 190L;
                        } else {
                            fileOnDisk.close();
                            if (this.authorizedLoginOnly && this.spacecraft.getBoolean("is_command_station")) {
                                this.processEvent(new PacSatEvent(12, this.fileHeaderCheck, this.fileBodyCheck));
                            } else {
                                this.processEvent(new PacSatEvent(4));
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        try {
                            fileOnDisk.close();
                        }
                        catch (Exception exception) {}
                        break block39;
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                            break block39;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                fileOnDisk.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    try {
                        fileOnDisk.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Config.mainWindow == null) continue;
            MainWindow.setUplinkStatus(this.spacecraft.name, states[this.state]);
        }
        Log.println("EXIT UPLINK Thread");
    }
}

