/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Iframe;
import ax25.KissFrame;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import pacSat.frames.FTL0Frame;
import pacSat.frames.PacSatEvent;
import pacSat.frames.PacSatFrame;

public class ULCmdFrame
extends PacSatFrame {
    public Iframe iFrame;
    int type;
    int[] data;
    SpacecraftSettings spacecraftSettings;
    byte[] hashVector;

    public ULCmdFrame(SpacecraftSettings spacecraftSettings, String fromCall, String toCall, PacSatEvent event, byte[] key) {
        this.spacecraftSettings = spacecraftSettings;
        this.type = event.type;
        switch (this.type) {
            case 11: {
                int[] byid;
                this.data = new int[46];
                int length_of_file = (int)event.psf.getActualLength();
                int length = 44;
                this.makeHeader(20, length);
                Date now = new Date();
                long time = now.getTime() / 1000L;
                int[] bydt = KissFrame.littleEndian4(time);
                this.data[2] = bydt[0];
                this.data[3] = bydt[1];
                this.data[4] = bydt[2];
                this.data[5] = bydt[3];
                PacSatFile psf = event.psf;
                PacSatFileHeader pfh = psf.getPfh(spacecraftSettings);
                if (pfh.getFileId() != 0L) {
                    byid = KissFrame.littleEndian4(pfh.getFileId());
                    this.data[6] = byid[0];
                    this.data[7] = byid[1];
                    this.data[8] = byid[2];
                    this.data[9] = byid[3];
                }
                byid = KissFrame.littleEndian4(length_of_file);
                this.data[10] = byid[0];
                this.data[11] = byid[1];
                this.data[12] = byid[2];
                this.data[13] = byid[3];
                try {
                    this.calcHashVector(key, 12);
                    int i2 = 0;
                    while (i2 < 32) {
                        this.data[14 + i2] = this.hashVector[i2] & 0xFF;
                        ++i2;
                    }
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 12: {
                this.data = new int[42];
                int length = 40;
                this.makeHeader(21, length);
                Date now = new Date();
                long time = now.getTime() / 1000L;
                int[] bydt = KissFrame.littleEndian4(time);
                this.data[2] = bydt[0];
                this.data[3] = bydt[1];
                this.data[4] = bydt[2];
                this.data[5] = bydt[3];
                int[] byid = KissFrame.littleEndian2(event.header_check);
                this.data[6] = byid[0];
                this.data[7] = byid[1];
                byid = KissFrame.littleEndian2(event.body_check);
                this.data[8] = byid[0];
                this.data[9] = byid[1];
                try {
                    this.calcHashVector(key, 8);
                    int i3 = 0;
                    while (i3 < 32) {
                        this.data[10 + i3] = this.hashVector[i3] & 0xFF;
                        ++i3;
                    }
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.iFrame = new Iframe(fromCall, toCall, 240, this.data);
    }

    public ULCmdFrame(SpacecraftSettings spacecraftSettings, String fromCall, String toCall, PacSatEvent event) {
        this.spacecraftSettings = spacecraftSettings;
        this.type = event.type;
        boolean control = false;
        switch (this.type) {
            case 2: {
                int[] byid;
                this.data = new int[10];
                int length_of_file = (int)event.psf.getActualLength();
                int length = 8;
                this.makeHeader(3, length);
                PacSatFile psf = event.psf;
                PacSatFileHeader pfh = psf.getPfh(spacecraftSettings);
                if (pfh.getFileId() != 0L) {
                    byid = KissFrame.littleEndian4(pfh.getFileId());
                    this.data[2] = byid[0];
                    this.data[3] = byid[1];
                    this.data[4] = byid[2];
                    this.data[5] = byid[3];
                }
                byid = KissFrame.littleEndian4(length_of_file);
                this.data[6] = byid[0];
                this.data[7] = byid[1];
                this.data[8] = byid[2];
                this.data[9] = byid[3];
                break;
            }
            case 3: {
                this.data = new int[event.bytes.length + 2];
                this.makeHeader(0, event.bytes.length);
                int j = 2;
                int[] nArray = event.bytes;
                int n = event.bytes.length;
                int n2 = 0;
                while (n2 < n) {
                    int i2 = nArray[n2];
                    this.data[j++] = i2;
                    ++n2;
                }
                break;
            }
            case 4: {
                this.data = new int[2];
                this.makeHeader(1, 0);
            }
        }
        this.iFrame = new Iframe(fromCall, toCall, 240, this.data);
    }

    ULCmdFrame(Iframe ifrm) {
        this.iFrame = ifrm;
    }

    private void makeHeader(int ftlType, int length) {
        this.data[0] = length & 0xFF;
        int msb_length = length >> 8 & 7;
        this.data[1] = msb_length << 5 | ftlType & 0x1F;
    }

    private void calcHashVector(byte[] key, int len) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] by = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            by[i2] = (byte)this.data[i2 + 2];
            ++i2;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secretKeySpec);
        this.hashVector = mac.doFinal(by);
    }

    @Override
    public int[] getBytes() {
        return this.iFrame.getBytes();
    }

    @Override
    public String toString() {
        String s = this.iFrame.headerString();
        int[] data = this.iFrame.getDataBytes();
        int length_lsb = data[0];
        int h1 = data[1];
        int length = length_lsb | h1 & 0xE0;
        int actualType = h1 & 0x1F;
        s = String.valueOf(s) + " UL CMD: " + FTL0Frame.ftl0Types[actualType];
        switch (actualType) {
            case 3: {
                int[] by = new int[]{data[2], data[3], data[4], data[5]};
                long file = KissFrame.getLongFromBytes(by);
                s = String.valueOf(s) + " File: " + Long.toHexString(file);
                int[] by2 = new int[]{data[6], data[7], data[8], data[9]};
                long size = KissFrame.getLongFromBytes(by2);
                s = String.valueOf(s) + " Size: " + Long.toHexString(size);
            }
        }
        return s;
    }

    public static void main(String[] args) throws MalformedPfhException, IOException {
        int[] nArray = new int[10];
        nArray[0] = 8;
        nArray[1] = 3;
        nArray[2] = 189;
        nArray[3] = 20;
        nArray[6] = 239;
        nArray[7] = 6;
        int[] by = nArray;
        int[] by2 = new int[]{2, 1};
        Iframe ifrm = new Iframe("From", "To", 240, by);
        ULCmdFrame ftl = new ULCmdFrame(ifrm);
        System.out.println(ftl);
    }
}

