/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.telem.RecordTlm;
import java.io.IOException;
import java.util.Date;
import pacSat.frames.PacSatFrame;

public class TlmFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    Date startDate;
    long timeStamp;
    int[] bytes;
    int[] data;
    public DataRecord record;
    SpacecraftSettings spacecraftSettings;

    public TlmFrame(SpacecraftSettings spacecraftSettings, Ax25Frame ui) throws MalformedPfhException, LayoutLoadException, IOException {
        this.spacecraftSettings = spacecraftSettings;
        this.frameType = 40;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        int[] by = new int[]{this.bytes[0], this.bytes[1], this.bytes[2], this.bytes[3]};
        this.timeStamp = KissFrame.getLongFromBytes(by);
        this.startDate = new Date(this.timeStamp * 1000L);
        this.data = this.uiFrame.toCallsign.startsWith("TLMI-1") ? new int[144] : new int[126];
        int j = 0;
        int p = 0;
        while (p < this.data.length) {
            this.data[p] = this.bytes[j + 5];
            this.data[p + 1] = this.bytes[j + 6];
            j += 3;
            p += 2;
        }
        this.getTlm();
    }

    public DataRecord getTlm() throws LayoutLoadException, IOException {
        String name = "TLM2_LAYOUT";
        if (this.uiFrame.toCallsign.startsWith("TLMI-1")) {
            name = "TLMI_LAYOUT";
        }
        ByteArrayLayout layout = this.spacecraftSettings.db.getLayoutByName(name);
        this.record = new RecordTlm(layout, 0, 0, this.timeStamp, 0, this.data, this.spacecraftSettings.spacecraft.ihuLittleEndian);
        return this.record;
    }

    @Override
    public int[] getBytes() {
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            s = String.valueOf(s) + this.uiFrame.headerString();
        }
        s = String.valueOf(s) + this.uiFrame.toCallsign + " " + this.startDate + " ";
        if (Config.getBoolean("DEBUG_TELEM")) {
            try {
                s = String.valueOf(s) + "\n" + this.getTlm().toString();
            }
            catch (LayoutLoadException | IOException e) {
                e.printStackTrace();
            }
        } else {
            int[] nArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                s = String.valueOf(s) + Integer.toHexString(b) + " ";
                ++n2;
            }
        }
        return s;
    }
}

