/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import common.Config;
import common.LayoutLoadException;
import fileStore.FileHole;
import fileStore.SortedArrayList;
import java.io.IOException;
import pacSat.frames.FrameException;
import pacSat.frames.PacSatFrame;

public class RequestFileFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    int flags;
    public static final int START_SENDING_FILE = 16;
    public static final int STOP_SENDING_FILE = 17;
    public static final int FRAME_IS_HOLE_LIST = 18;
    public long fileId;
    int blockSize = 244;
    int[] data;
    public static final int MAX_FILE_HOLES = 45;

    public RequestFileFrame(String fromCall, String toCall, boolean startSending, long file, SortedArrayList<FileHole> holes) {
        int i2;
        int n;
        int n2;
        int[] nArray;
        this.frameType = 31;
        int[] holedata = null;
        this.fileId = file;
        this.flags = 0;
        if (holes != null) {
            int h = 0;
            this.flags = 18;
            int num_of_holes = holes.size();
            if (num_of_holes > 45) {
                num_of_holes = 45;
            }
            holedata = new int[5 * num_of_holes];
            int i3 = 0;
            while (i3 < num_of_holes) {
                int[] hole_by;
                nArray = hole_by = ((FileHole)holes.get(i3)).getBytes();
                n2 = hole_by.length;
                n = 0;
                while (n < n2) {
                    int b = nArray[n];
                    holedata[h++] = b;
                    ++n;
                }
                ++i3;
            }
        }
        this.flags = startSending ? (this.flags |= 0x10) : (this.flags |= 0x11);
        int[] header = new int[7];
        header[0] = this.flags;
        int[] byid = KissFrame.littleEndian4(this.fileId);
        header[1] = byid[0];
        header[2] = byid[1];
        header[3] = byid[2];
        header[4] = byid[3];
        int[] byblock = KissFrame.littleEndian2(this.blockSize);
        header[5] = byblock[0];
        header[6] = byblock[1];
        int j = 0;
        this.data = holedata != null ? new int[header.length + holedata.length] : new int[header.length];
        nArray = header;
        n2 = header.length;
        n = 0;
        while (n < n2) {
            i2 = nArray[n];
            this.data[j++] = i2;
            ++n;
        }
        if (holedata != null) {
            nArray = holedata;
            n2 = holedata.length;
            n = 0;
            while (n < n2) {
                i2 = nArray[n];
                this.data[j++] = i2;
                ++n;
            }
        }
        this.uiFrame = new Ax25Frame(fromCall, toCall, 3, 1, 187, this.data);
    }

    @Override
    public int[] getBytes() {
        return this.uiFrame.getBytes();
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            this.uiFrame.headerString();
        }
        s = String.valueOf(s) + "FILE REQ: ";
        s = String.valueOf(s) + "FLG: " + Integer.toHexString(this.flags & 0xFF);
        s = String.valueOf(s) + " FILE: " + Long.toHexString(this.fileId & 0xFFFFFFFFFFFFFFFFL);
        s = String.valueOf(s) + " BLK_SIZE: " + Long.toHexString(this.blockSize & 0xFFFFFF);
        int h = 7;
        int j = 1;
        while (this.data.length > h) {
            int[] by2 = new int[]{this.data[h + 0], this.data[h + 1], this.data[h + 2]};
            long offset = KissFrame.getLongFromBytes(by2);
            int[] by3 = new int[]{this.data[h + 3], this.data[h + 4]};
            int length = KissFrame.getIntFromBytes(by3);
            s = String.valueOf(s) + " Hole " + j + ": " + offset + " " + length;
            h += 5;
            ++j;
        }
        return s;
    }

    public static final void main(String[] argc) throws FrameException, LayoutLoadException, IOException {
        int[] by;
        Config.init("PacSatGround.properties");
        RequestFileFrame req = new RequestFileFrame("G0KLA", "FS-3", true, 4660L, null);
        System.out.println(req);
        KissFrame kss = new KissFrame(0, 0, req.getBytes());
        KissFrame decode = new KissFrame();
        int[] nArray = kss.getDataBytes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            decode.add(b);
            System.out.print(String.valueOf(Integer.toHexString(b)) + " ");
            ++n2;
        }
        System.out.println("");
        Ax25Frame ui = new Ax25Frame(decode);
        System.out.println(ui);
        KissFrame decode2 = new KissFrame();
        int[] nArray2 = new int[26];
        nArray2[0] = 192;
        nArray2[2] = 160;
        nArray2[3] = 140;
        nArray2[4] = 166;
        nArray2[5] = 102;
        nArray2[6] = 64;
        nArray2[7] = 64;
        nArray2[8] = 246;
        nArray2[9] = 130;
        nArray2[10] = 134;
        nArray2[11] = 100;
        nArray2[12] = 134;
        nArray2[13] = 180;
        nArray2[14] = 64;
        nArray2[15] = 97;
        nArray2[16] = 3;
        nArray2[17] = 187;
        nArray2[18] = 16;
        nArray2[19] = 52;
        nArray2[20] = 18;
        nArray2[23] = 244;
        nArray2[25] = 192;
        int[] nArray3 = by = nArray2;
        int n3 = by.length;
        int n4 = 0;
        while (n4 < n3) {
            int b = nArray3[n4];
            decode2.add(b);
            ++n4;
        }
        Ax25Frame ui2 = new Ax25Frame(decode2);
        System.out.println(ui2);
    }
}

