/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import fileStore.MalformedPfhException;
import java.util.Arrays;
import pacSat.Crc16;
import pacSat.frames.BroadCastFrame;

public class BroadcastFileFrame
extends BroadCastFrame {
    Ax25Frame uiFrame;
    int flags;
    public static final int L_BIT = 1;
    public static final int E_BIT = 2;
    public static final int VV_BIT = 12;
    public static final int ZERO_BIT = 114;
    public long fileId;
    int fileType;
    public long offset;
    int length;
    public int[] data;
    int[] bytes;
    int crc;
    boolean lastByteOfFile = false;

    public BroadcastFileFrame(Ax25Frame ui) throws MalformedPfhException {
        this.frameType = 21;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        this.flags = this.bytes[0];
        int[] by = new int[]{this.bytes[1], this.bytes[2], this.bytes[3], this.bytes[4]};
        this.fileId = KissFrame.getLongFromBytes(by);
        this.fileType = this.bytes[5];
        int[] by2 = new int[]{this.bytes[6], this.bytes[7], this.bytes[8]};
        this.offset = KissFrame.getLongFromBytes(by2);
        if ((this.flags & 1) == 1) {
            System.err.println("LENGTH SET - CAN THAT BE RIGHT?");
            int[] by3 = new int[]{this.bytes[9], this.bytes[10]};
            this.length = KissFrame.getIntFromBytes(by3);
            this.data = Arrays.copyOfRange(this.bytes, 11, this.bytes.length - 2);
        } else {
            this.data = Arrays.copyOfRange(this.bytes, 9, this.bytes.length - 2);
        }
        if ((this.flags & 2) == 2) {
            this.lastByteOfFile = true;
        }
        int[] by4 = new int[]{this.bytes[this.bytes.length - 2], this.bytes[this.bytes.length - 1]};
        this.crc = KissFrame.getIntFromBytes(by4);
        if (!Crc16.goodCrc(this.bytes)) {
            throw new MalformedPfhException("Bad CRC for File ID: " + Long.toHexString(this.fileId));
        }
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public long getFirst() {
        return this.offset;
    }

    @Override
    public long getLast() {
        return this.offset + (long)this.data.length - 1L;
    }

    public boolean mayContainPFH() {
        int check1 = this.data[0];
        int check2 = this.data[1];
        if (this.data[0] == 85 && this.data[1] == 1 && this.data[2] == 0 && this.data[3] == 4) {
            return true;
        }
        return (check1 == 170 || check1 == 0) && check2 == 85;
    }

    public boolean hasLastByteOfFile() {
        return this.lastByteOfFile;
    }

    @Override
    public String toString() {
        String s = "FILE> ";
        s = String.valueOf(s) + this.uiFrame.headerString();
        s = String.valueOf(s) + "FLG: " + Integer.toHexString(this.flags & 0xFF);
        s = String.valueOf(s) + " FILE: " + Long.toHexString(this.fileId & 0xFFFFFFFFFFFFFFFFL);
        s = String.valueOf(s) + " TYPE: " + Integer.toHexString(this.fileType & 0xFF);
        s = String.valueOf(s) + " OFF: " + Long.toHexString(this.offset & 0xFFFFFFL);
        if ((this.flags & 1) == 1) {
            s = String.valueOf(s) + " LEN: " + Integer.toHexString(this.length & 0xFFFF);
        }
        s = String.valueOf(s) + " CRC: " + Integer.toHexString(this.crc & 0xFFFF);
        return s;
    }
}

