/*
 * Decompiled with CFR 0.152.
 */
package pacSat;

import common.Config;
import common.Log;
import gui.MainWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedDeque;
import jssc.SerialPortException;
import pacSat.FrameDecoder;

public abstract class TncDecoder
implements Runnable {
    protected FileOutputStream byteFile;
    protected FrameDecoder decoder;
    MainWindow log;
    protected boolean running = true;
    String fileName = null;
    public static final boolean EXPEDITED = true;
    public static final boolean NOT_EXPEDITED = false;
    public static final DateFormat fileDateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
    public static final String kissFileName = "bytes_";
    protected ConcurrentLinkedDeque<int[]> frameQueue = new ConcurrentLinkedDeque();

    public TncDecoder(FrameDecoder frameDecoder, MainWindow ta, String fileName) {
        this.log = ta;
        ta.append("Loading file..\n");
        this.fileName = fileName;
        this.decoder = frameDecoder;
    }

    public TncDecoder(FrameDecoder frameDecoder, MainWindow ta) {
        this.log = ta;
        this.decoder = frameDecoder;
    }

    public void sendFrame(int[] bytes, boolean expedited) {
        if (expedited) {
            this.frameQueue.push(bytes);
        } else {
            this.frameQueue.add(bytes);
        }
    }

    public String getKissLogName() {
        Date today = Calendar.getInstance().getTime();
        fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = fileDateFormat.format(today);
        String name = String.valueOf(kissFileName) + reportDate + ".kss";
        if (!Config.get("logfile_dir").equalsIgnoreCase("")) {
            name = String.valueOf(Config.get("logfile_dir")) + File.separator + name;
        }
        return name;
    }

    @Override
    public void run() {
        block19: {
            Log.println("START TNC Decoder Thread");
            Thread.currentThread().setName("TncDecoder");
            if (this.fileName != null) {
                try {
                    this.log.append("processing file..\n");
                    this.decoder.decode(this.fileName, this.log);
                }
                catch (IOException e) {
                    Log.errorDialog("ERROR", "with raw byte file " + e);
                }
            } else {
                try {
                    try {
                        if (Config.getBoolean("kiss_logging")) {
                            this.byteFile = new FileOutputStream(this.getKissLogName());
                        }
                        this.process();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        System.err.println("FILE ERROR!");
                        Log.errorDialog("ERROR", "with raw byte file " + e);
                        if (this.byteFile != null) {
                            try {
                                this.byteFile.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (this.byteFile != null) {
                        try {
                            this.byteFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (this.byteFile != null) {
                    try {
                        this.byteFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        Log.println("EXIT TNC Decoder Thread");
    }

    protected abstract void process();

    public abstract void close();

    protected abstract void kissOn() throws SerialPortException, IOException;

    protected abstract void kissOff() throws SerialPortException, IOException;

    protected abstract void txFrame(int[] var1) throws SerialPortException, UnknownHostException, IOException;

    protected void fullDuplex() {
        int[] bytes = new int[]{192, 192, 5, 1, 192};
        this.sendFrame(bytes, false);
        this.log.append("TNC IN FULL DUPLEX\n");
    }

    protected void txDelay(int ms) {
        int[] bytes = new int[]{192, 1, 15, 192};
        bytes[2] = ms / 10 & 0xFF;
        this.sendFrame(bytes, false);
        this.log.append("TX DELAY: " + bytes[2] * 10 + "ms\n");
    }

    protected void txTail() {
        int[] bytes = new int[]{192, 4, 3, 192};
        this.sendFrame(bytes, false);
    }
}

