/*
 * Decompiled with CFR 0.152.
 */
package pacSat;

import common.Config;
import common.Log;
import gui.MainWindow;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import pacSat.FrameDecoder;
import pacSat.TncDecoder;

public class TcpTncDecoder
extends TncDecoder {
    String hostName;
    int portNumber;
    Socket socket = null;
    OutputStream out = null;
    InputStream in = null;

    public TcpTncDecoder(String hostname, int port, FrameDecoder frameDecoder, MainWindow ta) {
        super(frameDecoder, ta);
        this.hostName = hostname;
        this.portNumber = port;
    }

    @Override
    protected void process() {
        try {
            this.socket = new Socket(this.hostName, this.portNumber);
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            PortReader portReader = new PortReader();
            Thread rxThread = new Thread(portReader);
            rxThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
            rxThread.setName("tcpPortReader");
            rxThread.start();
            this.kissOn();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.fullDuplex();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.txDelay(Config.getInt("TNC_TX_DELAY"));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.append("Decoder Ready\n");
            while (this.running) {
                if (this.frameQueue.size() > 0) {
                    this.txFrame((int[])this.frameQueue.poll());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (UnknownHostException e2) {
            Log.errorDialog("ERROR", "Could not connect to the TNC over TCP with host: " + this.hostName + " and port " + this.portNumber + "\n" + e2.getMessage());
            e2.printStackTrace(Log.getWriter());
        }
        catch (IOException e2) {
            Log.errorDialog("ERROR", "IO Error connecting to the TNC over TCP with host: " + this.hostName + " and port " + this.portNumber + "\n" + e2.getMessage());
            e2.printStackTrace(Log.getWriter());
        }
    }

    @Override
    public void close() {
        this.running = false;
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.out = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    @Override
    protected void kissOn() throws IOException {
        this.log.append("KISS is assumed ON\n");
    }

    @Override
    protected void kissOff() throws IOException {
    }

    @Override
    protected void txFrame(int[] bytes) throws UnknownHostException, IOException {
        if (this.socket == null) {
            this.socket = new Socket(this.hostName, this.portNumber);
            this.out = this.socket.getOutputStream();
        }
        int[] nArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            this.out.write(b);
            ++n2;
        }
    }

    class PortReader
    implements Runnable {
        PortReader() {
        }

        @Override
        public void run() {
            Log.println("Starting TCP RX thread");
            byte[] receivedData = new byte[4096];
            while (TcpTncDecoder.this.running) {
                try {
                    int len = TcpTncDecoder.this.in.read(receivedData);
                    if (receivedData != null && len > 0) {
                        byte[] kissData = new byte[len];
                        int j = 0;
                        while (j < len) {
                            int i2 = receivedData[j] & 0xFF;
                            TcpTncDecoder.this.decoder.decodeByte(i2);
                            kissData[j] = receivedData[j];
                            ++j;
                        }
                        if (!Config.getBoolean("kiss_logging")) continue;
                        try {
                            if (TcpTncDecoder.this.byteFile == null) {
                                TcpTncDecoder.this.byteFile = new FileOutputStream(TcpTncDecoder.this.getKissLogName());
                            }
                            TcpTncDecoder.this.byteFile.write(kissData);
                        }
                        catch (IOException e) {
                            Log.errorDialog("ERROR", "Could not write the KISS logfile:\n" + e.getMessage());
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Log.println("Stopping TCP RX thread");
        }
    }
}

