/*
 * Decompiled with CFR 0.152.
 */
package pacSat;

import common.Config;
import common.Log;
import gui.MainWindow;
import gui.SettingsFrame;
import java.io.IOException;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import pacSat.FrameDecoder;
import pacSat.TncDecoder;

public class SerialTncDecoder
extends TncDecoder {
    SerialPort serialPort;
    String comPort = "COM1";
    int baudRate = 9600;
    int dataBits = 8;
    int stopBits = 1;
    int parity = 0;
    public static String[] portNames;

    public SerialTncDecoder(FrameDecoder frameDecoder, MainWindow ta, String fileName) {
        super(frameDecoder, ta, fileName);
        this.comPort = "FILE";
    }

    public SerialTncDecoder(String comPort, int baudRate, int dataBits, int stopBits, int parity, FrameDecoder frameDecoder, MainWindow ta) {
        super(frameDecoder, ta);
        this.comPort = comPort;
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    @Override
    protected void process() {
        if (this.comPort.equals("NONE")) {
            Log.errorDialog("ERROR", "Can't connect to TNC, no com port is configured.\nSetup a com port or use a TCP connection..");
            return;
        }
        this.serialPort = new SerialPort(this.comPort);
        try {
            this.serialPort.openPort();
            this.serialPort.setParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            this.serialPort.setFlowControlMode(3);
            this.serialPort.addEventListener(new PortReader(), 1);
            this.kissOn();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.fullDuplex();
            int delay = Config.getInt("TNC_TX_DELAY");
            this.txDelay(delay);
            this.log.append("Decoder Ready\n");
            while (this.running) {
                if (this.frameQueue.size() > 0) {
                    this.txFrame((int[])this.frameQueue.poll());
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (SerialPortException ex) {
            Log.errorDialog("ERROR", "writing to serial port: " + ex);
        }
    }

    @Override
    protected void kissOn() throws SerialPortException {
        if (Config.getBoolean("toggle_kiss")) {
            if (Config.getBoolean("send_user_defined_tnc_bytes")) {
                int[] by = SettingsFrame.stringToBytes(Config.get("kiss_bytes_at_start"));
                this.txFrame(by);
                this.log.append("KISS ON using user defined bytes:\n");
                this.log.append(String.valueOf(SettingsFrame.byteToString(Config.get("kiss_bytes_at_start"))) + "\n");
            } else {
                this.serialPort.writeString("KISS ON");
                this.serialPort.writeByte((byte)13);
                this.serialPort.writeString("RESTART");
                this.serialPort.writeByte((byte)13);
                this.log.append("KISS ON\n");
            }
        } else {
            this.log.append("KISS is assumed ON\n");
        }
    }

    @Override
    protected void kissOff() throws SerialPortException {
        if (Config.getBoolean("toggle_kiss")) {
            if (Config.getBoolean("send_user_defined_tnc_bytes")) {
                this.log.append("KISS OFF using user defined bytes:\n");
                int[] bytes = SettingsFrame.stringToBytes(Config.get("kiss_bytes_at_end"));
                this.sendFrame(bytes, false);
            } else {
                int[] bytes = new int[]{192, 255, 192};
                this.sendFrame(bytes, false);
                this.log.append("KISS OFF\n");
            }
        }
    }

    @Override
    protected void txFrame(int[] bytes) throws SerialPortException {
        if (this.serialPort == null) {
            throw new SerialPortException(this.comPort, "Write", "Serial Port not initialized");
        }
        this.serialPort.writeIntArray(bytes);
        if (Config.getBoolean("DEBUG_TX")) {
            this.log.append("Tx " + bytes.length + " bytes\n");
        }
    }

    @Override
    public void close() {
        block4: {
            try {
                if (this.serialPort == null) break block4;
                this.kissOff();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {
                // empty catch block
            }
        }
        this.running = false;
    }

    public static String[] getSerialPorts() {
        portNames = SerialPortList.getPortNames();
        if (portNames.length == 0) {
            return null;
        }
        return portNames;
    }

    public static String[] getAvailableBaudRates() {
        String[] rates = new String[]{"1200", "4800", "9600", "19200", "38400", "57600"};
        return rates;
    }

    public static String[] getAvailableStopBits() {
        String[] rates = new String[]{"1", "2", "3"};
        return rates;
    }

    public static String[] getAvailableDataBits() {
        String[] rates = new String[]{"5", "6", "7", "8"};
        return rates;
    }

    public static String[] getAvailableParities() {
        String[] rates = new String[]{"NONE", "ODD", "EVEN", "MARK"};
        return rates;
    }

    private class PortReader
    implements SerialPortEventListener {
        private PortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    byte[] receivedData;
                    byte[] byArray = receivedData = SerialTncDecoder.this.serialPort.readBytes(event.getEventValue());
                    int n = receivedData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        int i2 = b & 0xFF;
                        SerialTncDecoder.this.decoder.decodeByte(i2);
                        ++n2;
                    }
                    if (Config.getBoolean("kiss_logging")) {
                        try {
                            SerialTncDecoder.this.byteFile.write(receivedData);
                        }
                        catch (IOException e) {
                            Log.errorDialog("ERROR", "Could not write the KISS logfile:\n" + e.getMessage());
                        }
                        catch (NullPointerException e) {
                            Log.errorDialog("ERROR", "Could not access the KISS logfile:\n" + e.getMessage());
                        }
                    }
                }
                catch (SerialPortException ex) {
                    Log.println("Error in receiving string from COM-port: " + ex);
                }
            }
        }
    }
}

