/*
 * Decompiled with CFR 0.152.
 */
package pacSat;

import ax25.Ax25Frame;
import ax25.KissFrame;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.server.STP;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import gui.MainWindow;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import pacSat.SubmitTelem;
import pacSat.frames.BroadCastFrame;
import pacSat.frames.BroadcastDirFrame;
import pacSat.frames.BroadcastFileFrame;
import pacSat.frames.FTL0Frame;
import pacSat.frames.FrameException;
import pacSat.frames.IorsStatusFrame;
import pacSat.frames.PacSatFrame;
import pacSat.frames.ResponseFrame;
import pacSat.frames.StatusFrame;
import pacSat.frames.TimeFrame;
import pacSat.frames.TlmFrame;
import pacSat.frames.TlmMirSatFrame;
import pacSat.frames.TlmPacsatFrame;

public class FrameDecoder
implements Runnable {
    KissFrame kissFrame;
    ConcurrentLinkedQueue<Integer> buffer = new ConcurrentLinkedQueue();
    MainWindow log;
    boolean running = true;
    int byteCount = 0;
    int byteCountAtFrameStart = 0;
    int byteRead = 0;
    int fileByteCount = 0;
    int seq = 0;
    SpacecraftSettings spacecraftSettings;
    Ax25Frame frame = null;
    TlmMirSatFrame mirSatTlm = null;
    KissFrame sentKissFrame;
    int mirTlmType = -1;

    public FrameDecoder(MainWindow ta) {
        this.kissFrame = new KissFrame();
        this.log = ta;
        this.spacecraftSettings = Config.getSatSettingsByName("FalconSat-3");
    }

    public void decode(String data) {
        int p = 0;
        this.decodeByte(192);
        while (p < data.length()) {
            String s = "" + data.charAt(p) + data.charAt(p + 1);
            int b = Integer.valueOf(s, 16);
            ++this.byteRead;
            this.decodeByte(b);
            p += 2;
        }
        this.decodeByte(192);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void decode(String file, MainWindow ta) throws IOException {
        this.log = ta;
        try (FileInputStream byteFile = null;){
            byteFile = new FileInputStream(file);
            while (byteFile.available() > 0) {
                if (this.buffer.size() >= Integer.MAX_VALUE) continue;
                int b = byteFile.read();
                ++this.byteRead;
                this.decodeByte(b);
            }
        }
    }

    public void decodeAX25Frame(String file, MainWindow ta) throws IOException {
        this.log = ta;
        byte[] chunk = new byte[2048];
        try (FileInputStream byteFile = null;){
            byteFile = new FileInputStream(file);
            while (byteFile.available() > 0) {
                if (this.buffer.size() >= Integer.MAX_VALUE) continue;
                int b = byteFile.read(chunk);
                int[] by = new int[b];
                int i2 = 0;
                while (i2 < b) {
                    by[i2] = chunk[i2] & 0xFF;
                    ++i2;
                }
                try {
                    this.frame = new Ax25Frame(by);
                    String response = this.decodeFrame(this.frame);
                    this.log.append(String.valueOf(response) + "\n");
                }
                catch (FrameException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void decodeByte(int b) {
        this.buffer.add(b);
    }

    private String decodeFrame(Ax25Frame frame) {
        boolean broadcastBytes = false;
        boolean echoFrame = false;
        String s = "";
        if (Config.getBoolean("DEBUG_TELEM")) {
            System.out.println("AX25: " + frame.toDataString());
        }
        try {
            PacSatFrame st;
            BroadCastFrame bf;
            String fromCallsign = frame.fromCallsign;
            if (this.spacecraftSettings == null) {
                this.spacecraftSettings = Config.getSatSettingsByCallsign(fromCallsign);
            } else if (!this.spacecraftSettings.hasCallsign(fromCallsign)) {
                this.spacecraftSettings = Config.getSatSettingsByCallsign(fromCallsign);
            }
            if (this.spacecraftSettings == null) {
                return frame.toString();
            }
            if (frame.isBroadcastFileFrame()) {
                broadcastBytes = true;
                bf = new BroadcastFileFrame(frame);
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    this.spacecraftSettings.downlink.processEvent(bf);
                }
                this.fileByteCount += ((BroadcastFileFrame)bf).data.length;
                System.out.println("File Bytes: " + this.fileByteCount);
                s = ((BroadcastFileFrame)bf).toString();
                echoFrame = true;
            } else if (frame.isDirectoryBroadcastFrame()) {
                broadcastBytes = true;
                bf = new BroadcastDirFrame(frame);
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    this.spacecraftSettings.downlink.processEvent(bf);
                }
                s = ((BroadcastDirFrame)bf).toString();
                echoFrame = true;
            } else if (frame.isIorsStatusFrame()) {
                st = new IorsStatusFrame(frame);
                s = ((IorsStatusFrame)st).toString();
                if (MainWindow.spacecraftTabs.get(this.spacecraftSettings.name) != null && MainWindow.spacecraftTabs.get((Object)this.spacecraftSettings.name).commanding != null) {
                    MainWindow.spacecraftTabs.get((Object)this.spacecraftSettings.name).commanding.setStatus(s);
                }
            } else if (frame.isStatusFrame()) {
                st = new StatusFrame(frame);
                if (((StatusFrame)st).frameType == 3) {
                    if (this.spacecraftSettings != null && this.spacecraftSettings.uplink != null) {
                        this.spacecraftSettings.uplink.processEvent(st);
                    }
                } else {
                    if (((StatusFrame)st).frameType == 4) {
                        ((StatusFrame)st).bytesReceivedOnGround = this.byteCountAtFrameStart;
                        this.byteCountAtFrameStart = 0;
                    }
                    if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                        this.spacecraftSettings.downlink.processEvent(st);
                    }
                }
                s = ((StatusFrame)st).toString();
            } else if (frame.isResponseFrame()) {
                st = new ResponseFrame(frame);
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    this.spacecraftSettings.downlink.processEvent(st);
                }
                s = ((ResponseFrame)st).toString();
            } else if (frame.isTlmFrame()) {
                st = null;
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    try {
                        st = new TlmFrame(this.spacecraftSettings, frame);
                    }
                    catch (LayoutLoadException e1) {
                        s = "ERROR: Opening Layout " + e1.getMessage();
                    }
                }
                if (st != null && this.spacecraftSettings.downlink != null) {
                    this.spacecraftSettings.downlink.processEvent(st);
                }
                echoFrame = true;
            } else if (frame.isPacsatTlmFrame(this.spacecraftSettings)) {
                st = null;
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    try {
                        st = new TlmPacsatFrame(this.spacecraftSettings, frame);
                    }
                    catch (LayoutLoadException e1) {
                        s = "ERROR: Opening Layout " + e1.getMessage();
                    }
                }
                if (st != null && this.spacecraftSettings.downlink != null) {
                    this.spacecraftSettings.downlink.processEvent(st);
                }
                echoFrame = true;
            } else if (frame.isTlmMirSat1Frame1() >= 0) {
                this.mirTlmType = frame.isTlmMirSat1Frame1();
                s = "TLM1: Type: " + this.mirTlmType + " : " + frame.toString();
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null) {
                    try {
                        this.mirSatTlm = new TlmMirSatFrame(this.spacecraftSettings, frame);
                        if (this.mirSatTlm != null) {
                            this.spacecraftSettings.downlink.processEvent(this.mirSatTlm);
                        }
                    }
                    catch (LayoutLoadException e1) {
                        s = "ERROR: Opening Layout " + e1.getMessage();
                    }
                }
                echoFrame = true;
            } else if (frame.isTlmMirSat1Frame2()) {
                s = "TLM2: Type: " + this.mirTlmType + " : " + frame.toString();
                try {
                    if (this.mirSatTlm != null) {
                        this.mirSatTlm.add2ndFrame(frame);
                        if (this.mirTlmType == 0) {
                            this.mirSatTlm.parse2ndFrame(frame);
                        }
                    } else if (this.mirTlmType == 0 && this.mirTlmType == 0) {
                        this.mirSatTlm = new TlmMirSatFrame(this.spacecraftSettings, this.mirTlmType);
                        this.mirSatTlm.parse2ndFrame(frame);
                    }
                }
                catch (LayoutLoadException e1) {
                    s = "ERROR: Opening Layout " + e1.getMessage();
                }
                if (this.spacecraftSettings != null && this.spacecraftSettings.downlink != null && this.mirSatTlm != null) {
                    this.spacecraftSettings.downlink.processEvent(this.mirSatTlm);
                }
                echoFrame = true;
                this.mirSatTlm = null;
                this.mirTlmType = -1;
            } else if (frame.isSFrame()) {
                if (this.spacecraftSettings != null && this.spacecraftSettings.layer2data != null) {
                    this.spacecraftSettings.layer2data.processEvent(frame);
                }
            } else if (frame.isIFrame()) {
                FTL0Frame f = new FTL0Frame(frame);
                s = "I>> " + f.toString();
                if (this.spacecraftSettings != null && this.spacecraftSettings.layer2data != null) {
                    this.spacecraftSettings.layer2data.processEvent(frame);
                }
            } else if (frame.isUFrame()) {
                if (this.spacecraftSettings != null && this.spacecraftSettings.layer2data != null) {
                    this.spacecraftSettings.layer2data.processEvent(frame);
                }
                s = "U>> " + frame.toString();
            } else if (frame.isLstatFrame()) {
                s = "LSTAT: " + frame.toString();
                echoFrame = true;
            } else if (frame.isTimeFrame()) {
                TimeFrame timeFrame = new TimeFrame(frame);
                s = "TIME-1: " + timeFrame.toString();
                echoFrame = true;
            } else {
                s = "Unk:" + frame.toString();
                echoFrame = true;
            }
            if (Config.getBoolean("send_to_server") && echoFrame && this.sentKissFrame != null && this.spacecraftSettings != null) {
                if (this.spacecraftSettings.name.equalsIgnoreCase("Mir-Sat-1")) {
                    new Thread(){

                        @Override
                        public void run() {
                            Date now = new Date();
                            String url = FrameDecoder.this.spacecraftSettings.get("telem_server");
                            SubmitTelem telem = new SubmitTelem(url, FrameDecoder.this.spacecraftSettings.getInt("norad_id"), Config.get("callsign"), now, Config.getDouble("longitude"), Config.getDouble("latitude"));
                            telem.setFrame(FrameDecoder.this.sentKissFrame);
                            int retries = 0;
                            int MAX_RETRIES = 10;
                            boolean success = false;
                            while (retries < MAX_RETRIES) {
                                try {
                                    success = telem.send();
                                }
                                catch (Exception e) {
                                    Log.println("ERROR Sending telemetry to Server:" + e.getMessage());
                                    success = false;
                                }
                                if (success) {
                                    retries = MAX_RETRIES;
                                    continue;
                                }
                                Log.println("Failed Sending telemetry to Server: " + (retries + 1) + " of " + MAX_RETRIES + ". Retrying in 5 seconds");
                                ++retries;
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!success) {
                                Log.println("ERROR Sending telemetry to Server: Max retries reached");
                            }
                        }
                    }.start();
                } else if (this.spacecraftSettings.name.equalsIgnoreCase("FalconSat-3")) {
                    long seq = Config.sequence.getNextSequence();
                    STP stp = new STP(this.spacecraftSettings.spacecraft.satId, Config.get("callsign"), Config.get("latitude"), Config.get("longitude"), Config.get("altitude"), Config.get("station_details"), "PacsatGround V" + Config.VERSION, SpacecraftSettings.SOURCE, seq, this.sentKissFrame);
                    Config.stpQueue.add(stp);
                    ++Config.totalFrames;
                }
            }
            if (broadcastBytes && frame != null && frame.getDataBytes() != null) {
                this.byteCountAtFrameStart += frame.getDataBytes().length;
            }
        }
        catch (MalformedPfhException e) {
            if (frame != null && Config.getBoolean("DEBUG_LAYER3")) {
                s = "ERROR: Bad PFH - " + e.getMessage() + ": " + frame.toString();
            }
            this.kissFrame = new KissFrame();
        }
        catch (FileNotFoundException e) {
            if (frame != null) {
                s = String.valueOf(s) + frame.fromCallsign + " to " + frame.toCallsign + " ";
            }
            s = "ERROR: Opening file " + e.getMessage();
            this.kissFrame = new KissFrame();
        }
        catch (IOException e) {
            if (frame != null) {
                s = String.valueOf(s) + frame.fromCallsign + " to " + frame.toCallsign + " ";
            }
            s = "ERROR: Writing received file chunk" + e.getMessage();
            this.kissFrame = new KissFrame();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (frame != null) {
                s = String.valueOf(s) + frame.fromCallsign + " to " + frame.toCallsign + " ";
            }
            s = "ERROR: Processing frame (Index out of bounds) - ignored. " + e.getMessage();
            this.kissFrame = new KissFrame();
        }
        catch (FrameException fe) {
            if (frame != null && Config.getBoolean("DEBUG_LAYER2")) {
                s = String.valueOf(s) + frame.fromCallsign + " to " + frame.toCallsign + " ";
                s = "ERROR: " + fe.getMessage();
            }
            this.kissFrame = new KissFrame();
        }
        return s;
    }

    private String decodeFrameByte(int b) {
        ++this.byteCount;
        String s = "";
        if (!this.kissFrame.add(b)) {
            this.sentKissFrame = this.kissFrame;
            this.kissFrame = new KissFrame();
            try {
                this.frame = new Ax25Frame(this.sentKissFrame);
                s = this.decodeFrame(this.frame);
            }
            catch (FrameException fe) {
                if (this.frame != null && Config.getBoolean("DEBUG_LAYER2")) {
                    s = String.valueOf(s) + this.frame.fromCallsign + " to " + this.frame.toCallsign + " ";
                    s = "ERROR: " + fe.getMessage();
                }
                this.kissFrame = new KissFrame();
            }
        }
        return s;
    }

    public void close() {
        this.running = false;
    }

    @Override
    public void run() {
        Log.println("START Frame Decoder Thread");
        Thread.currentThread().setName("FrameDecoder");
        while (this.running) {
            Integer i2 = this.buffer.poll();
            if (i2 != null) {
                String response = this.decodeFrameByte(i2);
                if (response == "") continue;
                if (this.log == null) {
                    System.out.println(String.valueOf(response) + "\n");
                } else {
                    this.log.append(String.valueOf(response) + "\n");
                }
                Log.println(response);
                continue;
            }
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.println("EXIT Frame Decoder Thread");
        System.out.println("Read " + this.byteRead + " bytes");
        System.out.println("Decoded " + this.byteCount + " bytes");
    }
}

