/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Rule;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.migrationsupport.rules.adapter.AbstractTestRuleAdapter;
import org.junit.jupiter.migrationsupport.rules.adapter.GenericBeforeAndAfterAdvice;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedField;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMethod;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.rules.TestRule;

class TestRuleSupport
implements BeforeEachCallback,
TestExecutionExceptionHandler,
AfterEachCallback {
    private final Class<? extends TestRule> ruleType;
    private final Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator;

    TestRuleSupport(Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator, Class<? extends TestRule> ruleType) {
        this.adapterGenerator = adapterGenerator;
        this.ruleType = ruleType;
    }

    private List<TestRuleAnnotatedMember> findRuleAnnotatedMembers(Object testInstance) {
        ArrayList result = new ArrayList();
        this.findAnnotatedMethods(testInstance).stream().map(method -> new TestRuleAnnotatedMethod(testInstance, (Method)method)).forEach(result::add);
        this.findAnnotatedFields(testInstance).stream().map(field -> new TestRuleAnnotatedField(testInstance, (Field)field)).forEach(result::add);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    private List<Method> findAnnotatedMethods(Object testInstance) {
        Predicate<Method> isRuleMethod = method -> AnnotationUtils.isAnnotated(method, Rule.class);
        Predicate<Method> hasCorrectReturnType = method -> TestRule.class.isAssignableFrom(method.getReturnType());
        return ReflectionUtils.findMethods(testInstance.getClass(), isRuleMethod.and(hasCorrectReturnType));
    }

    private List<Field> findAnnotatedFields(Object testInstance) {
        return AnnotationUtils.findPublicAnnotatedFields(testInstance.getClass(), TestRule.class, Rule.class);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, false, GenericBeforeAndAfterAdvice::before);
    }

    @Override
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        int numRuleAnnotatedMembers = this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, true, advice -> advice.handleTestExecutionException(throwable));
        if (numRuleAnnotatedMembers == 0) {
            throw throwable;
        }
    }

    @Override
    public void afterEach(ExtensionContext context) {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, true, GenericBeforeAndAfterAdvice::after);
    }

    private int invokeAppropriateMethodOnRuleAnnotatedMembers(ExtensionContext context, boolean reverseOrder, AdviceInvoker adviceInvoker) {
        List<TestRuleAnnotatedMember> ruleAnnotatedMembers = this.getRuleAnnotatedMembers(context);
        if (reverseOrder) {
            Collections.reverse(ruleAnnotatedMembers);
        }
        AtomicInteger counter = new AtomicInteger();
        ruleAnnotatedMembers.stream().filter(annotatedMember -> this.ruleType.isInstance(annotatedMember.getTestRule())).map(this.adapterGenerator).forEach(advice -> {
            adviceInvoker.invokeAndMaskCheckedExceptions((GenericBeforeAndAfterAdvice)advice);
            counter.incrementAndGet();
        });
        return counter.get();
    }

    private List<TestRuleAnnotatedMember> getRuleAnnotatedMembers(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create(TestRuleSupport.class, context.getRequiredTestClass());
        return new ArrayList<TestRuleAnnotatedMember>(context.getStore(namespace).getOrComputeIfAbsent("rule-annotated-members", key -> this.findRuleAnnotatedMembers(testInstance), List.class));
    }

    @FunctionalInterface
    private static interface AdviceInvoker {
        default public void invokeAndMaskCheckedExceptions(GenericBeforeAndAfterAdvice advice) {
            try {
                this.invoke(advice);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException(t);
            }
        }

        public void invoke(GenericBeforeAndAfterAdvice var1) throws Throwable;
    }
}

