/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.conditions;

import java.lang.reflect.AnnotatedElement;
import org.apiguardian.api.API;
import org.junit.Ignore;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="5.7")
public class IgnoreCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("@org.junit.Ignore is not present");

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = context.getElement().orElse(null);
        return AnnotationUtils.findAnnotation(element, Ignore.class).map(annotation -> this.toResult(element, (Ignore)annotation)).orElse(ENABLED);
    }

    private ConditionEvaluationResult toResult(AnnotatedElement element, Ignore annotation) {
        String value = annotation.value();
        String reason = StringUtils.isNotBlank(value) ? value : element + " is disabled via @org.junit.Ignore";
        return ConditionEvaluationResult.disabled(reason);
    }
}

