/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import jssc.SerialNativeInterface;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;

public class SerialPort {
    private SerialNativeInterface serialInterface;
    private SerialPortEventListener eventListener;
    private long portHandle;
    private String portName;
    private boolean portOpened = false;
    private boolean maskAssigned = false;
    private boolean eventListenerAdded = false;
    private Method methodErrorOccurred = null;
    public static final int BAUDRATE_110 = 110;
    public static final int BAUDRATE_300 = 300;
    public static final int BAUDRATE_600 = 600;
    public static final int BAUDRATE_1200 = 1200;
    public static final int BAUDRATE_2400 = 2400;
    public static final int BAUDRATE_4800 = 4800;
    public static final int BAUDRATE_9600 = 9600;
    public static final int BAUDRATE_14400 = 14400;
    public static final int BAUDRATE_19200 = 19200;
    public static final int BAUDRATE_38400 = 38400;
    public static final int BAUDRATE_57600 = 57600;
    public static final int BAUDRATE_115200 = 115200;
    public static final int BAUDRATE_128000 = 128000;
    public static final int BAUDRATE_256000 = 256000;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_RXCLEAR = 8;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_TXCLEAR = 4;
    public static final int MASK_RXCHAR = 1;
    public static final int MASK_RXFLAG = 2;
    public static final int MASK_TXEMPTY = 4;
    public static final int MASK_CTS = 8;
    public static final int MASK_DSR = 16;
    public static final int MASK_RLSD = 32;
    public static final int MASK_BREAK = 64;
    public static final int MASK_ERR = 128;
    public static final int MASK_RING = 256;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    public static final int ERROR_FRAME = 8;
    public static final int ERROR_OVERRUN = 2;
    public static final int ERROR_PARITY = 4;
    private static final int PARAMS_FLAG_IGNPAR = 1;
    private static final int PARAMS_FLAG_PARMRK = 2;
    private int linuxMask;
    private EventThread eventThread;

    public SerialPort(String portName) {
        this.portName = portName;
        this.serialInterface = new SerialNativeInterface();
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isOpened() {
        return this.portOpened;
    }

    public boolean openPort() throws SerialPortException {
        if (this.portOpened) {
            throw new SerialPortException(this.portName, "openPort()", "Port already opened");
        }
        if (this.portName == null) {
            throw new SerialPortException(this.portName, "openPort()", "Null not permitted");
        }
        boolean useTIOCEXCL = System.getProperty("JSSC_NO_TIOCEXCL") == null && System.getProperty("JSSC_NO_TIOCEXCL".toLowerCase()) == null;
        this.portHandle = this.serialInterface.openPort(this.portName, useTIOCEXCL);
        if (this.portHandle == -1L) {
            throw new SerialPortException(this.portName, "openPort()", "Port busy");
        }
        if (this.portHandle == -2L) {
            throw new SerialPortException(this.portName, "openPort()", "Port not found");
        }
        if (this.portHandle == -3L) {
            throw new SerialPortException(this.portName, "openPort()", "Permission denied");
        }
        if (this.portHandle == -4L) {
            throw new SerialPortException(this.portName, "openPort()", "Incorrect serial port");
        }
        this.portOpened = true;
        return true;
    }

    public boolean setParams(int baudRate, int dataBits, int stopBits, int parity) throws SerialPortException {
        return this.setParams(baudRate, dataBits, stopBits, parity, true, true);
    }

    public boolean setParams(int baudRate, int dataBits, int stopBits, int parity, boolean setRTS, boolean setDTR) throws SerialPortException {
        this.checkPortOpened("setParams()");
        if (stopBits == 1) {
            stopBits = 0;
        } else if (stopBits == 3) {
            stopBits = 1;
        }
        int flags = 0;
        if (System.getProperty("JSSC_IGNPAR") != null || System.getProperty("JSSC_IGNPAR".toLowerCase()) != null) {
            flags |= 1;
        }
        if (System.getProperty("JSSC_PARMRK") != null || System.getProperty("JSSC_PARMRK".toLowerCase()) != null) {
            flags |= 2;
        }
        return this.serialInterface.setParams(this.portHandle, baudRate, dataBits, stopBits, parity, setRTS, setDTR, flags);
    }

    public boolean purgePort(int flags) throws SerialPortException {
        this.checkPortOpened("purgePort()");
        return this.serialInterface.purgePort(this.portHandle, flags);
    }

    public boolean setEventsMask(int mask) throws SerialPortException {
        this.checkPortOpened("setEventsMask()");
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            this.linuxMask = mask;
            this.maskAssigned = mask > 0;
            return true;
        }
        boolean returnValue = this.serialInterface.setEventsMask(this.portHandle, mask);
        if (!returnValue) {
            throw new SerialPortException(this.portName, "setEventsMask()", "Can't set mask");
        }
        this.maskAssigned = mask > 0;
        return returnValue;
    }

    public int getEventsMask() throws SerialPortException {
        this.checkPortOpened("getEventsMask()");
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            return this.linuxMask;
        }
        return this.serialInterface.getEventsMask(this.portHandle);
    }

    private int getLinuxMask() {
        return this.linuxMask;
    }

    public boolean setRTS(boolean enabled) throws SerialPortException {
        this.checkPortOpened("setRTS()");
        return this.serialInterface.setRTS(this.portHandle, enabled);
    }

    public boolean setDTR(boolean enabled) throws SerialPortException {
        this.checkPortOpened("setDTR()");
        return this.serialInterface.setDTR(this.portHandle, enabled);
    }

    public boolean writeBytes(byte[] buffer) throws SerialPortException {
        this.checkPortOpened("writeBytes()");
        return this.serialInterface.writeBytes(this.portHandle, buffer);
    }

    public boolean writeByte(byte singleByte) throws SerialPortException {
        this.checkPortOpened("writeByte()");
        return this.writeBytes(new byte[]{singleByte});
    }

    public boolean writeString(String string) throws SerialPortException {
        this.checkPortOpened("writeString()");
        return this.writeBytes(string.getBytes());
    }

    public boolean writeString(String string, String charsetName) throws SerialPortException, UnsupportedEncodingException {
        this.checkPortOpened("writeString()");
        return this.writeBytes(string.getBytes(charsetName));
    }

    public boolean writeInt(int singleInt) throws SerialPortException {
        this.checkPortOpened("writeInt()");
        return this.writeBytes(new byte[]{(byte)singleInt});
    }

    public boolean writeIntArray(int[] buffer) throws SerialPortException {
        this.checkPortOpened("writeIntArray()");
        byte[] byteArray = new byte[buffer.length];
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            byteArray[i2] = (byte)buffer[i2];
        }
        return this.writeBytes(byteArray);
    }

    public byte[] readBytes(int byteCount) throws SerialPortException {
        this.checkPortOpened("readBytes()");
        return this.serialInterface.readBytes(this.portHandle, byteCount);
    }

    public String readString(int byteCount) throws SerialPortException {
        this.checkPortOpened("readString()");
        return new String(this.readBytes(byteCount));
    }

    public String readHexString(int byteCount) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        return this.readHexString(byteCount, " ");
    }

    public String readHexString(int byteCount, String separator) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        String[] strBuffer = this.readHexStringArray(byteCount);
        String returnString = "";
        boolean insertSeparator = false;
        for (String value : strBuffer) {
            if (insertSeparator) {
                returnString = returnString + separator;
            }
            returnString = returnString + value;
            insertSeparator = true;
        }
        return returnString;
    }

    public String[] readHexStringArray(int byteCount) throws SerialPortException {
        this.checkPortOpened("readHexStringArray()");
        int[] intBuffer = this.readIntArray(byteCount);
        String[] strBuffer = new String[intBuffer.length];
        for (int i2 = 0; i2 < intBuffer.length; ++i2) {
            String value = Integer.toHexString(intBuffer[i2]).toUpperCase();
            if (value.length() == 1) {
                value = "0" + value;
            }
            strBuffer[i2] = value;
        }
        return strBuffer;
    }

    public int[] readIntArray(int byteCount) throws SerialPortException {
        this.checkPortOpened("readIntArray()");
        byte[] buffer = this.readBytes(byteCount);
        int[] intBuffer = new int[buffer.length];
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            intBuffer[i2] = buffer[i2] < 0 ? 256 + buffer[i2] : buffer[i2];
        }
        return intBuffer;
    }

    private void waitBytesWithTimeout(String methodName, int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("waitBytesWithTimeout()");
        boolean timeIsOut = true;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)timeout) {
            if (this.getInputBufferBytesCount() >= byteCount) {
                timeIsOut = false;
                break;
            }
            try {
                Thread.sleep(0L, 100);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (timeIsOut) {
            throw new SerialPortTimeoutException(this.portName, methodName, timeout);
        }
    }

    public byte[] readBytes(int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readBytes()");
        this.waitBytesWithTimeout("readBytes()", byteCount, timeout);
        return this.readBytes(byteCount);
    }

    public String readString(int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readString()");
        this.waitBytesWithTimeout("readString()", byteCount, timeout);
        return this.readString(byteCount);
    }

    public String readHexString(int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexString()");
        this.waitBytesWithTimeout("readHexString()", byteCount, timeout);
        return this.readHexString(byteCount);
    }

    public String readHexString(int byteCount, String separator, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexString()");
        this.waitBytesWithTimeout("readHexString()", byteCount, timeout);
        return this.readHexString(byteCount, separator);
    }

    public String[] readHexStringArray(int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexStringArray()");
        this.waitBytesWithTimeout("readHexStringArray()", byteCount, timeout);
        return this.readHexStringArray(byteCount);
    }

    public int[] readIntArray(int byteCount, int timeout) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readIntArray()");
        this.waitBytesWithTimeout("readIntArray()", byteCount, timeout);
        return this.readIntArray(byteCount);
    }

    public byte[] readBytes() throws SerialPortException {
        this.checkPortOpened("readBytes()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readBytes(byteCount);
    }

    public String readString() throws SerialPortException {
        this.checkPortOpened("readString()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readString(byteCount);
    }

    public String readHexString() throws SerialPortException {
        this.checkPortOpened("readHexString()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readHexString(byteCount);
    }

    public String readHexString(String separator) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readHexString(byteCount, separator);
    }

    public String[] readHexStringArray() throws SerialPortException {
        this.checkPortOpened("readHexStringArray()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readHexStringArray(byteCount);
    }

    public int[] readIntArray() throws SerialPortException {
        this.checkPortOpened("readIntArray()");
        int byteCount = this.getInputBufferBytesCount();
        if (byteCount <= 0) {
            return null;
        }
        return this.readIntArray(byteCount);
    }

    public int getInputBufferBytesCount() throws SerialPortException {
        this.checkPortOpened("getInputBufferBytesCount()");
        return this.serialInterface.getBuffersBytesCount(this.portHandle)[0];
    }

    public int getOutputBufferBytesCount() throws SerialPortException {
        this.checkPortOpened("getOutputBufferBytesCount()");
        return this.serialInterface.getBuffersBytesCount(this.portHandle)[1];
    }

    public boolean setFlowControlMode(int mask) throws SerialPortException {
        this.checkPortOpened("setFlowControlMode()");
        return this.serialInterface.setFlowControlMode(this.portHandle, mask);
    }

    public int getFlowControlMode() throws SerialPortException {
        this.checkPortOpened("getFlowControlMode()");
        return this.serialInterface.getFlowControlMode(this.portHandle);
    }

    public boolean sendBreak(int duration) throws SerialPortException {
        this.checkPortOpened("sendBreak()");
        return this.serialInterface.sendBreak(this.portHandle, duration);
    }

    private int[][] waitEvents() {
        return this.serialInterface.waitEvents(this.portHandle);
    }

    private void checkPortOpened(String methodName) throws SerialPortException {
        if (!this.portOpened) {
            throw new SerialPortException(this.portName, methodName, "Port not opened");
        }
    }

    public int[] getLinesStatus() throws SerialPortException {
        this.checkPortOpened("getLinesStatus()");
        return this.serialInterface.getLinesStatus(this.portHandle);
    }

    public boolean isCTS() throws SerialPortException {
        this.checkPortOpened("isCTS()");
        return this.serialInterface.getLinesStatus(this.portHandle)[0] == 1;
    }

    public boolean isDSR() throws SerialPortException {
        this.checkPortOpened("isDSR()");
        return this.serialInterface.getLinesStatus(this.portHandle)[1] == 1;
    }

    public boolean isRING() throws SerialPortException {
        this.checkPortOpened("isRING()");
        return this.serialInterface.getLinesStatus(this.portHandle)[2] == 1;
    }

    public boolean isRLSD() throws SerialPortException {
        this.checkPortOpened("isRLSD()");
        return this.serialInterface.getLinesStatus(this.portHandle)[3] == 1;
    }

    public void addEventListener(SerialPortEventListener listener) throws SerialPortException {
        this.addEventListener(listener, 1, false);
    }

    public void addEventListener(SerialPortEventListener listener, int mask) throws SerialPortException {
        this.addEventListener(listener, mask, true);
    }

    private void addEventListener(SerialPortEventListener listener, int mask, boolean overwriteMask) throws SerialPortException {
        this.checkPortOpened("addEventListener()");
        if (!this.eventListenerAdded) {
            if (this.maskAssigned && overwriteMask || !this.maskAssigned) {
                this.setEventsMask(mask);
            }
            this.eventListener = listener;
            this.eventThread = this.getNewEventThread();
            this.eventThread.setName("EventThread " + this.portName);
            try {
                Method method = this.eventListener.getClass().getMethod("errorOccurred", SerialPortException.class);
                method.setAccessible(true);
                this.methodErrorOccurred = method;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } else {
            throw new SerialPortException(this.portName, "addEventListener()", "Event listener already added");
        }
        this.eventThread.start();
        this.eventListenerAdded = true;
    }

    private EventThread getNewEventThread() {
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            return new LinuxEventThread();
        }
        return new EventThread();
    }

    public boolean removeEventListener() throws SerialPortException {
        this.checkPortOpened("removeEventListener()");
        if (!this.eventListenerAdded) {
            throw new SerialPortException(this.portName, "removeEventListener()", "Can't remove event listener, because listener not added");
        }
        this.eventThread.terminateThread();
        this.setEventsMask(0);
        if (Thread.currentThread().getId() != this.eventThread.getId() && this.eventThread.isAlive()) {
            try {
                this.eventThread.join(5000L);
            }
            catch (InterruptedException ex) {
                throw new SerialPortException(this.portName, "removeEventListener()", "Event listener thread interrupted");
            }
        }
        this.methodErrorOccurred = null;
        this.eventListenerAdded = false;
        return true;
    }

    public boolean closePort() throws SerialPortException {
        boolean returnValue;
        this.checkPortOpened("closePort()");
        if (this.eventListenerAdded) {
            this.removeEventListener();
        }
        if (returnValue = this.serialInterface.closePort(this.portHandle)) {
            this.maskAssigned = false;
            this.portOpened = false;
        }
        return returnValue;
    }

    private class LinuxEventThread
    extends EventThread {
        private final int INTERRUPT_BREAK = 512;
        private final int INTERRUPT_TX = 1024;
        private final int INTERRUPT_FRAME = 2048;
        private final int INTERRUPT_OVERRUN = 4096;
        private final int INTERRUPT_PARITY = 8192;
        private int interruptBreak;
        private int interruptTX;
        private int interruptFrame;
        private int interruptOverrun;
        private int interruptParity;
        private int preCTS;
        private int preDSR;
        private int preRLSD;
        private int preRING;

        public LinuxEventThread() {
            this.INTERRUPT_BREAK = 512;
            this.INTERRUPT_TX = 1024;
            this.INTERRUPT_FRAME = 2048;
            this.INTERRUPT_OVERRUN = 4096;
            this.INTERRUPT_PARITY = 8192;
            int[][] eventArray = SerialPort.this.waitEvents();
            block11: for (int i2 = 0; i2 < eventArray.length; ++i2) {
                int eventType = eventArray[i2][0];
                int eventValue = eventArray[i2][1];
                switch (eventType) {
                    case 512: {
                        this.interruptBreak = eventValue;
                        continue block11;
                    }
                    case 1024: {
                        this.interruptTX = eventValue;
                        continue block11;
                    }
                    case 2048: {
                        this.interruptFrame = eventValue;
                        continue block11;
                    }
                    case 4096: {
                        this.interruptOverrun = eventValue;
                        continue block11;
                    }
                    case 8192: {
                        this.interruptParity = eventValue;
                        continue block11;
                    }
                    case 8: {
                        this.preCTS = eventValue;
                        continue block11;
                    }
                    case 16: {
                        this.preDSR = eventValue;
                        continue block11;
                    }
                    case 256: {
                        this.preRING = eventValue;
                        continue block11;
                    }
                    case 32: {
                        this.preRLSD = eventValue;
                    }
                }
            }
        }

        @Override
        public void run() {
            while (!((EventThread)this).threadTerminated) {
                int[][] eventArray = SerialPort.this.waitEvents();
                int mask = SerialPort.this.getLinuxMask();
                boolean interruptTxChanged = false;
                int errorMask = 0;
                for (int i2 = 0; i2 < eventArray.length; ++i2) {
                    boolean sendEvent = false;
                    int eventType = eventArray[i2][0];
                    int eventValue = eventArray[i2][1];
                    if (eventType <= 0 || ((EventThread)this).threadTerminated) continue;
                    switch (eventType) {
                        case 512: {
                            if (eventValue == this.interruptBreak) break;
                            this.interruptBreak = eventValue;
                            if ((mask & 0x40) != 64) break;
                            eventType = 64;
                            eventValue = 0;
                            sendEvent = true;
                            break;
                        }
                        case 1024: {
                            if (eventValue == this.interruptTX) break;
                            this.interruptTX = eventValue;
                            interruptTxChanged = true;
                            break;
                        }
                        case 2048: {
                            if (eventValue == this.interruptFrame) break;
                            this.interruptFrame = eventValue;
                            errorMask |= 8;
                            break;
                        }
                        case 4096: {
                            if (eventValue == this.interruptOverrun) break;
                            this.interruptOverrun = eventValue;
                            errorMask |= 2;
                            break;
                        }
                        case 8192: {
                            if (eventValue != this.interruptParity) {
                                this.interruptParity = eventValue;
                                errorMask |= 4;
                            }
                            if ((mask & 0x80) != 128 || errorMask == 0) break;
                            eventType = 128;
                            eventValue = errorMask;
                            sendEvent = true;
                            break;
                        }
                        case 8: {
                            if (eventValue == this.preCTS) break;
                            this.preCTS = eventValue;
                            if ((mask & 8) != 8) break;
                            sendEvent = true;
                            break;
                        }
                        case 16: {
                            if (eventValue == this.preDSR) break;
                            this.preDSR = eventValue;
                            if ((mask & 0x10) != 16) break;
                            sendEvent = true;
                            break;
                        }
                        case 256: {
                            if (eventValue == this.preRING) break;
                            this.preRING = eventValue;
                            if ((mask & 0x100) != 256) break;
                            sendEvent = true;
                            break;
                        }
                        case 32: {
                            if (eventValue == this.preRLSD) break;
                            this.preRLSD = eventValue;
                            if ((mask & 0x20) != 32) break;
                            sendEvent = true;
                            break;
                        }
                        case 1: {
                            if ((mask & 1) != 1 || eventValue <= 0) break;
                            sendEvent = true;
                            break;
                        }
                        case 4: {
                            if ((mask & 4) != 4 || eventValue != 0 || !interruptTxChanged) break;
                            sendEvent = true;
                        }
                    }
                    if (!sendEvent) continue;
                    SerialPort.this.eventListener.serialEvent(new SerialPortEvent(SerialPort.this.portName, eventType, eventValue));
                }
                try {
                    Thread.sleep(0L, 100);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class EventThread
    extends Thread {
        private boolean threadTerminated = false;

        private EventThread() {
        }

        @Override
        public void run() {
            while (!this.threadTerminated) {
                int[][] eventArray = SerialPort.this.waitEvents();
                for (int i2 = 0; i2 < eventArray.length; ++i2) {
                    if (eventArray[i2][0] <= 0 || this.threadTerminated) continue;
                    SerialPort.this.eventListener.serialEvent(new SerialPortEvent(SerialPort.this.portName, eventArray[i2][0], eventArray[i2][1]));
                }
            }
        }

        private void terminateThread() {
            this.threadTerminated = true;
        }
    }
}

