/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.gui.DisplayModule;
import com.g0kla.telem.gui.ModuleTab;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import common.Log;
import gui.MainWindow;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.io.IOException;

public class TelemTab
extends ModuleTab {
    DataRecord record;

    public TelemTab(ByteArrayLayout layout, Spacecraft sat, SatTelemStore db) {
        super(layout, sat, db);
    }

    public void updateTab(DataRecord record, boolean refreshTable) {
        DisplayModule mod;
        DisplayModule[] displayModuleArray = this.topModules;
        int n = this.topModules.length;
        int n2 = 0;
        while (n2 < n) {
            mod = displayModuleArray[n2];
            if (mod != null) {
                try {
                    mod.updateValues(record);
                }
                catch (NumberFormatException e) {
                    Log.errorDialog("ERROR", "ERROR");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    Log.errorDialog("ERROR", "ERROR");
                    e.printStackTrace();
                }
                catch (DataLoadException e) {
                    Log.errorDialog("ERROR", "ERROR");
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n = this.bottomModules.length;
            n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    try {
                        mod.updateValues(record);
                    }
                    catch (NumberFormatException e) {
                        Log.errorDialog("ERROR", "ERROR");
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR", "ERROR");
                        e.printStackTrace();
                    }
                    catch (DataLoadException e) {
                        Log.errorDialog("ERROR", "ERROR");
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        this.displayCaptureDate(record.uptime);
        if (refreshTable) {
            this.parseFrames();
        }
    }

    @Override
    public void parseFrames() {
        String[][] data = null;
        try {
            data = this.db.getTableData(this.SAMPLES, 0, this.START_RESET, this.START_UPTIME, false, this.reverse, this.layout.name);
        }
        catch (NumberFormatException e) {
            Log.errorDialog("ERROR", "Issue parsing telemetry: " + e.getMessage());
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Issue loading telemetry: " + e.getMessage());
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Issue loaring layout for telemetry: " + e.getMessage());
        }
        catch (DataLoadException e) {
            Log.errorDialog("ERROR", "Issue loading data for telemetry: " + e.getMessage());
        }
        if (data != null && data.length > 0) {
            this.parseTelemetry(data);
            MainWindow.frame.repaint();
        }
    }

    @Override
    public void run() {
        this.running = true;
        this.done = false;
        boolean justStarted = true;
        while (this.running) {
            boolean updated;
            if (this.db != null && (updated = this.db.getUpdated(this.layout.name))) {
                this.db.setUpdated(this.layout.name, false);
                try {
                    this.record = this.db.getLatest(this.layout.name);
                    if (this.record != null) {
                        this.updateTab(this.record, true);
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (DataLoadException e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: WODTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            DisplayModule mod;
            int n;
            int n2;
            DisplayModule[] displayModuleArray;
            boolean b = this.showRawValues.isSelected();
            if (this.topModules != null) {
                displayModuleArray = this.topModules;
                n2 = this.topModules.length;
                n = 0;
                while (n < n2) {
                    mod = displayModuleArray[n];
                    if (mod != null) {
                        mod.setDisplayRawValues(b);
                        try {
                            mod.updateValues(this.record);
                        }
                        catch (NumberFormatException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (DataLoadException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n2 = this.bottomModules.length;
                n = 0;
                while (n < n2) {
                    mod = displayModuleArray[n];
                    if (mod != null) {
                        mod.setDisplayRawValues(b);
                        try {
                            mod.updateValues(this.record);
                        }
                        catch (NumberFormatException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (DataLoadException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
            this.parseFrames();
        }
    }

    @Override
    protected void displayRow(int fromRow, int row) {
        long reset_l = (Long)this.table.getValueAt(row, 0);
        long uptime = (Long)this.table.getValueAt(row, 1);
        int reset = (int)reset_l;
        try {
            this.record = this.db.getLatest(0, reset, uptime, 0, this.layout.name, false);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataLoadException e) {
            e.printStackTrace();
        }
        if (this.record != null) {
            this.updateTab(this.record, false);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            this.table.setRowSelectionInterval(fromRow, row);
        } else {
            this.table.setRowSelectionInterval(row, fromRow);
        }
    }
}

