/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import gui.FileHeaderTableModel;
import gui.SpacecraftTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class TablePanel
extends JScrollPane
implements MouseListener {
    private static final long serialVersionUID = 1L;
    FileHeaderTableModel fileHeaderTableModel;
    JTable directoryTable;
    SpacecraftSettings spacecraftSettings;
    SpacecraftTab spacecraftTab;
    int holes;
    int age;

    TablePanel(SpacecraftSettings spacecraftSettings, SpacecraftTab spacecraftTab) {
        this.spacecraftSettings = spacecraftSettings;
        this.spacecraftTab = spacecraftTab;
        this.fileHeaderTableModel = new FileHeaderTableModel();
        this.directoryTable = new JTable(this.fileHeaderTableModel);
        this.directoryTable.setAutoCreateRowSorter(true);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(31);
        this.getViewport().add(this.directoryTable);
        this.directoryTable.setFillsViewportHeight(true);
        this.directoryTable.setAutoResizeMode(2);
        Font f = this.directoryTable.getFont();
        Font f2 = new Font(f.getFontName(), f.getStyle(), Config.getInt("font_size"));
        this.directoryTable.setFont(f2);
        this.directoryTable.getTableHeader().setFont(f2);
        int[] columnWidths = FileHeaderTableModel.columnWidths;
        int i2 = 0;
        while (i2 < this.directoryTable.getColumnModel().getColumnCount()) {
            TableColumn column = this.directoryTable.getColumnModel().getColumn(i2);
            column.setPreferredWidth(columnWidths[i2]);
            column.setCellRenderer(new DirTableCellRenderer());
            ++i2;
        }
        if (!Config.getBoolean("SHOW_DIR_TIMES")) {
            TableColumnModel tcm = this.directoryTable.getColumnModel();
            tcm.removeColumn(tcm.getColumn(5));
            tcm.removeColumn(tcm.getColumn(6));
        }
        this.directoryTable.addMouseListener(this);
        String PREV = "prev";
        String NEXT = "next";
        String ENTER = "enter";
        String ZERO = "zero";
        String ONE = "one";
        String TWO = "two";
        String THREE = "three";
        String FOUR = "four";
        String NINE = "nine";
        String N = "N";
        String DELETE = "del";
        String BACK = "back";
        String FIND = "find";
        InputMap inMap = this.directoryTable.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        inMap.put(KeyStroke.getKeyStroke("ENTER"), ENTER);
        inMap.put(KeyStroke.getKeyStroke("0"), ZERO);
        inMap.put(KeyStroke.getKeyStroke("1"), ONE);
        inMap.put(KeyStroke.getKeyStroke("2"), TWO);
        inMap.put(KeyStroke.getKeyStroke("3"), THREE);
        inMap.put(KeyStroke.getKeyStroke("4"), FOUR);
        inMap.put(KeyStroke.getKeyStroke("9"), NINE);
        inMap.put(KeyStroke.getKeyStroke("N"), N);
        inMap.put(KeyStroke.getKeyStroke(127, 0), DELETE);
        inMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), BACK);
        inMap.put(KeyStroke.getKeyStroke(70, 128), FIND);
        ActionMap actMap = this.directoryTable.getActionMap();
        actMap.put(DELETE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.deleteRow(TablePanel.this.directoryTable, row);
                    if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                        TablePanel.this.directoryTable.setRowSelectionInterval(row, row);
                        TablePanel.this.directoryTable.scrollRectToVisible(new Rectangle(TablePanel.this.directoryTable.getCellRect(row, 0, true)));
                    }
                }
            }
        });
        actMap.put(BACK, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.deleteRow(TablePanel.this.directoryTable, row);
                    if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                        TablePanel.this.directoryTable.setRowSelectionInterval(row, row);
                        TablePanel.this.directoryTable.scrollRectToVisible(new Rectangle(TablePanel.this.directoryTable.getCellRect(row, 0, true)));
                    }
                }
            }
        });
        actMap.put(FIND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row > 0) {
                    TablePanel.this.directoryTable.setRowSelectionInterval(row, row);
                    TablePanel.this.directoryTable.scrollRectToVisible(new Rectangle(TablePanel.this.directoryTable.getCellRect(row - 1, 0, true)));
                }
            }
        });
        actMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row > 0) {
                    TablePanel.this.directoryTable.setRowSelectionInterval(row - 1, row - 1);
                    TablePanel.this.directoryTable.scrollRectToVisible(new Rectangle(TablePanel.this.directoryTable.getCellRect(row - 1, 0, true)));
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row < TablePanel.this.directoryTable.getRowCount() - 1) {
                    TablePanel.this.directoryTable.setRowSelectionInterval(row + 1, row + 1);
                    TablePanel.this.directoryTable.scrollRectToVisible(new Rectangle(TablePanel.this.directoryTable.getCellRect(row + 1, 0, true)));
                }
            }
        });
        actMap.put(ENTER, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.displayRow(TablePanel.this.directoryTable, row);
                }
            }
        });
        actMap.put(ZERO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 0);
                }
            }
        });
        actMap.put(ONE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 1);
                }
            }
        });
        actMap.put(TWO, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 2);
                }
            }
        });
        actMap.put(THREE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 3);
                }
            }
        });
        actMap.put(FOUR, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 4);
                }
            }
        });
        actMap.put(NINE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 9);
                }
            }
        });
        actMap.put(N, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row >= 0 && row < TablePanel.this.directoryTable.getRowCount()) {
                    TablePanel.this.setPriority(TablePanel.this.directoryTable, row, 9);
                }
            }
        });
        actMap.put(FIND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("FIND not yet implement");
                int row = TablePanel.this.directoryTable.getSelectedRow();
                if (row < 0 || row < TablePanel.this.directoryTable.getRowCount()) {
                    // empty if block
                }
            }
        });
    }

    public void setDirectoryData(String[][] data) {
        if (data != null && data.length > 0) {
            int row = this.directoryTable.getSelectedRow();
            if (data.length > 0) {
                this.fileHeaderTableModel.setData(data);
            } else {
                this.fileHeaderTableModel.setData(FileHeaderTableModel.BLANK);
            }
            if (row >= 0 && row < this.directoryTable.getRowCount()) {
                this.directoryTable.setRowSelectionInterval(row, row);
            }
        } else {
            this.fileHeaderTableModel.setData(FileHeaderTableModel.BLANK);
        }
        this.holes = this.spacecraftSettings.directory.getHolesList().size();
        if (this.holes > 0) {
            --this.holes;
        }
        this.age = this.spacecraftSettings.directory.getAge();
    }

    protected abstract void displayRow(JTable var1, int var2);

    protected abstract void deleteRow(JTable var1, int var2);

    protected abstract void setPriority(JTable var1, int var2, long var3, int var5);

    protected void setPriority(JTable table, int row, int pri) {
        String idstr = (String)table.getValueAt(row, 0);
        Long id = Long.parseLong(idstr);
        if (this.spacecraftSettings.directory.getPfhById(id).getState() == 4) {
            if (pri == 0) {
                this.setPriority(table, row, id, pri);
            } else {
                Log.infoDialog("Request Ignored", "This file is missing on the server, so it cannot be requested");
            }
        } else if (this.spacecraftSettings.directory.getPfhById(id).getState() == 3 || this.spacecraftSettings.directory.getPfhById(id).getState() == 2) {
            if (pri == 0) {
                this.setPriority(table, row, id, pri);
            }
        } else {
            this.setPriority(table, row, id, pri);
        }
        if (row < this.directoryTable.getRowCount() - 1) {
            this.directoryTable.setRowSelectionInterval(row + 1, row + 1);
            this.directoryTable.scrollRectToVisible(new Rectangle(this.directoryTable.getCellRect(row + 1, 0, true)));
        } else {
            this.directoryTable.setRowSelectionInterval(row, row);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String id;
        int row = this.directoryTable.rowAtPoint(e.getPoint());
        int col = this.directoryTable.columnAtPoint(e.getPoint());
        if (row >= 0 && col >= 0 && (id = (String)this.directoryTable.getValueAt(row, 0)) != null) {
            this.spacecraftTab.txtFileId.setText(id);
            try {
                Long lid = Long.parseLong(id);
                PacSatFile pf = new PacSatFile(this.spacecraftSettings, this.spacecraftSettings.directory.dirFolder, lid);
                if (e.getClickCount() == 2) {
                    this.displayRow(this.directoryTable, row);
                }
                this.directoryTable.setRowSelectionInterval(row, row);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public class DirTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            String status = (String)table.getValueAt(row, 2);
            String toCallsign = (String)table.getValueAt(row, 3);
            if (!isSelected) {
                if (status.equalsIgnoreCase("")) {
                    cell.setForeground(Color.gray);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[4])) {
                    cell.setForeground(Color.gray);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[5])) {
                    cell.setForeground(Color.blue);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[8])) {
                    cell.setForeground(Color.gray);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[6])) {
                    cell.setForeground(Color.black);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[7])) {
                    cell.setForeground(Color.red);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[1])) {
                    cell.setForeground(Color.black);
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[2])) {
                    Font font = cell.getFont();
                    cell.setFont(font.deriveFont(1));
                    if (toCallsign.startsWith(Config.get("callsign"))) {
                        cell.setForeground(Color.red);
                    } else {
                        cell.setForeground(Color.blue);
                    }
                } else if (status.equalsIgnoreCase(PacSatFileHeader.states[3])) {
                    Font font = cell.getFont();
                    cell.setFont(font.deriveFont(0));
                    if (toCallsign.startsWith(Config.get("callsign"))) {
                        cell.setForeground(Color.red);
                    } else {
                        cell.setForeground(Color.blue);
                    }
                }
            }
            return cell;
        }
    }
}

