/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.g0kla.telem.data.ByteArrayLayout;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.DirHole;
import fileStore.FileHole;
import fileStore.PacSatFile;
import fileStore.SortedArrayList;
import gui.CommandFrame;
import gui.DirectoryPanel;
import gui.LimitLinesDocumentListener;
import gui.MainWindow;
import gui.OutboxPanel;
import gui.TelemTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.DefaultCaret;
import pacSat.frames.RequestDirFrame;
import pacSat.frames.RequestFileFrame;

public class SpacecraftTab
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String SHOW_ALL_LBL = "All Files";
    public static final String SHOW_USER_LBL = "User Files";
    public static final boolean SHOW_ALL = false;
    public static final boolean SHOW_USER = true;
    public DirectoryPanel dirPanel;
    public OutboxPanel outbox;
    JTabbedPane jtabbedPane;
    JPanel dirAndStatusPanel;
    SpacecraftSettings spacecraftSettings;
    JButton butDirReq;
    JButton butFileReq;
    JButton butCmd;
    JTextField txtFileId;
    JButton butFilter;
    JButton butNew;
    JButton butLogin;
    JCheckBox cbUplink;
    JCheckBox cbDownlink;
    JLabel lblDirHoles;
    JLabel lblFileName;
    JLabel lblPBStatus;
    JLabel lblPGStatus;
    JLabel lblPGLogin;
    JLabel lblFileUploading;
    JLabel lblUplinkStatus;
    JLabel lblLayer2Status;
    JLabel lblDownlinkStatus;
    JPanel filePanel;
    JLabel lblEfficiency;
    public CommandFrame commanding;

    SpacecraftTab(SpacecraftSettings spacecraftSettings) {
        this.spacecraftSettings = spacecraftSettings;
        spacecraftSettings.directory.setShowFiles(spacecraftSettings.getBoolean("show_user_files"));
        this.setLayout(new BorderLayout());
        this.makeTopPanel();
        this.makeSpacecraftPanel(spacecraftSettings);
        this.makeBottomPanel();
    }

    private void makeTopPanel() {
        JPanel topPanel = new JPanel();
        this.add((Component)topPanel, "North");
        topPanel.setLayout(new FlowLayout(0));
        this.butDirReq = new JButton("DIR");
        this.butDirReq.setMargin(new Insets(0, 0, 0, 0));
        this.butDirReq.addActionListener(this);
        this.butDirReq.setToolTipText("Request the lastest directory entries");
        this.butDirReq.setFont(MainWindow.sysFont);
        JLabel bar = new JLabel("|");
        JLabel bar2 = new JLabel("|");
        JLabel lblReq = new JLabel("Request: ");
        lblReq.setFont(MainWindow.sysFont);
        this.butFileReq = new JButton("FILE");
        this.butFileReq.setMargin(new Insets(0, 0, 0, 0));
        this.butFileReq.addActionListener(this);
        this.butFileReq.setToolTipText("Request the file with this ID");
        this.butFileReq.setFont(MainWindow.sysFont);
        JLabel dash = new JLabel("-");
        this.txtFileId = new JTextField();
        this.txtFileId.setColumns(4);
        this.butFilter = new JButton();
        if (this.spacecraftSettings.getBoolean("show_user_files")) {
            this.butFilter.setText(SHOW_USER_LBL);
        } else {
            this.butFilter.setText(SHOW_ALL_LBL);
        }
        this.butFilter.setMargin(new Insets(0, 0, 0, 0));
        this.butFilter.addActionListener(this);
        this.butFilter.setToolTipText("Toggle ALL or User Files");
        this.butFilter.setFont(MainWindow.sysFont);
        if (this.spacecraftSettings.getBoolean("supports_file_upload")) {
            this.butNew = new JButton("New Msg");
            this.butNew.setMargin(new Insets(0, 0, 0, 0));
            this.butNew.addActionListener(this);
            this.butNew.setToolTipText("Create a new Message");
            if (Config.get("callsign").equalsIgnoreCase("NONE")) {
                this.butNew.setEnabled(false);
            } else {
                this.butNew.setEnabled(true);
            }
            this.butNew.setFont(MainWindow.sysFont);
            topPanel.add(this.butNew);
            topPanel.add(bar2);
        }
        JLabel bar3 = new JLabel("  |    ");
        if (this.spacecraftSettings.getBoolean("is_command_station")) {
            this.butCmd = new JButton("Command");
            this.butCmd.setMargin(new Insets(0, 0, 0, 0));
            this.butCmd.addActionListener(this);
            this.butCmd.setToolTipText("Open Command Window");
            this.butCmd.setFont(MainWindow.sysFont);
        }
        topPanel.add(lblReq);
        topPanel.add(this.butDirReq);
        topPanel.add(this.butFileReq);
        topPanel.add(dash);
        topPanel.add(this.txtFileId);
        topPanel.add(bar);
        topPanel.add(this.butFilter);
        if (this.spacecraftSettings.getBoolean("is_command_station")) {
            topPanel.add(bar3);
            topPanel.add(this.butCmd);
        }
    }

    private void makeSpacecraftPanel(SpacecraftSettings spacecraftSettings) {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.jtabbedPane = new JTabbedPane();
        this.add((Component)this.jtabbedPane, "Center");
        this.dirPanel = new DirectoryPanel(spacecraftSettings, this);
        this.outbox = new OutboxPanel(spacecraftSettings, this);
        this.jtabbedPane.setTabLayoutPolicy(1);
        this.setFont(MainWindow.sysFont);
        this.addDirTabs();
        this.addTelemTabs(spacecraftSettings);
    }

    private void makeBottomPanel() {
        JPanel bottomPanel = new JPanel();
        this.dirAndStatusPanel.add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BorderLayout());
        JPanel satStatusPanel = this.makeSatStatusPanel();
        bottomPanel.add((Component)satStatusPanel, "Center");
    }

    void addDirTabs() {
        JPanel logPanel = this.makeLogPanel();
        this.dirAndStatusPanel = new JPanel();
        this.dirAndStatusPanel.setLayout(new BorderLayout());
        this.dirAndStatusPanel.add((Component)this.dirPanel, "Center");
        final JSplitPane splitPane = new JSplitPane(0, this.dirAndStatusPanel, logPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        MainWindow.splitPaneHeight = Config.getInt("window_split_pane_height");
        if (MainWindow.splitPaneHeight != 0) {
            splitPane.setDividerLocation(MainWindow.splitPaneHeight);
        } else {
            splitPane.setDividerLocation(450);
        }
        SplitPaneUI spui = splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    MainWindow.splitPaneHeight = splitPane.getDividerLocation();
                    Config.set("window_split_pane_height", MainWindow.splitPaneHeight);
                }
            });
        }
        this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>Directory</body></html>", splitPane);
        if (this.spacecraftSettings.getBoolean("supports_file_upload")) {
            this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>Outbox</body></html>", this.outbox);
        }
    }

    private JPanel makeLogPanel() {
        JPanel centerBottomPanel = new JPanel();
        centerBottomPanel.setLayout(new BoxLayout(centerBottomPanel, 1));
        MainWindow.logTextArea = new JTextArea(10, 135);
        MainWindow.logTextArea.setLineWrap(true);
        MainWindow.logTextArea.setWrapStyleWord(true);
        MainWindow.logTextArea.setEditable(false);
        Font f = MainWindow.logTextArea.getFont();
        Font f2 = new Font(f.getFontName(), f.getStyle(), MainWindow.fontSize);
        MainWindow.logTextArea.setFont(f2);
        DefaultCaret caret = (DefaultCaret)MainWindow.logTextArea.getCaret();
        caret.setUpdatePolicy(2);
        MainWindow.logTextArea.getDocument().addDocumentListener(new LimitLinesDocumentListener(100));
        JScrollPane logScroll = new JScrollPane(MainWindow.logTextArea);
        logScroll.setVerticalScrollBarPolicy(22);
        logScroll.setHorizontalScrollBarPolicy(32);
        centerBottomPanel.add(logScroll);
        return centerBottomPanel;
    }

    void addTelemTabs(SpacecraftSettings spacecraftSettings) {
        if (spacecraftSettings.spacecraft == null) {
            return;
        }
        if (spacecraftSettings.spacecraft.layoutsUseToCallsignAsType) {
            ByteArrayLayout[] byteArrayLayoutArray = spacecraftSettings.spacecraft.layout;
            int n = spacecraftSettings.spacecraft.layout.length;
            int n2 = 0;
            while (n2 < n) {
                ByteArrayLayout layout = byteArrayLayoutArray[n2];
                TelemTab wodPanel = new TelemTab(layout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread wodPanelThread = new Thread(wodPanel);
                wodPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                wodPanelThread.setName(layout.name);
                wodPanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>" + layout.name + "</body></html>", wodPanel);
                ++n2;
            }
        } else {
            ByteArrayLayout tlm2Layout;
            ByteArrayLayout tlm1Layout;
            ByteArrayLayout tlm16Layout;
            ByteArrayLayout tlmLayout;
            ByteArrayLayout fullWodLayout;
            ByteArrayLayout wodLayout = spacecraftSettings.spacecraft.getLayoutByName("WOD_LAYOUT");
            if (wodLayout != null) {
                TelemTab wodPanel = new TelemTab(wodLayout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread wodPanelThread = new Thread(wodPanel);
                wodPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                wodPanelThread.setName("WODTab");
                wodPanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>WOD</body></html>", wodPanel);
            }
            if ((fullWodLayout = spacecraftSettings.spacecraft.getLayoutByName("FULL_WOD_LAYOUT")) != null) {
                TelemTab fullWodPanel = new TelemTab(fullWodLayout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread wodPanelThread = new Thread(fullWodPanel);
                wodPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                wodPanelThread.setName("FullWODTab");
                wodPanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>Full WOD</body></html>", fullWodPanel);
            }
            if ((tlmLayout = spacecraftSettings.spacecraft.getLayoutByName("TLMI_LAYOUT")) != null) {
                TelemTab tlmIPanel = new TelemTab(tlmLayout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread telemIPanelThread = new Thread(tlmIPanel);
                telemIPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                telemIPanelThread.setName("TLMItab");
                telemIPanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>TLM</body></html>", tlmIPanel);
            }
            if ((tlm16Layout = spacecraftSettings.spacecraft.getLayoutByName("TLM16_LAYOUT")) != null) {
                TelemTab tlm16Panel = new TelemTab(tlm16Layout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread telemIPanelThread = new Thread(tlm16Panel);
                telemIPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                telemIPanelThread.setName("FailSafeTab");
                telemIPanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>FailSafe</body></html>", tlm16Panel);
            }
            if ((tlm1Layout = spacecraftSettings.spacecraft.getLayoutByName("TLM1_LAYOUT")) != null) {
                TelemTab tlm1Panel = new TelemTab(tlm1Layout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread telem2PanelThread = new Thread(tlm1Panel);
                telem2PanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                telem2PanelThread.setName("TLM1tab");
                telem2PanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>TLM1</body></html>", tlm1Panel);
            }
            if ((tlm2Layout = spacecraftSettings.spacecraft.getLayoutByName("TLM2_LAYOUT")) != null) {
                TelemTab tlm2Panel = new TelemTab(tlm2Layout, spacecraftSettings.spacecraft, spacecraftSettings.db);
                Thread telem2PanelThread = new Thread(tlm2Panel);
                telem2PanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                telem2PanelThread.setName("TLM2tab");
                telem2PanelThread.start();
                this.jtabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>TLM2</body></html>", tlm2Panel);
            }
        }
    }

    void removeTabs() {
        int i2 = 0;
        while (i2 < this.jtabbedPane.getTabCount()) {
            TelemTab tab;
            Component comp = this.jtabbedPane.getComponentAt(i2);
            if (comp instanceof TelemTab && (tab = (TelemTab)comp) != null) {
                tab.stopProcessing();
                this.jtabbedPane.remove(tab);
            }
            ++i2;
        }
        this.jtabbedPane.remove(this.dirAndStatusPanel);
        if (this.spacecraftSettings.getBoolean("supports_file_upload")) {
            this.jtabbedPane.remove(this.outbox);
        }
    }

    void setDirectoryData(String[][] data) {
        this.dirPanel.setDirectoryData(data);
        this.lblDirHoles.setText("DIR: " + this.dirPanel.holes + " holes. Age: " + this.dirPanel.age + " days");
    }

    private JPanel makeSatStatusPanel() {
        JPanel satStatusPanel = new JPanel();
        satStatusPanel.setLayout(new BorderLayout());
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        JPanel centerSat = new JPanel();
        centerSat.setLayout(new BorderLayout());
        centerSat.setBorder(loweredbevel);
        satStatusPanel.add((Component)centerSat, "Center");
        this.lblPBStatus = new JLabel("PB: ?????? ");
        centerSat.add((Component)this.lblPBStatus, "North");
        this.lblPBStatus.setFont(MainWindow.sysFont);
        Font f = this.lblPBStatus.getFont();
        this.lblPBStatus.setFont(f.deriveFont(f.getStyle() ^ 1));
        JPanel pbStatusPanel = new JPanel();
        pbStatusPanel.setLayout(new FlowLayout(0));
        centerSat.add((Component)pbStatusPanel, "South");
        this.lblDirHoles = new JLabel("DIR: ?? Holes");
        this.lblDirHoles.setFont(MainWindow.sysFont);
        this.lblDirHoles.setBorder(new EmptyBorder(2, 10, 2, 10));
        centerSat.add(this.lblDirHoles);
        JLabel bar = new JLabel("|");
        pbStatusPanel.add(bar);
        this.lblDownlinkStatus = new JLabel("Start");
        this.lblDownlinkStatus.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.lblDownlinkStatus.setFont(MainWindow.sysFont);
        pbStatusPanel.add(this.lblDownlinkStatus);
        JLabel bar2 = new JLabel("|");
        pbStatusPanel.add(bar2);
        this.lblEfficiency = new JLabel("Broadcast: 0 / Rec: 0 / Eff: 0%");
        this.lblEfficiency.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.lblEfficiency.setFont(MainWindow.sysFont);
        pbStatusPanel.add(this.lblEfficiency);
        JPanel rightSat = new JPanel();
        rightSat.setLayout(new BorderLayout());
        rightSat.setBorder(loweredbevel);
        satStatusPanel.add((Component)rightSat, "East");
        this.lblPGLogin = new JLabel("Disconnected");
        this.lblPGLogin.setFont(MainWindow.sysFont);
        rightSat.add((Component)this.lblPGLogin, "Center");
        this.lblPGStatus = new JLabel("Open: ??????");
        this.lblPGStatus.setFont(MainWindow.sysFont);
        f = this.lblPGStatus.getFont();
        this.lblPGStatus.setFont(f.deriveFont(f.getStyle() ^ 1));
        rightSat.add((Component)this.lblPGStatus, "North");
        JPanel pgStatusPanel = new JPanel();
        pgStatusPanel.setLayout(new FlowLayout(0));
        rightSat.add((Component)pgStatusPanel, "South");
        this.lblFileUploading = new JLabel("File: None");
        this.lblFileUploading.setFont(MainWindow.sysFont);
        this.setFileUploading(0L, 0L, 0L);
        this.lblFileUploading.setBorder(new EmptyBorder(2, 10, 2, 10));
        pgStatusPanel.add(this.lblFileUploading);
        JLabel bar4 = new JLabel("|");
        pgStatusPanel.add(bar4);
        this.lblUplinkStatus = new JLabel("Init");
        this.lblUplinkStatus.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.lblUplinkStatus.setFont(MainWindow.sysFont);
        pgStatusPanel.add(this.lblUplinkStatus);
        JLabel bar3 = new JLabel("|");
        pgStatusPanel.add(bar3);
        this.lblLayer2Status = new JLabel("LAYER2: UNK");
        this.lblLayer2Status.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.lblLayer2Status.setFont(MainWindow.sysFont);
        pgStatusPanel.add(this.lblLayer2Status);
        return satStatusPanel;
    }

    private JPanel makeFilePanel() {
        JPanel centerTopPanel = new JPanel();
        this.filePanel = new JPanel();
        this.filePanel.setVisible(false);
        centerTopPanel.add(this.filePanel);
        this.lblFileName = new JLabel();
        this.filePanel.add(this.lblFileName);
        return centerTopPanel;
    }

    public void setFileUploading(long id, long offset, long length) {
        String p = "0";
        if (length != 0L) {
            p = String.format("%.1f", Float.valueOf((float)(100L * offset) / (float)length));
        }
        this.lblFileUploading.setText("File: " + Long.toHexString(id) + " " + p + "%");
        if (id == 0L) {
            this.lblFileUploading.setForeground(Color.BLACK);
        } else if (offset == length) {
            this.lblFileUploading.setForeground(Color.BLUE);
        } else {
            this.lblFileUploading.setForeground(Config.AMSAT_RED);
        }
    }

    public void setPBStatus(String pb) {
        this.lblPBStatus.setText("fred " + pb);
    }

    public void setPGStatus(String pg) {
        this.lblPGStatus.setText(pg);
    }

    public void setLoggedIn(String pg) {
        this.lblPGLogin.setText(pg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butNew) {
            if (!this.spacecraftSettings.getBoolean("supports_file_upload")) {
                return;
            }
            if (Config.get("callsign").equalsIgnoreCase("NONE")) {
                Log.errorDialog("ERROR", "You need to set the callsign before you can compose a message\nGo to the File > Settings screen\n");
                return;
            }
            MainWindow.newMessage(this.spacecraftSettings);
        }
        if (e.getSource() == this.butDirReq) {
            if (Config.get("callsign").equalsIgnoreCase("NONE")) {
                Log.errorDialog("ERROR", "You need to set the callsign transmitting\nGo to the File > Settings screen\n");
                return;
            }
            if (!Config.getBoolean("tx_inhibit")) {
                if (this.spacecraftSettings == null) {
                    return;
                }
                RequestDirFrame dirFrame = null;
                SortedArrayList<DirHole> holes = this.spacecraftSettings.directory.getHolesList();
                if (holes != null) {
                    dirFrame = new RequestDirFrame(Config.get("callsign"), this.spacecraftSettings.get("broadcastCallsign"), true, holes);
                } else {
                    Log.errorDialog("ERROR", "Something has gone wrong and the directory holes file is missing or corrupt\nCan't request the directory\n");
                }
                this.spacecraftSettings.downlink.processEvent(dirFrame);
            } else {
                Log.errorDialog("Transmitted Disabled", "Directory can't be requested when the transmitter is inhibitted\nDisable 'Inhibit Tranmitter' on the settings tab");
            }
        }
        if (e.getSource() == this.butFileReq) {
            if (Config.get("callsign").equalsIgnoreCase("NONE")) {
                Log.errorDialog("ERROR", "You need to set the callsign transmitting\nGo to the File > Settings screen\n");
                return;
            }
            if (!Config.getBoolean("tx_inhibit")) {
                if (this.spacecraftSettings == null) {
                    return;
                }
                String fileIdstr = this.txtFileId.getText();
                if (fileIdstr == null || fileIdstr.length() == 0 || fileIdstr.length() > 4) {
                    Log.errorDialog("File Request Error", "File Id should be 1-4 digits in HEX.  Invalid: " + fileIdstr);
                } else {
                    try {
                        long fileId = Long.decode("0x" + fileIdstr);
                        PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.spacecraftSettings.directory.dirFolder, fileId);
                        SortedArrayList<FileHole> holes = psf.getHolesList();
                        RequestFileFrame fileFrame = new RequestFileFrame(Config.get("callsign"), this.spacecraftSettings.get("broadcastCallsign"), true, fileId, holes);
                        this.spacecraftSettings.downlink.processEvent(fileFrame);
                    }
                    catch (NumberFormatException ne) {
                        Log.errorDialog("File Request Error", "File Id should be 1-4 digits in HEX. Invalid: " + fileIdstr);
                    }
                }
            } else {
                Log.errorDialog("Transmitted Disabled", "File Id can't be requested when the transmitter is inhibitted\nDisable 'Inhibit Tranmitter' on the settings tab");
            }
        }
        if (e.getSource() == this.butFilter) {
            this.spacecraftSettings.set("show_user_files", !this.spacecraftSettings.getBoolean("show_user_files"));
            if (this.spacecraftSettings.getBoolean("show_user_files")) {
                this.butFilter.setText(SHOW_USER_LBL);
            } else {
                this.butFilter.setText(SHOW_ALL_LBL);
            }
            Log.println("SHOW: " + this.spacecraftSettings.getBoolean("show_user_files"));
            this.spacecraftSettings.directory.setShowFiles(this.spacecraftSettings.getBoolean("show_user_files"));
            this.setDirectoryData(this.spacecraftSettings.directory.getTableData());
            this.spacecraftSettings.save();
        }
        if (e.getSource() == this.butCmd && this.spacecraftSettings.getBoolean("is_command_station")) {
            if (this.commanding == null) {
                this.commanding = new CommandFrame(this.spacecraftSettings);
            } else {
                this.commanding.setVisible(true);
            }
        }
        if (e.getSource() == this.cbUplink) {
            if (this.cbUplink.isSelected()) {
                Config.set("uplink_enabled", true);
            } else {
                Config.set("uplink_enabled", false);
            }
        }
        if (e.getSource() == this.cbDownlink) {
            if (this.cbDownlink.isSelected()) {
                Config.set("downlink_enabled", true);
            } else {
                Config.set("downlink_enabled", false);
            }
        }
    }
}

