/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import gui.EditorFrame;
import gui.MainWindow;
import gui.SpacecraftTab;
import gui.TablePanel;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class OutboxPanel
extends TablePanel {
    OutboxPanel(SpacecraftSettings spacecraftSettings, SpacecraftTab spacecraftTab) {
        super(spacecraftSettings, spacecraftTab);
        TableColumnModel tcm = this.directoryTable.getColumnModel();
        tcm.removeColumn(tcm.getColumn(7));
    }

    @Override
    public void deleteRow(JTable table, int row) {
        Object[] options;
        int n;
        int column = 10;
        if (Config.getBoolean("SHOW_DIR_TIMES")) {
            column = 12;
        }
        String filename = (String)table.getValueAt(row, column);
        File f = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + filename);
        if (f.exists() && (n = JOptionPane.showOptionDialog(MainWindow.frame, "Do you want to delete this outbox file?", "Delete File?", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) != 1) {
            try {
                this.spacecraftSettings.outbox.delete(f);
                this.setDirectoryData(this.spacecraftSettings.outbox.getTableData());
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not remove file: " + f.getPath());
            }
        }
    }

    @Override
    public void setPriority(JTable table, int row, long id, int pri) {
    }

    @Override
    protected void displayRow(JTable table, int row) {
        PacSatFile psf;
        int column = 10;
        if (Config.getBoolean("SHOW_DIR_TIMES")) {
            column = 12;
        }
        String filename = (String)table.getValueAt(row, column);
        File f = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + filename);
        try {
            psf = new PacSatFile(this.spacecraftSettings, String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + filename);
        }
        catch (MalformedPfhException e1) {
            Log.errorDialog("ERROR", "Could not open message " + e1.getMessage());
            e1.printStackTrace(Log.getWriter());
            return;
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Could not open message " + e1.getMessage());
            e1.printStackTrace(Log.getWriter());
            return;
        }
        if (f.exists()) {
            EditorFrame editor = null;
            try {
                editor = new EditorFrame(this.spacecraftSettings, psf, true);
                editor.setVisible(true);
                this.setDirectoryData(this.spacecraftSettings.outbox.getTableData());
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not open file: " + f + "\n" + e.getMessage());
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open file.  Pacsat File Header Corrupt: " + f + "\n" + e.getMessage());
            }
        }
    }
}

