/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    protected BufferedImage image;
    boolean allowStretching = false;

    public ImagePanel() {
    }

    public ImagePanel(String filePath) {
        this.setImage(filePath);
    }

    public void setImage(String filePath) {
        try {
            this.image = ImageIO.read(new File(filePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
        this.repaint();
    }

    public void setBufferedImage(byte[] b) {
        this.image = this.createImageFromBytes(b);
        this.repaint();
    }

    public void allowStretching(boolean stretch) {
        this.allowStretching = stretch;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            BufferedImage display = this.image;
            if (this.allowStretching || this.getHeight() < this.image.getHeight() || this.getWidth() < this.image.getWidth()) {
                double ratio = (double)this.getHeight() / (double)this.image.getHeight();
                if ((double)this.image.getWidth() * ratio > (double)this.getWidth()) {
                    ratio = (double)this.getWidth() / (double)this.image.getWidth();
                }
                display = ImagePanel.scale(this.image, ratio);
            }
            g.drawImage(display, 0, 0, null);
        }
    }

    private BufferedImage createImageFromBytes(byte[] imageData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        try {
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage scale(BufferedImage source, double ratio) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        BufferedImage bi = ImagePanel.getCompatibleImage(w, h);
        Graphics2D g2d = bi.createGraphics();
        double xScale = (double)w / (double)source.getWidth();
        double yScale = (double)h / (double)source.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g2d.drawRenderedImage(source, at);
        g2d.dispose();
        return bi;
    }

    private static BufferedImage getCompatibleImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        return image;
    }
}

