/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import fileStore.XcamImg;
import fileStore.ZipFile;
import fileStore.telem.LogFileAL;
import fileStore.telem.LogFileLog;
import fileStore.telem.LogFileTlm;
import fileStore.telem.LogFileWE;
import gui.ImagePanel;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EditorFrame
extends JFrame
implements Runnable,
ActionListener,
WindowListener {
    int type = 0;
    int compressionType = 0;
    boolean running = true;
    public static final String TEXT_CARD = "text";
    public static final String IMAGE_CARD = "image";
    public static final int UNCOMPRESSED_CHAR_LIMIT = 200;
    public static final String OUT = "out";
    public static final String ERR = "err";
    public static final String UL = "ul";
    public static final String DRAFT = "outtmp";
    private JTextArea ta;
    private JMenuBar menuBar;
    private JMenu fileM;
    private JMenu editM;
    private JScrollPane scpane;
    private JMenuItem cancelI;
    private JMenuItem cutI;
    private JMenuItem copyI;
    private JMenuItem pasteI;
    private JMenuItem selectI;
    private JMenuItem saveAndExitI;
    private JMenuItem exportI;
    private JMenuItem loadI;
    private JMenuItem statusI;
    private String pad;
    private JToolBar toolBar;
    private String filename;
    private boolean buildingGui = true;
    JTextField txtTo;
    JTextField txtFrom;
    JTextField txtDate;
    JTextField txtTitle;
    JTextField txtUserFilename;
    JTextField txtKeywords;
    JButton butReply;
    JButton butReplyInclude;
    JButton butExport;
    JButton butCancel;
    JButton butSaveDraft;
    JButton butSaveAndExit;
    JCheckBox cbZipped;
    JLabel lblCrDate;
    JComboBox<String> cbType;
    JPanel centerpane;
    JSplitPane editPanes;
    JPanel textPane;
    ImagePanel imagePanel;
    byte[] pacsatFileBytes;
    long lastModified = 0L;
    SpacecraftSettings spacecraftSettings;
    private PacSatFile psf;
    private PacSatFileHeader pfh;
    private boolean editable = true;
    public static final boolean READ_ONLY = false;
    public static final boolean EDITABLE = true;
    public static final String RE = "Re: ";
    public static final String EDIT_WINDOW_X = "edit_window_x";
    public static final String EDIT_WINDOW_Y = "edit_window_y";
    public static final String EDIT_WINDOW_WIDTH = "edit_window_width";
    public static final String EDIT_WINDOW_HEIGHT = "edit_window_height";
    public static final int IMAGE_SIZE_LIMIT = 250000;

    public EditorFrame(SpacecraftSettings spacecraftSettings) {
        super("New Message");
        this.spacecraftSettings = spacecraftSettings;
        this.editable = true;
        this.makeFrame(this.editable);
        this.exportI.setEnabled(false);
        this.butExport.setEnabled(false);
        this.butSaveAndExit.setEnabled(false);
        this.butSaveDraft.setEnabled(false);
        this.saveAndExitI.setEnabled(false);
        this.butReply.setVisible(false);
        this.butReplyInclude.setVisible(false);
        this.loadI = new JMenuItem("Load");
        this.txtFrom.setText(Config.get("callsign"));
        this.addTextArea();
        this.addImageArea();
        this.scpane.setVisible(true);
        this.ta.append(".... select document type to edit");
        this.ta.setVisible(true);
        this.ta.setEditable(false);
        this.buildingGui = false;
    }

    public EditorFrame(SpacecraftSettings spacecraftSettings, String toCallsign, String fromCallsign, String title, String keywords, String origText) {
        super("Message Editor");
        this.spacecraftSettings = spacecraftSettings;
        this.editable = true;
        this.makeFrame(this.editable);
        this.butReply.setVisible(false);
        this.butReplyInclude.setVisible(false);
        this.txtFrom.setText(Config.get("callsign"));
        this.txtTo.setText(toCallsign.toUpperCase());
        this.txtTitle.setText(title);
        this.txtKeywords.setText(keywords);
        if (this.filename == null) {
            this.filename = String.valueOf(Config.get("callsign")) + spacecraftSettings.getNextSequenceNum() + ".txt";
            this.txtUserFilename.setText(this.filename);
        }
        this.cbType.setSelectedIndex(PacSatFileHeader.getTypeIndexByString("ASCII"));
        this.addImageArea();
        this.addTextArea();
        this.ta.append(origText);
        this.ta.setCaretPosition(0);
        this.buildingGui = false;
    }

    public EditorFrame(SpacecraftSettings spacecraftSettings, PacSatFile file, boolean edit) throws IOException, MalformedPfhException {
        super("Message Editor");
        Object we;
        this.spacecraftSettings = spacecraftSettings;
        this.psf = file;
        byte[] bytes = this.psf.getBytes();
        this.editable = edit;
        this.makeFrame(this.editable);
        if (!this.editable) {
            this.saveAndExitI.setVisible(false);
            this.butSaveAndExit.setVisible(false);
            this.butSaveDraft.setVisible(false);
        } else {
            this.butReply.setVisible(false);
            this.butReplyInclude.setVisible(false);
        }
        this.pfh = this.psf.loadPfh();
        File file_on_disk = new File(this.psf.getFileName());
        this.filename = file_on_disk.getName();
        String userFilename = this.pfh.getFieldString(38);
        this.txtUserFilename.setText(userFilename);
        this.txtTo.setText(this.pfh.getFieldString(20).toUpperCase());
        this.txtFrom.setText(this.pfh.getFieldString(16).toUpperCase());
        this.txtTitle.setText(this.pfh.getFieldString(34));
        this.txtKeywords.setText(this.pfh.getFieldString(35));
        String dates = "Created: " + this.pfh.getDateString(5) + "   Mod: " + this.pfh.getDateString(6) + "   Upl: " + this.pfh.getDateString(18) + "   Exp: " + this.pfh.getDateString(23);
        this.lblCrDate.setText(dates);
        int compressedBy = 0;
        this.cbZipped.setSelected(false);
        PacSatField compressionType = this.pfh.getFieldById(25);
        if (compressionType != null && (compressedBy = (int)this.pfh.getFieldById(25).getLongValue()) > 0) {
            this.cbZipped.setSelected(true);
        }
        this.type = this.pfh.getType();
        this.addImageArea();
        this.addTextArea();
        String ty = this.pfh.getTypeString();
        int j = 0;
        if (compressedBy == 2) {
            File destDir = this.psf.decompress(spacecraftSettings.directory.dirFolder);
            if (destDir != null) {
                File[] files = destDir.listFiles();
                boolean i2 = false;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    String[] fileParts = f.getName().split("\\.");
                    String ext = fileParts[fileParts.length - 1];
                    try {
                        bytes = Files.readAllBytes(Paths.get(f.getPath(), new String[0]));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    f.delete();
                    ++n2;
                }
                destDir.delete();
            } else {
                this.ta.append("Compressed Archive appears to be empty, or there was an error extracting the data..");
            }
        }
        j = this.editable ? PacSatFileHeader.getUserTypeIndexByString(ty) : PacSatFileHeader.getTypeIndexByString(ty);
        this.cbType.setSelectedIndex(j);
        if (ty.equalsIgnoreCase("JPG") || ty.equalsIgnoreCase("GIF") || ty.equalsIgnoreCase("PNG")) {
            try {
                this.pacsatFileBytes = bytes;
                this.imagePanel.setBufferedImage(this.pacsatFileBytes);
                this.editPanes.setDividerLocation(0);
                this.textPane.setVisible(false);
                this.imagePanel.setVisible(true);
                this.cbZipped.setEnabled(false);
            }
            catch (Exception e) {
                Log.errorDialog("Can't Parse Image Data", "The image could not be loaded into the editor.");
            }
        } else if (ty.equalsIgnoreCase("Image")) {
            Thread thread = new Thread(this);
            thread.start();
        } else if (this.type == 12) {
            this.pacsatFileBytes = bytes;
            this.ta.append(new String(bytes));
        } else if (this.type == 203 || this.type == 240) {
            this.ta.append("Whole Orbit Data File.. Binary Data\n");
            we = null;
            try {
                we = new LogFileTlm(this.pfh.getFieldString(20).toUpperCase(), spacecraftSettings, this.psf.getData(bytes));
                this.ta.append(((LogFileTlm)we).toString());
                this.ta.setCaretPosition(0);
                if (((LogFileTlm)we).records != null) {
                    for (DataRecord d : ((LogFileTlm)we).records) {
                        try {
                            spacecraftSettings.db.add(d);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (IOException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (DataLoadException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                    }
                }
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException e) {
            }
            catch (NullPointerException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
        } else if (this.type == 3) {
            we = null;
            try {
                we = new LogFileWE(spacecraftSettings, this.psf.getData(bytes));
                this.ta.append(((LogFileWE)we).toString());
                this.ta.setCaretPosition(0);
                if (((LogFileWE)we).records != null) {
                    for (DataRecord d : ((LogFileWE)we).records) {
                        try {
                            spacecraftSettings.db.add(d);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (IOException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (DataLoadException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                    }
                }
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (NullPointerException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
        } else if (this.type == 201) {
            we = null;
            try {
                we = new LogFileAL(spacecraftSettings, this.psf.getData(bytes));
                this.ta.append(((LogFileAL)we).toString());
                this.ta.setCaretPosition(0);
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
        } else if (this.type == 223) {
            we = null;
            try {
                we = new LogFileLog(spacecraftSettings, this.psf.getData(bytes));
                this.ta.append(((LogFileLog)we).toString());
                this.ta.setCaretPosition(0);
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR", "Could not open log file:" + e.getMessage());
            }
        } else {
            this.ta.append(new String(bytes));
            this.ta.setCaretPosition(0);
        }
        if (spacecraftSettings.getBoolean("psf_header_check_sums")) {
            short check = this.pfh.headerChecksumValid();
            if (check != 0) {
                short headerChecksum_in_pfh = (short)this.pfh.getFieldById(10).getLongValue();
                Log.errorDialog("Error in header checksum", "In header checksum is: " + Integer.toHexString(headerChecksum_in_pfh) + " but actual calculated as: " + Integer.toHexString(check));
            }
            short bodyChecksum_in_pfh = (short)this.pfh.getFieldById(9).getLongValue();
            int bodySize = 0;
            short bodyChecksum = 0;
            bodySize = bytes.length;
            bodyChecksum = PacSatFileHeader.checksum(bytes);
            if (bodyChecksum_in_pfh != bodyChecksum) {
                Log.errorDialog("Error in body checksum", "In header body checksum is: " + Integer.toHexString(bodyChecksum_in_pfh) + " but actual calculated as: " + Integer.toHexString(bodyChecksum) + "\n" + "If you are editing this file then you need to resave it to recalculate the checksum.");
            }
        }
        this.buildingGui = false;
    }

    private void refreshImage() {
        byte[] bytes = this.psf.getBytes();
        if (this.psf.lastModified() > this.lastModified) {
            this.pacsatFileBytes = bytes;
            XcamImg img = new XcamImg(bytes);
            this.imagePanel.allowStretching(true);
            BufferedImage i2 = img.getRotatedImage();
            this.imagePanel.setBufferedImage(i2);
            this.editPanes.setDividerLocation(0);
            this.textPane.setVisible(false);
            this.imagePanel.setVisible(true);
            this.cbZipped.setEnabled(false);
        }
    }

    private void addTextArea() {
        this.ta = new JTextArea();
        this.scpane = new JScrollPane(this.ta);
        this.ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.setEditable(this.editable);
        this.ta.setVisible(true);
        this.ta.setFont(new Font("SansSerif", 0, Config.getInt("font_size")));
        this.textPane.add((Component)this.scpane, "Center");
    }

    private void addImageArea() {
    }

    private void makeFrame(boolean edit) {
        this.addWindowListener(this);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/pacsat.jpg")));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.pad = " ";
        this.menuBar = new JMenuBar();
        this.menuBar.setFont(MainWindow.sysFont);
        this.fileM = new JMenu("File");
        this.fileM.setFont(MainWindow.sysFont);
        this.editM = new JMenu("Edit");
        this.editM.setFont(MainWindow.sysFont);
        this.cancelI = new JMenuItem("Exit");
        this.cancelI.setFont(MainWindow.sysFont);
        this.cutI = new JMenuItem("Cut");
        this.cutI.setFont(MainWindow.sysFont);
        this.copyI = new JMenuItem("Copy");
        this.copyI.setFont(MainWindow.sysFont);
        this.pasteI = new JMenuItem("Paste");
        this.pasteI.setFont(MainWindow.sysFont);
        this.selectI = new JMenuItem("Select All");
        this.selectI.setFont(MainWindow.sysFont);
        this.exportI = new JMenuItem("Export");
        this.exportI.setFont(MainWindow.sysFont);
        this.saveAndExitI = new JMenuItem("Send");
        this.saveAndExitI.setFont(MainWindow.sysFont);
        this.statusI = new JMenuItem("Status");
        this.statusI.setFont(MainWindow.sysFont);
        this.toolBar = new JToolBar();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileM);
        this.menuBar.add(this.editM);
        this.fileM.add(this.exportI);
        this.fileM.add(this.saveAndExitI);
        this.fileM.add(this.cancelI);
        this.editM.add(this.cutI);
        this.editM.add(this.copyI);
        this.editM.add(this.pasteI);
        this.editM.add(this.selectI);
        this.saveAndExitI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.cutI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyI.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteI.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.selectI.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.dispose();
            }
        });
        this.centerpane = new JPanel();
        pane.add((Component)this.centerpane, "Center");
        this.centerpane.setLayout(new BorderLayout());
        this.editPanes = new JSplitPane(0);
        this.centerpane.add((Component)this.editPanes, "Center");
        this.textPane = new JPanel();
        this.textPane.setLayout(new BorderLayout());
        this.editPanes.setTopComponent(this.textPane);
        this.imagePanel = new ImagePanel();
        this.editPanes.setBottomComponent(this.imagePanel);
        this.editPanes.setDividerLocation(2000);
        this.textPane.setVisible(true);
        this.imagePanel.setVisible(false);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.centerpane.add((Component)topPanel, "North");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(0));
        topPanel.add((Component)buttonBar, "North");
        this.butReply = new JButton("Reply");
        this.butReply.setMargin(new Insets(0, 0, 0, 0));
        this.butReply.addActionListener(this);
        this.butReply.setToolTipText("Reply to this message");
        this.butReply.setFont(MainWindow.sysFont);
        if (this.editable) {
            this.butReply.setEnabled(false);
        }
        buttonBar.add(this.butReply);
        this.butReplyInclude = new JButton("Reply Inc");
        this.butReplyInclude.setMargin(new Insets(0, 0, 0, 0));
        this.butReplyInclude.addActionListener(this);
        this.butReplyInclude.setToolTipText("Reply to this message and include the original text");
        this.butReplyInclude.setFont(MainWindow.sysFont);
        if (this.editable) {
            this.butReplyInclude.setEnabled(false);
        }
        buttonBar.add(this.butReplyInclude);
        this.butExport = new JButton("Export");
        this.butExport.setMargin(new Insets(0, 0, 0, 0));
        this.butExport.addActionListener(this);
        this.butExport.setToolTipText("Save this message to a file");
        this.butExport.setFont(MainWindow.sysFont);
        buttonBar.add(this.butExport);
        this.butSaveDraft = new JButton("Save Draft");
        this.butSaveDraft.setMargin(new Insets(0, 0, 0, 0));
        this.butSaveDraft.addActionListener(this);
        this.butSaveDraft.setToolTipText("Save draft and continue editing this message");
        this.butSaveDraft.setFont(MainWindow.sysFont);
        buttonBar.add(this.butSaveDraft);
        this.butSaveAndExit = new JButton("Send");
        this.butSaveAndExit.setMargin(new Insets(0, 0, 0, 0));
        this.butSaveAndExit.addActionListener(this);
        this.butSaveAndExit.setToolTipText("Save and send this message");
        this.butSaveAndExit.setFont(MainWindow.sysFont);
        buttonBar.add(this.butSaveAndExit);
        this.butCancel = new JButton("Exit");
        this.butCancel.setMargin(new Insets(0, 0, 0, 0));
        this.butCancel.addActionListener(this);
        this.butCancel.setToolTipText("Cancel and exit this message");
        this.butCancel.setFont(MainWindow.sysFont);
        buttonBar.add(this.butCancel);
        JPanel header = new JPanel();
        header.setLayout(new BorderLayout());
        header.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)header, "South");
        JPanel headerFields = new JPanel();
        header.add((Component)headerFields, "Center");
        JPanel header1 = new JPanel();
        JPanel header2 = new JPanel();
        JPanel header3 = new JPanel();
        JPanel header4 = new JPanel();
        headerFields.setLayout(new BoxLayout(headerFields, 1));
        headerFields.add(header1);
        headerFields.add(header2);
        headerFields.add(header3);
        headerFields.add(header4);
        header1.setLayout(new BoxLayout(header1, 0));
        header2.setLayout(new BoxLayout(header2, 0));
        header3.setLayout(new BoxLayout(header3, 0));
        header4.setLayout(new FlowLayout(0));
        header1.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        header2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        header3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        header4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel lblTo = new JLabel("To:    ");
        lblTo.setFont(MainWindow.sysFont);
        this.txtTo = new JTextField();
        this.txtTo.setColumns(20);
        this.txtTo.setEditable(edit);
        this.txtTo.setFont(MainWindow.sysFont);
        header1.add(lblTo);
        header1.add(new Box.Filler(new Dimension(10, 10), new Dimension(23, 20), new Dimension(23, 20)));
        header1.add(this.txtTo);
        header1.add(new Box.Filler(new Dimension(10, 10), new Dimension(200, 20), new Dimension(1000, 20)));
        this.cbZipped = new JCheckBox("Compressed  ");
        this.cbZipped.setFont(MainWindow.sysFont);
        header1.add(this.cbZipped);
        this.cbZipped.setEnabled(edit);
        this.cbZipped.setSelected(true);
        this.cbZipped.addActionListener(this);
        this.cbType = this.editable ? new JComboBox<String>(PacSatFileHeader.userTypeStrings) : new JComboBox<String>(PacSatFileHeader.typeStrings);
        this.cbType.setEnabled(edit);
        this.cbType.addActionListener(this);
        this.cbType.setFont(MainWindow.sysFont);
        header1.add(this.cbType);
        JLabel lblFrom = new JLabel("From: ");
        lblFrom.setFont(MainWindow.sysFont);
        this.txtFrom = new JTextField();
        this.txtFrom.setColumns(20);
        this.txtFrom.setEditable(edit);
        this.txtFrom.setFont(MainWindow.sysFont);
        header2.add(lblFrom);
        header2.add(new Box.Filler(new Dimension(10, 10), new Dimension(20, 20), new Dimension(30, 20)));
        header2.add(this.txtFrom);
        header2.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 20), new Dimension(23, 20)));
        JLabel lblKeywords = new JLabel("Folders: ");
        lblKeywords.setFont(MainWindow.sysFont);
        this.txtKeywords = new JTextField();
        this.txtKeywords.setColumns(30);
        this.txtKeywords.setEditable(edit);
        this.txtKeywords.setFont(MainWindow.sysFont);
        header2.add(lblKeywords);
        header2.add(new Box.Filler(new Dimension(10, 10), new Dimension(24, 20), new Dimension(23, 20)));
        header2.add(this.txtKeywords);
        JLabel lblTitle = new JLabel("Title: ");
        lblTitle.setFont(MainWindow.sysFont);
        this.txtTitle = new JTextField();
        this.txtTitle.setColumns(80);
        this.txtTitle.setEditable(edit);
        this.txtTitle.setFont(MainWindow.sysFont);
        header3.add(lblTitle);
        header3.add(new Box.Filler(new Dimension(10, 10), new Dimension(24, 20), new Dimension(23, 20)));
        header3.add(this.txtTitle);
        JLabel lblUserFilename = new JLabel("User File: ");
        lblTitle.setFont(MainWindow.sysFont);
        this.txtUserFilename = new JTextField();
        this.txtUserFilename.setColumns(40);
        this.txtUserFilename.setEditable(edit);
        this.txtUserFilename.setFont(MainWindow.sysFont);
        header3.add(lblUserFilename);
        header3.add(new Box.Filler(new Dimension(10, 10), new Dimension(24, 20), new Dimension(23, 20)));
        header3.add(this.txtUserFilename);
        this.lblCrDate = new JLabel();
        header4.add((Component)this.lblCrDate, "North");
        pane.add((Component)this.toolBar, "South");
        this.exportI.addActionListener(this);
        this.saveAndExitI.addActionListener(this);
        this.cancelI.addActionListener(this);
        this.cutI.addActionListener(this);
        this.copyI.addActionListener(this);
        this.pasteI.addActionListener(this);
        this.selectI.addActionListener(this);
        this.statusI.addActionListener(this);
        if (!this.spacecraftSettings.getBoolean("supports_file_upload")) {
            this.butReply.setEnabled(false);
            this.butReplyInclude.setEnabled(false);
        }
        this.setVisible(true);
    }

    private void reply(boolean include) {
        String title;
        EditorFrame editor = null;
        String origText = "";
        if (include) {
            Pattern pattern = Pattern.compile("(^.*)", 8);
            Matcher matcher = pattern.matcher(this.ta.getText());
            String text = matcher.replaceAll("> $1");
            origText = "\r\n\r\nPreviously on PacSat, " + this.txtFrom.getText() + " said:\r\n" + text;
        }
        if (!(title = this.txtTitle.getText()).startsWith(RE)) {
            title = RE + title;
        }
        editor = new EditorFrame(this.spacecraftSettings, this.txtFrom.getText(), this.txtFrom.getText(), title, this.txtKeywords.getText(), origText);
        editor.setVisible(true);
        editor.setBounds(this.getX() + 30, this.getY() + 30, this.getWidth(), this.getHeight());
        if (include) {
            this.dispose();
        }
    }

    private void savePacsatFile(int state) {
        File draft;
        String existingFilename = this.filename;
        byte[] bytes = null;
        String ext = ".txt";
        if (this.type == 0) {
            String txt = this.ta.getText();
            String newTxt = "";
            int prevChar = 0;
            int i2 = 0;
            while (i2 < txt.length()) {
                char ch = txt.charAt(i2);
                newTxt = ch == '\n' && prevChar != 13 ? String.valueOf(newTxt) + "\r\n" : String.valueOf(newTxt) + ch;
                prevChar = ch;
                ++i2;
            }
            bytes = newTxt.getBytes();
        } else if (this.type == 12) {
            bytes = this.pacsatFileBytes;
        } else {
            bytes = this.pacsatFileBytes;
            ext = ".jpg";
            if (this.pfh != null) {
                String ty = this.pfh.getTypeString();
                if (ty.equalsIgnoreCase("GIF")) {
                    ext = ".gif";
                }
                if (ty.equalsIgnoreCase("PNG")) {
                    ext = ".png";
                }
            }
        }
        if (this.cbZipped.isSelected()) {
            try {
                this.filename = this.filename.replaceAll("\\..*$", ext);
                bytes = ZipFile.zipBytes(this.txtUserFilename.getText(), bytes);
                this.compressionType = 2;
                this.filename = this.filename.replaceAll("\\..*$", ".zip");
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not compress the file\n" + e);
            }
        } else {
            this.filename = this.filename.replaceAll("\\..*$", ext);
        }
        int bodySize = 0;
        short bodyChecksum = 0;
        bodySize = bytes.length;
        bodyChecksum = PacSatFileHeader.checksum(bytes);
        PacSatFileHeader pfh = new PacSatFileHeader(this.txtFrom.getText().toUpperCase(), this.txtTo.getText().toUpperCase(), bodySize, bodyChecksum, this.type, this.compressionType, this.txtTitle.getText(), this.txtKeywords.getText(), this.txtUserFilename.getText());
        pfh.setState(state);
        File que = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + existingFilename + "." + OUT);
        if (que.exists()) {
            que.delete();
        }
        if ((draft = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + existingFilename + "." + DRAFT)).exists()) {
            draft.delete();
        }
        String state_ext = OUT;
        if (state == 8) {
            state_ext = DRAFT;
        }
        this.psf = new PacSatFile(this.spacecraftSettings, String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + this.filename + "." + state_ext, pfh, bytes);
        this.psf.save();
        if (Config.mainWindow != null) {
            MainWindow.setOutboxData(this.spacecraftSettings.name, this.spacecraftSettings.outbox.getTableData());
        }
    }

    private File pickFile(String title, String buttonText, int type, String defaultName) {
        File file = null;
        File dir = null;
        String d = Config.get("editor_current_dir");
        if (d == null) {
            dir = new File(".");
        } else if (d != "") {
            dir = new File(Config.get("editor_current_dir"));
        }
        if (Config.getBoolean("use_native_file_chooser")) {
            FileDialog fd = new FileDialog((Frame)this, title, type);
            if (dir != null) {
                fd.setDirectory(dir.getAbsolutePath());
            }
            if (defaultName != null) {
                fd.setFile(defaultName);
            }
            fd.setVisible(true);
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            if (filename != null) {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setApproveButtonText(buttonText);
            if (defaultName != null) {
                fc.setSelectedFile(new File(defaultName));
            }
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            if (dir != null) {
                fc.setCurrentDirectory(dir);
            }
            int returnVal = fc.showOpenDialog(this);
            Config.set("mainwindow_height", fc.getHeight());
            Config.set("mainwindow_width", fc.getWidth());
            if (returnVal == 0) {
                file = fc.getSelectedFile();
            }
        }
        if (file != null) {
            Config.set("editor_current_dir", file.getParent());
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportFileToDisk() throws IOException {
        File defaultFile;
        if (this.psf == null) {
            this.savePacsatFile(8);
        }
        if ((defaultFile = this.psf.extractUserFile(this.spacecraftSettings.directory.dirFolder)) == null) {
            defaultFile = this.psf.extractSystemFile(this.spacecraftSettings.directory.dirFolder);
        }
        if (defaultFile == null) {
            defaultFile = new File("pacsatfile");
        }
        File file = null;
        file = this.pickFile("Save As", "Save", 1, defaultFile.getName());
        if (file == null) return;
        try (RandomAccessFile saveFile = null;){
            try {
                saveFile = new RandomAccessFile(file, "rw");
                saveFile.write(this.psf.getBytes());
                return;
            }
            catch (FileNotFoundException e) {
                Log.errorDialog("ERROR", "Error with file name: " + file.getAbsolutePath() + "\n" + e.getMessage());
                if (saveFile == null) return;
                saveFile.close();
                return;
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Error writing file: " + file.getAbsolutePath() + "\n" + e.getMessage());
                if (saveFile == null) return;
                saveFile.close();
                return;
            }
        }
    }

    private void processTypeSelection(String ty) {
        this.type = PacSatFileHeader.getTypeIdByString(ty);
        if (ty.equalsIgnoreCase("JPG") || ty.equalsIgnoreCase("GIF") || ty.equalsIgnoreCase("PNG")) {
            if (this.editable) {
                String ext = ".jpg";
                if (ty.equalsIgnoreCase("GIF")) {
                    ext = ".gif";
                }
                if (ty.equalsIgnoreCase("PNG")) {
                    ext = ".png";
                }
                if (this.filename == null) {
                    this.filename = String.valueOf(Config.get("callsign")) + this.spacecraftSettings.getNextSequenceNum() + ext;
                }
                File file = null;
                file = this.pickFile("Open Image", "Open", 0, null);
                if (file != null) {
                    Config.set("editor_current_dir", file.getParent());
                    try {
                        RandomAccessFile loadImage = new RandomAccessFile(file, "r");
                        if (loadImage.length() > 250000L) {
                            Log.errorDialog("ERROR - TOO LARGE", "You can't create a pacsat file with a " + loadImage.length() + " byte image.\n" + "Maximum image size is: " + 250000);
                            this.cbType.setSelectedIndex(0);
                            loadImage.close();
                            return;
                        }
                        this.pacsatFileBytes = new byte[(int)loadImage.length()];
                        int i2 = 0;
                        while ((long)i2 < loadImage.length()) {
                            this.pacsatFileBytes[i2] = loadImage.readByte();
                            ++i2;
                        }
                        this.imagePanel.setBufferedImage(this.pacsatFileBytes);
                        this.editPanes.setDividerLocation(0);
                        this.textPane.setVisible(false);
                        this.imagePanel.setVisible(true);
                        this.exportI.setEnabled(true);
                        this.butExport.setEnabled(true);
                        this.butSaveAndExit.setEnabled(true);
                        this.butSaveDraft.setEnabled(true);
                        this.saveAndExitI.setEnabled(true);
                        this.cbZipped.setSelected(false);
                        this.cbZipped.setEnabled(false);
                        this.txtUserFilename.setText(file.getName());
                        loadImage.close();
                    }
                    catch (FileNotFoundException e) {
                        Log.errorDialog("ERROR", "Error with file name: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR", "Error writing file: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    }
                }
            }
        } else if (ty.equalsIgnoreCase("ASCII")) {
            if (this.filename == null) {
                this.filename = String.valueOf(Config.get("callsign")) + this.spacecraftSettings.getNextSequenceNum() + ".txt";
                this.txtUserFilename.setText(this.filename);
            }
            if (this.ta != null) {
                this.ta.setEditable(true);
                this.ta.setText("");
                this.butSaveAndExit.setEnabled(true);
                this.butSaveDraft.setEnabled(true);
                this.saveAndExitI.setEnabled(true);
                this.exportI.setEnabled(true);
                this.butExport.setEnabled(true);
                this.cbZipped.setEnabled(true);
                this.editPanes.setDividerLocation(2000);
                this.textPane.setVisible(true);
                this.imagePanel.setVisible(false);
            }
        } else if (ty.equalsIgnoreCase("BINARY") && this.editable) {
            String ext = ".bin";
            if (this.filename == null) {
                this.filename = String.valueOf(Config.get("callsign")) + this.spacecraftSettings.getNextSequenceNum() + ext;
            }
            File file = null;
            file = this.pickFile("Open Binary", "Open", 0, null);
            if (file != null) {
                Config.set("editor_current_dir", file.getParent());
                if (this.ta != null) {
                    try {
                        RandomAccessFile loadBinary = new RandomAccessFile(file, "r");
                        if (loadBinary.length() > 250000L) {
                            Log.errorDialog("ERROR - TOO LARGE", "You can't create a pacsat file with a " + loadBinary.length() + " byte file.\n" + "Maximum size is: " + 250000);
                            this.cbType.setSelectedIndex(0);
                            loadBinary.close();
                            return;
                        }
                        this.txtUserFilename.setText(file.getName());
                        this.pacsatFileBytes = new byte[(int)loadBinary.length()];
                        this.ta.setEditable(true);
                        this.ta.setText("");
                        this.butSaveAndExit.setEnabled(true);
                        this.butSaveDraft.setEnabled(true);
                        this.saveAndExitI.setEnabled(true);
                        this.exportI.setEnabled(true);
                        this.butExport.setEnabled(true);
                        this.cbZipped.setEnabled(true);
                        this.editPanes.setDividerLocation(2000);
                        this.textPane.setVisible(true);
                        this.imagePanel.setVisible(false);
                        int i3 = 0;
                        while ((long)i3 < loadBinary.length()) {
                            this.pacsatFileBytes[i3] = loadBinary.readByte();
                            char c = (char)this.pacsatFileBytes[i3];
                            this.ta.append(String.valueOf(c));
                            ++i3;
                        }
                        loadBinary.close();
                    }
                    catch (FileNotFoundException e) {
                        Log.errorDialog("ERROR", "Error with file name: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR", "Error writing file: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butExport || e.getSource() == this.exportI) {
            try {
                this.exportFileToDisk();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not extract the name of the user file");
            }
        } else if (e.getSource() == this.saveAndExitI || e.getSource() == this.butSaveAndExit) {
            if (this.ta.getText().length() < 200) {
                this.cbZipped.setSelected(false);
            }
            if (this.editable) {
                if (this.txtTo.getText().equalsIgnoreCase("")) {
                    Log.infoDialog("TO is blank", "The message needs to be sent to at least one other station.\nPut something in the TO field.");
                    return;
                }
                if (this.txtTitle.getText().equalsIgnoreCase("")) {
                    Log.infoDialog("TITLE is blank", "The message needs to have a title so that stations can decide if \nit should be downloaded.  Put something in the TITLE field.");
                    return;
                }
                this.savePacsatFile(5);
                this.dispose();
            } else {
                Log.errorDialog("ERROR", "Can't resave the file when browsing it");
            }
        } else if (e.getSource() == this.butSaveDraft) {
            if (this.ta.getText().length() < 200) {
                this.cbZipped.setSelected(false);
            }
            if (this.editable) {
                this.savePacsatFile(8);
            } else {
                Log.errorDialog("ERROR", "Can't save the file when browsing it");
            }
        } else if (e.getSource() == this.butReply) {
            this.reply(false);
        } else if (e.getSource() == this.butReplyInclude) {
            this.reply(true);
        } else if (e.getSource() == this.cancelI || e.getSource() == this.butCancel) {
            this.dispose();
        } else if (e.getSource() == this.cutI) {
            this.pad = this.ta.getSelectedText();
            this.ta.replaceRange("", this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        } else if (e.getSource() == this.copyI) {
            this.pad = this.ta.getSelectedText();
        } else if (e.getSource() == this.pasteI) {
            this.ta.insert(this.pad, this.ta.getCaretPosition());
        } else if (e.getSource() == this.selectI) {
            this.ta.selectAll();
        } else {
            e.getSource();
        }
        if (e.getSource() == this.cbType) {
            if (this.buildingGui) {
                return;
            }
            int i2 = this.cbType.getSelectedIndex();
            if (this.editable) {
                this.processTypeSelection(PacSatFileHeader.userTypeStrings[i2]);
            } else {
                this.processTypeSelection(PacSatFileHeader.typeStrings[i2]);
            }
        }
    }

    public void saveProperties() {
        Config.set(EDIT_WINDOW_HEIGHT, this.getHeight());
        Config.set(EDIT_WINDOW_WIDTH, this.getWidth());
        Config.set(EDIT_WINDOW_X, this.getX());
        Config.set(EDIT_WINDOW_Y, this.getY());
        Config.save();
    }

    public void loadProperties() {
        if (Config.getInt(EDIT_WINDOW_X) == 0) {
            Config.set(EDIT_WINDOW_X, 100);
            Config.set(EDIT_WINDOW_Y, 100);
            Config.set(EDIT_WINDOW_HEIGHT, 600);
            Config.set(EDIT_WINDOW_WIDTH, 650);
        }
        this.setBounds(Config.getInt(EDIT_WINDOW_X), Config.getInt(EDIT_WINDOW_Y), Config.getInt(EDIT_WINDOW_WIDTH), Config.getInt(EDIT_WINDOW_HEIGHT));
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.running = false;
        this.saveProperties();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void run() {
        Log.println("STARTING Editor Refresh Thread");
        Thread.currentThread().setName("Editor Refresh");
        while (this.running) {
            this.refreshImage();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

