/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import gui.EditorFrame;
import gui.FileHeaderTableModel;
import gui.SpacecraftTab;
import gui.TablePanel;
import java.io.File;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class DirectoryPanel
extends TablePanel {
    private static final long serialVersionUID = 1L;

    DirectoryPanel(SpacecraftSettings spacecraftSettings, SpacecraftTab spacecraftTab) {
        super(spacecraftSettings, spacecraftTab);
        TableColumnModel tcm = this.directoryTable.getColumnModel();
        tcm.removeColumn(tcm.getColumn(11));
    }

    @Override
    public void deleteRow(JTable table, int row) {
    }

    @Override
    public void setPriority(JTable table, int row, long id, int pri) {
        this.spacecraftSettings.directory.setPriority(id, pri);
        table.setValueAt("" + pri, row, 1);
        ((FileHeaderTableModel)table.getModel()).fireTableCellUpdated(row, 1);
    }

    @Override
    protected void displayRow(JTable table, int row) {
        String id = (String)table.getValueAt(row, 0);
        long file_id = Long.parseLong(id);
        File f = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + Long.toHexString(file_id) + ".act");
        PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.spacecraftSettings.directory.dirFolder, Long.parseLong(id));
        if (f.exists()) {
            EditorFrame editor = null;
            try {
                editor = new EditorFrame(this.spacecraftSettings, psf, false);
                editor.setVisible(true);
                int state = psf.getPfh(this.spacecraftSettings).getState();
                if (state == 2) {
                    psf.getPfh(this.spacecraftSettings).setState(3);
                }
                this.setDirectoryData(this.spacecraftSettings.directory.getTableData());
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not open file: " + f + "\n" + e.getMessage());
            }
            catch (MalformedPfhException e) {
                Log.errorDialog("ERROR", "Could not open file: " + f + "\n" + e.getMessage());
            }
        }
    }
}

