/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.CommandParams;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pacSat.frames.CmdFrame;

public class CommandFrame
extends JFrame
implements ActionListener,
WindowListener {
    public static final String CMD_WINDOW_X = "cmd_window_x";
    public static final String CMD_WINDOW_Y = "cmd_window_y";
    public static final String CMD_WINDOW_WIDTH = "cmd_window_width";
    public static final String CMD_WINDOW_HEIGHT = "cmd_window_height";
    static SpacecraftSettings spacecraftSettings;
    private JComboBox<String> cbNameSpace;
    private JComboBox<String> cbCommands;
    JButton butCmdSend;
    JButton butCmdStop;
    JLabel[] lblArg;
    JLabel lblStatus;
    JTextField txtFileId;
    JTextField[] txtArg;
    JComboBox<String>[] cbArg;
    JPanel[] argPanel;
    JTextArea taDesc;

    public CommandFrame(SpacecraftSettings spacecraftSettings) {
        super("PACSAT COMMAND");
        CommandFrame.spacecraftSettings = spacecraftSettings;
        this.addWindowListener(this);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/pacsat.jpg")));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        JPanel center = new JPanel();
        JPanel bottom = new JPanel();
        pane.add((Component)top, "North");
        pane.add((Component)left, "West");
        pane.add((Component)right, "East");
        pane.add((Component)center, "Center");
        pane.add((Component)bottom, "South");
        top.setLayout(new FlowLayout(1));
        this.lblStatus = new JLabel("");
        Font f = this.lblStatus.getFont();
        this.lblStatus.setFont(f.deriveFont(f.getStyle() | 1));
        top.add(this.lblStatus);
        right.add(new Box.Filler(new Dimension(10, 10), new Dimension(40, 10), new Dimension(100, 40)));
        center.setLayout(new BorderLayout());
        JPanel centerTop = new JPanel();
        JPanel centerCenter = new JPanel();
        JPanel centerBottom = new JPanel();
        center.add((Component)centerTop, "North");
        center.add((Component)centerCenter, "Center");
        center.add((Component)centerBottom, "South");
        TitledBorder heading0 = this.title("Command");
        centerTop.setBorder(heading0);
        centerTop.add(new Box.Filler(new Dimension(10, 10), new Dimension(40, 30), new Dimension(100, 30)));
        centerTop.setLayout(new BoxLayout(centerTop, 0));
        JLabel lblNameSpace = new JLabel("   Type  ");
        this.cbNameSpace = new JComboBox();
        ArrayList<String> types = spacecraftSettings.getList("namespaces");
        if (types != null) {
            for (String param : types) {
                this.cbNameSpace.addItem(param);
            }
        }
        this.cbNameSpace.setSelectedIndex(1);
        centerTop.add(lblNameSpace);
        centerTop.add(this.cbNameSpace);
        this.cbNameSpace.addActionListener(this);
        JLabel lblCommand = new JLabel("     Command  ");
        this.cbCommands = new JComboBox();
        this.setCommands();
        centerTop.add(lblCommand);
        centerTop.add(this.cbCommands);
        this.cbCommands.addActionListener(this);
        centerCenter.setLayout(new BoxLayout(centerCenter, 1));
        centerCenter.add(new Box.Filler(new Dimension(10, 10), new Dimension(40, 50), new Dimension(100, 50)));
        TitledBorder heading1 = this.title("Paramaters");
        centerCenter.setBorder(heading1);
        this.lblArg = new JLabel[4];
        this.txtArg = new JTextField[4];
        this.cbArg = new JComboBox[4];
        this.argPanel = new JPanel[4];
        int a = 0;
        while (a < 4) {
            this.argPanel[a] = new JPanel();
            this.argPanel[a].setLayout(new FlowLayout());
            this.lblArg[a] = new JLabel("Argument " + a + " (s)   ");
            this.txtArg[a] = new JTextField();
            this.txtArg[a].setColumns(10);
            this.cbArg[a] = new JComboBox();
            this.cbArg[a].addActionListener(this);
            this.argPanel[a].add(this.lblArg[a]);
            this.argPanel[a].add(this.cbArg[a]);
            this.argPanel[a].add(this.txtArg[a]);
            centerCenter.add(this.argPanel[a]);
            ++a;
        }
        TitledBorder heading9 = this.title("Description");
        centerBottom.setBorder(heading9);
        centerBottom.setLayout(new BorderLayout());
        this.taDesc = new JTextArea(2, 45);
        this.taDesc.setText(spacecraftSettings.get("description"));
        this.taDesc.setLineWrap(true);
        this.taDesc.setWrapStyleWord(true);
        this.taDesc.setEditable(false);
        this.taDesc.setFont(new Font("SansSerif", 0, 12));
        centerBottom.add((Component)this.taDesc, "Center");
        CommandParams p = spacecraftSettings.getParam(this.cbNameSpace.getSelectedIndex(), (String)this.cbCommands.getSelectedItem());
        this.setArgs(p);
        centerCenter.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        bottom.setLayout(new FlowLayout(1));
        this.butCmdSend = new JButton("Send");
        this.butCmdSend.addActionListener(this);
        this.butCmdSend.setToolTipText("Send the command");
        this.butCmdSend.setFont(MainWindow.sysFont);
        bottom.add(this.butCmdSend);
        this.butCmdStop = new JButton("Stop");
        this.butCmdStop.addActionListener(this);
        this.butCmdStop.setToolTipText("Stop sending command");
        this.butCmdStop.setFont(MainWindow.sysFont);
        bottom.add(this.butCmdStop);
        this.setVisible(true);
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    void setCommands() {
        this.cbCommands.removeAllItems();
        ArrayList<String> names = spacecraftSettings.getParamsByNamespace(this.cbNameSpace.getSelectedIndex());
        for (String param : names) {
            this.cbCommands.addItem(param);
        }
    }

    public void setStatus(String status) {
        this.lblStatus.setText(status);
    }

    void setArgs(CommandParams param) {
        if (param == null) {
            return;
        }
        boolean noParams = true;
        int a = 0;
        while (a < 4) {
            if (param.argNames[a].equalsIgnoreCase("NONE")) {
                this.lblArg[a].setVisible(false);
                this.txtArg[a].setVisible(false);
                this.cbArg[a].setVisible(false);
            } else if (param.argNames[a].equalsIgnoreCase("MSB32BIT")) {
                this.lblArg[a].setVisible(false);
                this.txtArg[a].setVisible(false);
                this.cbArg[a].setVisible(false);
            } else {
                this.lblArg[a].setVisible(true);
                this.lblArg[a].setText(param.argNames[a]);
                this.txtArg[a].setText("" + param.args[a]);
                ArrayList<String> argStrings = spacecraftSettings.getList(param.argNames[a]);
                if (argStrings == null) {
                    this.txtArg[a].setVisible(true);
                    this.cbArg[a].setVisible(false);
                } else {
                    this.txtArg[a].setVisible(false);
                    this.cbArg[a].setVisible(true);
                    this.cbArg[a].removeAllItems();
                    for (String val : argStrings) {
                        this.cbArg[a].addItem(val);
                    }
                    this.cbArg[a].setSelectedIndex(param.args[a]);
                }
                noParams = false;
            }
            ++a;
        }
        if (noParams) {
            this.lblArg[0].setVisible(true);
            this.lblArg[0].setText("None");
        }
        if (param.args[0] == 99099099) {
            this.txtArg[0].setEnabled(false);
        } else {
            this.txtArg[0].setEnabled(true);
        }
        if (param.description != null) {
            this.taDesc.setText(param.description);
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    public void saveProperties() {
        Config.set(CMD_WINDOW_HEIGHT, this.getHeight());
        Config.set(CMD_WINDOW_WIDTH, this.getWidth());
        Config.set(CMD_WINDOW_X, this.getX());
        Config.set(CMD_WINDOW_Y, this.getY());
        Config.save();
    }

    public void loadProperties() {
        if (Config.getInt(CMD_WINDOW_X) == 0) {
            Config.set(CMD_WINDOW_X, 100);
            Config.set(CMD_WINDOW_Y, 100);
            Config.set(CMD_WINDOW_HEIGHT, 600);
            Config.set(CMD_WINDOW_WIDTH, 650);
        }
        this.setBounds(Config.getInt(CMD_WINDOW_X), Config.getInt(CMD_WINDOW_Y), Config.getInt(CMD_WINDOW_WIDTH), Config.getInt(CMD_WINDOW_HEIGHT));
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i2 = 0;
        while (i2 < 4) {
            if (e.getSource() == this.cbArg[i2]) {
                int j = this.cbArg[i2].getSelectedIndex();
                this.txtArg[i2].setText("" + j);
            }
            ++i2;
        }
        if (e.getSource() == this.cbNameSpace) {
            this.setCommands();
        }
        if (e.getSource() == this.cbCommands) {
            CommandParams p = spacecraftSettings.getParam(this.cbNameSpace.getSelectedIndex(), (String)this.cbCommands.getSelectedItem());
            this.setArgs(p);
        }
        if (e.getSource() == this.butCmdSend) {
            CommandParams cmd = spacecraftSettings.getParam(this.cbNameSpace.getSelectedIndex(), (String)this.cbCommands.getSelectedItem());
            if (cmd == null) {
                Log.infoDialog("No command selcted", "Select a Command type and command to transmit.");
                return;
            }
            if (cmd.confirm) {
                Object[] options = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(MainWindow.frame, "Are you sure you want to send a command that will:\n " + cmd.description, "Do you want to continue?", 0, 0, null, options, options[1]);
                if (n == 1) {
                    return;
                }
            }
            int[] pass_args = new int[4];
            if (cmd.args[0] == 99099099) {
                Date now = new Date();
                long unixtime = now.getTime() / 1000L;
                pass_args[0] = (int)unixtime & 0xFFFF;
                pass_args[1] = (int)unixtime >> 16;
            } else {
                int i3 = 0;
                while (i3 < 4) {
                    try {
                        pass_args[i3] = (int)(Long.parseLong(this.txtArg[i3].getText()) & 0xFFFFL);
                    }
                    catch (NumberFormatException ef) {
                        pass_args[i3] = 0;
                    }
                    if (cmd.argNames[i3].equalsIgnoreCase("MSB32BIT") && i3 > 0) {
                        pass_args[i3] = (int)(Long.parseLong(this.txtArg[i3 - 1].getText()) >> 16);
                    }
                    ++i3;
                }
            }
            this.sendCommand(cmd.nameSpace, cmd.cmd, pass_args);
        }
        if (e.getSource() == this.butCmdStop) {
            CmdFrame cmdFrame = new CmdFrame();
            CommandFrame.spacecraftSettings.downlink.processEvent(cmdFrame);
        }
    }

    void sendCommand(int nameSpace, int cmd, int[] args) {
        Log.println("Sending command: " + cmd + " " + Integer.toHexString(args[0]) + " " + Integer.toHexString(args[1]) + " " + Integer.toHexString(args[2]) + " " + Integer.toHexString(args[3]));
        if (spacecraftSettings == null) {
            return;
        }
        if (!spacecraftSettings.getBoolean("is_command_station")) {
            return;
        }
        if (Config.get("callsign").equalsIgnoreCase("NONE")) {
            Log.errorDialog("ERROR", "You need to set the callsign transmitting\nGo to the File > Settings screen\n");
            return;
        }
        if (!Config.getBoolean("tx_inhibit")) {
            try {
                Date now = new Date();
                long time = now.getTime() / 1000L;
                CmdFrame cmdFrame = new CmdFrame(Config.get("callsign"), spacecraftSettings.get("broadcastCallsign"), time, nameSpace, cmd, args, CommandFrame.spacecraftSettings.key);
                CommandFrame.spacecraftSettings.downlink.processEvent(cmdFrame);
            }
            catch (IllegalArgumentException e) {
                Log.errorDialog("ERROR", "Invalid secret command key\n");
            }
        } else {
            Log.errorDialog("Transmitted Disabled", "Command cant be sent when the transmitter is inhibitted\nDisable 'Inhibit Tranmitter' on the settings tab");
        }
    }
}

