/*
 * Decompiled with CFR 0.152.
 */
package fileStore.telem;

import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class LogFileWE {
    public static final int LIMWOD_CHANNELS = 12;
    public static final int FULLWOD_CHANNELS = 137;
    String fileName;
    long startDate;
    int interval;
    int channels;
    public ArrayList<DataRecord> records;
    int[] data;
    SpacecraftSettings spacecraftSettings;

    public LogFileWE(SpacecraftSettings spacecraftSettings, String fileName) throws MalformedPfhException, IOException, LayoutLoadException {
        this.spacecraftSettings = spacecraftSettings;
        this.fileName = fileName;
        this.data = this.loadData();
        this.parseFile();
    }

    public LogFileWE(SpacecraftSettings spacecraftSettings, int[] bytes) throws MalformedPfhException, IOException, LayoutLoadException {
        this.spacecraftSettings = spacecraftSettings;
        this.data = bytes;
        this.parseFile();
    }

    int[] loadData() {
        File f = new File(this.fileName);
        int[] b = new int[(int)f.length()];
        RandomAccessFile fileOnDisk = null;
        int p = 0;
        try {
            try {
                fileOnDisk = new RandomAccessFile(this.fileName, "r");
                boolean readingBytes = true;
                while (readingBytes) {
                    try {
                        b[p++] = fileOnDisk.readUnsignedByte();
                    }
                    catch (EOFException e) {
                        readingBytes = false;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Log.errorDialog("ERROR", "File: " + this.fileName + "\nseems to have too many data bytes or the data is corrupt");
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (fileOnDisk != null) {
                        fileOnDisk.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fileOnDisk != null) {
                    fileOnDisk.close();
                }
            }
            catch (IOException iOException) {}
        }
        return b;
    }

    private void parseFile() throws LayoutLoadException, IOException {
        int i2 = 0;
        int r = 0;
        String layout = "WOD_LAYOUT";
        this.startDate = DataRecord.getLongValue(i2, this.data);
        this.interval = DataRecord.getIntValue(i2 += 8, this.data);
        this.channels = this.data[i2 += 2];
        layout = this.channels == 12 ? "WOD_LAYOUT" : (this.channels == 137 ? "FULL_WOD_LAYOUT" : null);
        if (layout != null) {
            ++i2;
            i2 += this.channels;
            int len = this.channels * 2;
            this.records = new ArrayList();
            while (i2 < this.data.length) {
                int[] dataSet = Arrays.copyOfRange(this.data, i2, len + i2);
                DataRecord we = new DataRecord(this.spacecraftSettings.spacecraft.getLayoutByName(layout), 0, 0, this.startDate + (long)(r * this.interval), 0, dataSet, this.spacecraftSettings.spacecraft.ihuLittleEndian);
                this.records.add(we);
                i2 += len;
                ++r;
            }
        }
    }

    public String toString() {
        String s = "Start Date: " + PacSatField.getDateStringSecs(new Date(this.startDate * 1000L));
        s = String.valueOf(s) + "\nInterval: " + this.interval + "s";
        s = String.valueOf(s) + "\nChannels: " + this.channels + "\n\n";
        s = String.valueOf(s) + "Date, " + this.records.get(0).toHeaderString() + "\n";
        boolean i2 = false;
        for (DataRecord d : this.records) {
            s = String.valueOf(s) + PacSatField.getDateStringSecs(new Date(d.uptime * 1000L)) + ", ";
            s = String.valueOf(s) + d.toString() + "\n";
        }
        return s;
    }
}

