/*
 * Decompiled with CFR 0.152.
 */
package fileStore.telem;

import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import fileStore.telem.AlogSession;
import fileStore.telem.RecordAL1;
import fileStore.telem.RecordAL2;
import java.io.IOException;
import java.util.Arrays;

public class LogFileLog
extends PacSatFile {
    public static final int LEN_1 = 9;
    public static final int LEN_1F = 33;
    public static final int LEN_2 = 16;
    public static final int LEN_2F = 40;
    String[] event_text = new String[]{"         ", "STARTUP  ", "ERROR    ", "EXIT     ", "COMMAND  ", "FREE-DISK (blks, blk-size, files-avail, files)", "FS-START ", "FS-STOP  ", "LOG-LEVEL", "SENSORS START ", "SENSORS STOP ", "SENSORS ERROR "};
    public static final int ALOG_ERROR = 2;
    public static final int MAX_SESSION = 20;
    int sidx = 0;
    int event;
    AlogSession[] session;
    public String content;
    String[] log_errors = new String[]{"Undefined error", "Removing PID File", "Could not store WOD", "Sending Packet", "Setting Time", "Max Radio Retries", "Max TNC Retries", "SSTV Failure", "FS Failure", "Direwolf Failure", "PTT Failure", "TNC Failure", "Crew Interface Fail", "Setting radio mode", "Checking disk space", "Radio Time IO", "Number of Errors", "Max File IO Errors", "", "", "Cosmic Watch Failure", "Microphone Failure", "", "", "", "FS Directory Load Failure", "FS TNC Failure"};
    int[] data;
    RecordAL1 alog_1f;
    RecordAL2 alog_2f;

    public LogFileLog(SpacecraftSettings spacecraftSettings, String dir, long id) throws LayoutLoadException, IOException {
        super(spacecraftSettings, dir, id);
        this.data = this.getData();
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    public LogFileLog(SpacecraftSettings spacecraftSettings, String fileName) throws MalformedPfhException, IOException, LayoutLoadException {
        super(spacecraftSettings, fileName);
        this.data = this.getData();
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    public LogFileLog(SpacecraftSettings spacecraftSettings, int[] bytes) throws MalformedPfhException, IOException, LayoutLoadException {
        super(spacecraftSettings, bytes);
        this.data = bytes;
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    private String parseFile() throws LayoutLoadException, IOException {
        String s = "";
        s = String.valueOf(s) + "Spacecraft Computer Log. " + " Length: " + this.data.length + " bytes\n\n";
        s = String.valueOf(s) + "Time\t\tEvent             Text     \tRx          Data\n";
        int i2 = 0;
        int len = 999;
        while (i2 < this.data.length && len > 0) {
            long timeStamp = 0L;
            this.event = DataRecord.getByteValue(i2, this.data);
            len = DataRecord.getByteValue(i2 + 1, this.data);
            if (len == 0 || len > 40) {
                s = String.valueOf(s) + "File is damaged, can not be parsed";
                break;
            }
            int[] dataSet1 = Arrays.copyOfRange(this.data, i2, 33 + i2);
            this.alog_1f = new RecordAL1(0, 0, timeStamp, 0, dataSet1, true);
            int[] dataSet2 = Arrays.copyOfRange(this.data, i2, 40 + i2);
            this.alog_2f = new RecordAL2(0, 0, timeStamp, 0, dataSet2, true);
            switch (len) {
                case 9: {
                    s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.search_for_string(this.event_text, this.event);
                    if (this.event == 2) {
                        s = String.valueOf(s) + " " + this.search_for_string(this.log_errors, this.alog_1f.getRawValue("serial_no"));
                        break;
                    }
                    s = String.valueOf(s) + " " + this.alog_1f.getRawValue("serial_no");
                    break;
                }
                case 33: {
                    s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.search_for_string(this.event_text, this.event);
                    long var1 = this.alog_1f.getRawValue("var1");
                    long var2 = this.alog_1f.getRawValue("var2");
                    long var3 = this.alog_1f.getRawValue("var3");
                    long var4 = this.alog_1f.getRawValue("var4");
                    long var5 = this.alog_1f.getRawValue("var5");
                    long var6 = this.alog_1f.getRawValue("var6");
                    s = String.valueOf(s) + " " + var1 + ", " + var2 + ", " + var3 + ", " + var4 + ", " + var5 + ", " + var6;
                    break;
                }
                case 16: {
                    s = String.valueOf(s) + this.pcalla();
                    break;
                }
                case 40: {
                    s = String.valueOf(s) + this.pcalla();
                    long var1 = this.alog_2f.getRawValue("var1");
                    long var2 = this.alog_2f.getRawValue("var2");
                    long var3 = this.alog_2f.getRawValue("var3");
                    long var4 = this.alog_2f.getRawValue("var4");
                    long var5 = this.alog_2f.getRawValue("var5");
                    long var6 = this.alog_2f.getRawValue("var6");
                    s = String.valueOf(s) + "        " + var1 + ", " + var2 + ", " + var3 + ", " + var4 + ", " + var5 + ", " + var6;
                    break;
                }
                default: {
                    s = String.valueOf(s) + "UNK: " + this.alog_1f;
                }
            }
            s = String.valueOf(s) + "\n";
            i2 += len;
        }
        return s;
    }

    private String pcallsession() {
        String s = "";
        String c = this.alog_2f.getCallString();
        String ss = this.alog_2f.getSsid();
        int n = this.alog_2f.getRawValue("serial_no");
        this.session[this.sidx] = new AlogSession(c, ss, n);
        this.sidx = (this.sidx + 1) % 20;
        s = String.valueOf(s) + this.pcalla();
        return s;
    }

    private String pcalla() {
        String s = "";
        s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.search_for_string(this.event_text, this.event) + " ";
        s = String.valueOf(s) + this.alog_2f.getCallString() + "-" + this.alog_2f.getSsid() + "\t" + this.alog_2f.getRxChan();
        return s;
    }

    private String pcall() {
        String s = "";
        int serial = this.alog_1f.getRawValue("serial_no");
        int i2 = 0;
        while (i2 < 20) {
            if (this.session[i2].session == serial) break;
            ++i2;
        }
        s = String.valueOf(s) + this.alog_1f;
        s = i2 < 20 ? String.valueOf(s) + this.session[i2].call + "-" + this.session[i2].ssid : String.valueOf(s) + "******-**    ";
        return s;
    }

    private String search_for_string(String[] strings, int var3) {
        String err_str = "";
        err_str = var3 > 0 && var3 < strings.length ? " " + strings[var3] : " " + var3;
        if (err_str == null) {
            err_str = "";
        }
        return err_str;
    }

    private RecordAL2 getAlogStruct(int[] data, int offset) {
        int len = DataRecord.getIntValue(offset, data);
        return null;
    }

    public String toString() {
        return this.content;
    }
}

