/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import common.Config;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import pacSat.frames.FrameException;

public class PacSatFileHeader
implements Comparable<PacSatFileHeader>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TAG1 = 170;
    public static final int TAG1_ALT = 0;
    public static final int TAG2 = 85;
    public static final int PRI_N = 9;
    public static final int MAX_HEADER_LENGTH = 1024;
    int[] rawBytes;
    ArrayList<PacSatField> fields;
    public static final int FILE_ID = 1;
    public static final int FILE_NAME = 2;
    public static final int FILE_EXT = 3;
    public static final int FILE_SIZE = 4;
    public static final int CREATE_TIME = 5;
    public static final int LAST_MOD_TIME = 6;
    public static final int SEU_FLAG = 7;
    public static final int FILE_TYPE = 8;
    public static final int BODY_CHECKSUM = 9;
    public static final int HEADER_CHECKSUM = 10;
    public static final int BODY_OFFSET = 11;
    public static final int SOURCE = 16;
    public static final int AX25_UPLOADER = 17;
    public static final int UPLOAD_TIME = 18;
    public static final int DOWNLOAD_COUNT = 19;
    public static final int DESTINATION = 20;
    public static final int AX25_DOWNLOADER = 21;
    public static final int DOWNLOAD_TIME = 22;
    public static final int EXPIRE_TIME = 23;
    public static final int PRIORITY = 24;
    public static final int COMPRESSION_TYPE = 25;
    public static final int BBS_MSG_TYPE = 32;
    public static final int BULLETIN_ID_NUMBER = 33;
    public static final int TITLE = 34;
    public static final int KEYWORDS = 35;
    public static final int FILE_DESCRIPTION = 36;
    public static final int COMPRESSION_DESCRIPTION = 37;
    public static final int USER_FILE_NAME = 38;
    public static final int BODY_NOT_COMPRESSED = 0;
    public static final int BODY_COMPRESSED_PKARC = 1;
    public static final int BODY_COMPRESSED_PKZIP = 2;
    public static final String[] compressions = new String[]{"None", "PKARC", "PKZIP"};
    public static final int NONE = 0;
    public static final int PARTIAL = 1;
    public static final int NEWMSG = 2;
    public static final int MSG = 3;
    public static final int MISSING = 4;
    public static final int QUE = 5;
    public static final int SENT = 6;
    public static final int REJ = 7;
    public static final int DRAFT = 8;
    public static final String[] states = new String[]{"", "PART", "NEW", "MSG", "GONE", "QUE", "SENT", "FAIL", "DRAFT"};
    public static final String[] userTypeStrings = new String[]{"Select Type", "ASCII", "JPG", "BINARY"};
    public static final int[] userTypes;
    private static final int[] types;
    public static final String[] typeStrings;
    public static final int WOD_TYPE = 3;
    public static final int AL_TYPE = 201;
    public static final int LOG_TYPE = 223;
    public static final int BL_TYPE = 202;
    public static final int WOD_LOG_TYPE = 203;
    public static final int EL_TYPE = 208;
    public static final int IMAGES_TYPE = 211;
    public static final int BINARY_TYPE = 12;
    public static final int SOOSS_WOD_LOG_TYPE = 240;
    long timeOld;
    long timeNew;
    Date dateDownloaded = new Date();
    public int userDownLoadPriority = 0;
    long downloadedBytes = 0L;
    int state;
    static final int MAX_TITLE_LENGTH = 80;
    static final int MAX_KEYWORDS_LENGTH = 50;
    static final int MAX_FILENAME_LENGTH = 80;
    static final int[] eight0;
    static final int[] four0;
    static final int[] two0;

    static {
        int[] nArray = new int[4];
        nArray[0] = -999;
        nArray[2] = 16;
        nArray[3] = 12;
        userTypes = nArray;
        int[] nArray2 = new int[37];
        nArray2[0] = -999;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 6;
        nArray2[5] = 7;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 12;
        nArray2[9] = 13;
        nArray2[10] = 14;
        nArray2[11] = 15;
        nArray2[12] = 16;
        nArray2[13] = 17;
        nArray2[14] = 18;
        nArray2[15] = 19;
        nArray2[16] = 200;
        nArray2[17] = 201;
        nArray2[18] = 202;
        nArray2[19] = 203;
        nArray2[20] = 204;
        nArray2[21] = 205;
        nArray2[22] = 206;
        nArray2[23] = 207;
        nArray2[24] = 208;
        nArray2[25] = 209;
        nArray2[26] = 210;
        nArray2[27] = 211;
        nArray2[28] = 212;
        nArray2[29] = 213;
        nArray2[30] = 214;
        nArray2[31] = 215;
        nArray2[32] = 221;
        nArray2[33] = 222;
        nArray2[34] = 223;
        nArray2[35] = 240;
        nArray2[36] = 255;
        types = nArray2;
        typeStrings = new String[]{"Select Type", "ASCII", "BBS", "WOD", "EXE", "COM", "NASA KEPS", "AMSAT KEPS", "BINARY", "MULTIPLE ASCII", "GIF", "PCX", "JPG", "CONFIRM", "SAT GATE", "INET", "Config Uploaded", "Activity Log", "Broadcast Log", "WOD Log", "ADCS Log", "TDE Log", "SCTE Log", "Transputer Log", "SEU Log", "CPE", "Battery Charge Log", "Image", "SPL Log", "PCT Log", "PCT Command Log", "QL Image", "CCD Image", "CPE Result", "Log", "SOOSS WOD Log", "Undefined"};
        eight0 = new int[8];
        four0 = new int[4];
        two0 = new int[2];
    }

    public PacSatFileHeader(String from, String to, long fileBodyLength, short bodyChecksum, int type, int compressionType, String title, String keywords, String userFileName) {
        this.fields = new ArrayList();
        this.createMandatoryHeader(bodyChecksum, type);
        this.createExtendedHeader(from, to, fileBodyLength, type);
        this.createOptionalHeader(fileBodyLength, compressionType, title, keywords, userFileName);
        int headerLength = 0;
        for (PacSatField f : this.fields) {
            headerLength += f.getBytes().length;
        }
        this.rawBytes = new int[5 + headerLength];
        PacSatField bodyOffset = this.getFieldById(11);
        PacSatField newBodyOffset = new PacSatField(this.rawBytes.length, 11);
        bodyOffset.copyFrom(newBodyOffset);
        PacSatField fileSize = this.getFieldById(4);
        PacSatField newFileSize = new PacSatField((long)this.rawBytes.length + fileBodyLength, 4);
        fileSize.copyFrom(newFileSize);
        this.generateBytes();
    }

    public short headerChecksumValid() {
        short headercs = (short)this.getFieldById(10).getLongValue();
        int[] checkBytes = new int[this.rawBytes.length];
        checkBytes[0] = this.rawBytes[0];
        checkBytes[1] = this.rawBytes[1];
        int h = 2;
        for (PacSatField f : this.fields) {
            int[] by;
            int n;
            if (f.id == 10) {
                int[] by2;
                PacSatField newHeaderChecksum = new PacSatField(0, 10);
                int[] nArray = by2 = newHeaderChecksum.getBytes();
                int n2 = by2.length;
                n = 0;
                while (n < n2) {
                    int b = nArray[n];
                    checkBytes[h++] = b;
                    ++n;
                }
                continue;
            }
            int[] nArray = by = f.getBytes();
            n = by.length;
            int n3 = 0;
            while (n3 < n) {
                int b = nArray[n3];
                checkBytes[h++] = b;
                ++n3;
            }
        }
        short calculatedHeaderCS = PacSatFileHeader.checksum(checkBytes);
        if (calculatedHeaderCS == headercs) {
            return 0;
        }
        return calculatedHeaderCS;
    }

    private void generateBytes() {
        this.rawBytes[0] = 170;
        this.rawBytes[1] = 85;
        PacSatField headerChecksum = this.getFieldById(10);
        short zero = 0;
        PacSatField newHeaderChecksum = new PacSatField(zero, 10);
        headerChecksum.copyFrom(newHeaderChecksum);
        int h = 2;
        for (PacSatField f : this.fields) {
            int[] by;
            int[] nArray = by = f.getBytes();
            int n = by.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                this.rawBytes[h++] = b;
                ++n2;
            }
        }
        short headerCS = PacSatFileHeader.checksum(this.rawBytes);
        PacSatField headerChecksum2 = this.getFieldById(10);
        PacSatField newHeaderChecksum2 = new PacSatField(headerCS, 10);
        headerChecksum2.copyFrom(newHeaderChecksum2);
        h = 2;
        for (PacSatField f : this.fields) {
            int[] by;
            int[] nArray = by = f.getBytes();
            int n = by.length;
            int n3 = 0;
            while (n3 < n) {
                int b = nArray[n3];
                this.rawBytes[h++] = b;
                ++n3;
            }
        }
        this.rawBytes[h++] = 0;
        this.rawBytes[h++] = 0;
        this.rawBytes[h] = 0;
    }

    public void copyMetaData(PacSatFileHeader pfh) {
        this.state = pfh.state;
        this.userDownLoadPriority = pfh.userDownLoadPriority;
    }

    public static short checksum(int[] bytes) {
        short cs = 0;
        int[] nArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            cs = (short)(cs + b);
            ++n2;
        }
        return cs;
    }

    public static short checksum(byte[] bytes) {
        short cs = 0;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            cs = (short)(cs + (b & 0xFF));
            ++n2;
        }
        return cs;
    }

    private void createMandatoryHeader(short bodyCS, int type) {
        PacSatField fileNum = new PacSatField(four0, 1);
        this.fields.add(fileNum);
        PacSatField fileName = new PacSatField("        ", 2);
        this.fields.add(fileName);
        PacSatField fileExt = new PacSatField("   ", 3);
        this.fields.add(fileExt);
        PacSatField fileSize = new PacSatField(four0, 4);
        this.fields.add(fileSize);
        PacSatField createTime = new PacSatField(new Date(), 5);
        this.fields.add(createTime);
        PacSatField lastModTime = new PacSatField(new Date(), 6);
        this.fields.add(lastModTime);
        PacSatField seu = new PacSatField(0, 7);
        this.fields.add(seu);
        PacSatField fileType = new PacSatField((byte)type, 8);
        this.fields.add(fileType);
        PacSatField bodyChecksum = new PacSatField(bodyCS, 9);
        this.fields.add(bodyChecksum);
        PacSatField headerChecksum = new PacSatField(two0, 10);
        this.fields.add(headerChecksum);
        PacSatField bodyOffset = new PacSatField(two0, 11);
        this.fields.add(bodyOffset);
    }

    private void createExtendedHeader(String from, String to, long fileBodyLength, int type) {
        PacSatField source = new PacSatField(from, 16);
        this.fields.add(source);
        int[] nArray = new int[6];
        nArray[4] = 90;
        int[] wispax25_uploader = nArray;
        PacSatField ax25uploader = new PacSatField(wispax25_uploader, 17);
        this.fields.add(ax25uploader);
        PacSatField uploadTime = new PacSatField(four0, 18);
        this.fields.add(uploadTime);
        PacSatField downloadCount = new PacSatField(0, 19);
        this.fields.add(downloadCount);
        PacSatField destination = new PacSatField(to, 20);
        this.fields.add(destination);
        PacSatField ax25downloader = new PacSatField(wispax25_uploader, 21);
        this.fields.add(ax25downloader);
        PacSatField downloadTime = new PacSatField(four0, 22);
        this.fields.add(downloadTime);
        PacSatField expireTime = new PacSatField(four0, 23);
        this.fields.add(expireTime);
        PacSatField priority = new PacSatField(0, 24);
        this.fields.add(priority);
    }

    private void createOptionalHeader(long fileBodyLength, int compressionType, String title, String keywords, String userFileName) {
        PacSatField compression = new PacSatField((byte)compressionType, 25);
        this.fields.add(compression);
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        PacSatField titleField = new PacSatField(title, 34);
        this.fields.add(titleField);
        if (keywords != null && !keywords.equalsIgnoreCase("")) {
            if (keywords.length() > 50) {
                keywords = keywords.substring(0, 50);
            }
            PacSatField keywordsField = new PacSatField(keywords, 35);
            this.fields.add(keywordsField);
        }
        if (userFileName != null && !userFileName.equalsIgnoreCase("")) {
            if (userFileName.length() > 80) {
                userFileName = userFileName.substring(0, 50);
            }
            PacSatField userFileNameField = new PacSatField(userFileName, 38);
            this.fields.add(userFileNameField);
        }
        PacSatField wisp2A = new PacSatField("PGS0.06", 42);
        this.fields.add(wisp2A);
        PacSatField wisp2E = new PacSatField(eight0, 46);
        this.fields.add(wisp2E);
        PacSatField wisp2F = new PacSatField(eight0, 47);
        this.fields.add(wisp2F);
    }

    public PacSatFileHeader(long fileId, long told, long tnew, int[] bytes) throws MalformedPfhException {
        this.timeOld = told;
        this.timeNew = tnew;
        this.rawBytes = bytes;
        this.fields = new ArrayList();
        if (bytes.length < 2) {
            throw new MalformedPfhException("Missing PFH.  Not enough bytes for fileId: " + Long.toHexString(fileId));
        }
        int check1 = bytes[0];
        int check2 = bytes[1];
        if (check1 != 170 && check1 != 0) {
            throw new MalformedPfhException("Missing " + Integer.toHexString(170) + " for fileId: " + Long.toHexString(fileId));
        }
        if (check2 != 85) {
            throw new MalformedPfhException("Missing " + Integer.toHexString(85) + " for fileId: " + Long.toHexString(fileId));
        }
        boolean readingHeader = true;
        int p = 2;
        while (readingHeader) {
            PacSatField field = new PacSatField(p, bytes);
            p = p + field.length + 3;
            if (field.isNull()) {
                readingHeader = false;
                continue;
            }
            this.fields.add(field);
        }
    }

    public PacSatFileHeader(RandomAccessFile fileOnDisk) throws MalformedPfhException, IOException {
        int len = (int)fileOnDisk.length();
        if (len > 1024) {
            len = 1024;
        }
        this.fields = new ArrayList();
        byte[] by = new byte[len];
        fileOnDisk.read(by);
        int[] bytes = new int[by.length];
        int p = 0;
        byte[] byArray = by;
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            bytes[p++] = b & 0xFF;
            ++n2;
        }
        this.rawBytes = bytes;
        if (bytes.length < 5) {
            throw new MalformedPfhException("Missing PFH");
        }
        int check1 = bytes[0];
        int check2 = bytes[1];
        if (check1 != 170 && check1 != 0) {
            throw new MalformedPfhException("Missing " + Integer.toHexString(170) + " has " + Integer.toHexString(check1));
        }
        if (check2 != 85) {
            throw new MalformedPfhException("Missing " + Integer.toHexString(85));
        }
        boolean readingHeader = true;
        int headerLength = 0;
        p = 2;
        while (readingHeader) {
            PacSatField field = new PacSatField(p, bytes);
            p = p + field.length + 3;
            if (field.isNull()) {
                readingHeader = false;
                headerLength = p;
                continue;
            }
            this.fields.add(field);
        }
        this.rawBytes = Arrays.copyOfRange(bytes, 0, p);
    }

    public String getHexFileId() {
        return Long.toHexString(this.getFileId());
    }

    public long getFileId() {
        return this.getFieldById(1).getLongValue();
    }

    public String getFileName() {
        return this.getFieldById(1).getLongHexString();
    }

    public Date getDate(int id) {
        PacSatField dateField = null;
        dateField = this.getFieldById(id);
        Date lastDate = null;
        if (dateField != null) {
            lastDate = dateField.getDateValue();
        }
        return lastDate;
    }

    public static int getUserTypeIndexByString(String str) {
        int i2 = 0;
        while (i2 < userTypes.length) {
            if (userTypeStrings[i2].equalsIgnoreCase(str)) {
                return i2;
            }
            ++i2;
        }
        return 0;
    }

    public static int getTypeIndexByString(String str) {
        int i2 = 0;
        while (i2 < types.length) {
            if (typeStrings[i2].equalsIgnoreCase(str)) {
                return i2;
            }
            ++i2;
        }
        return 0;
    }

    public static int getTypeIdByString(String str) {
        int i2 = 0;
        while (i2 < types.length) {
            if (typeStrings[i2].equalsIgnoreCase(str)) {
                return types[i2];
            }
            ++i2;
        }
        return 0;
    }

    public static String getTypeStringByIndex(int id) {
        return typeStrings[id];
    }

    public static String getTypeStringById(int id) {
        int i2 = 0;
        while (i2 < types.length) {
            if (types[i2] == id) {
                return typeStrings[i2];
            }
            ++i2;
        }
        return "";
    }

    public int[] getBytes() {
        return this.rawBytes;
    }

    public int getType() {
        PacSatField typeField = null;
        typeField = this.getFieldById(8);
        return (int)typeField.getLongValue();
    }

    public String getTypeString() {
        int t;
        PacSatField typeField = null;
        typeField = this.getFieldById(8);
        String s = "";
        if (typeField != null && (s = PacSatFileHeader.getTypeStringById(t = (int)typeField.getLongValue())) == null) {
            return "Unknown";
        }
        return s;
    }

    public String getFieldString(int fieldId) {
        PacSatField field = null;
        field = this.getFieldById(fieldId);
        String s = "";
        if (field != null && (s = field.getStringValue()) == null) {
            s = "";
        }
        return s;
    }

    public String getDateString(int fieldId) {
        PacSatField field = null;
        field = this.getFieldById(fieldId);
        String s = "";
        if (field != null && (s = field.getDateString()) == null) {
            s = "";
        }
        return s;
    }

    public PacSatField getFieldById(int id) {
        for (PacSatField field : this.fields) {
            if (field.id != id) continue;
            return field;
        }
        return null;
    }

    public void setFileId(long fileid) {
        PacSatField fileNum = new PacSatField(fileid, 1);
        for (PacSatField field : this.fields) {
            if (field.id != 1) continue;
            field.copyFrom(fileNum);
            break;
        }
        this.generateBytes();
    }

    public void setFileUploadDate() {
        Date now = new Date();
        PacSatField uploadTime = new PacSatField(now.getTime() / 1000L, 18);
        for (PacSatField field : this.fields) {
            if (field.id != 18) continue;
            field.copyFrom(uploadTime);
            break;
        }
        this.generateBytes();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String[] getTableFields() {
        int compressedBy;
        String[] fields = new String[15];
        fields[0] = this.getFieldById(1).getLongString();
        fields[1] = this.userDownLoadPriority == 9 ? "N" : (this.userDownLoadPriority > 0 ? Integer.toString(this.userDownLoadPriority) : "");
        fields[2] = states[this.state];
        fields[3] = this.getFieldById(20) != null ? this.getFieldById(20).getStringValue() : "";
        fields[4] = this.getFieldById(16) != null ? this.getFieldById(16).getStringValue() : "";
        fields[5] = PacSatField.getDateString(new Date(this.timeOld * 1000L));
        fields[6] = this.getFieldById(18) != null ? this.getFieldById(18).getDateString() : "";
        fields[7] = PacSatField.getDateString(new Date(this.timeNew * 1000L));
        fields[8] = this.getFieldById(4).getLongString();
        int percent = (int)((double)(100L * this.downloadedBytes) / (double)this.getFieldById(4).getLongValue());
        fields[9] = "" + percent;
        if (this.getFieldById(34) != null) {
            fields[10] = this.getFieldById(34).getStringValue();
        } else if (this.getFieldById(2) != null && this.getFieldById(3) != null) {
            fields[10] = String.valueOf(this.getFieldById(2).getStringValue()) + '.' + this.getFieldById(3).getStringValue();
        }
        fields[11] = this.getTypeString();
        if (this.getFieldById(8) != null) {
            PacSatField typeField = this.getFieldById(8);
            int t = (int)typeField.getLongValue();
            String s = PacSatFileHeader.getTypeStringById(t);
            if (s == null) {
                s = "Unknown";
            }
            fields[11] = String.valueOf(s) + "-" + t;
        } else {
            fields[11] = "";
        }
        fields[12] = this.getFieldById(35) != null ? this.getFieldById(35).getStringValue() : "";
        fields[13] = this.getFieldById(38) != null ? this.getFieldById(38).getStringValue() : "";
        fields[14] = this.getFieldById(25) != null ? ((compressedBy = (int)this.getFieldById(25).getLongValue()) > 0 && compressedBy < compressions.length ? compressions[compressedBy] : "") : "";
        return fields;
    }

    public String toFullString() {
        String s = "";
        for (PacSatField f : this.fields) {
            s = String.valueOf(s) + f + "\n";
        }
        return s;
    }

    public String toString() {
        String s = "";
        if (this.getFieldById(1) != null) {
            s = String.valueOf(s) + " FILE: " + this.getFieldById(1).getLongHexString();
        }
        if (this.getFieldById(2) != null) {
            s = String.valueOf(s) + " NAME: " + this.getFieldById(2).getStringValue() + '.' + this.getFieldById(3).getStringValue();
        }
        if (this.getFieldById(4) != null) {
            s = String.valueOf(s) + " FLEN: " + this.getFieldById(4).getLongString();
        }
        if (this.getFieldById(5) != null) {
            s = String.valueOf(s) + " CR: " + this.getFieldById(5).getDateValue();
        }
        s = String.valueOf(s) + " NEW: " + PacSatField.getDateString(new Date(this.timeNew * 1000L));
        if (this.getFieldById(18) != null) {
            s = String.valueOf(s) + " UP: " + this.getFieldById(18).getDateValue();
        }
        s = String.valueOf(s) + " OLD: " + PacSatField.getDateString(new Date(this.timeOld * 1000L));
        if (this.getFieldById(7) != null) {
            s = String.valueOf(s) + " SEU: " + this.getFieldById(7).getLongString();
        }
        if (this.getFieldById(8) != null) {
            s = String.valueOf(s) + " TYPE: " + this.getFieldById(8).getLongString();
        }
        if (this.getFieldById(9) != null) {
            s = String.valueOf(s) + " BCRC: " + this.getFieldById(9).getLongHexString();
        }
        if (this.getFieldById(10) != null) {
            s = String.valueOf(s) + " HCRC: " + this.getFieldById(10).getLongHexString();
        }
        if (this.getFieldById(25) != null) {
            int compressedBy = (int)this.getFieldById(25).getLongValue();
            s = String.valueOf(s) + " Compression: " + compressedBy + " " + compressions[compressedBy];
        }
        return s;
    }

    @Override
    public int compareTo(PacSatFileHeader p) {
        PacSatField id = this.getFieldById(1);
        if (id == null) {
            return -1;
        }
        PacSatField pid = p.getFieldById(1);
        if (pid == null) {
            return -1;
        }
        if (id.getLongValue() == pid.getLongValue()) {
            return 0;
        }
        PacSatField uploadTimeField = this.getFieldById(18);
        if (uploadTimeField == null) {
            return -1;
        }
        long uploadTime = uploadTimeField.getLongValue();
        PacSatField pUploadTimeField = p.getFieldById(18);
        if (pUploadTimeField == null) {
            return 1;
        }
        long pUploadTime = pUploadTimeField.getLongValue();
        if (uploadTime == pUploadTime) {
            return 0;
        }
        if (uploadTime < pUploadTime) {
            return -1;
        }
        if (uploadTime > pUploadTime) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) throws IOException, FrameException, MalformedPfhException {
        Config.init("Test");
        int[] nArray = new int[73];
        nArray[0] = 170;
        nArray[1] = 85;
        nArray[2] = 1;
        nArray[4] = 4;
        nArray[9] = 2;
        nArray[11] = 8;
        nArray[12] = 66;
        nArray[13] = 68;
        nArray[14] = 67;
        nArray[15] = 65;
        nArray[16] = 83;
        nArray[17] = 84;
        nArray[18] = 85;
        nArray[19] = 49;
        nArray[20] = 3;
        nArray[22] = 3;
        nArray[23] = 84;
        nArray[24] = 88;
        nArray[25] = 84;
        nArray[26] = 4;
        nArray[28] = 4;
        nArray[29] = 248;
        nArray[30] = 7;
        nArray[33] = 5;
        nArray[35] = 4;
        nArray[36] = 196;
        nArray[37] = 148;
        nArray[38] = 124;
        nArray[39] = 94;
        nArray[40] = 6;
        nArray[42] = 4;
        nArray[43] = 254;
        nArray[44] = 61;
        nArray[45] = 116;
        nArray[46] = 40;
        nArray[47] = 7;
        nArray[49] = 1;
        nArray[51] = 8;
        nArray[53] = 1;
        nArray[55] = 9;
        nArray[57] = 2;
        nArray[58] = 119;
        nArray[59] = 25;
        nArray[60] = 10;
        nArray[62] = 2;
        nArray[63] = 26;
        nArray[64] = 10;
        nArray[65] = 11;
        nArray[67] = 2;
        nArray[68] = 73;
        int[] byheader = nArray;
        PacSatFileHeader pfh = new PacSatFileHeader(9L, 0L, 0L, byheader);
        short cs = pfh.headerChecksumValid();
        System.out.println(cs);
        System.out.println(pfh);
        int[] nArray2 = new int[73];
        nArray2[0] = 170;
        nArray2[1] = 85;
        nArray2[2] = 1;
        nArray2[4] = 4;
        nArray2[9] = 2;
        nArray2[11] = 8;
        nArray2[12] = 66;
        nArray2[13] = 68;
        nArray2[14] = 67;
        nArray2[15] = 65;
        nArray2[16] = 83;
        nArray2[17] = 84;
        nArray2[18] = 85;
        nArray2[19] = 49;
        nArray2[20] = 3;
        nArray2[22] = 3;
        nArray2[23] = 84;
        nArray2[24] = 88;
        nArray2[25] = 84;
        nArray2[26] = 4;
        nArray2[28] = 4;
        nArray2[29] = 248;
        nArray2[30] = 7;
        nArray2[33] = 5;
        nArray2[35] = 4;
        nArray2[36] = 196;
        nArray2[37] = 148;
        nArray2[38] = 124;
        nArray2[39] = 94;
        nArray2[40] = 6;
        nArray2[42] = 4;
        nArray2[43] = 254;
        nArray2[44] = 61;
        nArray2[45] = 116;
        nArray2[46] = 40;
        nArray2[47] = 7;
        nArray2[49] = 1;
        nArray2[51] = 8;
        nArray2[53] = 1;
        nArray2[55] = 9;
        nArray2[57] = 2;
        nArray2[58] = 119;
        nArray2[59] = 25;
        nArray2[60] = 10;
        nArray2[62] = 2;
        nArray2[65] = 11;
        nArray2[67] = 2;
        nArray2[68] = 73;
        int[] header_no_checksum = nArray2;
        int result = 0;
        int[] nArray3 = header_no_checksum;
        int n = header_no_checksum.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray3[n2];
            result = (short)(result + i2);
            ++n2;
        }
        System.out.println(Integer.toHexString(result));
        short cs2 = PacSatFileHeader.checksum(header_no_checksum);
        System.out.println(Integer.toHexString(cs2));
    }
}

