/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import common.Log;
import common.SpacecraftSettings;
import fileStore.FileHole;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import fileStore.PacSatFileHeader;
import fileStore.SortedArrayList;
import fileStore.UnzipFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import pacSat.frames.BroadCastFrame;
import pacSat.frames.BroadcastDirFrame;
import pacSat.frames.BroadcastFileFrame;

public class PacSatFile {
    PacSatFileHeader pfh;
    RandomAccessFile fileOnDisk;
    String directory;
    long fileid;
    String filename;
    SortedArrayList<FileHole> holes;
    byte[] bytes;
    SpacecraftSettings spacecraftSettings;

    public PacSatFile(SpacecraftSettings spacecraftSettings, String dir, long id) {
        this.spacecraftSettings = spacecraftSettings;
        this.directory = dir;
        this.fileid = id;
        this.filename = this.makeActFileName();
        try {
            this.loadHoleList();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PacSatFile(SpacecraftSettings spacecraftSettings, String fileName) throws MalformedPfhException, IOException {
        this.spacecraftSettings = spacecraftSettings;
        File f = new File(fileName);
        this.filename = fileName;
        this.loadFile();
    }

    public PacSatFile(SpacecraftSettings spacecraftSettings, String file, PacSatFileHeader h, byte[] b) {
        this.spacecraftSettings = spacecraftSettings;
        this.filename = file;
        this.pfh = h;
        this.bytes = b;
    }

    public PacSatFile(SpacecraftSettings spacecraftSettings, int[] b) {
        this.spacecraftSettings = spacecraftSettings;
        this.bytes = new byte[b.length];
        int j = 0;
        int[] nArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            this.bytes[j++] = (byte)i2;
            ++n2;
        }
    }

    public void setFileId(long id) {
        this.fileid = id;
        this.pfh.setFileId(id);
    }

    public long getFileId() {
        return this.fileid;
    }

    public void setPfh(PacSatFileHeader p) {
        this.pfh = p;
    }

    public void setBytes(byte[] b) {
        this.bytes = b;
    }

    public PacSatFileHeader getPfh(SpacecraftSettings spacecraftSettings) {
        if (this.pfh == null) {
            this.pfh = spacecraftSettings.directory.getPfhById(this.fileid);
        }
        return this.pfh;
    }

    public long getActualLength() {
        File file = new File(this.filename);
        long actualSize = file.length();
        return actualSize;
    }

    private String makeActFileName() {
        return String.valueOf(this.directory) + File.separator + Long.toHexString(this.fileid) + ".act";
    }

    public String getFileName() {
        return this.filename;
    }

    public String getHolFileName() {
        return String.valueOf(this.filename) + ".hol";
    }

    public SortedArrayList<FileHole> getHolesList() {
        if (this.holes == null) {
            return null;
        }
        if (this.holes.size() == 1 && ((FileHole)this.holes.get(0)).getFirst() == 0L) {
            return null;
        }
        return this.holes;
    }

    public boolean addFrame(SpacecraftSettings spacecraftSettings, BroadcastFileFrame bf) throws IOException {
        this.saveFrame(bf);
        this.updateHoles(spacecraftSettings, bf);
        return this.finalHoleCheck();
    }

    public boolean addFrame(SpacecraftSettings spacecraftSettings, BroadcastDirFrame dir) throws IOException {
        this.saveFrame(dir);
        this.updateHoles(spacecraftSettings, dir);
        return this.finalHoleCheck();
    }

    private void updateHoles(SpacecraftSettings spacecraftSettings, BroadCastFrame fragment) {
        if (this.getPfh(spacecraftSettings) != null && (this.pfh.state == 2 || this.pfh.state == 3)) {
            return;
        }
        if (this.holes == null) {
            this.holes = new SortedArrayList();
            this.holes.add(new FileHole(0L, 0xFFFFFFL));
        }
        SortedArrayList<FileHole> newHoles = new SortedArrayList<FileHole>();
        for (FileHole hole : this.holes) {
            FileHole newHole;
            if (fragment.getFirst() > hole.getLast()) {
                newHoles.add(hole);
                continue;
            }
            if (fragment.getLast() < hole.getFirst()) {
                newHoles.add(hole);
                continue;
            }
            if (fragment.getFirst() > hole.getFirst()) {
                newHole = new FileHole(hole.getFirst(), fragment.getFirst() - 1L);
                newHoles.add(newHole);
            }
            if (fragment.getLast() >= hole.getLast()) continue;
            newHole = new FileHole(fragment.getLast() + 1L, hole.getLast());
            newHoles.add(newHole);
        }
        this.holes = newHoles;
        try {
            this.saveHoleList();
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Could not write hole file to disk: " + this.filename + ".hol\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean finalHoleCheck() {
        PacSatFileHeader filePfh;
        if (this.pfh != null && (this.pfh.state == 2 || this.pfh.state == 3)) {
            return true;
        }
        try {
            filePfh = this.loadPfh();
        }
        catch (MalformedPfhException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        if (this.pfh != null && filePfh != null && filePfh.getFieldById(4) != null) {
            long len = filePfh.getFieldById(4).getLongValue();
            if (this.holes.size() > 0 && ((FileHole)this.holes.get(this.holes.size() - 1)).getFirst() == len) {
                this.holes.remove(this.holes.size() - 1);
            }
        }
        if (this.holes != null && this.holes.size() == 0) {
            File holeFile = new File(this.getHolFileName());
            holeFile.delete();
            return true;
        }
        return false;
    }

    private void saveHoleList() throws IOException {
        FileOutputStream fileOut = null;
        ObjectOutputStream objectOut = null;
        try {
            fileOut = new FileOutputStream(this.getHolFileName());
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(this.holes);
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (Exception exception) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadHoleList() throws IOException, ClassNotFoundException {
        ObjectInputStream objectIn = null;
        FileInputStream streamIn = null;
        try {
            streamIn = new FileInputStream(this.getHolFileName());
            objectIn = new ObjectInputStream(streamIn);
            this.holes = (SortedArrayList)objectIn.readObject();
        }
        finally {
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (Exception exception) {}
            }
            if (streamIn != null) {
                try {
                    streamIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getNumOfHoles() {
        if (this.holes == null) {
            return 0;
        }
        return this.holes.size();
    }

    public String getHoleListString() {
        if (this.holes == null) {
            return "";
        }
        String s = "";
        for (FileHole hole : this.holes) {
            s = String.valueOf(s) + hole + "\n";
        }
        return s;
    }

    public long getHolesSize(SpacecraftSettings spcacecraftSettings) {
        this.pfh = this.getPfh(spcacecraftSettings);
        long l = 0L;
        if (this.holes == null) {
            return 0L;
        }
        for (FileHole hole : this.holes) {
            if (hole.getLast() >= this.pfh.getFieldById(4).getLongValue()) continue;
            l += (long)hole.length;
        }
        return l;
    }

    private void saveFrame(BroadcastFileFrame bf) throws IOException {
        try {
            this.fileOnDisk = new RandomAccessFile(this.getFileName(), "rw");
            int j = 0;
            byte[] by = new byte[bf.data.length];
            int[] nArray = bf.data;
            int n = bf.data.length;
            int n2 = 0;
            while (n2 < n) {
                int i2 = nArray[n2];
                by[j++] = (byte)i2;
                ++n2;
            }
            this.fileOnDisk.seek(bf.offset);
            this.fileOnDisk.write(by);
        }
        finally {
            this.fileOnDisk.close();
        }
    }

    private void saveFrame(BroadcastDirFrame bf) throws IOException {
        try {
            this.fileOnDisk = new RandomAccessFile(this.getFileName(), "rw");
            int j = 0;
            byte[] by = new byte[bf.getDataBytes().length];
            int[] nArray = bf.getDataBytes();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i2 = nArray[n2];
                by[j++] = (byte)i2;
                ++n2;
            }
            this.fileOnDisk.seek(bf.getOffset());
            this.fileOnDisk.write(by);
        }
        finally {
            this.fileOnDisk.close();
        }
    }

    public int[] getData() {
        this.bytes = this.getBytes();
        return this.getData(this.bytes);
    }

    public int[] getData(byte[] bytes) {
        int[] data = new int[bytes.length];
        int i2 = 0;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            data[i2++] = b & 0xFF;
            ++n2;
        }
        return data;
    }

    public byte[] getBytes() {
        byte[] b = null;
        PacSatFileHeader pfh = this.getPfh(this.spacecraftSettings);
        if (pfh != null) {
            long fileSize = pfh.getFieldById(4).getLongValue();
            long offset = pfh.getFieldById(11).getLongValue();
            int dataLength = (int)(fileSize - offset);
            b = new byte[dataLength];
            boolean p = false;
            try {
                try {
                    this.fileOnDisk = new RandomAccessFile(this.getFileName(), "r");
                    this.fileOnDisk.seek(pfh.getFieldById(11).getLongValue());
                    this.fileOnDisk.read(b);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (this.fileOnDisk != null) {
                            this.fileOnDisk.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (this.fileOnDisk != null) {
                        this.fileOnDisk.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return b;
    }

    public File decompress(String folder) throws IOException {
        File file = this.extractUserFile(folder);
        if (file == null) {
            file = this.extractSystemFile(folder);
        }
        if (this.pfh.getFieldById(25) != null) {
            int compressedBy = (int)this.pfh.getFieldById(25).getLongValue();
            if (compressedBy == 2) {
                if (file != null) {
                    File destDir = new File(String.valueOf(folder) + File.separator + this.pfh.getHexFileId());
                    if (!destDir.isDirectory() && !destDir.mkdir()) {
                        return null;
                    }
                    UnzipFile unzippedFile = new UnzipFile(file, destDir);
                    return destDir;
                }
                Log.errorDialog("ERROR", "Could not decompress file ID: " + this.pfh.getHexFileId());
                return null;
            }
        } else {
            return null;
        }
        return null;
    }

    public File extractUserFile(String folder) throws IOException {
        PacSatField field = this.pfh.getFieldById(38);
        File file = null;
        if (field != null) {
            file = new File(String.valueOf(folder) + File.separator + Long.toHexString(this.fileid) + "-" + field.getStringValue());
            RandomAccessFile saveFile = new RandomAccessFile(file, "rw");
            saveFile.write(this.getBytes());
        }
        return file;
    }

    public File extractSystemFile(String folder) throws IOException {
        PacSatField field = this.pfh.getFieldById(2);
        File file = null;
        if (field != null) {
            file = new File(String.valueOf(folder) + File.separator + Long.toHexString(this.fileid) + "-" + field.getStringValue());
            RandomAccessFile saveFile = new RandomAccessFile(file, "rw");
            saveFile.write(this.getBytes());
        }
        return file;
    }

    public File extractSystemFileByUserFilename(String folder) throws IOException {
        PacSatField field = this.pfh.getFieldById(38);
        File file = null;
        if (field != null) {
            file = new File(String.valueOf(folder) + File.separator + Long.toHexString(this.fileid) + "-" + field.getStringValue());
            RandomAccessFile saveFile = new RandomAccessFile(file, "rw");
            saveFile.write(this.getBytes());
        }
        return file;
    }

    public PacSatFileHeader loadPfh() throws MalformedPfhException, IOException {
        PacSatFileHeader pfh = null;
        try {
            this.fileOnDisk = new RandomAccessFile(this.getFileName(), "r");
            pfh = new PacSatFileHeader(this.fileOnDisk);
        }
        finally {
            try {
                if (this.fileOnDisk != null) {
                    this.fileOnDisk.close();
                }
            }
            catch (IOException iOException) {}
        }
        return pfh;
    }

    public long lastModified() {
        File file = new File(this.getFileName());
        return file.lastModified();
    }

    public void loadFile() throws MalformedPfhException, IOException {
        this.pfh = this.loadPfh();
        this.bytes = this.getBytes();
    }

    public void save() {
        File file = new File(this.getFileName());
        if (file != null) {
            FileOutputStream saveFile = null;
            try {
                try {
                    saveFile = new FileOutputStream(file);
                    int j = 0;
                    byte[] by = new byte[this.pfh.getBytes().length + this.bytes.length];
                    Object[] objectArray = this.pfh.getBytes();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i2 = objectArray[n2];
                        by[j++] = (byte)i2;
                        ++n2;
                    }
                    objectArray = this.bytes;
                    n = this.bytes.length;
                    n2 = 0;
                    while (n2 < n) {
                        int b = objectArray[n2];
                        by[j++] = b;
                        ++n2;
                    }
                    saveFile.write(by);
                }
                catch (FileNotFoundException e) {
                    Log.errorDialog("ERROR", "Error with file name: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    try {
                        saveFile.close();
                    }
                    catch (Exception exception) {}
                }
                catch (IOException e) {
                    Log.errorDialog("ERROR", "Error writing file: " + file.getAbsolutePath() + "\n" + e.getMessage());
                    try {
                        saveFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    saveFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

