/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import ax25.Ax25Frame;
import ax25.KissFrame;
import fileStore.MalformedPfhException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PacSatField
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DateFormat dateFormat = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);
    public static final DateFormat dateFormatSecs = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);
    public int id;
    public int length;
    int[] data;

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormatSecs.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public PacSatField(String str, int id) {
        this.id = id;
        this.length = str.length();
        this.data = new int[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            this.data[i2] = str.charAt(i2);
            ++i2;
        }
    }

    public PacSatField(int[] bytes, int id) {
        this.id = id;
        this.length = bytes.length;
        this.data = new int[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            this.data[i2] = bytes[i2];
            ++i2;
        }
    }

    public PacSatField(Date date, int id) {
        this.id = id;
        this.length = 4;
        this.data = new int[this.length];
        long time = date.getTime() / 1000L;
        int[] bytes = KissFrame.littleEndian4(time);
        int i2 = 0;
        while (i2 < this.length) {
            this.data[i2] = bytes[i2];
            ++i2;
        }
    }

    public PacSatField(byte value, int id) {
        this.id = id;
        this.length = 1;
        this.data = new int[this.length];
        this.data[0] = value & 0xFF;
    }

    public PacSatField(short value, int id) {
        this.id = id;
        this.length = 2;
        this.data = new int[this.length];
        int[] by2 = KissFrame.littleEndian2(value);
        this.data[0] = by2[0];
        this.data[1] = by2[1];
    }

    public PacSatField(int value, int id) {
        this.id = id;
        this.length = 2;
        this.data = new int[this.length];
        int[] by2 = KissFrame.littleEndian2(value);
        this.data[0] = by2[0];
        this.data[1] = by2[1];
    }

    public PacSatField(long value, int id) {
        this.id = id;
        this.length = 4;
        this.data = new int[this.length];
        int[] by2 = KissFrame.littleEndian4(value);
        this.data[0] = by2[0];
        this.data[1] = by2[1];
        this.data[2] = by2[2];
        this.data[3] = by2[3];
    }

    public PacSatField(int p, int[] bytes) throws MalformedPfhException {
        if (p + 2 > bytes.length) {
            throw new MalformedPfhException("Id Field past end of PFH");
        }
        int[] by = new int[]{bytes[p], bytes[p + 1]};
        this.id = KissFrame.getIntFromBytes(by);
        if (this.id == 0) {
            return;
        }
        if (p + 3 > bytes.length) {
            this.length = 0;
            this.id = 0;
            return;
        }
        this.length = bytes[p + 2];
        if (this.length + p + 3 > bytes.length) {
            this.length = 0;
            this.id = 0;
            return;
        }
        this.data = new int[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            this.data[i2] = bytes[i2 + p + 3] & 0xFF;
            ++i2;
        }
    }

    public void copyFrom(PacSatField pf) {
        this.id = pf.id;
        this.length = pf.length;
        this.data = new int[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            this.data[i2] = pf.data[i2];
            ++i2;
        }
    }

    boolean isNull() {
        return this.id == 0 && this.length == 0;
    }

    public static String getDateString(Date date) {
        String s = "";
        try {
            s = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String getDateStringSecs(Date date) {
        String s = "";
        try {
            s = dateFormatSecs.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public String getStringValue() {
        String fileName = "";
        int i2 = 0;
        while (i2 < this.length) {
            if (Ax25Frame.isPrintableChar((char)this.data[i2])) {
                fileName = String.valueOf(fileName) + (char)this.data[i2];
            }
            ++i2;
        }
        return fileName;
    }

    public long getLongValue() {
        long value = 0L;
        int i2 = 0;
        while (i2 < this.length) {
            value += ((long)this.data[i2] & 0xFFL) << 8 * i2;
            ++i2;
        }
        return value;
    }

    public Date getDateValue() {
        long time = this.getLongValue();
        Date crDate = new Date(time * 1000L);
        return crDate;
    }

    public String getDateString() {
        Date d = this.getDateValue();
        if (d == null) {
            return "";
        }
        String s = "";
        try {
            s = dateFormat.format(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public String getLongString() {
        return "" + (this.getLongValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public String getLongHexString() {
        return Long.toHexString(this.getLongValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public int[] getBytes() {
        int[] bytes = new int[3 + this.data.length];
        int[] by = KissFrame.littleEndian2(this.id);
        bytes[0] = by[0];
        bytes[1] = by[1];
        bytes[2] = this.length;
        int i2 = 0;
        while (i2 < this.data.length) {
            bytes[3 + i2] = this.data[i2];
            ++i2;
        }
        return bytes;
    }

    public String toString() {
        String s = Integer.toHexString(this.id & 0xFF) + " " + this.length;
        int i2 = 0;
        while (i2 < this.length) {
            s = String.valueOf(s) + " " + Integer.toHexString(this.data[i2] & 0xFF);
            ++i2;
        }
        s = String.valueOf(s) + " | ";
        i2 = 0;
        while (i2 < this.length) {
            if (Ax25Frame.isPrintableChar((char)this.data[i2])) {
                s = String.valueOf(s) + (char)this.data[i2];
            }
            ++i2;
        }
        return s;
    }

    public static void main(String[] args) {
        int[] by;
        String title = "12346";
        if (title.length() > 5) {
            title = title.substring(0, 5);
        }
        PacSatField pf = new PacSatField(title, 2);
        System.out.println(pf);
        int[] nArray = by = pf.getBytes();
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            System.out.print(String.valueOf(Integer.toHexString(i2)) + " ");
            ++n2;
        }
        System.out.println();
    }
}

