/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.Directory;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Outbox {
    String dirFolder;
    File lastModifiedFile;
    SpacecraftSettings spacecraftSettings;

    public Outbox(SpacecraftSettings spacecraftSettings, String satname) {
        this.spacecraftSettings = spacecraftSettings;
        this.dirFolder = String.valueOf(Config.get("logfile_dir")) + File.separator + satname;
    }

    public File getNextFile() {
        return this.lastModifiedFile;
    }

    public File getLastModifiedFile() {
        File dir = new File(this.dirFolder);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        File lastModifiedFile = files[0];
        int i2 = 1;
        while (i2 < files.length) {
            if (this.isOutFile(files[i2])) {
                if (!this.isOutFile(lastModifiedFile)) {
                    lastModifiedFile = files[i2];
                } else if (lastModifiedFile.lastModified() > files[i2].lastModified()) {
                    lastModifiedFile = files[i2];
                }
            }
            ++i2;
        }
        if (!this.isOutFile(lastModifiedFile)) {
            return null;
        }
        return lastModifiedFile;
    }

    boolean isOutFile(File file) {
        return file.isFile() && file.getName().endsWith(".out");
    }

    boolean isOutboxFile(File file) {
        return file.isFile() && file.getName().endsWith("out") || file.getName().endsWith("outtmp") || file.getName().endsWith("err") || file.getName().endsWith("ul");
    }

    public String[][] getTableData() {
        this.lastModifiedFile = this.getLastModifiedFile();
        ArrayList<PacSatFileHeader> files = new ArrayList<PacSatFileHeader>();
        ArrayList<String> filenames = new ArrayList<String>();
        File folder = new File(this.dirFolder);
        File[] targetFiles = folder.listFiles();
        try {
            Arrays.sort(targetFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
        }
        catch (IllegalArgumentException e) {
            Log.println("ERROR - while sorting: " + e);
        }
        boolean found = false;
        if (targetFiles != null) {
            int i2 = 0;
            while (i2 < targetFiles.length) {
                if (this.isOutboxFile(targetFiles[i2])) {
                    PacSatFile psf = null;
                    try {
                        psf = new PacSatFile(this.spacecraftSettings, targetFiles[i2].getPath());
                    }
                    catch (MalformedPfhException e) {
                        Log.println("ERROR: Could not load malformed PFH: " + targetFiles[i2].getPath());
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (IOException e) {
                        Log.println("ERROR: IO Exception with outfile: " + targetFiles[i2].getPath());
                        e.printStackTrace(Log.getWriter());
                    }
                    catch (NullPointerException e) {
                        Log.println("ERROR: Could not load corrupted outfile: " + targetFiles[i2].getPath());
                        e.printStackTrace(Log.getWriter());
                    }
                    if (psf != null) {
                        files.add(psf.pfh);
                        filenames.add(targetFiles[i2].getName());
                    }
                }
                ++i2;
            }
        }
        if (files.size() > 0) {
            String[][] data = new String[files.size()][15];
            int i3 = 0;
            for (PacSatFileHeader pfh : files) {
                PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.dirFolder, pfh.getFileId());
                data[files.size() - 1 - i3++] = pfh.getTableFields();
                long fileSize = pfh.getFieldById(4).getLongValue();
                String filename = (String)filenames.get(i3 - 1);
                data[files.size() - i3][2] = filename.endsWith("ul") ? PacSatFileHeader.states[6] : (filename.endsWith("err") ? PacSatFileHeader.states[7] : (filename.endsWith("outtmp") ? PacSatFileHeader.states[8] : PacSatFileHeader.states[5]));
                data[files.size() - i3][13] = filename;
            }
            return data;
        }
        return null;
    }

    public void delete(File f) throws IOException {
        Directory.remove(f.getPath());
    }
}

