/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import ax25.KissFrame;
import fileStore.HoleLimits;
import java.io.Serializable;

public class FileHole
implements HoleLimits,
Comparable<FileHole>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 5;
    long offset;
    int length;
    int[] bytes = new int[5];
    public static final int MAX_HOLE_LENGTH = 65535;
    public static final long MAX_OFFSET = 0xFFFFFFL;

    public FileHole(long first, long last) {
        this.offset = first;
        this.length = (int)(last - this.offset + 1L);
        this.setBytes();
    }

    @Override
    public long getFirst() {
        return this.offset;
    }

    @Override
    public long getLast() {
        return this.offset + (long)this.length - 1L;
    }

    private void setBytes() {
        int length;
        long offset = this.offset;
        if (offset > 0xFFFFFFL) {
            offset = 0xFFFFFFL;
        }
        if ((length = this.length) > 65535) {
            length = 65535;
        }
        int[] offby = KissFrame.littleEndian4(offset);
        this.bytes[0] = offby[0] & 0xFF;
        this.bytes[1] = offby[1] & 0xFF;
        this.bytes[2] = offby[2] & 0xFF;
        if (length >= 65535) {
            this.bytes[3] = 255;
            this.bytes[4] = 255;
        } else {
            int[] lenby = KissFrame.littleEndian2(length);
            this.bytes[3] = lenby[0] & 0xFF;
            this.bytes[4] = lenby[1] & 0xFF;
        }
    }

    @Override
    public int[] getBytes() {
        this.setBytes();
        return this.bytes;
    }

    @Override
    public int compareTo(FileHole fh) {
        if (this.offset > fh.offset) {
            return 1;
        }
        if (this.offset < fh.offset) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.getFirst()) + " " + this.length;
    }
}

