/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import fileStore.PacSatField;
import java.io.Serializable;

public class DirSelectionCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STRING_OP = 0;
    public static final int NUM_OP = 1;
    public static final String[] FIELDS = new String[]{"To Callsign", "From Callsign", "File Size", "Keywords", "Title", "User Filename", "File Type"};
    public static final int[] OP_TYPE;
    public static final int[] PFHFieldKey;
    public static final int EQ = 0;
    public static final int NE = 1;
    public static final int GT = 2;
    public static final int LT = 3;
    public static final int CONTAINS = 2;
    public static final int EXCLUDES = 3;
    public static final String[] NUMERIC_OPS;
    public static final String[] STRING_OPS;
    int pfhFieldKey;
    String value;
    int opType;
    int operation;

    static {
        int[] nArray = new int[7];
        nArray[2] = 1;
        nArray[6] = 1;
        OP_TYPE = nArray;
        PFHFieldKey = new int[]{20, 16, 4, 35, 34, 38, 8};
        NUMERIC_OPS = new String[]{"=", "!=", ">", "<"};
        STRING_OPS = new String[]{"=", "!=", "contains", "excludes"};
    }

    public DirSelectionCriteria(String field, int opType, int operation, String value) {
        int key;
        this.pfhFieldKey = key = DirSelectionCriteria.getKeyByField(field);
        this.opType = opType;
        this.operation = operation;
        this.value = value.toUpperCase();
    }

    public int getPfhFieldKey() {
        return this.pfhFieldKey;
    }

    public String getField() {
        return DirSelectionCriteria.getFieldByKey(this.pfhFieldKey);
    }

    public boolean matches(PacSatField field) {
        block14: {
            if (this.opType == 1) {
                int val;
                long in;
                block13: {
                    block12: {
                        block11: {
                            try {
                                in = field.getLongValue();
                                val = Integer.parseInt(this.value);
                                if (this.operation != 0 || in != (long)val) break block11;
                                return true;
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (this.operation != 3 || in >= (long)val) break block12;
                        return true;
                    }
                    if (this.operation != 2 || in <= (long)val) break block13;
                    return true;
                }
                if (this.operation == 1 && in != (long)val) {
                    return true;
                }
                break block14;
            }
            String input = field.getStringValue().toUpperCase();
            if (this.operation == 0 && input.equalsIgnoreCase(this.value)) {
                return true;
            }
            if (this.operation == 2 && input.contains(this.value)) {
                return true;
            }
            if (this.operation == 3 && !input.contains(this.value)) {
                return true;
            }
            if (this.operation == 1 && !input.equalsIgnoreCase(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static int getKeyByField(String field) {
        int j = 0;
        String[] stringArray = FIELDS;
        int n = FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equalsIgnoreCase(field)) {
                return PFHFieldKey[j];
            }
            ++j;
            ++n2;
        }
        return 0;
    }

    public static String getFieldByKey(int key) {
        int j = 0;
        int[] nArray = PFHFieldKey;
        int n = PFHFieldKey.length;
        int n2 = 0;
        while (n2 < n) {
            int field = nArray[n2];
            if (field == key) {
                return FIELDS[j];
            }
            ++j;
            ++n2;
        }
        return null;
    }

    public static int getOpTypeByField(String field) {
        int j = 0;
        String[] stringArray = FIELDS;
        int n = FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equalsIgnoreCase(field)) {
                return OP_TYPE[j];
            }
            ++j;
            ++n2;
        }
        return 0;
    }

    public String getHashKey() {
        return this.pfhFieldKey + ":" + this.opType + ":" + this.operation + ":" + this.value;
    }

    public String toString() {
        String s = "";
        String field = DirSelectionCriteria.getFieldByKey(this.pfhFieldKey);
        if (field == null) {
            field = "UNK";
        }
        String op = "x";
        if (this.opType == 0) {
            op = STRING_OPS[this.operation];
        }
        if (this.opType == 1) {
            op = NUMERIC_OPS[this.operation];
        }
        s = String.valueOf(s) + field + " " + op + " " + this.value;
        return s;
    }
}

