/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import ax25.KissFrame;
import fileStore.HoleLimits;
import fileStore.PacSatField;
import java.io.Serializable;
import java.util.Date;

public class DirHole
implements HoleLimits,
Comparable<DirHole>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 8;
    Date fromDate;
    Date toDate;
    long from;
    long to;
    int[] bytes = new int[8];

    public DirHole(Date from, Date to) {
        this.fromDate = from;
        this.from = this.fromDate.getTime() / 1000L;
        this.toDate = to;
        this.to = this.toDate.getTime() / 1000L;
        this.setBytes();
    }

    public DirHole(long from, long to) {
        this.from = from;
        this.to = to;
        this.setBytes();
    }

    public DirHole(int[] data) {
        this.bytes = data;
        int[] by2 = new int[]{this.bytes[0], this.bytes[1], this.bytes[2], this.bytes[3]};
        this.from = KissFrame.getLongFromBytes(by2);
        int[] by3 = new int[]{this.bytes[4], this.bytes[5], this.bytes[6], this.bytes[7]};
        this.to = KissFrame.getLongFromBytes(by3);
    }

    private void setBytes() {
        int[] fromby = KissFrame.littleEndian4(this.from);
        this.bytes[0] = fromby[0] & 0xFF;
        this.bytes[1] = fromby[1] & 0xFF;
        this.bytes[2] = fromby[2] & 0xFF;
        this.bytes[3] = fromby[3] & 0xFF;
        int[] toby = KissFrame.littleEndian4(this.to);
        this.bytes[4] = toby[0] & 0xFF;
        this.bytes[5] = toby[1] & 0xFF;
        this.bytes[6] = toby[2] & 0xFF;
        this.bytes[7] = toby[3] & 0xFF;
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public long getFirst() {
        return this.from;
    }

    @Override
    public long getLast() {
        return this.to;
    }

    public Date getFirstDate() {
        return new Date(this.from * 1000L);
    }

    public Date getLastDate() {
        return new Date(this.to * 1000L);
    }

    @Override
    public int compareTo(DirHole o) {
        if (this.from > o.from) {
            return -1;
        }
        if (this.from < o.from) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        Date fDate = new Date(this.from * 1000L);
        Date tDate = new Date(this.to * 1000L);
        return "Frm: " + PacSatField.getDateString(fDate) + " To: " + PacSatField.getDateString(tDate);
    }

    public static final void main(String[] args) {
        int[] data = new int[]{77, 28, 82, 91, 236, 60, 82, 91};
        int h = 0;
        while (h < data.length) {
            int[] by1 = new int[]{data[h + 0], data[h + 1], data[h + 2], data[h + 3], data[h + 4], data[h + 5], data[h + 6], data[h + 7]};
            DirHole dh1 = new DirHole(by1);
            System.out.println(dh1);
            h += 8;
        }
    }
}

