/*
 * Decompiled with CFR 0.152.
 */
package common;

import com.g0kla.telem.segDb.SatelliteManager;
import com.g0kla.telem.segDb.Spacecraft;
import com.g0kla.telem.segDb.TleFileException;
import com.g0kla.telem.server.STPQueue;
import com.g0kla.telem.server.Sequence;
import common.LayoutLoadException;
import common.Log;
import common.SpacecraftSettings;
import gui.MainWindow;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import pacSatServer.KissStpQueue;
import uk.me.g4dpz.satellite.GroundStationPosition;

public class Config {
    public static Properties properties;
    public static String VERSION_NUM;
    public static String VERSION;
    public static String propertiesFileName;
    public static String homeDir;
    public static String currentDir;
    public static boolean logDirFromPassedParam;
    public static int totalFrames;
    public static final String WINDOWS = "win";
    public static final String MACOS = "mac";
    public static final String LINUX = "lin";
    public static String osName;
    public static String OS;
    public static final Color AMSAT_BLUE;
    public static final Color AMSAT_RED;
    public static final Color PURPLE;
    public static final Color AMSAT_GREEN;
    public static final String NONE = "NONE";
    public static final String DEFAULT_STATION = "NONE";
    public static final String DEFAULT_ALTITUDE = "0";
    public static final String DEFAULT_LATITUDE = "0.0";
    public static final String DEFAULT_LONGITUDE = "0.0";
    public static final String DEFAULT_LOCATOR = "XX00xx";
    public static final String FIRST_RUN = "first_run";
    public static final String GLOBAL = "global";
    public static final String LOGFILE_DIR = "logfile_dir";
    public static final String LOGGING = "logging";
    public static final String ECHO_TO_STDOUT = "echo_to_stdout";
    public static final String KISS_LOGGING = "kiss_logging";
    public static final String USE_NATIVE_FILE_CHOOSER = "use_native_file_chooser";
    public static final String CALLSIGN = "callsign";
    public static final String DEFAULT_CALLSIGN = "NONE";
    public static final String NO_COM_PORT = "NONE";
    public static final String TNC_COM_PORT = "COM_PORT";
    public static final String TNC_BAUD_RATE = "TNC_BAUD_RATE";
    public static final String TNC_DATA_BITS = "TNC_DATA_BITS";
    public static final String TNC_STOP_BITS = "TNC_STOP_BITS";
    public static final String TNC_PARITY = "TNC_PARITY";
    public static final String TNC_TCP_PORT = "tnc_tcp_port";
    public static final String TNC_TCP_HOSTNAME = "tnc_tcp_hostname";
    public static final String TNC_TX_DELAY = "TNC_TX_DELAY";
    public static final String DEBUG_LAYER2 = "DEBUG_LAYER2";
    public static final String DEBUG_LAYER3 = "DEBUG_LAYER3";
    public static final String DEBUG_DOWNLINK = "DEBUG_DOWNLINK";
    public static final String DEBUG_TELEM = "DEBUG_TELEM";
    public static final String DEBUG_TX = "DEBUG_TX";
    public static final String IGNORE_UA_PF = "ignore_ua_pf";
    public static final String UPLINK_ENABLED = "uplink_enabled";
    public static final String DOWNLINK_ENABLED = "downlink_enabled";
    public static final String KISS_TCP_INTERFACE = "kiss_tcp_interface";
    public static final String TX_INHIBIT = "tx_inhibit";
    public static final String SEND_TO_SERVER = "send_to_server";
    public static final String TELEM_SERVER = "telem_server";
    public static final String TELEM_SERVER_PORT = "telem_server_port";
    public static final String MAIDENHEAD_LOC = "maidenhead_loc";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ALTITUDE = "altitude";
    public static final String STATION_DETAILS = "station_details";
    public static final String TOGGLE_KISS = "toggle_kiss";
    public static final String DEBUG_EVENTS = "DEBUG_EVENTS";
    public static final String KISS_BYTES_AT_START = "kiss_bytes_at_start";
    public static final String KISS_BYTES_AT_END = "kiss_bytes_at_end";
    public static final String EDIT_KISS_BYTES = "edit_kiss_bytes";
    public static final String KEEP_CARET_AT_END_OF_LOG = "keep_caret_at_end_of_log";
    public static final String SEND_USER_DEFINED_TNC_BYTES = "send_user_defined_tnc_bytes";
    public static final String ARCHIVE_DIR = "archive_dir";
    public static final String FONT_SIZE = "font_size";
    public static final String SHOW_DIR_TIMES = "SHOW_DIR_TIMES";
    public static boolean logging;
    public static SatelliteManager satManager;
    public static ArrayList<SpacecraftSettings> spacecraftSettings;
    public static MainWindow mainWindow;
    public static STPQueue stpQueue;
    public static Thread stpThread;
    public static Sequence sequence;

    static {
        VERSION_NUM = "0.46o";
        VERSION = String.valueOf(VERSION_NUM) + " - 13 Jan 2026";
        propertiesFileName = "PacSatGround.properties";
        homeDir = "";
        currentDir = "";
        logDirFromPassedParam = false;
        totalFrames = 0;
        osName = "Unknown OS";
        OS = WINDOWS;
        AMSAT_BLUE = new Color(0, 0, 116);
        AMSAT_RED = new Color(224, 0, 0);
        PURPLE = new Color(123, 6, 130);
        AMSAT_GREEN = new Color(0, 102, 0);
        logging = true;
    }

    public static void init(String file) {
        propertiesFileName = file;
        osName = System.getProperty("os.name").toLowerCase();
        Config.setOs();
        properties = new Properties();
        Config.set(FIRST_RUN, true);
        Config.set(LOGFILE_DIR, "");
        Config.set(LOGGING, false);
        Config.set(ECHO_TO_STDOUT, false);
        Config.set(USE_NATIVE_FILE_CHOOSER, true);
        Config.set(CALLSIGN, "NONE");
        Config.set(TNC_COM_PORT, "NONE");
        Config.set(TNC_BAUD_RATE, 9600);
        Config.set(TNC_DATA_BITS, 8);
        Config.set(TNC_STOP_BITS, 1);
        Config.set(TNC_PARITY, 0);
        Config.set(TNC_TX_DELAY, 130);
        Config.set(KISS_LOGGING, false);
        Config.set(DEBUG_LAYER2, false);
        Config.set(DEBUG_LAYER3, false);
        Config.set(DEBUG_DOWNLINK, false);
        Config.set(DEBUG_TX, false);
        Config.set(IGNORE_UA_PF, true);
        Config.set(UPLINK_ENABLED, true);
        Config.set(DOWNLINK_ENABLED, true);
        Config.set(TNC_TCP_HOSTNAME, "127.0.0.1");
        Config.set(TNC_TCP_PORT, 8100);
        Config.set(KISS_TCP_INTERFACE, true);
        Config.set(DEBUG_TELEM, false);
        Config.set(TX_INHIBIT, false);
        Config.set(SEND_TO_SERVER, false);
        Config.set(TELEM_SERVER, "tlm.amsatfox.org");
        Config.set(TELEM_SERVER_PORT, 41041);
        Config.set(MAIDENHEAD_LOC, DEFAULT_LOCATOR);
        Config.set(ALTITUDE, DEFAULT_ALTITUDE);
        Config.set(LONGITUDE, "0.0");
        Config.set(LATITUDE, "0.0");
        Config.set(STATION_DETAILS, "NONE");
        Config.set(TOGGLE_KISS, true);
        Config.set(DEBUG_EVENTS, false);
        Config.set(KISS_BYTES_AT_START, "4B 49 53 53 20 4F 4E 0D 52 45 53 54 41 52 54 0D");
        Config.set(KISS_BYTES_AT_END, "C0 FF C0");
        Config.set(EDIT_KISS_BYTES, false);
        Config.set(KEEP_CARET_AT_END_OF_LOG, true);
        Config.set(SEND_USER_DEFINED_TNC_BYTES, false);
        Config.set(ARCHIVE_DIR, "");
        Config.set(FONT_SIZE, 0);
    }

    public static void load() {
        Config.loadFile();
    }

    public static boolean missing() {
        File aFile = new File(String.valueOf(homeDir) + File.separator + propertiesFileName);
        return !aFile.exists();
    }

    public static void setHome() {
        File aFile = new File(homeDir);
        if (!aFile.isDirectory()) {
            aFile.mkdir();
        }
        if (!aFile.isDirectory()) {
            Log.errorDialog("ERROR", "ERROR can't create the directory: " + aFile.getAbsolutePath() + "\nFoxTelem needs to save the program settings.  The directory is either not accessible or not writable\n");
        }
    }

    private static void addSpacecraftProperties(String filename) {
        File masterFile = new File(String.valueOf(currentDir) + File.separator + "spacecraft" + File.separator + filename);
        if (!masterFile.exists()) {
            Log.println("Skipping spacecraft.  Could not find: " + masterFile.getPath());
            return;
        }
        try {
            File satFile = new File(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + "spacecraft" + File.separator + filename);
            if (satFile.exists()) {
                if (satFile.lastModified() < masterFile.lastModified()) {
                    Date targetDate = new Date(satFile.lastModified());
                    Date masterDate = new Date(masterFile.lastModified());
                    int n = Log.optionYNdialog("Overwrite Existing spacecraft config file", "There is a newer spacecraft file available in the installation directory. You should replace your local file.\nLocal changes you have made to the spacecraft will be lost.\nExisting File (" + targetDate + "): " + satFile.getPath() + "\nwill be replaced with\n" + "Master Copy (" + masterDate + "): " + masterFile.getPath());
                    if (n == 1) {
                        Log.println("Leaving existing spacecraft file: " + satFile.getName());
                    } else {
                        Log.println("Copying spacecraft file: " + masterFile.getName() + " to " + satFile.getName());
                        if (!Config.copyFile(masterFile, satFile)) {
                            Log.errorDialog("FATAL", "Could not install: " + masterFile.getPath() + "\ninto: " + Config.get(LOGFILE_DIR) + File.separator + "spacecraft");
                            System.exit(1);
                        }
                    }
                }
            } else if (!Config.copyFile(masterFile, satFile)) {
                Log.errorDialog("FATAL", "Could not install: " + masterFile.getPath() + "\ninto: " + Config.get(LOGFILE_DIR) + File.separator + "spacecraft");
                System.exit(1);
            }
            SpacecraftSettings sat = new SpacecraftSettings(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + "spacecraft" + File.separator + filename);
            spacecraftSettings.add(sat);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL ERROR", e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            Log.errorDialog("FATAL ERROR", "Spacecraft file " + filename + " can not be processed: " + e.getMessage());
            System.exit(1);
        }
    }

    public static SpacecraftSettings getSatSettingsByName(String name) {
        for (SpacecraftSettings satSettings : spacecraftSettings) {
            if (!satSettings.name.equalsIgnoreCase(name)) continue;
            return satSettings;
        }
        return null;
    }

    public static SpacecraftSettings getSatSettingsByCallsign(String call) {
        for (SpacecraftSettings satSettings : spacecraftSettings) {
            if (!satSettings.hasCallsign(call)) continue;
            return satSettings;
        }
        return null;
    }

    public static void simpleStart() throws com.g0kla.telem.data.LayoutLoadException, IOException {
        spacecraftSettings = new ArrayList();
        satManager = new SatelliteManager(false, String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + "spacecraft");
        File installedSatFolder = new File(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + "spacecraft");
        File[] listOfFiles = installedSatFolder.listFiles();
        if (listOfFiles != null) {
            int i2 = 0;
            while (i2 < listOfFiles.length) {
                if (listOfFiles[i2].isFile() && listOfFiles[i2].getName().endsWith(".properties") && !listOfFiles[i2].getName().startsWith("PacSatGround") && !listOfFiles[i2].getName().startsWith("PacSatServer")) {
                    System.out.println("Checking spacecraft file: " + listOfFiles[i2].getName());
                    Config.addSpacecraftProperties(listOfFiles[i2].getName());
                }
                ++i2;
            }
        }
        for (SpacecraftSettings satSettings : spacecraftSettings) {
            try {
                satManager.fetchTLEFile(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + satSettings.name);
            }
            catch (Exception e) {
                Log.println("ERROR: " + e.getMessage());
            }
            try {
                satSettings.spacecraft = new Spacecraft(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + satSettings.name, new File(String.valueOf(currentDir) + File.separator + "spacecraft" + File.separator + satSettings.get("telemLayoutFile")));
            }
            catch (IOException e1) {
                Log.errorDialog("FATAL ERROR", "Spacecraft file could not be loaded: spacecraft" + File.separator + satSettings.get("telemLayoutFile") + "\n" + e1.getMessage());
                System.exit(1);
            }
            try {
                satSettings.spacecraft.loadTleHistory();
            }
            catch (TleFileException tleFileException) {
                // empty catch block
            }
            satManager.add(satSettings.spacecraft);
            satSettings.initSegDb(satSettings.spacecraft);
        }
    }

    public static void start() throws com.g0kla.telem.data.LayoutLoadException, IOException {
        Config.simpleStart();
        for (SpacecraftSettings satSettings : spacecraftSettings) {
            Config.storeGroundStation(satSettings.spacecraft);
        }
        stpQueue = new KissStpQueue(String.valueOf(Config.get(LOGFILE_DIR)) + File.separator + "stp.dat", Config.get(TELEM_SERVER), Config.getInt(TELEM_SERVER_PORT));
        stpThread = new Thread(stpQueue);
        stpThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        stpThread.setName("STP Queue");
        stpThread.start();
        sequence = new Sequence(Config.get(LOGFILE_DIR));
    }

    public static void storeGroundStation(Spacecraft spacecraft) {
        GroundStationPosition pos;
        int h = 0;
        try {
            if (Config.get(ALTITUDE).equalsIgnoreCase("NONE")) {
                Config.set(ALTITUDE, DEFAULT_ALTITUDE);
                h = 0;
            } else {
                h = Integer.parseInt(Config.get(ALTITUDE));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            float lat = Float.parseFloat(Config.get(LATITUDE));
            float lon = Float.parseFloat(Config.get(LONGITUDE));
            pos = new GroundStationPosition(lat, lon, h);
        }
        catch (NumberFormatException e) {
            pos = new GroundStationPosition(0.0, 0.0, 0.0);
        }
        spacecraft.setGroundStationPosition(pos);
    }

    public static void close() {
        for (SpacecraftSettings sat : spacecraftSettings) {
            sat.close();
        }
    }

    private static void setOs() {
        OS = osName.indexOf(WINDOWS) >= 0 ? WINDOWS : (osName.indexOf(MACOS) >= 0 ? MACOS : LINUX);
    }

    public static boolean isWindowsOs() {
        return OS == WINDOWS;
    }

    public static boolean isLinuxOs() {
        return OS == LINUX;
    }

    public static boolean isMacOs() {
        return OS == MACOS;
    }

    public static void set(String key, String value) {
        properties.setProperty(key, value);
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    public static void set(String sat, String fieldName, String key, String value) {
        properties.setProperty(String.valueOf(sat) + fieldName + key, value);
    }

    public static String get(String sat, String fieldName, String key) {
        return properties.getProperty(String.valueOf(sat) + fieldName + key);
    }

    public static void set(String key, int value) {
        properties.setProperty(key, Integer.toString(value));
    }

    public static void set(String sat, String fieldName, String key, int value) {
        properties.setProperty(String.valueOf(sat) + fieldName + key, Integer.toString(value));
    }

    public static void set(String sat, String fieldName, String key, long value) {
        properties.setProperty(String.valueOf(sat) + fieldName + key, Long.toString(value));
    }

    public static void set(String key, boolean value) {
        properties.setProperty(key, Boolean.toString(value));
    }

    public static void set(String sat, String fieldName, String key, boolean value) {
        properties.setProperty(String.valueOf(sat) + fieldName + key, Boolean.toString(value));
    }

    public static int getInt(String key) {
        try {
            return Integer.parseInt(properties.getProperty(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int getInt(String sat, String fieldName, String key) {
        try {
            return Integer.parseInt(properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long getLong(String sat, String fieldName, String key) {
        try {
            return Long.parseLong(properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean getBoolean(String key) {
        try {
            return Boolean.parseBoolean(properties.getProperty(key));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean getBoolean(String sat, String fieldName, String key) {
        try {
            return Boolean.parseBoolean(properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double getDouble(String key) {
        try {
            return Double.parseDouble(properties.getProperty(key));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static void save() {
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(homeDir) + File.separator + propertiesFileName);
            properties.store(fos, "PacSat Ground Station Properties");
            fos.close();
        }
        catch (FileNotFoundException e1) {
            Log.errorDialog("ERROR", "Could not write properties file. Check permissions on directory or on the file\n" + homeDir + propertiesFileName);
            e1.printStackTrace(Log.getWriter());
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error writing properties file");
            e1.printStackTrace(Log.getWriter());
        }
    }

    private static void loadFile() {
        try {
            FileInputStream fis = new FileInputStream(String.valueOf(homeDir) + File.separator + propertiesFileName);
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            Config.save();
        }
    }

    private static String getProperty(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static boolean copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            long transferred = ((FileChannel)destination).transferFrom(source, 0L, source.size());
            return transferred == source.size();
            {
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

