/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.data.BitArrayLayout;
import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.EpochTime;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.predict.FoxTLE;
import com.g0kla.telem.predict.PositionCalcException;
import com.g0kla.telem.predict.SortedTleList;
import com.g0kla.telem.segDb.LookUpTable;
import com.g0kla.telem.segDb.SpacecraftPositionCache;
import com.g0kla.telem.segDb.TleFileException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import uk.me.g4dpz.satellite.GroundStationPosition;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class Spacecraft
implements Comparable<Spacecraft> {
    public Properties properties = new Properties();
    public File propertiesFile;
    SpacecraftPositionCache positionCache;
    String dirName;
    String spacecraftLogDir;
    GroundStationPosition position;
    boolean epochUsesT0 = false;
    public static final int ERROR_IDX = -1;
    public static final int EM = 0;
    public static final int FM = 1;
    public static final int FS = 2;
    public static String[] modelNames = new String[]{"Engineering Model", "Flight Model", "Flight Spare"};
    public static String[] models = new String[]{"EM", "FM", "FS"};
    public int satId = 1;
    public int catalogNumber = 0;
    public String name = "";
    public String description = "";
    public int model;
    public int telemetryDownlinkFreqkHz = 145980;
    public int minFreqBoundkHz = 145970;
    public int maxFreqBoundkHz = 145990;
    public boolean layoutsUseBits = false;
    public boolean layoutsUseToCallsignAsType = false;
    public boolean telemetryMSBfirst = true;
    public boolean ihuLittleEndian = true;
    public boolean useResetUptime = false;
    public int numberOfLayouts = 0;
    public String[] layoutFilename;
    public ByteArrayLayout[] layout;
    public int numberOfLookupTables = 0;
    public String[] lookupTableFilename;
    public LookUpTable[] lookupTable;
    public String measurementsFileName;
    public String passMeasurementsFileName;
    public ByteArrayLayout measurementLayout;
    public ByteArrayLayout passMeasurementLayout;
    public static final String MEASUREMENTS = "measurements";
    public static final String PASS_MEASUREMENTS = "passmeasurements";
    public int numberOfFrameLayouts = 1;
    public String[] frameLayoutFilename;
    public boolean track = true;
    public SatPos satPos;
    public double satPosErrorCode;
    private SortedTleList tleList;
    public String conversionCoefficientsFileName;
    public static final DateFormat timeDateFormat = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat dateDateFormat = new SimpleDateFormat("dd MMM yy");

    public Spacecraft(String spacecraftLogDir, File fileName) throws LayoutLoadException, IOException {
        this.propertiesFile = fileName;
        this.dirName = fileName.getParent();
        this.spacecraftLogDir = spacecraftLogDir;
        this.tleList = new SortedTleList(10);
        this.positionCache = new SpacecraftPositionCache(this.satId);
        this.load();
    }

    public void setGroundStationPosition(GroundStationPosition pos) {
        this.position = pos;
    }

    public int getLayoutIdxByName(String name) {
        int i2 = 0;
        while (i2 < this.numberOfLayouts) {
            if (this.layout[i2].name.equalsIgnoreCase(name)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getLookupIdxByName(String name) {
        int i2 = 0;
        while (i2 < this.numberOfLookupTables) {
            if (this.lookupTable[i2].name.equalsIgnoreCase(name)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public ByteArrayLayout getLayoutByName(String name) {
        int i2 = this.getLayoutIdxByName(name);
        if (i2 != -1) {
            return this.layout[i2];
        }
        return null;
    }

    public LookUpTable getLookupTableByName(String name) {
        int i2 = this.getLookupIdxByName(name);
        if (i2 != -1) {
            return this.lookupTable[i2];
        }
        return null;
    }

    public String getLayoutFileNameByName(String name) {
        int i2 = this.getLayoutIdxByName(name);
        if (i2 != -1) {
            return this.layoutFilename[i2];
        }
        return null;
    }

    public String getLookupTableFileNameByName(String name) {
        int i2 = this.getLookupIdxByName(name);
        if (i2 != -1) {
            return this.lookupTableFilename[i2];
        }
        return null;
    }

    public void loadTleHistory() throws TleFileException {
        String file = String.valueOf(this.spacecraftLogDir) + File.separator + this.name + ".tle";
        File f = new File(file);
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(f);
                this.tleList = FoxTLE.importFoxSat(is);
            }
            catch (IOException e) {
                throw new TleFileException("TLE file not loaded: " + file);
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveTleHistory() throws IOException {
        String file = String.valueOf(this.spacecraftLogDir) + File.separator + this.name + ".tle";
        File f = new File(file);
        BufferedWriter output = new BufferedWriter(new FileWriter(f, false));
        for (FoxTLE tle : this.tleList) {
            output.write(tle.toFileString());
        }
        ((Writer)output).flush();
        ((Writer)output).close();
    }

    public boolean addTLE(FoxTLE tle) throws IOException {
        this.tleList.add(tle);
        this.saveTleHistory();
        return true;
    }

    protected TLE getTLEbyDate(DateTime dateTime) throws PositionCalcException {
        if (this.tleList == null) {
            return null;
        }
        FoxTLE t = this.tleList.getTleByDate(dateTime);
        if (t == null) {
            this.satPosErrorCode = -998.0;
            throw new PositionCalcException(-998.0);
        }
        return t;
    }

    public SatPos calcSatellitePosition(DateTime timeNow) throws PositionCalcException {
        TLE tle = this.getTLEbyDate(timeNow);
        if (tle == null) {
            this.satPosErrorCode = -998.0;
            throw new PositionCalcException(-998.0);
        }
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        SatPos satellitePosition = satellite.getPosition(this.position, timeNow.toDate());
        return satellitePosition;
    }

    protected SatPos calcualteCurrentPosition() throws PositionCalcException {
        DateTime timeNow = new DateTime(DateTimeZone.UTC);
        SatPos pos = null;
        this.satPos = pos = this.calcSatellitePosition(timeNow);
        return pos;
    }

    public SatPos getCurrentPosition() throws PositionCalcException {
        if (this.satPos == null) {
            throw new PositionCalcException(-999.0);
        }
        return this.satPos;
    }

    public boolean aboveHorizon() {
        if (this.satPos == null) {
            return false;
        }
        return Spacecraft.radToDeg(this.satPos.getElevation()) >= 0.0;
    }

    protected void load() throws LayoutLoadException, IOException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.propertiesFile);
            this.properties.load(f);
            f.close();
        }
        catch (IOException e) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("Could not load spacecraft files: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            this.satId = Integer.parseInt(this.getProperty("satId"));
            this.catalogNumber = Integer.parseInt(this.getProperty("catalogNumber"));
            this.name = this.getProperty("name");
            this.description = this.getProperty("description");
            this.model = Integer.parseInt(this.getProperty("model"));
            String b = this.getOptionalProperty("layoutsUseBits");
            this.layoutsUseBits = b == null ? false : Boolean.parseBoolean(b);
            String b2 = this.getOptionalProperty("layoutsUseToCallsignAsType");
            this.layoutsUseToCallsignAsType = b2 == null ? false : Boolean.parseBoolean(b);
            b = this.getOptionalProperty("useResetUptime");
            this.useResetUptime = b == null ? false : Boolean.parseBoolean(b);
            this.conversionCoefficientsFileName = this.getProperty("conversionCoefficients");
            this.numberOfLayouts = Integer.parseInt(this.getProperty("numberOfLayouts"));
            this.layoutFilename = new String[this.numberOfLayouts];
            this.layout = this.layoutsUseBits ? new BitArrayLayout[this.numberOfLayouts] : new ByteArrayLayout[this.numberOfLayouts];
            int i2 = 0;
            while (i2 < this.numberOfLayouts) {
                this.layoutFilename[i2] = String.valueOf(this.dirName) + File.separator + this.getProperty("layout" + i2 + ".filename");
                String name = this.getProperty("layout" + i2 + ".name");
                this.layout[i2] = this.layoutsUseBits ? new BitArrayLayout(name, this.layoutFilename[i2]) : new ByteArrayLayout(name, this.layoutFilename[i2]);
                this.layout[i2].name = name;
                this.layout[i2].parentLayout = this.getOptionalProperty("layout" + i2 + ".parentLayout");
                ++i2;
            }
            this.numberOfLookupTables = Integer.parseInt(this.getProperty("numberOfLookupTables"));
            this.lookupTableFilename = new String[this.numberOfLookupTables];
            this.lookupTable = new LookUpTable[this.numberOfLookupTables];
            i2 = 0;
            while (i2 < this.numberOfLookupTables) {
                this.lookupTableFilename[i2] = String.valueOf(this.dirName) + File.separator + this.getProperty("lookupTable" + i2 + ".filename");
                this.lookupTable[i2] = new LookUpTable(this.lookupTableFilename[i2]);
                this.lookupTable[i2].name = this.getProperty("lookupTable" + i2);
                ++i2;
            }
            String t = this.getOptionalProperty("track");
            this.track = t == null ? true : Boolean.parseBoolean(t);
        }
        catch (NoSuchElementException ne) {
            throw new LayoutLoadException("Corrupt data found: " + ne.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (NumberFormatException nf) {
            throw new LayoutLoadException("Corrupt data found: " + nf.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (NullPointerException nf) {
            throw new LayoutLoadException("Missing data value: " + nf.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new LayoutLoadException("File not found: " + e.getMessage() + "\nwhen processing Spacecraft file: " + this.propertiesFile.getAbsolutePath());
        }
    }

    protected String getOptionalProperty(String key) throws LayoutLoadException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return null;
        }
        return value;
    }

    protected String getProperty(String key) throws LayoutLoadException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new LayoutLoadException("Missing data value: " + key + " when loading Spacecraft file: \n" + this.propertiesFile.getAbsolutePath());
        }
        return value;
    }

    protected void store() throws LayoutLoadException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.propertiesFile);
            this.properties.store(new FileOutputStream(this.propertiesFile), "Fox 1 Telemetry Decoder Properties");
            f.close();
        }
        catch (FileNotFoundException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("ERROR Could not write spacecraft file. Check permissions on run directory or on the file");
        }
        catch (IOException e1) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("ERROR writing spacecraft file");
        }
    }

    protected void save() {
        this.properties.setProperty("foxId", Integer.toString(this.satId));
        this.properties.setProperty("catalogNumber", Integer.toString(this.catalogNumber));
        this.properties.setProperty("name", this.name);
        this.properties.setProperty("description", this.description);
        this.properties.setProperty("model", Integer.toString(this.model));
        this.properties.setProperty("telemetryDownlinkFreqkHz", Integer.toString(this.telemetryDownlinkFreqkHz));
        this.properties.setProperty("minFreqBoundkHz", Integer.toString(this.minFreqBoundkHz));
        this.properties.setProperty("maxFreqBoundkHz", Integer.toString(this.maxFreqBoundkHz));
        this.properties.setProperty("maxFreqBoundkHz", Integer.toString(this.maxFreqBoundkHz));
        this.properties.setProperty("track", Boolean.toString(this.track));
    }

    public String getIdString() {
        String id = "??";
        id = Integer.toString(this.satId);
        return id;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Spacecraft s2) {
        return this.name.compareToIgnoreCase(s2.name);
    }

    public boolean hasTimeZero() {
        return false;
    }

    public boolean hasTimeZero(int reset) {
        return false;
    }

    public String[][] getT0TableData() {
        return null;
    }

    public String getUtcTimeForReset(int reset, long uptime) {
        Date dt = null;
        if (!this.epochUsesT0) {
            dt = new Date(uptime * 1000L);
        }
        timeDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = timeDateFormat.format(dt);
        return time;
    }

    public String getUtcDateForReset(int reset, long uptime) {
        Date dt = null;
        if (!this.epochUsesT0) {
            dt = new Date(uptime * 1000L);
        }
        dateDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = dateDateFormat.format(dt);
        return time;
    }

    public Date getUtcForReset(int reset, long uptime) {
        if (!this.epochUsesT0) {
            Date dt = new Date(uptime * 1000L);
            return dt;
        }
        return null;
    }

    public DateTime getUtcDateTimeForReset(int reset, long uptime) {
        if (!this.epochUsesT0) {
            Date dt = new Date(uptime * 1000L);
            DateTime dateTime = new DateTime(dt);
            return dateTime;
        }
        return null;
    }

    public EpochTime getUptimeForUtcDate(Date fromDate) {
        if (!this.epochUsesT0) {
            int reset = 0;
            long uptime = fromDate.getTime() / 1000L;
            EpochTime ft = new EpochTime(reset, uptime);
            return ft;
        }
        return null;
    }

    public SatPos getSatellitePosition(int reset, long uptime) throws PositionCalcException {
        DateTime timeNow = this.getUtcDateTimeForReset(reset, uptime);
        if (timeNow == null) {
            return null;
        }
        SatPos satellitePosition = this.positionCache.getPosition(timeNow.getMillis());
        if (satellitePosition != null) {
            return satellitePosition;
        }
        TLE tle = this.getTLEbyDate(timeNow);
        if (tle == null) {
            throw new PositionCalcException(-998.0);
        }
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        satellitePosition = satellite.getPosition(this.position, timeNow.toDate());
        this.positionCache.storePosition(timeNow.getMillis(), satellitePosition);
        return satellitePosition;
    }

    public static double radToDeg(Double rad) {
        return 180.0 * (rad / Math.PI);
    }

    public static double latRadToDeg(Double rad) {
        return Spacecraft.radToDeg(rad);
    }

    public static double lonRadToDeg(Double rad) {
        double lon = Spacecraft.radToDeg(rad);
        if (lon > 180.0) {
            return lon - 360.0;
        }
        return lon;
    }
}

