/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.data.LayoutLoadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LookUpTable {
    public String name;
    protected Map<Integer, Double> table = new LinkedHashMap<Integer, Double>();

    public LookUpTable() {
    }

    public LookUpTable(String fileName) throws LayoutLoadException, IOException {
        this.load(fileName);
    }

    private double linearInterpolation(double x, double x0, double x1, double y0, double y1) {
        double y = y0 + (y1 - y0) * ((x - x0) / (x1 - x0));
        return y;
    }

    public double lookupValue(int lookUpKey) {
        Iterator<Map.Entry<Integer, Double>> it = this.table.entrySet().iterator();
        double lastValue = 0.0;
        int lastKey = 0;
        double prevValue = 0.0;
        int prevKey = 0;
        Map.Entry<Integer, Double> pairs = null;
        boolean firstKey = true;
        double value = 9.99999999E8;
        while (it.hasNext()) {
            pairs = it.next();
            int key = pairs.getKey();
            value = pairs.getValue();
            if (firstKey) {
                firstKey = false;
                if (lookUpKey < key) {
                    lastKey = key;
                    lastValue = value;
                    pairs = it.next();
                    key = pairs.getKey();
                    value = pairs.getValue();
                    value = this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                    return value;
                }
            }
            if (lookUpKey == key) {
                return value;
            }
            if (lookUpKey < key) {
                value = this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                return value;
            }
            prevKey = lastKey;
            prevValue = lastValue;
            lastKey = key;
            lastValue = value;
        }
        if (pairs != null) {
            value = this.linearInterpolation(lookUpKey, prevKey, lastKey, prevValue, lastValue);
        }
        return value;
    }

    public int reverseLookup(double lookUpKey) {
        Iterator<Map.Entry<Integer, Double>> it = this.table.entrySet().iterator();
        int lastValue = 0;
        double lastKey = 0.0;
        int prevValue = 0;
        double prevKey = 0.0;
        Map.Entry<Integer, Double> pairs = null;
        boolean firstKey = true;
        int value = 999999999;
        while (it.hasNext()) {
            pairs = it.next();
            value = pairs.getKey();
            double key = pairs.getValue();
            if (firstKey) {
                firstKey = false;
                if (lookUpKey < key) {
                    lastKey = key;
                    lastValue = value;
                    pairs = it.next();
                    value = pairs.getKey();
                    key = pairs.getValue();
                    value = (int)this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                    return value;
                }
            }
            if (lookUpKey == key) {
                return value;
            }
            if (lookUpKey < key) {
                value = (int)this.linearInterpolation(lookUpKey, lastKey, pairs.getKey().intValue(), lastValue, pairs.getValue());
                return value;
            }
            prevKey = lastKey;
            prevValue = lastValue;
            lastKey = key;
            lastValue = value;
        }
        if (pairs != null) {
            value = (int)this.linearInterpolation(lookUpKey, prevKey, lastKey, prevValue, lastValue);
        }
        return value;
    }

    protected void load(String fileName) throws LayoutLoadException, IOException {
        fileName = "spacecraft" + File.separator + fileName;
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                int key = Integer.valueOf(st.nextToken());
                double value = Double.valueOf(st.nextToken());
                this.table.put(key, value);
            }
            dis.close();
        }
        catch (NumberFormatException n) {
            throw new LayoutLoadException("NUMBER FORMAT EXCEPTION Loading Lookup table " + fileName + " " + n.getMessage());
        }
        catch (NoSuchElementException n) {
            throw new LayoutLoadException("Missing Field in Lookup table File. Halted loading " + fileName);
        }
    }
}

