/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.segDb.SortedArrayList;
import com.g0kla.telem.segDb.SortedDataRecordArrayList;
import com.g0kla.telem.segDb.TableSeg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.StringTokenizer;

public class DataTable {
    public static final int MAX_DATA_LENGTH = 62;
    public static final int MAX_SEGMENT_SIZE = 1000;
    public static final int RESETS_COL = 0;
    public static final int UPTIME_COL = 1;
    public static final int DATA_COL = 2;
    public static final int LAT_COL = 3;
    public static final int LON_COL = 4;
    private SortedArrayList<TableSeg> tableIdx = new SortedArrayList(2);
    private static final int INITIAL_SIZE = 2;
    private String fileName;
    private String tableName;
    private String dbDir;
    private ByteArrayLayout layout;
    private SortedDataRecordArrayList rtRecords;
    private boolean updated = false;

    public DataTable(int size, String dbDir, ByteArrayLayout layout, String tableName) throws IOException {
        this.tableName = tableName;
        this.layout = layout;
        this.dbDir = dbDir;
        this.fileName = String.valueOf(dbDir) + File.separator + tableName;
        this.rtRecords = new SortedDataRecordArrayList(size);
        this.loadIdx();
        this.updated = true;
    }

    public void setUpdated(boolean t) {
        this.updated = t;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public int getSize() {
        int s = 0;
        for (TableSeg t : this.tableIdx) {
            s += t.records;
        }
        return s;
    }

    public boolean hasFrame(int id, long uptime, int resets) throws IOException, NumberFormatException, DataLoadException {
        TableSeg seg = this.loadSeg(resets, uptime);
        return this.rtRecords.hasFrame(id, uptime, resets);
    }

    public DataRecord getLatest() throws IOException, NumberFormatException, DataLoadException {
        if (this.tableIdx.size() > 0) {
            TableSeg lastSeg = this.tableIdx.get((TableSeg)(this.tableIdx.size() - 1));
            if (!lastSeg.isLoaded()) {
                this.load(lastSeg);
            }
            if (this.rtRecords.size() == 0) {
                return null;
            }
            return (DataRecord)this.rtRecords.get(this.rtRecords.size() - 1);
        }
        return null;
    }

    public DataRecord getFrame(int id, long uptime, int resets, boolean prev) throws IOException, NumberFormatException, DataLoadException {
        TableSeg seg = this.loadSeg(resets, uptime);
        if (seg.records == 0) {
            return null;
        }
        if (prev) {
            int i2 = this.rtRecords.getNearestPrevFrameIndex(id, uptime, resets);
            if (i2 == -1) {
                return null;
            }
            return (DataRecord)this.rtRecords.get(i2);
        }
        int i3 = this.rtRecords.getNearestFrameIndex(id, uptime, resets);
        if (i3 == -1) {
            return null;
        }
        return (DataRecord)this.rtRecords.get(i3);
    }

    public DataRecord getFrame(int id, long uptime, int resets, int type, boolean prev) throws IOException, NumberFormatException, DataLoadException {
        TableSeg seg = this.loadSeg(resets, uptime);
        if (prev) {
            int i2 = this.rtRecords.getNearestPrevFrameIndex(id, uptime, resets, type);
            if (i2 == -1) {
                return null;
            }
            return (DataRecord)this.rtRecords.get(i2);
        }
        int i3 = this.rtRecords.getNearestFrameIndex(id, uptime, resets, type);
        if (i3 == -1) {
            return null;
        }
        return (DataRecord)this.rtRecords.get(i3);
    }

    public String[][] getPayloadData(int period, int id, int fromReset, long fromUptime, int length, boolean reverse) throws IOException, NumberFormatException, LayoutLoadException, DataLoadException {
        return this.getPayloadData(period, id, fromReset, fromUptime, length, false, reverse);
    }

    public String[][] getPayloadData(int period, int id, int fromReset, long fromUptime, int length, boolean returnType, boolean reverse) throws IOException, NumberFormatException, LayoutLoadException, DataLoadException {
        if (this.rtRecords == null) {
            return null;
        }
        this.loadSegments(fromReset, fromUptime, period, reverse);
        int start = 0;
        int end = 0;
        if (reverse) {
            start = this.rtRecords.size() - period;
            end = this.rtRecords.size();
        } else {
            start = this.rtRecords.getNearestFrameIndex(id, fromUptime, fromReset);
            if (start == -1) {
                start = this.rtRecords.size() - period;
            }
            end = start + period;
        }
        if (end > this.rtRecords.size()) {
            end = this.rtRecords.size();
        }
        if (end < start) {
            end = start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.rtRecords.size()) {
            start = this.rtRecords.size();
        }
        int[][] results = new int[end - start][];
        String[] upTime = new String[end - start];
        String[] resets = new String[end - start];
        String[] type = null;
        if (returnType) {
            type = new String[end - start];
        }
        int j = results.length - 1;
        int i2 = end - 1;
        while (i2 >= start) {
            results[j] = ((DataRecord)this.rtRecords.get(i2)).fieldValue;
            if (returnType) {
                type[j] = "" + ((DataRecord)this.rtRecords.get(i2)).type;
            }
            upTime[j] = "" + ((DataRecord)this.rtRecords.get(i2)).uptime;
            resets[j--] = "" + ((DataRecord)this.rtRecords.get(i2)).resets;
            --i2;
        }
        int offset = 2;
        if (returnType) {
            offset = 3;
        }
        String[][] resultSet = new String[end - start][length + offset];
        int r = 0;
        while (r < end - start) {
            resultSet[r][0] = resets[r];
            resultSet[r][1] = upTime[r];
            if (returnType) {
                resultSet[r][2] = type[r];
            }
            int k = 0;
            while (k < results[r].length) {
                resultSet[r][k + offset] = "" + results[r][k];
                ++k;
            }
            ++r;
        }
        return resultSet;
    }

    double[][] getGraphData(String name, int period, int id, int fromReset, long fromUptime, boolean raw, boolean positionData, boolean reverse) throws IOException, NumberFormatException, DataLoadException {
        this.loadSegments(fromReset, fromUptime, period, reverse);
        int start = 0;
        int end = 0;
        int COLUMNS = 3;
        double[] lat = null;
        double[] lon = null;
        if (positionData) {
            COLUMNS = 5;
        }
        if (reverse) {
            start = this.rtRecords.size() - period;
            end = this.rtRecords.size();
        } else {
            start = this.rtRecords.getNearestFrameIndex(id, fromUptime, fromReset);
            if (start == -1) {
                start = this.rtRecords.size() - period;
            }
            end = start + period;
        }
        if (end > this.rtRecords.size()) {
            end = this.rtRecords.size();
        }
        if (end < start) {
            end = start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.rtRecords.size()) {
            start = this.rtRecords.size();
        }
        double[] results = new double[end - start];
        double[] upTime = new double[end - start];
        double[] resets = new double[end - start];
        if (positionData) {
            lat = new double[end - start];
            lon = new double[end - start];
        }
        int j = results.length - 1;
        int i2 = end - 1;
        while (i2 >= start) {
            results[j] = raw ? (double)((DataRecord)this.rtRecords.get(i2)).getRawValue(name) : ((DataRecord)this.rtRecords.get(i2)).getDoubleValue(name);
            if (positionData) {
                lat[j] = ((DataRecord)this.rtRecords.get(i2)).satLatitude;
                lon[j] = ((DataRecord)this.rtRecords.get(i2)).satLongitude;
            }
            upTime[j] = ((DataRecord)this.rtRecords.get(i2)).uptime;
            resets[j--] = ((DataRecord)this.rtRecords.get(i2)).resets;
            --i2;
        }
        double[][] resultSet = new double[COLUMNS][end - start];
        resultSet[2] = results;
        resultSet[1] = upTime;
        resultSet[0] = resets;
        if (positionData) {
            resultSet[3] = lat;
            resultSet[4] = lon;
        }
        return resultSet;
    }

    private TableSeg getSeg(int reset, long uptime) throws IOException {
        int i2 = this.tableIdx.size() - 1;
        while (i2 >= 0) {
            if (this.tableIdx.get((TableSeg)i2).fromReset <= reset && this.tableIdx.get((TableSeg)i2).fromUptime <= uptime) {
                return this.tableIdx.get((TableSeg)i2);
            }
            --i2;
        }
        TableSeg seg = new TableSeg(reset, uptime, this.tableName);
        this.tableIdx.add(seg);
        this.saveIdx();
        return seg;
    }

    private TableSeg loadSeg(int reset, long uptime) throws IOException, NumberFormatException, DataLoadException {
        TableSeg seg = this.getSeg(reset, uptime);
        if (seg.isLoaded()) {
            return seg;
        }
        this.load(seg);
        return seg;
    }

    protected int getNumberOfPayloadsBetweenTimestamps(int reset, long uptime, int toReset, long toUptime) throws IOException, NumberFormatException, LayoutLoadException, DataLoadException {
        int end;
        int fromSeg = this.findFirstSeg(reset, uptime);
        int toSeg = this.findFirstSeg(toReset, toUptime);
        int number = 0;
        int i2 = fromSeg;
        while (i2 <= toSeg && i2 < this.tableIdx.size()) {
            if (!this.tableIdx.get((TableSeg)i2).isLoaded()) {
                this.load(this.tableIdx.get((TableSeg)i2));
            }
            ++i2;
        }
        int id = ((DataRecord)this.rtRecords.get(false)).id;
        int start = this.rtRecords.getNearestFrameIndex(id, uptime, reset);
        if (start < (end = this.rtRecords.getNearestFrameIndex(id, toUptime, toReset))) {
            number = end - start;
        }
        return number;
    }

    private int findFirstSeg(int reset, long uptime) {
        boolean loadnow = false;
        int i2 = 0;
        while (i2 < this.tableIdx.size()) {
            if (!loadnow) {
                if (this.tableIdx.get((TableSeg)i2).fromReset > reset) {
                    loadnow = true;
                }
                if (i2 == 0 && this.tableIdx.get((TableSeg)i2).fromReset == reset) {
                    loadnow = true;
                }
                if (i2 < this.tableIdx.size() - 1 && this.tableIdx.get((TableSeg)i2).fromReset < reset && (this.tableIdx.get((TableSeg)(i2 + 1)).fromReset > reset || this.tableIdx.get((TableSeg)(i2 + 1)).fromReset == reset && this.tableIdx.get((TableSeg)(i2 + 1)).fromUptime > uptime)) {
                    loadnow = true;
                }
                if (i2 < this.tableIdx.size() - 1 && this.tableIdx.get((TableSeg)i2).fromReset == reset && this.tableIdx.get((TableSeg)i2).fromUptime < uptime && (this.tableIdx.get((TableSeg)(i2 + 1)).fromReset > reset || this.tableIdx.get((TableSeg)(i2 + 1)).fromReset == reset && this.tableIdx.get((TableSeg)(i2 + 1)).fromUptime > uptime)) {
                    loadnow = true;
                }
                if (i2 == this.tableIdx.size() - 1 && this.tableIdx.get((TableSeg)i2).fromReset <= reset) {
                    loadnow = true;
                }
            }
            if (loadnow) {
                return i2;
            }
            ++i2;
        }
        return -99;
    }

    private void loadSegments(int reset, long uptime, int number, boolean reverse) throws IOException, NumberFormatException, DataLoadException {
        block7: {
            block8: {
                int total = 0;
                if (!reverse) break block8;
                int startIdx = 0;
                int i2 = this.tableIdx.size() - 1;
                while (i2 >= 0) {
                    if ((total += this.tableIdx.get((TableSeg)i2).records) >= number) {
                        startIdx = i2;
                        break;
                    }
                    --i2;
                }
                total = 0;
                i2 = startIdx;
                while (i2 < this.tableIdx.size()) {
                    if (!this.tableIdx.get((TableSeg)i2).isLoaded()) {
                        this.load(this.tableIdx.get((TableSeg)i2));
                    }
                    total += this.tableIdx.get((TableSeg)i2).records;
                    ++i2;
                }
                break block7;
            }
            int i3 = this.findFirstSeg(reset, uptime);
            if (i3 < 0) break block7;
            while (i3 < this.tableIdx.size()) {
                if (!this.tableIdx.get((TableSeg)i3).isLoaded()) {
                    this.load(this.tableIdx.get((TableSeg)i3));
                }
                if ((total += this.tableIdx.get((TableSeg)i3++).records) < number + 1000) {
                    continue;
                }
                break;
            }
        }
    }

    public boolean save(DataRecord f) throws IOException, NumberFormatException, DataLoadException {
        TableSeg seg = this.loadSeg(f.resets, f.uptime);
        if (this.rtRecords.add(f)) {
            this.updated = true;
            if (seg.records == 1000) {
                seg = new TableSeg(f.resets, f.uptime, this.tableName);
                this.tableIdx.add(seg);
            }
            this.save(f, String.valueOf(this.dbDir) + File.separator + seg.fileName);
            ++seg.records;
            this.saveIdx();
            return true;
        }
        return false;
    }

    public void load(TableSeg seg) throws IOException, NumberFormatException, DataLoadException {
        String log = String.valueOf(this.dbDir) + File.separator + seg.fileName;
        this.createNewFile(log);
        try (BufferedReader dis = new BufferedReader(new FileReader(log));){
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                DataRecord rt = this.addLine(line);
                boolean bl = this.rtRecords.add(rt);
            }
            seg.setLoaded(true);
            dis.close();
        }
    }

    private DataRecord addLine(String line) throws IOException, DataLoadException {
        if (line.length() == 0) {
            return null;
        }
        DataRecord rt = new DataRecord(this.layout, line);
        return rt;
    }

    private boolean createNewFile(String log) throws IOException {
        File aFile = new File(log);
        if (!aFile.exists()) {
            aFile.createNewFile();
            return true;
        }
        return false;
    }

    private void save(DataRecord f, String log) throws IOException {
        boolean appendNewLine = false;
        if (!this.createNewFile(log) && !DataTable.newLineExists(log)) {
            appendNewLine = true;
        }
        File aFile = new File(log);
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
        try {
            if (appendNewLine) {
                output.write("\n");
            }
            output.write(String.valueOf(f.toFile()) + "\n");
            ((Writer)output).flush();
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public static boolean newLineExists(String log) throws IOException {
        File file = new File(log);
        RandomAccessFile fileHandler = new RandomAccessFile(file, "r");
        long fileLength = fileHandler.length() - 1L;
        if (fileLength < 0L) {
            fileHandler.close();
            return true;
        }
        fileHandler.seek(fileLength);
        byte readByte = fileHandler.readByte();
        fileHandler.close();
        return readByte == 10 || readByte == 13;
    }

    private void saveIdx() throws IOException {
        File aFile = new File(String.valueOf(this.fileName) + ".idx");
        this.createNewFile(String.valueOf(this.fileName) + ".idx");
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, false));
        try {
            for (TableSeg seg : this.tableIdx) {
                output.write(String.valueOf(seg.toFile()) + "\n");
                ((Writer)output).flush();
            }
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public void loadIdx() throws IOException, NumberFormatException {
        File aFile = new File(String.valueOf(this.fileName) + ".idx");
        if (this.createNewFile(String.valueOf(this.fileName) + ".idx")) {
            BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
            ((Writer)output).close();
        }
        try (BufferedReader dis = new BufferedReader(new FileReader(aFile.getPath()));){
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                int resets = Integer.valueOf(st.nextToken());
                long uptime = Long.valueOf(st.nextToken());
                int records = Integer.valueOf(st.nextToken());
                String name = st.nextToken();
                TableSeg seg = new TableSeg(resets, uptime, name, records);
                this.tableIdx.add(seg);
            }
        }
    }

    public void remove() throws IOException, SecurityException {
        for (TableSeg seg : this.tableIdx) {
            DataTable.remove(String.valueOf(this.dbDir) + File.separator + seg.fileName);
        }
        DataTable.remove(String.valueOf(this.fileName) + ".idx");
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void remove(String f) throws IOException, SecurityException {
        File file = new File(f);
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file " + file.getName() + " Check the file system and remove it manually.");
        }
    }
}

