/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.predict;

import com.g0kla.telem.predict.FoxTLE;
import com.g0kla.telem.segDb.SortedArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.joda.time.DateTime;

public class SortedTleList
extends SortedArrayList<FoxTLE> {
    static final TimeZone TZ = TimeZone.getTimeZone("UTC:UTC");

    public SortedTleList(int i2) {
        super(i2);
    }

    protected static double julianDateOfYear(double theYear) {
        long i2;
        double aYear = theYear - 1.0;
        long a = i2 = (long)Math.floor(aYear / 100.0);
        i2 = a / 4L;
        long b = 2L - a + i2;
        i2 = (long)Math.floor(365.25 * aYear);
        i2 = (long)((double)i2 + 428.4014);
        return (double)i2 + 1720994.5 + (double)b;
    }

    private static double juliandDateOfEpoch(double epoch) {
        double year = Math.floor(epoch * 0.001);
        double day = (epoch * 0.001 - year) * 1000.0;
        year = year < 57.0 ? (year += 2000.0) : (year += 1900.0);
        return SortedTleList.julianDateOfYear(year) + day;
    }

    private static double calcCurrentDaynum(DateTime date) {
        long now = date.getMillis();
        Calendar sgp4Epoch = Calendar.getInstance(TZ);
        sgp4Epoch.clear();
        sgp4Epoch.set(1979, 11, 31, 0, 0, 0);
        long then = sgp4Epoch.getTimeInMillis();
        long millis = now - then;
        return (double)millis / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    public FoxTLE getTleByDate(DateTime dateTime) {
        if (this.size() <= 0) {
            return null;
        }
        double julRequested = SortedTleList.calcCurrentDaynum(dateTime) + 2444238.5;
        int i2 = this.size() - 1;
        while (i2 >= 0) {
            FoxTLE f = (FoxTLE)this.get(i2);
            double julianDateEpoch = SortedTleList.juliandDateOfEpoch(f.getEpoch());
            if (julianDateEpoch <= julRequested) {
                return (FoxTLE)this.get(i2);
            }
            --i2;
        }
        return (FoxTLE)this.get(false);
    }
}

