/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected BufferedImage image;

    public MapPanel() {
    }

    public MapPanel(String filePath) throws IOException {
        this.setImage(filePath);
    }

    private void setImage(String filePath) throws IOException {
        this.image = ImageIO.read(new File(filePath));
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
        this.repaint();
    }

    protected void paintMap(Graphics g, int x, int y, int graphHeight, int graphWidth) {
        if (this.image != null) {
            BufferedImage display = this.image;
            if (graphHeight < this.image.getHeight() || graphWidth < this.image.getWidth()) {
                double ratio = (double)graphHeight / (double)this.image.getHeight();
                if ((double)this.image.getWidth() * ratio > (double)graphWidth) {
                    ratio = (double)graphWidth / (double)this.image.getWidth();
                }
                if (ratio > 0.0) {
                    display = MapPanel.scale(this.image, ratio);
                }
            }
            g.drawImage(display, x, y, null);
        }
    }

    public static BufferedImage scale(BufferedImage source, double ratio) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        BufferedImage bi = MapPanel.getCompatibleImage(w, h);
        Graphics2D g2d = bi.createGraphics();
        double xScale = (double)w / (double)source.getWidth();
        double yScale = (double)h / (double)source.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g2d.drawRenderedImage(source, at);
        g2d.dispose();
        return bi;
    }

    private static BufferedImage getCompatibleImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        return image;
    }
}

