/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class ConfigFile {
    public Properties properties = new Properties();
    public String propertiesFileName = "";

    public ConfigFile(String name) throws IOException {
        this.propertiesFileName = name;
        this.init();
    }

    abstract void initParams();

    public void init() throws IOException {
        this.initParams();
        this.load();
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void set(String sat, String fieldName, String key, String value) {
        this.properties.setProperty(String.valueOf(sat) + fieldName + key, value);
    }

    public String get(String sat, String fieldName, String key) {
        return this.properties.getProperty(String.valueOf(sat) + fieldName + key);
    }

    public void set(String key, int value) {
        this.properties.setProperty(key, Integer.toString(value));
    }

    public void set(String sat, String fieldName, String key, int value) {
        this.properties.setProperty(String.valueOf(sat) + fieldName + key, Integer.toString(value));
    }

    public void set(String sat, String fieldName, String key, long value) {
        this.properties.setProperty(String.valueOf(sat) + fieldName + key, Long.toString(value));
    }

    public void set(String key, boolean value) {
        this.properties.setProperty(key, Boolean.toString(value));
    }

    public void set(String sat, String fieldName, String key, boolean value) {
        this.properties.setProperty(String.valueOf(sat) + fieldName + key, Boolean.toString(value));
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getInt(String sat, String fieldName, String key) {
        try {
            return Integer.parseInt(this.properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLong(String sat, String fieldName, String key) {
        try {
            return Long.parseLong(this.properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public boolean getBoolean(String key) {
        try {
            return Boolean.parseBoolean(this.properties.getProperty(key));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getBoolean(String sat, String fieldName, String key) {
        try {
            return Boolean.parseBoolean(this.properties.getProperty(String.valueOf(sat) + fieldName + key));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void save() throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(this.propertiesFileName);
            this.properties.store(fos, "PacSat Ground Station Properties");
            fos.close();
        }
        catch (FileNotFoundException e1) {
            throw new FileNotFoundException("Could not write properties file. Check permissions on directory or on the file\n" + this.propertiesFileName);
        }
        catch (IOException e1) {
            throw new IOException("Error writing properties file:\n" + this.propertiesFileName);
        }
    }

    public void load() throws IOException {
        try {
            FileInputStream fis = new FileInputStream(this.propertiesFileName);
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.save();
        }
    }

    private String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }
}

