/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.data;

import com.g0kla.telem.data.LayoutLoadException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ConversionTable {
    String fileName;
    int NUMBER_OF_FIELDS = 0;
    public static final DateFormat dateFormatSecs = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);
    public String[] fieldName = null;
    public String[] fieldName2 = null;
    public String[] name = null;
    public double[] a = null;
    public double[] b = null;
    public double[] c = null;
    public double[] d = null;
    public double[] e = null;
    public double[] f = null;
    public String[] format = null;
    public int[] low = null;
    public int[] high = null;
    public String[] description = null;
    public static final String TERMINATOR = "NOTES:";

    static {
        dateFormatSecs.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public ConversionTable(String fileName) throws LayoutLoadException, IOException {
        this.fileName = fileName;
        this.load(fileName);
    }

    public String getUnits(int conversion) {
        String s = this.format[conversion];
        return s;
    }

    public String getStringValue(int conversion, long rawValue) {
        double val = this.convertRawValue(conversion, rawValue);
        String s = "";
        if (this.format[conversion].equalsIgnoreCase("Counts")) {
            s = Integer.toString((int)val);
        } else if (this.format[conversion].equalsIgnoreCase("Boolean")) {
            s = val > 0.0 ? "True" : "False";
        } else if (this.format[conversion].equalsIgnoreCase("Time")) {
            int h = (int)(val / 3600000.0);
            int m = (int)((val -= (double)(h * 60 * 60 * 1000)) / 60000.0);
            int sec = (int)val - m * 60 * 1000;
            s = String.format("%02d:%02d:%02d", h, m, sec /= 1000);
        } else if (this.format[conversion].equalsIgnoreCase("Date")) {
            Date dt = new Date((long)val * 1000L);
            s = dateFormatSecs.format(dt);
        } else if (this.format[conversion].equalsIgnoreCase("Raw8")) {
            s = ConversionTable.toByteString(rawValue, 8);
        } else if (this.format[conversion].equalsIgnoreCase("Raw10")) {
            s = ConversionTable.toByteString(rawValue, 10);
        } else if (this.format[conversion].equalsIgnoreCase("Bit2")) {
            s = this.intToBin((int)val, 2);
        } else if (this.format[conversion].equalsIgnoreCase("Bit3")) {
            s = this.intToBin((int)val, 3);
        } else if (this.format[conversion].equalsIgnoreCase("Bit4")) {
            s = this.intToBin((int)val, 4);
        } else if (this.format[conversion].equalsIgnoreCase("Bit8")) {
            s = this.intToBin((int)val, 8);
        } else if (this.format[conversion].equalsIgnoreCase("Bit16")) {
            s = this.intToBin((int)val, 16);
        } else if (this.format[conversion].equalsIgnoreCase("SMint8")) {
            long bitMask = 128L;
            long valueMask = 127L;
            long sval = rawValue & valueMask;
            long sign = rawValue & bitMask;
            if (sign == bitMask) {
                sval *= -1L;
            }
            val = this.convertRawValue(conversion, sval);
            s = String.format("%1.2f", val);
        } else if (this.format[conversion].equalsIgnoreCase("SMint16")) {
            long bitMask = 32768L;
            long valueMask = 32767L;
            long sval = rawValue & valueMask;
            long sign = rawValue & bitMask;
            if (sign == bitMask) {
                sval *= -1L;
            }
            val = this.convertRawValue(conversion, sval);
            s = String.format("%1.2f", val);
        } else if (this.format[conversion].equalsIgnoreCase("Sint8")) {
            byte b_val = (byte)rawValue;
            val = this.convertRawValue(conversion, b_val);
            s = String.format("%1.2f", val);
        } else if (this.format[conversion].equalsIgnoreCase("Sint16")) {
            short short_val = (short)rawValue;
            val = this.convertRawValue(conversion, short_val);
            s = String.format("%1.2f", val);
        } else {
            String[] mode;
            s = this.format[conversion].equalsIgnoreCase("MirADCSMode") ? (rawValue < (long)(mode = new String[]{"standby", "detumble", "coarse-point", "fine-point"}).length ? mode[(int)rawValue] : "" + rawValue) : (this.format[conversion].equalsIgnoreCase("MirSpacecraftMode") ? (rawValue < (long)(mode = new String[]{"reset/power-up", "separation", "safe", "standby", "mission"}).length ? mode[(int)rawValue] : "" + rawValue) : (this.format[conversion].equalsIgnoreCase("MirADCSState") ? (rawValue < (long)(mode = new String[]{"nadir", "sun", "velocity", "LLA", "moon"}).length ? mode[(int)rawValue] : "" + rawValue) : (this.format[conversion].equalsIgnoreCase("AX5043_PWRMODE") ? (rawValue < (long)(mode = new String[]{"OFF", "SLEEP", "", "", "", "STDBY", "", "FIFO", "SYNTHRX", "RX", "", "WOR", "SNTHTX", "TX"}).length ? mode[(int)rawValue] : "" + rawValue) : (this.format[conversion].equalsIgnoreCase("Enum") ? (rawValue < (long)(mode = this.description[conversion].split(":")).length ? mode[(int)rawValue] : "" + rawValue) : String.format("%1.2f", val)))));
        }
        return s;
    }

    public String intToBin(int word, int len) {
        boolean[] b = new boolean[len];
        int i2 = 0;
        while (i2 < len) {
            b[len - 1 - i2] = (word >> i2 & 1) == 1;
            ++i2;
        }
        String s = "";
        boolean[] blArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bit = blArray[n2];
            s = bit ? String.valueOf(s) + "1" : String.valueOf(s) + "0";
            ++n2;
        }
        return s;
    }

    public static String toByteString(long value, int len) {
        String s = "";
        int i2 = 0;
        while (i2 < len) {
            s = String.valueOf(ConversionTable.plainhex(value & 0xFFL)) + s;
            value >>= 8;
            ++i2;
        }
        return s;
    }

    public static String plainhex(long l) {
        return String.format("%2s", Long.toHexString(l)).replace(' ', '0');
    }

    public double convertRawValue(int conversion, long rawValue) {
        if (conversion < 0 || conversion > this.NUMBER_OF_FIELDS) {
            throw new NumberFormatException("Conversion number invalid");
        }
        double A = this.a[conversion];
        double B = this.b[conversion];
        double C = this.c[conversion];
        double D = this.d[conversion];
        double E = this.e[conversion];
        double F = this.f[conversion];
        double val = A + B * (double)rawValue + C * Math.pow(rawValue, 2.0) + D * Math.pow(rawValue, 3.0) + E * Math.pow(rawValue, 4.0) + F * Math.pow(rawValue, 5.0);
        return val;
    }

    protected void load(String file) throws LayoutLoadException, IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader dis = new BufferedReader(new FileReader(file));
        int field = 0;
        boolean reading = true;
        while (reading) {
            line = dis.readLine();
            if (line.startsWith(TERMINATOR)) {
                reading = false;
                continue;
            }
            lines.add(line);
            ++field;
        }
        if (reading) {
            throw new LayoutLoadException("Could not find end of Conversion file");
        }
        this.NUMBER_OF_FIELDS = field;
        this.fieldName = new String[this.NUMBER_OF_FIELDS];
        this.fieldName2 = new String[this.NUMBER_OF_FIELDS];
        this.name = new String[this.NUMBER_OF_FIELDS];
        this.a = new double[this.NUMBER_OF_FIELDS];
        this.b = new double[this.NUMBER_OF_FIELDS];
        this.c = new double[this.NUMBER_OF_FIELDS];
        this.d = new double[this.NUMBER_OF_FIELDS];
        this.e = new double[this.NUMBER_OF_FIELDS];
        this.f = new double[this.NUMBER_OF_FIELDS];
        this.format = new String[this.NUMBER_OF_FIELDS];
        this.low = new int[this.NUMBER_OF_FIELDS];
        this.high = new int[this.NUMBER_OF_FIELDS];
        this.description = new String[this.NUMBER_OF_FIELDS];
        field = 0;
        field = 0;
        while (field < this.NUMBER_OF_FIELDS) {
            line = (String)lines.get(field);
            if (line != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                this.fieldName[field] = st.nextToken();
                this.fieldName2[field] = st.nextToken();
                this.name[field] = st.nextToken();
                this.a[field] = Double.valueOf(st.nextToken());
                this.b[field] = Double.valueOf(st.nextToken());
                this.c[field] = Double.valueOf(st.nextToken());
                this.d[field] = Double.valueOf(st.nextToken());
                this.e[field] = Double.valueOf(st.nextToken());
                this.f[field] = Double.valueOf(st.nextToken());
                this.format[field] = st.nextToken();
                this.low[field] = Integer.valueOf(st.nextToken());
                this.high[field] = Integer.valueOf(st.nextToken());
                try {
                    this.description[field] = st.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            ++field;
        }
        dis.close();
        if (this.NUMBER_OF_FIELDS != field) {
            throw new LayoutLoadException("Error loading fields from " + file + ". Expected " + this.NUMBER_OF_FIELDS + " fields , but loaded " + field);
        }
    }

    public static void main(String[] args) throws LayoutLoadException, IOException {
        long v = 555555555555L;
        String s = ConversionTable.toByteString(v, 5);
        System.out.println(s);
        ConversionTable ct = new ConversionTable("C:\\Users\\chris\\Desktop\\workspace\\Falcon\\spacecraft\\mir-sat-1-coef.csv");
        double val = ct.convertRawValue(70, -32767L);
        System.out.println(val);
        System.out.println(ct.getStringValue(123, 2L));
    }
}

