/*
 * Decompiled with CFR 0.152.
 */
package ax25;

import ax25.Ax25Frame;
import com.g0kla.telem.server.STPable;
import java.util.ArrayList;
import java.util.Arrays;
import pacSat.frames.FrameException;

public class KissFrame
implements STPable {
    public static final int FEND = 192;
    public static final int FESC = 219;
    public static final int TFEND = 220;
    public static final int TFESC = 221;
    public static final int DATA_FRAME = 0;
    public static final int TX_DELAY = 1;
    public static final int PERSISTENCE = 2;
    public static final int SLOT_TIME = 3;
    public static final int TX_TAIL = 4;
    public static final int FULL_DUPLEX = 5;
    public static final int SET_HARDWARE = 6;
    public static final int RETURN = 255;
    int length;
    int bytesAdded;
    int commandCode;
    int portIndex;
    int[] sourceBytes;
    int[] bytes;
    int prevByte = 0;
    boolean foundStart = false;
    boolean frameFull = false;

    public KissFrame(int portIndex, int command, int[] data) {
        ArrayList<Integer> byteList = new ArrayList<Integer>();
        int commandByte = portIndex << 4 & 0xF0;
        byteList.add(192);
        byteList.add(commandByte |= command & 0xF);
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            if (i2 == 192) {
                byteList.add(219);
                byteList.add(220);
            } else if (i2 == 219) {
                byteList.add(219);
                byteList.add(221);
            } else {
                byteList.add(i2);
            }
            ++n2;
        }
        byteList.add(192);
        int j = 0;
        this.bytes = new int[byteList.size()];
        for (Integer in : byteList) {
            this.bytes[j++] = in;
        }
    }

    public KissFrame() {
        this.bytes = new int[2048];
        this.sourceBytes = new int[2048];
        this.length = 0;
    }

    @Override
    public int[] getRawBytes() {
        return this.sourceBytes;
    }

    public int[] getDataBytes() {
        return this.bytes;
    }

    public boolean add(int b) {
        this.sourceBytes[this.bytesAdded++] = b;
        if (b == 219) {
            this.prevByte = b;
            return true;
        }
        if (b == 192) {
            if (this.length == 0) {
                if (this.foundStart) {
                    return true;
                }
                this.foundStart = true;
                this.prevByte = 192;
                return true;
            }
            this.frameFull = true;
            this.bytes = Arrays.copyOfRange(this.bytes, 0, this.length);
            this.sourceBytes = Arrays.copyOfRange(this.sourceBytes, 0, this.bytesAdded);
            return false;
        }
        if (this.prevByte == 192) {
            this.prevByte = b;
            this.commandCode = b & 0xF;
            this.portIndex = b & 0xF0;
            return true;
        }
        if (this.prevByte == 219) {
            if (b == 220) {
                this.bytes[this.length++] = 192;
                this.prevByte = b;
                return true;
            }
            if (b == 221) {
                this.bytes[this.length++] = 219;
                this.prevByte = b;
                return true;
            }
            System.err.println("ERROR: ADDED ESC WITHOUT TFESC");
            this.bytes[this.length++] = 219;
        }
        if (!this.foundStart) {
            return true;
        }
        this.bytes[this.length++] = b;
        this.prevByte = b;
        return true;
    }

    public static long getLongFromBytes(int[] by) {
        long value = 0L;
        int i2 = 0;
        while (i2 < by.length) {
            value += ((long)by[i2] & 0xFFL) << 8 * i2;
            ++i2;
        }
        return value;
    }

    public static int getIntFromBytes(int[] by) {
        int value = 0;
        int i2 = 0;
        while (i2 < by.length) {
            value += (by[i2] & 0xFF) << 8 * i2;
            ++i2;
        }
        return value;
    }

    public static int[] littleEndian2(long in) {
        int[] b = new int[2];
        b[1] = (int)(in >> 8 & 0xFFL);
        b[0] = (int)(in >> 0 & 0xFFL);
        return b;
    }

    public static int[] littleEndian4(long in) {
        int[] b = new int[4];
        b[3] = (int)(in >> 24 & 0xFFL);
        b[2] = (int)(in >> 16 & 0xFFL);
        b[1] = (int)(in >> 8 & 0xFFL);
        b[0] = (int)(in >> 0 & 0xFFL);
        return b;
    }

    public static boolean[] intToBin8(int word) {
        boolean[] b = new boolean[8];
        int i2 = 0;
        while (i2 < 8) {
            b[7 - i2] = (word >> i2 & 1) == 1;
            ++i2;
        }
        return b;
    }

    public String toByteString() {
        String s = "";
        int[] nArray = this.bytes;
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            s = String.valueOf(s) + Integer.toHexString(b & 0xFF);
            ++n2;
        }
        return s;
    }

    public String toString() {
        String s = "";
        int[] nArray = this.bytes;
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            char ch = (char)b;
            s = String.valueOf(s) + ch;
            ++n2;
        }
        return s;
    }

    public static final void main(String[] argc) throws FrameException {
        int[] raw;
        int[] by;
        KissFrame kiss = new KissFrame();
        int[] nArray = new int[21];
        nArray[0] = 192;
        nArray[2] = 150;
        nArray[3] = 104;
        nArray[4] = 150;
        nArray[5] = 136;
        nArray[6] = 164;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 132;
        nArray[17] = 240;
        nArray[19] = 6;
        nArray[20] = 192;
        int[] nArray2 = by = nArray;
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray2[n2];
            kiss.add(b);
            ++n2;
        }
        Ax25Frame bf = new Ax25Frame(kiss);
        System.out.println(kiss);
        System.out.println(kiss.length);
        int[] nArray3 = raw = kiss.getRawBytes();
        int n3 = raw.length;
        int n4 = 0;
        while (n4 < n3) {
            int b = nArray3[n4];
            System.out.print(String.valueOf(b) + " ");
            ++n4;
        }
        System.out.println("");
        System.out.println(bf);
    }
}

