/*
 * Decompiled with CFR 0.152.
 */
package ax25;

import ax25.Ax25Primitive;
import ax25.KissFrame;
import common.Config;
import common.SpacecraftSettings;
import java.util.Arrays;
import pacSat.frames.FrameException;

public class Ax25Frame
extends Ax25Primitive {
    public static final int PID_BROADCAST = 187;
    public static final int PID_DIR_BROADCAST = 189;
    public static final int PID_COMMAND = 188;
    public static final int PID_NO_PROTOCOL = 240;
    public static final int TYPE_S = 1;
    public static final int TYPE_I = 0;
    public static final int U_CONTROL_MASK = 239;
    public static final int TYPE_U_SABME = 111;
    public static final int TYPE_U_SABM = 47;
    public static final int TYPE_U_DISCONNECT = 67;
    public static final int TYPE_U_DISCONNECT_MODE = 15;
    public static final int TYPE_UA = 99;
    public static final int TYPE_U_FRAME_REJECT = 135;
    public static final int TYPE_UI = 3;
    public static final int TYPE_U_EXCH_ID = 175;
    public static final int TYPE_U_TEST = 227;
    public static final int TYPE_S_RECEIVE_READY = 0;
    public static final int TYPE_S_RECEIVE_NOT_READY = 1;
    public static final int TYPE_S_REJECT = 2;
    public static final int TYPE_S_SELECTIVE_REJECT = 3;
    public static final int COMMAND = 1;
    public static final int RESPONSE = 0;
    public static final int RR_BITS = 96;
    public String toCallsign;
    public String fromCallsign;
    public String viaCallsign;
    int controlByte;
    public int pid;
    int[] bytes;
    int[] data;
    int type = 3;
    int C;
    int PF;
    int NR;
    int NS;
    int SS;

    public Ax25Frame(String fromCallsign, String toCallsign, int controlByte, int command, int pid, int[] data) {
        int i2;
        this.fromCallsign = fromCallsign;
        this.toCallsign = toCallsign;
        this.pid = pid;
        this.data = data;
        this.controlByte = controlByte;
        this.C = command & 1;
        this.PF = controlByte >> 4 & 1;
        this.type = (controlByte & 1) == 0 ? 0 : ((controlByte & 3) == 3 ? controlByte & 0xEF : ((controlByte & 3) == 1 ? 1 : 255));
        int command2 = 0;
        if (command == 0) {
            command2 = 1;
        }
        int[] byto = Ax25Frame.encodeCall(toCallsign, false, command);
        int[] byfrom = Ax25Frame.encodeCall(fromCallsign, true, command2);
        int j = 0;
        int dataLen = 0;
        if (data != null) {
            dataLen = data.length;
        }
        this.bytes = new int[16 + dataLen];
        int[] nArray = byto;
        int n = byto.length;
        int n2 = 0;
        while (n2 < n) {
            i2 = nArray[n2];
            this.bytes[j++] = i2;
            ++n2;
        }
        nArray = byfrom;
        n = byfrom.length;
        n2 = 0;
        while (n2 < n) {
            i2 = nArray[n2];
            this.bytes[j++] = i2;
            ++n2;
        }
        this.bytes[j++] = controlByte;
        this.bytes[j++] = pid;
        if (data != null) {
            nArray = data;
            n = data.length;
            n2 = 0;
            while (n2 < n) {
                i2 = nArray[n2];
                this.bytes[j++] = i2;
                ++n2;
            }
        }
    }

    public Ax25Frame(String fromCallsign, String toCallsign, int controlByte, int command) {
        int i2;
        this.fromCallsign = fromCallsign;
        this.toCallsign = toCallsign;
        this.controlByte = controlByte;
        this.C = command & 1;
        int command2 = 0;
        if (command == 0) {
            command2 = 1;
        }
        int[] byto = Ax25Frame.encodeCall(toCallsign, false, command);
        int[] byfrom = Ax25Frame.encodeCall(fromCallsign, true, command2);
        int j = 0;
        this.PF = controlByte >> 4 & 1;
        this.type = (controlByte & 1) == 0 ? 0 : ((controlByte & 3) == 3 ? controlByte & 0xEF : ((controlByte & 3) == 1 ? 1 : 255));
        this.bytes = new int[15];
        int[] nArray = byto;
        int n = byto.length;
        int n2 = 0;
        while (n2 < n) {
            i2 = nArray[n2];
            this.bytes[j++] = i2;
            ++n2;
        }
        nArray = byfrom;
        n = byfrom.length;
        n2 = 0;
        while (n2 < n) {
            i2 = nArray[n2];
            this.bytes[j++] = i2;
            ++n2;
        }
        this.bytes[j++] = controlByte;
    }

    public Ax25Frame(KissFrame kiss) throws FrameException {
        this.bytes = kiss.getDataBytes();
        this.parseByteFrame();
    }

    public Ax25Frame(byte[] bytes) throws FrameException {
        this.bytes = new int[bytes.length];
        int i2 = 0;
        while (i2 < bytes.length) {
            this.bytes[i2] = bytes[i2] & 0xFF;
            ++i2;
        }
        this.parseByteFrame();
    }

    public Ax25Frame(int[] bytes) throws FrameException {
        this.bytes = bytes;
        this.parseByteFrame();
    }

    private void parseByteFrame() throws FrameException {
        String d;
        if (this.bytes.length < 15) {
            throw new FrameException("Not enough bytes for a valid S, I or UI Frame");
        }
        int[] callbytes = Arrays.copyOfRange(this.bytes, 0, 7);
        int[] callbytes2 = Arrays.copyOfRange(this.bytes, 7, 14);
        this.toCallsign = Ax25Frame.getcall(callbytes);
        this.fromCallsign = Ax25Frame.getcall(callbytes2);
        int destCbit = this.bytes[6] >> 7;
        int sourceCbit = this.bytes[13] >> 7;
        this.C = destCbit != sourceCbit ? (destCbit == 1 ? 1 : 0) : destCbit;
        int v = 0;
        if (!Ax25Frame.isFinalCall(callbytes2)) {
            int[] callbytes3 = Arrays.copyOfRange(this.bytes, 14, 21);
            this.viaCallsign = Ax25Frame.getcall(callbytes3);
            v = 7;
            if (!Ax25Frame.isFinalCall(callbytes3)) {
                throw new FrameException(">>>>>>>>>>> more than one VIA not supported: " + this.headerString());
            }
        }
        if (this.bytes.length < 15 + v) {
            throw new FrameException("Not enough bytes for a valid S, I or UI Frame: " + this.bytes.length);
        }
        this.controlByte = this.bytes[14 + v];
        if ((this.controlByte & 1) == 0) {
            if (this.bytes.length < 16 + v) {
                throw new FrameException("Not enough bytes for a valid I Frame: " + this.bytes.length + " " + this.toString());
            }
            this.type = 0;
            this.NR = this.controlByte >> 5 & 7;
            this.NS = this.controlByte >> 1 & 7;
            this.PF = this.controlByte >> 4 & 1;
            this.pid = this.bytes[15 + v];
            this.data = Arrays.copyOfRange(this.bytes, 16 + v, this.bytes.length);
        } else if ((this.controlByte & 3) == 3) {
            this.type = this.controlByte & 0xEF;
            this.PF = this.controlByte >> 4 & 1;
            if (this.type != 3) {
                return;
            }
            if (this.bytes.length < 16) {
                d = "";
                d = String.valueOf(d) + "From:" + this.fromCallsign + " to " + this.toCallsign;
                int[] nArray = this.bytes;
                int n = this.bytes.length;
                int n2 = 0;
                while (n2 < n) {
                    int i2 = nArray[n2];
                    d = String.valueOf(d) + " " + Integer.toHexString(i2);
                    ++n2;
                }
                throw new FrameException("Not enough bytes for a valid UI Frame" + d);
            }
            this.pid = this.bytes[15];
            try {
                this.data = Arrays.copyOfRange(this.bytes, 16 + v, this.bytes.length);
            }
            catch (IllegalArgumentException e) {
                throw new FrameException("Invalid number of bytes for UI Frame with length" + this.bytes.length);
            }
        } else {
            if ((this.controlByte & 3) == 1) {
                this.type = 1;
                this.NR = this.controlByte >> 5 & 7;
                this.SS = this.controlByte >> 2 & 3;
                this.PF = this.controlByte >> 4 & 1;
                return;
            }
            this.type = 255;
            d = "";
            int[] nArray = this.bytes;
            int n = this.bytes.length;
            int n3 = 0;
            while (n3 < n) {
                int i3 = nArray[n3];
                d = String.valueOf(d) + " " + Integer.toHexString(i3);
                ++n3;
            }
            throw new FrameException("ERROR: Frame type not supported: " + this.headerString() + d);
        }
    }

    public boolean isCommandFrame() {
        return this.C == 1;
    }

    public int[] getBytes() {
        return this.bytes;
    }

    public int[] getDataBytes() {
        return this.data;
    }

    public String getSTypeString() {
        switch (this.SS) {
            case 0: {
                return "RR";
            }
            case 1: {
                return "RNR";
            }
            case 2: {
                return "REJ";
            }
            case 3: {
                return "SREJ";
            }
        }
        return "UNK";
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 3: {
                return "UI";
            }
            case 1: {
                return "S";
            }
            case 0: {
                return "I";
            }
            case 111: {
                return "U-SABME";
            }
            case 47: {
                return "U-SABM";
            }
            case 67: {
                return "U-DISC";
            }
            case 15: {
                return "U-DM";
            }
            case 99: {
                return "UA";
            }
            case 135: {
                return "U-FRMR";
            }
            case 175: {
                return "U-XID";
            }
            case 227: {
                return "U-TEST";
            }
        }
        return "UNK";
    }

    public boolean isBroadcastFileFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        return this.toCallsign.startsWith("QST") && (this.pid & 0xFF) == 187;
    }

    public boolean isDirectoryBroadcastFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        return this.toCallsign.startsWith("QST") && (this.pid & 0xFF) == 189;
    }

    public boolean isIorsStatusFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        if ((this.pid & 0xFF) == 240) {
            return this.toCallsign.startsWith("ARISS");
        }
        return false;
    }

    public boolean isStatusFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        if ((this.pid & 0xFF) == 240) {
            if (this.toCallsign.startsWith("PBLIST")) {
                return true;
            }
            if (this.toCallsign.startsWith("PBFULL")) {
                return true;
            }
            if (this.toCallsign.startsWith("PBSHUT")) {
                return true;
            }
            if (this.toCallsign.startsWith("BBSTAT")) {
                return true;
            }
            if (this.toCallsign.startsWith("BBCOM")) {
                return true;
            }
            return this.toCallsign.startsWith("STATUS");
        }
        return false;
    }

    public boolean isResponseFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        return (this.pid & 0xFF) == 187 && !this.toCallsign.startsWith("QST");
    }

    public boolean isTlmFrame() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        if ((this.pid & 0xFF) == 240) {
            if (this.toCallsign.startsWith("TLMI-1")) {
                return true;
            }
            if (this.toCallsign.startsWith("TLM2-1")) {
                return true;
            }
        }
        return false;
    }

    public boolean isPacsatTlmFrame(SpacecraftSettings spacecraftSettings) {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        return (this.pid & 0xFF) == 240 && spacecraftSettings.spacecraft.getLayoutByName(this.toCallsign.trim()) != null;
    }

    public int isTlmMirSat1Frame1() {
        if (this.data == null) {
            return -1;
        }
        if (this.type != 3) {
            return -1;
        }
        if ((this.pid & 0xFF) == 240 && this.fromCallsign.startsWith("3B8MIR") && this.toCallsign.startsWith("3B8MRC")) {
            if ((this.data[13] & 0xFF) != 3) {
                return -1;
            }
            if ((this.data[14] & 0xFF) != 25) {
                return -1;
            }
            return this.data[15];
        }
        return -1;
    }

    public boolean isTlmMirSat1Frame2() {
        if (this.data == null) {
            return false;
        }
        if (this.type != 3) {
            return false;
        }
        return (this.pid & 0xFF) == 240 && this.fromCallsign.startsWith("3B8MIR") && this.toCallsign.startsWith("3B8MRC");
    }

    public boolean isLstatFrame() {
        if (this.type != 3) {
            return false;
        }
        return (this.pid & 0xFF) == 240 && this.toCallsign.startsWith("LSTAT");
    }

    public boolean isTimeFrame() {
        if (this.type != 3) {
            return false;
        }
        return (this.pid & 0xFF) == 240 && this.toCallsign.startsWith("TIME-1");
    }

    public boolean isIFrame() {
        return this.type == 0;
    }

    public boolean isSFrame() {
        return this.type == 1;
    }

    public boolean isUFrame() {
        if (this.type == 111) {
            return true;
        }
        if (this.type == 47) {
            return true;
        }
        if (this.type == 67) {
            return true;
        }
        if (this.type == 15) {
            return true;
        }
        if (this.type == 99) {
            return true;
        }
        if (this.type == 135) {
            return true;
        }
        if (this.type == 175) {
            return true;
        }
        return this.type == 227;
    }

    public static boolean isFinalCall(int[] framebuf) {
        return (framebuf[6] & 1) == 1;
    }

    public static String getcall(int[] framebuf) {
        String cbp = "";
        int i2 = 0;
        while (i2 < 6) {
            if (framebuf[i2] != 64 && framebuf[i2] != 32) {
                cbp = String.valueOf(cbp) + (char)(framebuf[i2] >> 1 & 0x7F);
            }
            ++i2;
        }
        int ssid = (framebuf[6] & 0x1E) >> 1;
        cbp = ssid > 0 ? String.valueOf(cbp) + "-" + ssid : String.valueOf(cbp) + ' ';
        return cbp;
    }

    public static int[] encodeCall(String callsign, boolean finalCall, int command) {
        String call = callsign.split("-")[0];
        int ssid = 0;
        try {
            ssid = Integer.parseInt(callsign.split("-")[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] by = new int[7];
        int i2 = 0;
        while (i2 < 7) {
            by[i2] = 64;
            ++i2;
        }
        i2 = 0;
        while (i2 < 6 && i2 < call.length()) {
            by[i2] = (call.charAt(i2) & 0x7F) << 1;
            ++i2;
        }
        by[6] = ssid << 1 & 0x1E;
        command = (command & 1) << 7;
        by[6] = by[6] | command | 0x60;
        if (finalCall) {
            by[6] = by[6] | 1;
        }
        return by;
    }

    public static boolean isPrintableChar(char c) {
        return c >= ' ' && c <= '\u007f';
    }

    public static String makeString(int[] data) {
        String s = "";
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            char ch = (char)b;
            s = Ax25Frame.isPrintableChar(ch) ? String.valueOf(s) + ch : String.valueOf(s) + ".";
            ++n2;
        }
        return s;
    }

    public String headerString() {
        String s = "";
        s = String.valueOf(s) + "From:" + this.fromCallsign;
        if (this.viaCallsign != null) {
            s = String.valueOf(s) + " VIA " + this.viaCallsign;
        }
        s = String.valueOf(s) + " to " + this.toCallsign;
        s = String.valueOf(s) + " Ctrl: " + Integer.toHexString(this.controlByte);
        s = String.valueOf(s) + " Type: " + Ax25Frame.getTypeString(this.type);
        s = this.C == 1 ? String.valueOf(s) + " Cmd" : String.valueOf(s) + " Res";
        if (this.type == 3) {
            s = String.valueOf(s) + " PID: " + Integer.toHexString(this.pid & 0xFF) + " ";
        } else if (this.type == 1) {
            s = String.valueOf(s) + " PF: " + this.PF;
            s = String.valueOf(s) + " NR: " + Integer.toHexString(this.NR & 0x1F) + " ";
            s = String.valueOf(s) + " SS: " + this.getSTypeString() + " ";
        } else {
            s = String.valueOf(s) + " PF: " + this.PF;
            s = String.valueOf(s) + " NR: " + Integer.toHexString(this.NR & 0xF) + " ";
            s = String.valueOf(s) + " NS: " + Integer.toHexString(this.NS & 0xF) + " ";
            if (this.data != null) {
                String tmp = "";
                int[] nArray = this.data;
                int n = this.data.length;
                int n2 = 0;
                while (n2 < n) {
                    int i2 = nArray[n2];
                    if (i2 < 32 || i2 > 126) {
                        tmp = "*** BINARY DATA *** ";
                        break;
                    }
                    tmp = String.valueOf(tmp) + " " + Integer.toHexString(i2);
                    ++n2;
                }
            }
        }
        return s;
    }

    public String toDataString() {
        String s = "";
        int[] nArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            s = String.valueOf(s) + Integer.toHexString(b) + " ";
            ++n2;
        }
        return s;
    }

    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            s = String.valueOf(s) + this.headerString();
        }
        if (this.isBroadcastFileFrame()) {
            s = String.valueOf(s) + "FILE> ";
        }
        if (this.isDirectoryBroadcastFrame()) {
            s = String.valueOf(s) + "DIR> ";
        }
        if (this.type == 0 && this.data != null) {
            s = String.valueOf(s) + " " + this.data.length + " data byte(s)";
        } else if (this.data != null) {
            s = String.valueOf(s) + Ax25Frame.makeString(this.data);
        }
        return s;
    }

    public static final void main(String[] argc) throws FrameException {
        int[] by;
        Config.init("test");
        int[] nArray = by = Ax25Frame.encodeCall("G0KLA-4", false, 1);
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            boolean[] blArray = KissFrame.intToBin8(b);
            ++n2;
        }
        String call = Ax25Frame.getcall(by);
        boolean[] bits = KissFrame.intToBin8(115);
        int[] nArray2 = new int[79];
        nArray2[0] = 192;
        nArray2[2] = 164;
        nArray2[3] = 108;
        nArray2[4] = 166;
        nArray2[5] = 170;
        nArray2[6] = 98;
        nArray2[7] = 168;
        nArray2[8] = 96;
        nArray2[9] = 174;
        nArray2[10] = 114;
        nArray2[11] = 138;
        nArray2[12] = 176;
        nArray2[13] = 160;
        nArray2[14] = 64;
        nArray2[15] = 238;
        nArray2[16] = 160;
        nArray2[17] = 140;
        nArray2[18] = 166;
        nArray2[19] = 102;
        nArray2[20] = 64;
        nArray2[21] = 64;
        nArray2[22] = 227;
        nArray2[23] = 3;
        nArray2[24] = 240;
        nArray2[25] = 96;
        nArray2[26] = 108;
        nArray2[27] = 38;
        nArray2[28] = 124;
        nArray2[29] = 108;
        nArray2[30] = 33;
        nArray2[31] = 41;
        nArray2[32] = 75;
        nArray2[33] = 92;
        nArray2[34] = 62;
        nArray2[35] = 34;
        nArray2[36] = 52;
        nArray2[37] = 34;
        nArray2[38] = 125;
        nArray2[39] = 52;
        nArray2[40] = 51;
        nArray2[41] = 53;
        nArray2[42] = 46;
        nArray2[43] = 49;
        nArray2[44] = 49;
        nArray2[45] = 48;
        nArray2[46] = 77;
        nArray2[47] = 72;
        nArray2[48] = 122;
        nArray2[49] = 32;
        nArray2[50] = 84;
        nArray2[51] = 48;
        nArray2[52] = 54;
        nArray2[53] = 55;
        nArray2[54] = 72;
        nArray2[55] = 105;
        nArray2[56] = 32;
        nArray2[57] = 102;
        nArray2[58] = 114;
        nArray2[59] = 111;
        nArray2[60] = 109;
        nArray2[61] = 32;
        nArray2[62] = 115;
        nArray2[63] = 117;
        nArray2[64] = 110;
        nArray2[65] = 110;
        nArray2[66] = 121;
        nArray2[67] = 32;
        nArray2[68] = 83;
        nArray2[69] = 70;
        nArray2[70] = 76;
        nArray2[71] = 32;
        nArray2[72] = 69;
        nArray2[73] = 76;
        nArray2[74] = 57;
        nArray2[75] = 54;
        nArray2[76] = 61;
        nArray2[77] = 13;
        nArray2[78] = 192;
        int[] by1 = nArray2;
        int[] nArray3 = new int[259];
        nArray3[0] = 192;
        nArray3[2] = 102;
        nArray3[3] = 132;
        nArray3[4] = 112;
        nArray3[5] = 154;
        nArray3[6] = 164;
        nArray3[7] = 134;
        nArray3[8] = 96;
        nArray3[9] = 102;
        nArray3[10] = 132;
        nArray3[11] = 112;
        nArray3[12] = 154;
        nArray3[13] = 146;
        nArray3[14] = 164;
        nArray3[15] = 97;
        nArray3[16] = 3;
        nArray3[17] = 240;
        nArray3[19] = 16;
        nArray3[20] = 60;
        nArray3[21] = 60;
        nArray3[22] = 24;
        nArray3[24] = 8;
        nArray3[25] = 2;
        nArray3[26] = 193;
        nArray3[27] = 39;
        nArray3[28] = 1;
        nArray3[29] = 108;
        nArray3[30] = 16;
        nArray3[31] = 3;
        nArray3[32] = 25;
        nArray3[34] = 1;
        nArray3[36] = 244;
        nArray3[37] = 60;
        nArray3[38] = 104;
        nArray3[41] = 80;
        nArray3[42] = 6;
        nArray3[43] = 64;
        nArray3[44] = 170;
        nArray3[45] = 170;
        nArray3[62] = 26;
        nArray3[63] = 6;
        nArray3[64] = 1;
        nArray3[65] = 229;
        nArray3[66] = 254;
        nArray3[67] = 18;
        nArray3[72] = 7;
        nArray3[73] = 44;
        nArray3[74] = 1;
        nArray3[75] = 230;
        nArray3[76] = 2;
        nArray3[77] = 196;
        nArray3[82] = 7;
        nArray3[83] = 44;
        nArray3[84] = 1;
        nArray3[85] = 230;
        nArray3[86] = 7;
        nArray3[87] = 118;
        nArray3[92] = 7;
        nArray3[93] = 40;
        nArray3[94] = 1;
        nArray3[95] = 230;
        nArray3[96] = 12;
        nArray3[97] = 40;
        nArray3[102] = 7;
        nArray3[103] = 44;
        nArray3[104] = 1;
        nArray3[105] = 230;
        nArray3[106] = 16;
        nArray3[107] = 218;
        nArray3[112] = 7;
        nArray3[113] = 44;
        nArray3[114] = 1;
        nArray3[115] = 230;
        nArray3[116] = 21;
        nArray3[117] = 142;
        nArray3[122] = 7;
        nArray3[123] = 44;
        nArray3[124] = 1;
        nArray3[125] = 230;
        nArray3[126] = 26;
        nArray3[127] = 64;
        nArray3[132] = 7;
        nArray3[133] = 44;
        nArray3[134] = 1;
        nArray3[135] = 230;
        nArray3[136] = 30;
        nArray3[137] = 242;
        nArray3[142] = 7;
        nArray3[143] = 46;
        nArray3[144] = 1;
        nArray3[145] = 230;
        nArray3[146] = 35;
        nArray3[147] = 164;
        nArray3[152] = 7;
        nArray3[153] = 44;
        nArray3[154] = 1;
        nArray3[155] = 230;
        nArray3[156] = 40;
        nArray3[157] = 86;
        nArray3[162] = 7;
        nArray3[163] = 45;
        nArray3[164] = 80;
        nArray3[165] = 15;
        nArray3[166] = 44;
        nArray3[167] = 251;
        nArray3[168] = 144;
        nArray3[171] = 57;
        nArray3[172] = 96;
        nArray3[173] = 15;
        nArray3[174] = 45;
        nArray3[175] = 33;
        nArray3[176] = 16;
        nArray3[179] = 57;
        nArray3[180] = 96;
        nArray3[181] = 15;
        nArray3[182] = 45;
        nArray3[183] = 70;
        nArray3[184] = 144;
        nArray3[187] = 57;
        nArray3[188] = 96;
        nArray3[189] = 15;
        nArray3[190] = 45;
        nArray3[191] = 108;
        nArray3[192] = 16;
        nArray3[195] = 57;
        nArray3[196] = 96;
        nArray3[197] = 15;
        nArray3[198] = 45;
        nArray3[199] = 145;
        nArray3[200] = 144;
        nArray3[203] = 57;
        nArray3[204] = 96;
        nArray3[205] = 15;
        nArray3[206] = 45;
        nArray3[207] = 183;
        nArray3[208] = 16;
        nArray3[211] = 57;
        nArray3[212] = 96;
        nArray3[213] = 15;
        nArray3[214] = 45;
        nArray3[215] = 220;
        nArray3[216] = 160;
        nArray3[219] = 57;
        nArray3[220] = 96;
        nArray3[221] = 15;
        nArray3[222] = 46;
        nArray3[223] = 2;
        nArray3[224] = 32;
        nArray3[227] = 57;
        nArray3[228] = 96;
        nArray3[229] = 15;
        nArray3[230] = 46;
        nArray3[231] = 39;
        nArray3[232] = 160;
        nArray3[235] = 57;
        nArray3[236] = 96;
        nArray3[237] = 15;
        nArray3[238] = 46;
        nArray3[239] = 77;
        nArray3[240] = 32;
        nArray3[243] = 57;
        nArray3[244] = 96;
        nArray3[256] = 8;
        nArray3[257] = 20;
        nArray3[258] = 192;
        int[] mirTlm1 = nArray3;
        int[] nArray4 = new int[11];
        nArray4[0] = 192;
        nArray4[1] = 9;
        nArray4[4] = 1;
        nArray4[5] = 120;
        nArray4[6] = 130;
        nArray4[7] = 146;
        nArray4[8] = 155;
        nArray4[9] = 218;
        nArray4[10] = 192;
        int[] filler = nArray4;
        KissFrame kissFrame = new KissFrame();
        int[] nArray5 = mirTlm1;
        int n3 = mirTlm1.length;
        int n4 = 0;
        while (n4 < n3) {
            int b = nArray5[n4];
            kissFrame.add(b);
            ++n4;
        }
        Ax25Frame frame = new Ax25Frame(kissFrame);
        System.out.println(frame.toString());
    }
}

