/*
 * Decompiled with CFR 0.152.
 */
import ax25.Ax25Frame;
import ax25.KissFrame;
import ax25.Sframe;
import ax25.Uframe;
import common.Config;
import common.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import pacSat.FrameDecoder;

public class TestSat {
    static String comPort = "COM8";
    static SerialPort serialPort;
    static boolean running;
    static FrameDecoder decoder;
    static Thread decoderThread;
    FileOutputStream byteFile;
    boolean printBytes;

    static {
        running = true;
        decoder = new FrameDecoder(null);
    }

    public static void main(String[] args) throws FileNotFoundException {
        String port = null;
        if (args.length > 0) {
            port = args[0];
        }
        TestSat testSat = new TestSat(port);
    }

    TestSat(String com) throws FileNotFoundException {
        block48: {
            this.printBytes = false;
            Config.init("TestSat.properties");
            if (com != null) {
                comPort = com;
            }
            decoderThread = new Thread(decoder);
            decoderThread.start();
            serialPort = new SerialPort(comPort);
            try {
                try {
                    this.byteFile = new FileOutputStream("testsat_bytes.kss");
                    serialPort.openPort();
                    serialPort.setParams(9600, 8, 1, 0);
                    serialPort.setFlowControlMode(3);
                    serialPort.addEventListener(new PortReader(), 1);
                    System.out.println("Listening on Port: " + comPort);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String help = "Send a command or H for this menu:\nDOWNLINK\nOK) OK AC2CZ\nERR) NO -2 AC2CZ\nOTHER) PB: Other cally\nPBD) PB: AC2CZ\\D\nPB ) PB: AC2CZ\nEMPTY ) PB: Empty\n\nUPLINK\nOPEN) Open: ABCD\nPG) Open: ABC AC2CZ\nUA) Send UA frame\nRR 0-7) RR Session Response\nREJ) REJ NR - rejects that ns and all after\nGO) Ready for File 846\nGOO) Ready for File 34e at offset 0x333\nACK 0-7) UL_ACK RESP\nNAK 0-7) UL_NAK RESP 16\nUL_ERR 0-7) UL_ERR RESP ERR\nLOG) Login Response\n";
                    Scanner scanner = new Scanner(System.in);
                    System.out.println(help);
                    while (running) {
                        String line = scanner.nextLine();
                        String[] command = line.split("\\s+");
                        if (command.length == 1) {
                            if (command[0].equalsIgnoreCase("H")) {
                                System.out.println(help);
                            }
                            if (command[0].equalsIgnoreCase("OK")) {
                                this.sendOK();
                            }
                            if (command[0].equalsIgnoreCase("ERR")) {
                                this.sendERR();
                            }
                            if (command[0].equalsIgnoreCase("other")) {
                                this.sendPBOther();
                            }
                            if (command[0].equalsIgnoreCase("PB")) {
                                this.sendPB();
                            }
                            if (command[0].equalsIgnoreCase("PBD")) {
                                this.sendPBD();
                            }
                            if (command[0].equalsIgnoreCase("EMPTY")) {
                                this.sendPBEmpty();
                            }
                            if (command[0].equalsIgnoreCase("OPEN")) {
                                this.sendOpen();
                            }
                            if (command[0].equalsIgnoreCase("PG")) {
                                this.sendOnPG();
                            }
                            if (command[0].equalsIgnoreCase("UA")) {
                                this.sendUA();
                            }
                            if (command[0].equalsIgnoreCase("UA2")) {
                                this.sendUA2();
                            }
                            if (command[0].equalsIgnoreCase("DM")) {
                                this.sendDM();
                            }
                            if (command[0].equalsIgnoreCase("DISC")) {
                                this.sendDISC();
                            }
                            if (command[0].equalsIgnoreCase("LOG")) {
                                this.sendLOGGED_IN();
                            }
                            if (command[0].equalsIgnoreCase("GO")) {
                                this.sendGO();
                            }
                            if (command[0].equalsIgnoreCase("GOO")) {
                                this.sendGOoffset();
                            }
                            if (command[0].equalsIgnoreCase("EXIT")) {
                                System.exit(0);
                            }
                        } else if (command.length == 2) {
                            if (command[0].equalsIgnoreCase("RR")) {
                                this.sendRR(Integer.parseInt(command[1]));
                            }
                            if (command[0].equalsIgnoreCase("ACK")) {
                                this.sendAck(Integer.parseInt(command[1]));
                            }
                            if (command[0].equalsIgnoreCase("NAK")) {
                                this.sendNak(Integer.parseInt(command[1]));
                            }
                            if (command[0].equalsIgnoreCase("REJ")) {
                                this.sendRej(Integer.parseInt(command[1]));
                            }
                        } else if (command.length == 3) {
                            if (command[0].equalsIgnoreCase("UL_ERR")) {
                                this.sendUlErr(Integer.parseInt(command[1]), Integer.parseInt(command[2]));
                            }
                            if (command[0].equalsIgnoreCase("RR")) {
                                this.sendRR(Integer.parseInt(command[1]), Integer.parseInt(command[2]));
                            }
                        } else if (command.length == 4 && command[0].equalsIgnoreCase("UL_ERR")) {
                            this.sendUlErr(Integer.parseInt(command[1]), Integer.parseInt(command[2]), Integer.parseInt(command[3]));
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (SerialPortException ex) {
                    Log.errorDialog("ERROR", "writing string to port: " + ex);
                    if (this.byteFile == null) break block48;
                    try {
                        this.byteFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (this.byteFile != null) {
                    try {
                        this.byteFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void close() {
        try {
            if (serialPort != null) {
                serialPort.closePort();
            }
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
        running = false;
    }

    private void sendOK() throws SerialPortException {
        int[] nArray = new int[30];
        nArray[0] = 192;
        nArray[1] = 192;
        nArray[3] = 130;
        nArray[4] = 134;
        nArray[5] = 100;
        nArray[6] = 134;
        nArray[7] = 180;
        nArray[8] = 64;
        nArray[10] = 160;
        nArray[11] = 140;
        nArray[12] = 166;
        nArray[13] = 102;
        nArray[14] = 64;
        nArray[15] = 64;
        nArray[16] = 23;
        nArray[17] = 3;
        nArray[18] = 187;
        nArray[19] = 79;
        nArray[20] = 75;
        nArray[21] = 32;
        nArray[22] = 65;
        nArray[23] = 67;
        nArray[24] = 50;
        nArray[25] = 67;
        nArray[26] = 90;
        nArray[27] = 13;
        nArray[28] = 192;
        nArray[29] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT OK AC2CZ");
    }

    private void sendERR() throws SerialPortException {
        int[] nArray = new int[33];
        nArray[0] = 192;
        nArray[1] = 192;
        nArray[3] = 130;
        nArray[4] = 134;
        nArray[5] = 100;
        nArray[6] = 134;
        nArray[7] = 180;
        nArray[8] = 64;
        nArray[10] = 160;
        nArray[11] = 140;
        nArray[12] = 166;
        nArray[13] = 102;
        nArray[14] = 64;
        nArray[15] = 64;
        nArray[16] = 23;
        nArray[17] = 3;
        nArray[18] = 187;
        nArray[19] = 78;
        nArray[20] = 79;
        nArray[21] = 32;
        nArray[22] = 45;
        nArray[23] = 50;
        nArray[24] = 32;
        nArray[25] = 65;
        nArray[26] = 67;
        nArray[27] = 50;
        nArray[28] = 67;
        nArray[29] = 90;
        nArray[30] = 13;
        nArray[31] = 192;
        nArray[32] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT ERR AC2CZ");
    }

    private void sendPBEmpty() throws SerialPortException {
        int[] nArray = new int[30];
        nArray[0] = 192;
        nArray[2] = 160;
        nArray[3] = 132;
        nArray[4] = 152;
        nArray[5] = 146;
        nArray[6] = 166;
        nArray[7] = 168;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 23;
        nArray[16] = 3;
        nArray[17] = 240;
        nArray[18] = 80;
        nArray[19] = 66;
        nArray[20] = 58;
        nArray[21] = 32;
        nArray[22] = 69;
        nArray[23] = 109;
        nArray[24] = 112;
        nArray[25] = 116;
        nArray[26] = 121;
        nArray[27] = 46;
        nArray[28] = 13;
        nArray[29] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT Empty");
    }

    private void sendPBOther() throws SerialPortException {
        int[] nArray = new int[30];
        nArray[0] = 192;
        nArray[1] = 192;
        nArray[3] = 160;
        nArray[4] = 132;
        nArray[5] = 152;
        nArray[6] = 146;
        nArray[7] = 166;
        nArray[8] = 168;
        nArray[10] = 160;
        nArray[11] = 140;
        nArray[12] = 166;
        nArray[13] = 102;
        nArray[14] = 64;
        nArray[15] = 64;
        nArray[16] = 23;
        nArray[17] = 3;
        nArray[18] = 240;
        nArray[19] = 80;
        nArray[20] = 66;
        nArray[21] = 58;
        nArray[22] = 32;
        nArray[23] = 75;
        nArray[24] = 52;
        nArray[25] = 75;
        nArray[26] = 68;
        nArray[27] = 82;
        nArray[28] = 13;
        nArray[29] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT Other");
    }

    private void sendPBD() throws SerialPortException {
        int[] nArray = new int[31];
        nArray[0] = 192;
        nArray[2] = 160;
        nArray[3] = 132;
        nArray[4] = 152;
        nArray[5] = 146;
        nArray[6] = 166;
        nArray[7] = 168;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 23;
        nArray[16] = 3;
        nArray[17] = 240;
        nArray[18] = 80;
        nArray[19] = 66;
        nArray[20] = 58;
        nArray[21] = 32;
        nArray[22] = 65;
        nArray[23] = 67;
        nArray[24] = 50;
        nArray[25] = 67;
        nArray[26] = 90;
        nArray[27] = 92;
        nArray[28] = 68;
        nArray[29] = 13;
        nArray[30] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT PB AC2CZ/D");
    }

    private void sendPB() throws SerialPortException {
        int[] nArray = new int[36];
        nArray[0] = 192;
        nArray[1] = 192;
        nArray[3] = 160;
        nArray[4] = 132;
        nArray[5] = 152;
        nArray[6] = 146;
        nArray[7] = 166;
        nArray[8] = 168;
        nArray[10] = 160;
        nArray[11] = 140;
        nArray[12] = 166;
        nArray[13] = 102;
        nArray[14] = 64;
        nArray[15] = 64;
        nArray[16] = 23;
        nArray[17] = 3;
        nArray[18] = 240;
        nArray[19] = 80;
        nArray[20] = 66;
        nArray[21] = 58;
        nArray[22] = 32;
        nArray[23] = 75;
        nArray[24] = 66;
        nArray[25] = 50;
        nArray[26] = 77;
        nArray[27] = 32;
        nArray[28] = 65;
        nArray[29] = 67;
        nArray[30] = 50;
        nArray[31] = 67;
        nArray[32] = 90;
        nArray[33] = 13;
        nArray[34] = 192;
        nArray[35] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT PB AC2CZ");
    }

    private void sendOpen() throws SerialPortException {
        int[] nArray = new int[30];
        nArray[0] = 192;
        nArray[2] = 132;
        nArray[3] = 132;
        nArray[4] = 166;
        nArray[5] = 168;
        nArray[6] = 130;
        nArray[7] = 168;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 25;
        nArray[16] = 3;
        nArray[17] = 240;
        nArray[18] = 79;
        nArray[19] = 112;
        nArray[20] = 101;
        nArray[21] = 110;
        nArray[22] = 32;
        nArray[23] = 65;
        nArray[24] = 66;
        nArray[25] = 67;
        nArray[26] = 68;
        nArray[27] = 58;
        nArray[28] = 32;
        nArray[29] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT Open");
    }

    private void sendOnPG() throws SerialPortException {
        int[] nArray = new int[37];
        nArray[0] = 192;
        nArray[2] = 132;
        nArray[3] = 132;
        nArray[4] = 166;
        nArray[5] = 168;
        nArray[6] = 130;
        nArray[7] = 168;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 25;
        nArray[16] = 3;
        nArray[17] = 240;
        nArray[18] = 79;
        nArray[19] = 112;
        nArray[20] = 101;
        nArray[21] = 110;
        nArray[22] = 32;
        nArray[23] = 65;
        nArray[24] = 66;
        nArray[25] = 32;
        nArray[26] = 68;
        nArray[27] = 58;
        nArray[28] = 32;
        nArray[29] = 75;
        nArray[30] = 67;
        nArray[31] = 57;
        nArray[32] = 69;
        nArray[33] = 76;
        nArray[34] = 85;
        nArray[35] = 32;
        nArray[36] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT Open");
    }

    public void sendAx25Frame(Ax25Frame u) throws SerialPortException {
        if (serialPort == null) {
            throw new SerialPortException(comPort, "Write", "Serial Port not initialized");
        }
        KissFrame kss = new KissFrame(0, 0, u.getBytes());
        int[] bytes = kss.getDataBytes();
        serialPort.writeIntArray(bytes);
    }

    private void sendUA() throws SerialPortException {
        Uframe u = new Uframe("PFS3-12", "AC2CZ", 1, 99, 0);
        this.sendAx25Frame(u);
        System.out.println("SENT UA: " + u.toString());
    }

    private void sendUA2() throws SerialPortException {
        Uframe u = new Uframe("PFS3-12", "N2AAA", 1, 99, 0);
        this.sendAx25Frame(u);
        System.out.println("SENT UA: " + u.toString());
    }

    private void sendDISC() throws SerialPortException {
        Uframe u = new Uframe("PFS3-12", "AC2CZ", 1, 67, 1);
        this.sendAx25Frame(u);
        System.out.println("SENT DISC: " + u.toString());
    }

    private void sendDM() throws SerialPortException {
        Uframe u = new Uframe("PFS3-12", "AC2CZ", 1, 15, 0);
        this.sendAx25Frame(u);
        System.out.println("SENT DM: " + u.toString());
    }

    private void sendLOGGED_IN() throws SerialPortException {
        int[] nArray = new int[26];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[17] = 240;
        nArray[18] = 5;
        nArray[19] = 2;
        nArray[20] = 52;
        nArray[21] = 196;
        nArray[22] = 185;
        nArray[23] = 90;
        nArray[24] = 4;
        nArray[25] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT LOGGED IN AC2CZ");
    }

    private void sendGO() throws SerialPortException {
        int[] nArray = new int[29];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 34;
        nArray[17] = 240;
        nArray[18] = 8;
        nArray[19] = 4;
        nArray[20] = 78;
        nArray[21] = 3;
        nArray[28] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT GO");
    }

    private void sendGOoffset() throws SerialPortException {
        int[] nArray = new int[29];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 34;
        nArray[17] = 240;
        nArray[18] = 8;
        nArray[19] = 4;
        nArray[20] = 78;
        nArray[21] = 3;
        nArray[24] = 51;
        nArray[25] = 3;
        nArray[28] = 192;
        int[] bytes = nArray;
        this.sendFrame(bytes);
        System.out.println("SENT GO");
    }

    private void sendRR(int n) throws SerialPortException {
        this.sendRR(n, 0);
    }

    private void sendRR(int n, int P) throws SerialPortException {
        int SS = 0;
        Sframe u = new Sframe("PFS3-12", "AC2CZ", n, P, SS, 0);
        System.out.println("SENT RR: " + u.toString());
        this.sendAx25Frame(u);
    }

    private void sendRej(int n) throws SerialPortException {
        int SS = 2;
        int P = 0;
        Sframe u = new Sframe("PFS3-12", "AC2CZ", n, P, SS, 0);
        System.out.println("SENT REJ: " + u.toString());
        this.sendAx25Frame(u);
    }

    private void sendCMD(int n) throws SerialPortException {
        int[] nArray = new int[18];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 96;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 249;
        nArray[17] = 192;
        int[] bytes = nArray;
        bytes[16] = n;
        this.sendFrame(bytes);
        System.out.println("SENT Ctrl:" + Integer.toHexString(n));
    }

    private void sendAck(int nr) throws SerialPortException {
        int controlByte;
        int[] nArray = new int[21];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 132;
        nArray[17] = 240;
        nArray[19] = 6;
        nArray[20] = 192;
        int[] bytes = nArray;
        int p = 0;
        int ns = 2;
        bytes[16] = controlByte = nr << 5 | p << 4 | ns << 1;
        this.sendFrame(bytes);
        System.out.println("SENT ACK " + nr);
    }

    private void sendNak(int nr) throws SerialPortException {
        int controlByte;
        int[] nArray = new int[22];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 132;
        nArray[17] = 240;
        nArray[18] = 1;
        nArray[19] = 7;
        nArray[20] = 16;
        nArray[21] = 192;
        int[] bytes = nArray;
        int p = 0;
        int ns = 2;
        bytes[16] = controlByte = nr << 5 | p << 4 | ns << 1;
        this.sendFrame(bytes);
        System.out.println("SENT NAK " + nr);
    }

    private void sendUlErr(int nr, int err) throws SerialPortException {
        int controlByte;
        int[] nArray = new int[22];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 132;
        nArray[17] = 240;
        nArray[18] = 1;
        nArray[19] = 5;
        nArray[20] = 15;
        nArray[21] = 192;
        int[] bytes = nArray;
        int p = 0;
        int ns = 1;
        bytes[16] = controlByte = nr << 5 | p << 4 | ns << 1;
        bytes[20] = err;
        this.sendFrame(bytes);
        System.out.println("SENT UL ERR: " + err);
    }

    private void sendUlErr(int nr, int ns, int err) throws SerialPortException {
        int controlByte;
        int[] nArray = new int[22];
        nArray[0] = 192;
        nArray[2] = 130;
        nArray[3] = 134;
        nArray[4] = 100;
        nArray[5] = 134;
        nArray[6] = 180;
        nArray[7] = 64;
        nArray[8] = 224;
        nArray[9] = 160;
        nArray[10] = 140;
        nArray[11] = 166;
        nArray[12] = 102;
        nArray[13] = 64;
        nArray[14] = 64;
        nArray[15] = 121;
        nArray[16] = 132;
        nArray[17] = 240;
        nArray[18] = 1;
        nArray[19] = 5;
        nArray[20] = 15;
        nArray[21] = 192;
        int[] bytes = nArray;
        int p = 0;
        bytes[16] = controlByte = nr << 5 | p << 4 | ns << 1;
        bytes[20] = err;
        this.sendFrame(bytes);
        System.out.println("SENT UL ERR: " + err);
    }

    public void sendFrame(int[] bytes) throws SerialPortException {
        if (serialPort == null) {
            throw new SerialPortException(comPort, "Write", "Serial Port not initialized");
        }
        serialPort.writeIntArray(bytes);
    }

    private class PortReader
    implements SerialPortEventListener {
        private PortReader() {
        }

        @Override
        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    byte[] receivedData;
                    byte[] byArray = receivedData = serialPort.readBytes(event.getEventValue());
                    int n = receivedData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        int i2 = b & 0xFF;
                        char ch = (char)b;
                        if (TestSat.this.printBytes) {
                            System.out.print(String.valueOf(Integer.toHexString(i2)) + " ");
                        }
                        decoder.decodeByte(i2);
                        ++n2;
                    }
                    if (TestSat.this.printBytes) {
                        System.out.println(" ");
                    }
                    try {
                        TestSat.this.byteFile.write(receivedData);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (SerialPortException ex) {
                    System.out.println("Error in receiving string from COM-port: " + ex);
                }
            }
        }
    }
}

