/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import uk.me.g4dpz.satellite.AbstractSatellite;
import uk.me.g4dpz.satellite.DeepSpaceSatellite;
import uk.me.g4dpz.satellite.LEOSatellite;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.TLE;

public final class SatelliteFactory {
    private SatelliteFactory() {
    }

    public static synchronized Satellite createSatellite(TLE tle) throws IllegalArgumentException {
        if (tle == null) {
            throw new IllegalArgumentException("TLE was null");
        }
        AbstractSatellite satellite = null;
        satellite = tle.isDeepspace() ? new DeepSpaceSatellite(tle) : new LEOSatellite(tle);
        return satellite;
    }
}

