/*
 * Decompiled with CFR 0.152.
 */
package telemetry.payloads;

import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.payloads.CanPacket;
import telemetry.payloads.PayloadCanExperiment;

public class PayloadCanWODExperiment
extends PayloadCanExperiment {
    public static final String WOD_RESETS = "WODTimestampReset";
    public static final String WOD_UPTIME = "WODTimestampUptime";
    public static final String CRC_ERROR = "crcError";

    public PayloadCanWODExperiment(BitArrayLayout lay, int id, long uptime, int resets) {
        super(lay, id, uptime, resets);
    }

    public PayloadCanWODExperiment(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, date, st, lay);
    }

    @Override
    protected void init() {
    }

    @Override
    public void copyBitsToFields() {
        super.copyBitsToFields();
        this.resets = this.getRawValue(WOD_RESETS);
        this.uptime = this.getRawValue(WOD_UPTIME);
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "CAN WOD EXPERIMENT PAYLOAD - " + this.canPackets.size() + " CAN PACKETS\n";
        s = String.valueOf(s) + "RESET: " + this.getRawValue(WOD_RESETS);
        s = String.valueOf(s) + "  UPTIME: " + this.getRawValue(WOD_UPTIME);
        s = String.valueOf(s) + "  TYPE: " + this.type;
        s = String.valueOf(s) + "  OVERFLOW FLAG: " + this.getRawValue(CRC_ERROR) + "\n";
        int p = 0;
        while (p < this.canPackets.size()) {
            s = String.valueOf(s) + ((CanPacket)this.canPackets.get(p)).toString() + "    ";
            if ((p + 1) % 3 == 0) {
                s = String.valueOf(s) + "\n";
            }
            ++p;
        }
        s = String.valueOf(s) + "\n";
        return s;
    }
}

