/*
 * Decompiled with CFR 0.152.
 */
package telemetry.herci;

import common.Spacecraft;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;

public class HerciHighspeedHeader
extends FramePart {
    public static final int MAX_RAD_TELEM_BYTES = 16;
    public static final int HERCI_EPOCH_FIELD = 5;
    public static final int HERCI_TIME_FIELD = 4;
    public int NUMBER_OF_FIELDS = 8;
    public int reset;
    public long uptime;
    public static final String[] herciSource = new String[]{"PANIC", "HRS", "LRS", "HSK"};

    public HerciHighspeedHeader(int r, long u, BitArrayLayout l) {
        super(8, l);
        this.reset = r;
        this.uptime = u;
    }

    public HerciHighspeedHeader(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 8, date, st, lay);
    }

    @Override
    protected void init() {
    }

    public void addNext8Bits(int b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    @Override
    public String getStringValue(String name, Spacecraft fox) {
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        String s = "-----";
        if (pos != -1) {
            if (this.layout.getIntConversionByPos(pos) == 29) {
                int value = this.getRawValue(name);
                try {
                    s = herciSource[value];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    s = "???";
                }
            } else if (this.layout.getIntConversionByPos(pos) == 28) {
                s = "";
                int value = this.getRawValue(name);
                int i2 = 0;
                while (i2 < 4) {
                    s = " " + FoxDecoder.plainhex(value & 0xFF) + s;
                    value >>= 8;
                    ++i2;
                }
            } else {
                s = super.getStringValue(name, fox);
            }
        }
        return s;
    }

    public String toDataString(Spacecraft fox) {
        this.copyBitsToFields();
        String s = new String();
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.getStringValue(this.layout.fieldName[i], fox) + " ";
            ++i;
        }
        return s;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "HERCI HS SCIENCE HEADER:\n";
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + FoxDecoder.hex(this.fieldValue[i]) + " ";
            ++i;
        }
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }
}

