/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.SatPayloadTable;
import telemetry.SortedFramePartArrayList;
import telemetry.herci.HerciHighSpeedPacket;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.PayloadWODRad;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.legacyPayloads.WodRadiationTelemetry;

public class SatPayloadStore {
    public int foxId;
    private Spacecraft fox;
    private static final int INIT_SIZE = 1000;
    SatPayloadTable[] records;
    public static final int MAX_RAD_DATA_LENGTH = 61;
    public static final int MAX_HERCI_PACKET_DATA_LENGTH = 128;
    boolean deleteLock = false;

    public SatPayloadStore(int id) {
        this.foxId = id;
        this.fox = Config.satManager.getSpacecraft(this.foxId);
        try {
            this.initPayloadFiles();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, "You may need to reset FoxTelem.properties or re-install FoxTelem\nWas the data directory moved?\n" + e.toString(), "FATAL! Cannot find the Stored Payload data", 0);
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, "You may need to reset FoxTelem.properties or re-install FoxTelem\nWas the data directory moved?\n" + e.toString(), "FATAL! Cannot Load the Stored Payload data", 0);
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
    }

    private void initPayloadFiles() throws IOException {
        this.records = new SatPayloadTable[this.fox.numberOfLayouts];
        int i = 0;
        while (i < this.fox.numberOfLayouts) {
            this.records[i] = new SatPayloadTable(1000, String.valueOf(this.fox.series) + this.foxId + this.fox.layout[i].name, this.fox.layout[i], this.fox.hasModeInHeader, this.fox.hasFOXDB_V3);
            ++i;
        }
    }

    public void setUpdatedAll() {
        int i = 0;
        while (i < this.fox.numberOfLayouts) {
            this.records[i].setUpdated(true);
            ++i;
        }
    }

    public boolean getUpdated(String layout) {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getUpdated();
        }
        return false;
    }

    public void setUpdated(String layout, boolean u) {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            this.records[i].setUpdated(u);
        }
    }

    public int getNumberOfFrames() {
        int total = 0;
        int i = 0;
        while (i < this.fox.numberOfLayouts) {
            if (!this.fox.layout[i].isSecondaryPayload()) {
                total += this.records[i].getSize();
            }
            ++i;
        }
        return total;
    }

    public int getNumberOfFrames(String layout) {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            if (this.records[i] == null) {
                return 0;
            }
            return this.records[i].getSize();
        }
        return 0;
    }

    public int getNumberOfTelemFrames() {
        if (this.fox.hasFOXDB_V3) {
            return this.getNumberOfFrames(this.fox.getLayoutNameByType("RT")) + this.getNumberOfFrames(this.fox.getLayoutNameByType("MAX")) + this.getNumberOfFrames(this.fox.getLayoutNameByType("MIN"));
        }
        return this.getNumberOfFrames("rttelemetry") + this.getNumberOfFrames("maxtelemetry") + this.getNumberOfFrames("mintelemetry");
    }

    public SortedFramePartArrayList getFrameParts(int fromReset, long fromUptime, int period, boolean reverse, String layout) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getFrameParts(fromReset, fromUptime, period, reverse);
        }
        return null;
    }

    public boolean add(int id, long uptime, int resets, FramePart f) throws ArrayIndexOutOfBoundsException, IOException {
        f.captureHeaderInfo(id, uptime, resets);
        return this.add(f);
    }

    @Deprecated
    public boolean add(int id, long uptime, int resets, PayloadRadExpData[] f) throws IOException {
        int l = this.fox.getLayoutIdxByName("radtelemetry");
        if (l != -1) {
            if (!this.records[l].hasFrame(id, uptime, resets)) {
                int i = 0;
                while (i < f.length) {
                    if (f[i].hasData()) {
                        f[i].captureHeaderInfo(id, uptime, resets);
                        try {
                            this.records[l].save(f[i]);
                        }
                        catch (IOException e) {
                            e.printStackTrace(Log.getWriter());
                        }
                        this.addRadSecondaryRecord(f[i]);
                    }
                    ++i;
                }
            } else {
                if (Config.debugFrames) {
                    Log.println("DUPLICATE RAD RECORD SET, not loaded");
                }
                return false;
            }
        }
        return true;
    }

    @Deprecated
    private boolean addRadSecondaryRecord(PayloadRadExpData f) throws IOException {
        if (f.layout.getSecondaryPayloadName() != null) {
            BitArrayLayout secondaryLayout = Config.satManager.getLayoutByName(this.fox.foxId, f.layout.getSecondaryPayloadName());
            FramePart radiationTelemetry = FramePart.makePayload(f.id, f.resets, f.uptime, secondaryLayout.name);
            this.add(radiationTelemetry);
        } else if (f.layout.name.equalsIgnoreCase("herciHSdata") || f.isTelemetry()) {
            RadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
            radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
            if (f.type >= 400) {
                radiationTelemetry.type = f.type + 300;
            }
            this.add(radiationTelemetry);
        }
        return true;
    }

    @Deprecated
    private boolean addWODRadSecondaryRecord(PayloadWODRad f) throws IOException {
        if (f.layout.name.equalsIgnoreCase("herciHSdata") || f.isTelemetry()) {
            WodRadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
            radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
            if (f.type >= 400) {
                radiationTelemetry.type = f.type + 300;
            }
            this.add(radiationTelemetry);
        }
        return true;
    }

    protected boolean addHerciSecondaryRecord(PayloadHERCIhighSpeed f) throws IOException {
        HerciHighspeedHeader radiationTelemetry = f.calculateTelemetryPalyoad();
        radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
        if (f.type >= 600) {
            radiationTelemetry.type = f.type + 200;
        }
        this.add(radiationTelemetry);
        ArrayList<HerciHighSpeedPacket> pkts = f.calculateTelemetryPackets();
        int i = 0;
        while (i < pkts.size()) {
            HerciHighSpeedPacket pk = pkts.get(i);
            pk.captureHeaderInfo(f.id, f.uptime, f.resets);
            if (f.type >= 600) {
                pk.type = f.type * 1000 + 900 + i;
            }
            this.add(pk);
            ++i;
        }
        return true;
    }

    private boolean add(FramePart f) throws IOException {
        boolean ret = false;
        int i = this.fox.getLayoutIdxByName(f.layout.name);
        if (i != -1 && (ret = this.records[i].save(f))) {
            if (f instanceof PayloadWODRad) {
                return this.addWODRadSecondaryRecord((PayloadWODRad)f);
            }
            if (f instanceof PayloadRadExpData) {
                return this.addRadSecondaryRecord((PayloadRadExpData)f);
            }
            if (f instanceof PayloadHERCIhighSpeed) {
                return this.addHerciSecondaryRecord((PayloadHERCIhighSpeed)f);
            }
        }
        return ret;
    }

    public FramePart getLatest(int id, int reset, long uptime, String layout, boolean prev) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getFrame(id, uptime, reset, prev);
        }
        return null;
    }

    public FramePart getLatest(int id, int reset, long uptime, int type, String layout, boolean prev) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getFrame(id, uptime, reset, type, prev);
        }
        return null;
    }

    public FramePart getLatest(String layout) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getLatest();
        }
        return null;
    }

    public FramePart getLatestRt() throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getLatest(this.fox.getLayoutNameByType("RT"));
        }
        return this.getLatest("rttelemetry");
    }

    public FramePart getLatestMax() throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getLatest(this.fox.getLayoutNameByType("MAX"));
        }
        return this.getLatest("maxtelemetry");
    }

    public FramePart getLatestMin() throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getLatest(this.fox.getLayoutNameByType("MIN"));
        }
        return this.getLatest("mintelemetry");
    }

    @Deprecated
    public FramePart getLatestRad() throws IOException {
        return this.getLatest("radtelemetry");
    }

    @Deprecated
    public RadiationTelemetry getLatestRadTelem() throws IOException {
        return (RadiationTelemetry)this.getLatest("radtelemetry2");
    }

    @Deprecated
    public RadiationTelemetry getRadTelem(int id, int resets, long uptime) throws IOException {
        if (uptime == 0L && resets == 0) {
            return this.getLatestRadTelem();
        }
        int i = this.fox.getLayoutIdxByName("radtelemetry2");
        if (i != -1) {
            return (RadiationTelemetry)this.records[i].getFrame(id, uptime, resets, false);
        }
        return null;
    }

    @Deprecated
    public PayloadHERCIhighSpeed getLatestHerci() throws IOException {
        return (PayloadHERCIhighSpeed)this.getLatest("herciHSdata");
    }

    @Deprecated
    public HerciHighspeedHeader getLatestHerciHeader() throws IOException {
        return (HerciHighspeedHeader)this.getLatest("herciHSheader");
    }

    public double[][] getGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, String layout, boolean positionData, boolean reverse) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.records[i].getGraphData(name, period, id, fromReset, fromUptime, positionData, reverse);
        }
        return null;
    }

    public double[][] getRtGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getGraphData(name, period, id, fromReset, fromUptime, this.fox.getLayoutNameByType("RT"), positionData, reverse);
        }
        return this.getGraphData(name, period, id, fromReset, fromUptime, "rttelemetry", positionData, reverse);
    }

    public double[][] getMaxGraphData(String name, int period, Spacecraft fox2, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getGraphData(name, period, fox2, fromReset, fromUptime, this.fox.getLayoutNameByType("MAX"), positionData, reverse);
        }
        return this.getGraphData(name, period, fox2, fromReset, fromUptime, "maxtelemetry", positionData, reverse);
    }

    public double[][] getMinGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getGraphData(name, period, id, fromReset, fromUptime, this.fox.getLayoutNameByType("MIN"), positionData, reverse);
        }
        return this.getGraphData(name, period, id, fromReset, fromUptime, "mintelemetry", positionData, reverse);
    }

    @Deprecated
    public double[][] getRadTelemGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        return this.getGraphData(name, period, id, fromReset, fromUptime, "radtelemetry2", positionData, reverse);
    }

    public String[][] getRtData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getTableData(period, id, fromReset, fromUptime, reverse, this.fox.getLayoutNameByType("RT"));
        }
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "rttelemetry");
    }

    public String[][] getWODData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        if (this.fox.hasFOXDB_V3) {
            return this.getTableData(period, id, fromReset, fromUptime, reverse, this.fox.getLayoutNameByType("WOD"));
        }
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "wodtelemetry");
    }

    @Deprecated
    public String[][] getRadData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "radtelemetry");
    }

    @Deprecated
    public String[][] getWODRadData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "wodradtelemetry");
    }

    @Deprecated
    public String[][] getRadTelemData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "radtelemetry2");
    }

    @Deprecated
    public String[][] getWodRadTelemData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        return this.getTableData(period, id, fromReset, fromUptime, reverse, "wodradtelemetry2");
    }

    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean returnType, boolean reverse, String layout) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        BitArrayLayout l = this.fox.getLayoutByName(layout);
        if (i != -1) {
            return this.records[i].getPayloadData(period, id, fromReset, fromUptime, l.fieldName.length, returnType, reverse);
        }
        return null;
    }

    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean reverse, String layout) throws IOException {
        int i = this.fox.getLayoutIdxByName(layout);
        BitArrayLayout l = this.fox.getLayoutByName(layout);
        if (i != -1) {
            return this.records[i].getPayloadData(period, id, fromReset, fromUptime, l.fieldName.length, reverse);
        }
        return null;
    }

    @Deprecated
    public double[][] getHerciScienceHeaderGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime, boolean positionData, boolean reverse) throws IOException {
        return this.getGraphData(name, period, id, fromReset, fromUptime, "herciHSheader", positionData, reverse);
    }

    @Deprecated
    public String[][] getHerciPacketData(int period, int id, int fromReset, long fromUptime, boolean type, boolean reverse) throws IOException {
        int i = this.fox.getLayoutIdxByName("herciHSpackets");
        if (i != -1) {
            return this.records[i].getPayloadData(period, id, fromReset, fromUptime, 128, type, reverse);
        }
        return null;
    }

    @Deprecated
    public String[][] getHerciHsData(int period, int id, int fromReset, long fromUptime, boolean reverse) throws IOException {
        int i = this.fox.getLayoutIdxByName("herciHSdata");
        if (i != -1) {
            return this.records[i].getPayloadData(period, id, fromReset, fromUptime, 868, true, reverse);
        }
        return null;
    }

    public void offloadSegments() {
        while (this.deleteLock) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.fox.numberOfLayouts) {
            this.records[i].offloadSegments();
            ++i;
        }
    }

    public void deleteAll() {
        this.deleteLock = true;
        try {
            int i = 0;
            while (i < this.fox.numberOfLayouts) {
                this.records[i].remove();
                ++i;
            }
            this.initPayloadFiles();
            this.setUpdatedAll();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting Payload Files for FoxId:" + this.foxId + ", check permissions", 0);
        }
        this.deleteLock = false;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public void convert() throws IOException {
        int i = 0;
        while (i < this.fox.numberOfLayouts) {
            this.records[i].convert();
            ++i;
        }
    }

    public static void remove(String f) throws IOException {
        block3: {
            try {
                File file = new File(f);
                if (!file.exists()) break block3;
                if (file.delete()) {
                    Log.println(String.valueOf(file.getName()) + " is deleted!");
                    break block3;
                }
                Log.println("Delete operation failed for: " + file.getName());
                throw new IOException("Could not delete file " + file.getName() + " Check the file system and remove it manually.");
            }
            catch (Exception ex) {
                Log.errorDialog("Error Deleting File", ex.toString());
            }
        }
    }

    public int getNumberOfPayloadsBetweenTimestamps(int id, int reset, long uptime, int toReset, long toUptime, String payloadType) {
        int i = this.fox.getLayoutIdxByName(payloadType);
        if (i != -1) {
            try {
                return this.records[i].getNumberOfPayloadsBetweenTimestamps(reset, uptime, toReset, toUptime);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                return 0;
            }
        }
        return 0;
    }
}

