/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.SpacecraftEditorWindow;
import spacecraftEditor.listEditors.CsvTableModel;
import spacecraftEditor.listEditors.ListTableModel;
import spacecraftEditor.listEditors.lookupTables.LookupCsvFileEditPanel;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;

public abstract class TableListEditPanel
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public String TEMPLATE_FILENAME = "LOOKUP_template.csv";
    protected String FILE_EXT = "csv";
    protected SpacecraftEditPanel parent;
    protected Spacecraft sat;
    String title;
    protected JTable table;
    protected JPanel leftPanel;
    protected JLabel lFilename;
    protected ListTableModel listTableModel;
    CsvTableModel csvTableModel;
    LookupCsvFileEditPanel lookupCsvFileEditPanel;
    protected ArrayList<String[]> dataLines;
    JButton btnAdd;
    JButton btnRemove;
    JButton btnBrowse;
    JButton btnUpdate;
    protected JTextField txtFilename;
    protected JTextField txtName;

    public TableListEditPanel(Spacecraft sat, String title, ListTableModel listTableModel, CsvTableModel csvTableModel, String file_ext, SpacecraftEditPanel parent) {
        this.sat = sat;
        this.title = title;
        this.listTableModel = listTableModel;
        this.csvTableModel = csvTableModel;
        this.parent = parent;
        this.FILE_EXT = file_ext;
        this.dataLines = new ArrayList();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        this.leftPanel = this.addLeftPanel();
        this.add((Component)this.leftPanel, "West");
        JPanel centerPanel = this.addCenterPanel();
        this.add((Component)centerPanel, "Center");
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            if (this.lookupCsvFileEditPanel != null && this.dataLines != null && this.dataLines.size() > 0) {
                this.lookupCsvFileEditPanel.setFile(this.dataLines.get(0)[2]);
            }
        }
    }

    protected abstract void loadTable();

    protected abstract void saveTable() throws IOException, LayoutLoadException;

    private void setData() {
        if (this.dataLines.size() == 0) {
            String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
            String[][] fakeRow = new String[][]{dataToAdd};
            this.listTableModel.setData(fakeRow);
        } else {
            String[][] data = new String[this.dataLines.size()][this.listTableModel.getColumnCount()];
            int j = 0;
            while (j < this.dataLines.size()) {
                data[j] = this.dataLines.get(j);
                ++j;
            }
            this.listTableModel.setData(data);
        }
    }

    private void load() {
        this.loadTable();
        this.setData();
    }

    private void save() throws IOException, LayoutLoadException {
        this.saveTable();
        this.parent.save();
    }

    private void scrollToRow(JTable table, int row) {
        Rectangle cellRect = table.getCellRect(row, 0, false);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
    }

    private JPanel addLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel leftPanel1 = new JPanel();
        leftPanel.add(leftPanel1);
        leftPanel1.setLayout(new BorderLayout());
        TitledBorder headingFrames = SpacecraftEditPanel.title(this.title);
        leftPanel1.setBorder(headingFrames);
        this.table = new JTable(this.listTableModel);
        this.table.setAutoCreateRowSorter(true);
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 31);
        scrollPane.setPreferredSize(new Dimension(100, 400));
        this.table.setFillsViewportHeight(true);
        leftPanel1.add((Component)scrollPane, "Center");
        int i = 0;
        while (i < this.listTableModel.columnWidths.length) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.listTableModel.columnWidths[i]);
            ++i;
        }
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.table.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.table.getActionMap();
        actMap.put(PREV, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TableListEditPanel.this.table.getSelectedRow();
                if (row > 0) {
                    TableListEditPanel.this.updateRow(row - 1);
                    TableListEditPanel.this.table.setRowSelectionInterval(row - 1, row - 1);
                    TableListEditPanel.this.scrollToRow(TableListEditPanel.this.table, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TableListEditPanel.this.table.getSelectedRow();
                if (row < TableListEditPanel.this.table.getRowCount() - 1) {
                    TableListEditPanel.this.updateRow(row + 1);
                    TableListEditPanel.this.table.setRowSelectionInterval(row + 1, row + 1);
                    TableListEditPanel.this.scrollToRow(TableListEditPanel.this.table, row + 1);
                }
            }
        });
        this.table.addMouseListener(this);
        this.load();
        JPanel footerPanel = new JPanel();
        leftPanel.add((Component)footerPanel, "South");
        footerPanel.setLayout(new BoxLayout(footerPanel, 1));
        JPanel footerPanelRow1 = new JPanel();
        footerPanelRow1.setLayout(new BoxLayout(footerPanelRow1, 0));
        footerPanel.add(footerPanelRow1);
        JPanel f1 = new JPanel();
        f1.setLayout(new BoxLayout(f1, 1));
        JLabel lf1 = new JLabel("Name");
        this.txtName = new JTextField();
        f1.add(lf1);
        f1.add(this.txtName);
        footerPanelRow1.add(f1);
        JPanel f3 = new JPanel();
        f3.setLayout(new BoxLayout(f3, 1));
        this.lFilename = new JLabel("Filename");
        this.txtFilename = new JTextField();
        f3.add(this.lFilename);
        f3.add(this.txtFilename);
        this.txtFilename.setEditable(false);
        this.txtFilename.addMouseListener(this);
        footerPanelRow1.add(f3);
        JPanel footerPanelRow2 = new JPanel();
        footerPanel.add(footerPanelRow2);
        this.btnAdd = new JButton("Add");
        this.btnAdd.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.addActionListener(this);
        this.btnUpdate = new JButton("Update");
        this.btnUpdate.addActionListener(this);
        footerPanelRow2.add(this.btnAdd);
        footerPanelRow2.add(this.btnUpdate);
        footerPanelRow2.add(this.btnRemove);
        this.btnAdd.setEnabled(true);
        this.btnRemove.setEnabled(true);
        leftPanel.add(new Box.Filler(new Dimension(500, 10), new Dimension(500, 400), new Dimension(500, 500)));
        return leftPanel;
    }

    protected JPanel addCenterPanel() {
        this.lookupCsvFileEditPanel = new LookupCsvFileEditPanel(this.sat, this.csvTableModel, "Lookup Tables", null);
        return this.lookupCsvFileEditPanel;
    }

    private void addListItem() {
        block9: {
            String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
            boolean fileSet = false;
            try {
                File dest = new File(String.valueOf(Config.spacecraftDir) + this.txtFilename.getText());
                if (!dest.isFile()) {
                    File source = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "templates" + File.separator + this.TEMPLATE_FILENAME);
                    SatPayloadStore.copyFile(source, dest);
                }
                dataToAdd[0] = "" + this.dataLines.size();
                dataToAdd[1] = !this.txtName.getText().equalsIgnoreCase("") ? this.txtName.getText() : "NONE";
                if (!this.txtFilename.getText().equalsIgnoreCase("")) {
                    dataToAdd[2] = this.txtFilename.getText();
                    if (this.lookupCsvFileEditPanel != null) {
                        fileSet = this.lookupCsvFileEditPanel.setFile(this.txtFilename.getText());
                    }
                } else {
                    dataToAdd[2] = "NONE";
                }
                if (this.lookupCsvFileEditPanel != null && !fileSet) break block9;
                this.dataLines.add(dataToAdd);
                try {
                    this.save();
                }
                catch (IOException e1) {
                    Log.errorDialog("ERROR", "Error saving details to file\n" + e1);
                }
                catch (LayoutLoadException e) {
                    Log.errorDialog("ERROR", "Error saving table\n" + e);
                }
                this.load();
                this.table.setRowSelectionInterval(this.dataLines.size() - 1, this.dataLines.size() - 1);
                this.updateRow(this.dataLines.size() - 1);
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Error with file\n" + e1);
            }
        }
    }

    private void removeListItem(int row) {
        if (row == -1) {
            Log.infoDialog("No row selected", "Select a row to remove");
            return;
        }
        if (this.dataLines.size() == 0) {
            return;
        }
        int n = Log.optionYNdialog("Remove file on disk too?", "Remove the file as well as the table row?\n" + this.txtFilename.getText() + "\n\n" + "If this file is used by other rows or spacecraft then click No.  Otherwise this file will be gone forever.\n");
        if (n != 1) {
            File file = new File(String.valueOf(Config.spacecraftDir) + this.txtFilename.getText());
            try {
                SatPayloadStore.remove(file.getAbsolutePath());
            }
            catch (IOException ef) {
                Log.errorDialog("ERROR removing File", "\nCould not remove the file\n" + ef.getMessage());
            }
        }
        this.dataLines.remove(row);
        try {
            this.save();
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error saving details to file\n" + e1);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Error saving table\n" + e);
        }
        this.load();
        if (this.dataLines.size() > 0) {
            try {
                if (row > 0) {
                    this.table.setRowSelectionInterval(row - 1, row - 1);
                    this.txtName.setText(this.dataLines.get(row - 1)[1]);
                    this.txtFilename.setText(this.dataLines.get(row - 1)[2]);
                    this.updateRow(row - 1);
                } else {
                    this.table.setRowSelectionInterval(row, row);
                    this.txtName.setText(this.dataLines.get(row)[1]);
                    this.txtFilename.setText(this.dataLines.get(row)[2]);
                    this.updateRow(row);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updateListItem(int row) {
        if (row == -1) {
            Log.infoDialog("No row selected", "Select a row to update");
            return;
        }
        if (this.dataLines.size() == 0) {
            return;
        }
        String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
        dataToAdd[0] = "" + row;
        dataToAdd[1] = !this.txtName.getText().equalsIgnoreCase("") ? this.txtName.getText() : "NONE";
        if (this.txtFilename.getText().equalsIgnoreCase("")) {
            dataToAdd[2] = "NONE";
            Log.infoDialog("ERROR", "Select a valid file");
            return;
        }
        dataToAdd[2] = this.txtFilename.getText();
        this.dataLines.set(row, dataToAdd);
        try {
            this.save();
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error saving details to file\n" + e1);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Error saving table\n" + e);
        }
        this.load();
        this.table.setRowSelectionInterval(row, row);
        if (this.lookupCsvFileEditPanel != null) {
            this.lookupCsvFileEditPanel.setFile(this.dataLines.get(row)[2]);
        }
        this.updateRow(row);
    }

    protected void browseListItem() {
        Log.println("Browse for list item filename ...");
        File dir = new File(Config.spacecraftDir);
        File file = SpacecraftEditorWindow.pickFile(dir, this, "Specify file", "Select", this.FILE_EXT);
        if (file == null) {
            return;
        }
        this.txtFilename.setText(file.getName());
    }

    protected void updateRow(int row) {
        this.txtName.setText(this.dataLines.get(row)[1]);
        this.txtFilename.setText(this.dataLines.get(row)[2]);
        this.lookupCsvFileEditPanel.setFile(this.dataLines.get(row)[2]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.btnAdd) {
            Log.println("Adding List item ...");
            this.addListItem();
        }
        if (e.getSource() == this.btnUpdate) {
            row = this.table.getSelectedRow();
            Log.println("Updating row " + row);
            this.updateListItem(row);
        }
        if (e.getSource() == this.btnRemove) {
            row = this.table.getSelectedRow();
            Log.println("Removing row " + row);
            this.removeListItem(row);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.txtFilename) {
            this.browseListItem();
        }
        if (e.getSource() == this.table) {
            if (this.dataLines.size() == 0) {
                return;
            }
            int row = this.table.rowAtPoint(e.getPoint());
            int col = this.table.columnAtPoint(e.getPoint());
            if (row >= 0 && col >= 0) {
                Log.println("PRESSED ROW: " + row + " and COL: " + col + " COUNT: " + e.getClickCount());
                this.updateRow(row);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

